/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad.config;

import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.ad.config.AdvertiseDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.money.api.appconfigcenter.CommonAdvertiseInfo;

public class AdvertiseConfigInfo {
    @SerializedName(value="update_time")
    private long updateTime;
    @SerializedName(value="location_type")
    private int locationType;
    @SerializedName(value="first_req")
    private int firstReq;
    @SerializedName(value="req_interval")
    private int reqInterval;
    @SerializedName(value="show_times")
    private int showTimes;
    @SerializedName(value="ui_schema")
    private String uiSchema;
    @SerializedName(value="line_no")
    private int lineNo;
    @SerializedName(value="game_mins")
    private int gameMins;
    @SerializedName(value="can_close")
    private boolean canClose;
    @SerializedName(value="ad_details")
    private List<AdvertiseDetail> adDetails;
    @SerializedName(value="conf_id")
    private int confId;
    @SerializedName(value="cache_gameids")
    private List<String> cacheGameIds;
    @SerializedName(value="ad_group_id")
    private int adGroupId;
    @SerializedName(value="win_streak_time")
    private int winStreakTime;

    static AdvertiseConfigInfo create(CommonAdvertiseInfo info) {
        AdvertiseConfigInfo config = new AdvertiseConfigInfo();
        config.updateTime = info.update_time;
        config.locationType = info.location_type;
        config.firstReq = info.first_req;
        config.reqInterval = info.req_interval;
        config.showTimes = info.show_times;
        config.uiSchema = info.ui_schema;
        config.lineNo = info.line_no;
        config.gameMins = info.game_mins;
        config.canClose = info.can_close;
        config.confId = info.conf_id;
        config.cacheGameIds = info.cache_gameids;
        config.adGroupId = info.ad_group_id;
        config.winStreakTime = info.win_streak_times;
        config.adDetails = new ArrayList<AdvertiseDetail>();
        if (!FP.empty((Collection)info.ad_details)) {
            for (net.ihago.money.api.appconfigcenter.AdvertiseDetail detail : info.ad_details) {
                AdvertiseDetail advertiseDetail = AdvertiseDetail.create(detail);
                if (config.adDetails.contains(advertiseDetail)) continue;
                config.adDetails.add(AdvertiseDetail.create(detail));
            }
        }
        return config;
    }

    private AdvertiseConfigInfo() {
    }

    private AdvertiseConfigInfo(Builder builder) {
        this.updateTime = builder.updateTime;
        this.locationType = builder.locationType;
        this.firstReq = builder.firstReq;
        this.reqInterval = builder.reqInterval;
        this.showTimes = builder.showTimes;
        this.uiSchema = builder.uiSchema;
        this.lineNo = builder.lineNo;
        this.gameMins = builder.gameMins;
        this.canClose = builder.canClose;
        this.adDetails = builder.adDetails;
        this.confId = builder.confId;
        this.cacheGameIds = builder.cacheGameIds;
        this.adGroupId = builder.adGroupId;
        this.winStreakTime = builder.winStreakTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public int getLocalAdId() {
        return this.locationType;
    }

    public int getFirstReq() {
        return this.firstReq;
    }

    public int getReqInterval() {
        return this.reqInterval;
    }

    public int getShowTimes() {
        return this.showTimes;
    }

    public String getUiSchema() {
        return this.uiSchema;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getGameMins() {
        return this.gameMins;
    }

    public boolean isCanClose() {
        return this.canClose;
    }

    public int getConfId() {
        return this.confId;
    }

    @Nullable
    public List<String> getCacheGameids() {
        if (this.cacheGameIds != null) {
            return new ArrayList<String>(this.cacheGameIds);
        }
        return null;
    }

    @Nullable
    public List<AdvertiseDetail> getAdDetails() {
        if (this.adDetails != null) {
            return new ArrayList<AdvertiseDetail>(this.adDetails);
        }
        return null;
    }

    public int getAdGroupId() {
        return this.adGroupId;
    }

    public int getWinStreakTime() {
        return this.winStreakTime;
    }

    public String toString() {
        return "AdvertiseConfigInfo:updateTime=" + this.updateTime + "\uff0clocationType=" + this.locationType + ", firstReq=" + this.firstReq + ", reqInterval=" + this.reqInterval + ", showTimes=" + this.showTimes + ", uiSchema=" + this.uiSchema + ", lineNo=" + this.lineNo + ", gameMins=" + this.gameMins + ", canClose=" + this.canClose + ", adDetails=" + this.adDetails + ", winStreakTime=" + this.winStreakTime + ", confId=" + this.confId + ", cacheGameIds=" + this.cacheGameIds + ", adGroupId=" + this.adGroupId;
    }

    public static final class Builder {
        private long updateTime;
        private int locationType;
        private int firstReq;
        private int reqInterval;
        private int showTimes;
        private String uiSchema;
        private int lineNo;
        private int gameMins;
        private boolean canClose;
        private List<AdvertiseDetail> adDetails;
        private int confId;
        private List<String> cacheGameIds;
        private int adGroupId;
        private int winStreakTime;

        private Builder() {
        }

        public Builder updateTime(long val) {
            this.updateTime = val;
            return this;
        }

        public Builder locationType(int val) {
            this.locationType = val;
            return this;
        }

        public Builder firstReq(int val) {
            this.firstReq = val;
            return this;
        }

        public Builder reqInterval(int val) {
            this.reqInterval = val;
            return this;
        }

        public Builder showTimes(int val) {
            this.showTimes = val;
            return this;
        }

        public Builder uiSchema(String val) {
            this.uiSchema = val;
            return this;
        }

        public Builder lineNo(int val) {
            this.lineNo = val;
            return this;
        }

        public Builder gameMins(int val) {
            this.gameMins = val;
            return this;
        }

        public Builder canClose(boolean val) {
            this.canClose = val;
            return this;
        }

        public Builder adDetails(List<AdvertiseDetail> val) {
            this.adDetails = val;
            return this;
        }

        public Builder confId(int val) {
            this.confId = val;
            return this;
        }

        public Builder cacheGameIds(List<String> val) {
            this.cacheGameIds = val;
            return this;
        }

        public Builder adGroupId(int val) {
            this.adGroupId = val;
            return this;
        }

        public Builder winStreakTime(int val) {
            this.winStreakTime = val;
            return this;
        }

        public AdvertiseConfigInfo build() {
            return new AdvertiseConfigInfo(this);
        }
    }
}

