/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad.config;

import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import com.yy.hiyo.wallet.ad.config.AdvertiseDetail;
import com.yy.socialplatformbase.data.AdPlatform;
import com.yy.socialplatformbase.data.AdvertiseType;
import java.util.ArrayList;
import java.util.List;

public class AdLocalConfigUtils {
    static AdvertiseConfigInfo createAdConfigInfo(int localId, int advertiseType) {
        return AdvertiseConfigInfo.newBuilder().locationType(localId).adDetails(AdLocalConfigUtils.createAdDetail(advertiseType)).firstReq(0).reqInterval(0).build();
    }

    private static List<AdvertiseDetail> createAdDetail(int advertiseType) {
        if (advertiseType == AdvertiseType.motivation.getValue()) {
            return AdLocalConfigUtils.createRewardAdDetail();
        }
        if (advertiseType == AdvertiseType.smallBanner.getValue()) {
            return AdLocalConfigUtils.createBannerAdDetail();
        }
        return null;
    }

    private static List<AdvertiseDetail> createRewardAdDetail() {
        ArrayList<AdvertiseDetail> list = new ArrayList<AdvertiseDetail>();
        list.add(AdLocalConfigUtils.createAdvertiseDetail("259183588047169_603579783607546", AdvertiseType.motivation, AdPlatform.facebook));
        if (RuntimeContext.sIsDebuggable && SystemUtils.isShowEnvSetting()) {
            list.add(AdLocalConfigUtils.createAdvertiseDetail("ca-app-pub-3940256099942544/5224354917", AdvertiseType.motivation, AdPlatform.google));
        } else {
            list.add(AdLocalConfigUtils.createAdvertiseDetail("ca-app-pub-9161924326164168/8653721770", AdvertiseType.motivation, AdPlatform.google));
        }
        list.add(AdLocalConfigUtils.createAdvertiseDetail("test_rewarded", AdvertiseType.motivation, AdPlatform.unity));
        return list;
    }

    private static List<AdvertiseDetail> createBannerAdDetail() {
        ArrayList<AdvertiseDetail> list = new ArrayList<AdvertiseDetail>();
        list.add(AdLocalConfigUtils.createAdvertiseDetail("ca-app-pub-5655349380234202/7325415275", AdvertiseType.smallBanner, AdPlatform.google));
        list.add(AdLocalConfigUtils.createAdvertiseDetail("259183588047169_281579245807603", AdvertiseType.smallBanner, AdPlatform.facebook));
        return list;
    }

    private static AdvertiseDetail createAdvertiseDetail(String adId, AdvertiseType adType, AdPlatform adPlatform) {
        AdvertiseDetail advertiseDetail = new AdvertiseDetail();
        advertiseDetail.setAdId(adId);
        advertiseDetail.setAdType(adType);
        advertiseDetail.setOrigin(adPlatform);
        return advertiseDetail;
    }
}

