/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AdConfig;
import com.yy.appbase.unifyconfig.config.AdConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.data.AdConfigBean;
import com.yy.hiyo.wallet.ad.data.AdTimeWrapper;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IAdCacheCallBack;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdModel {
    private static final String TAG = "FTAdv_AdModel";
    private static final int MSG_CHECK_TIMEOUT = 0;
    private Map<Integer, AdTimeWrapper> mAdTimeWrapperMap = new ConcurrentHashMap<Integer, AdTimeWrapper>();
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    long remain = AdModel.this.checkTimeout();
                    if (remain <= 0L) break;
                    AdModel.this.mHandler.removeMessages(0);
                    AdModel.this.mHandler.sendEmptyMessageDelayed(0, remain);
                    break;
                }
            }
        }
    };

    public void cacheAd(final int localAdId, final @NonNull IAdCacheCallBack callback2) {
        AdConfigBean adConfigBean;
        boolean handled = false;
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"Network unavailable", (int)0);
            }
            callback2.onError(100000013, "no network");
            FeatureLog.i((String)"FTAdv", (String)"AdModel no network localAdId=%d", (Object[])new Object[]{localAdId});
            return;
        }
        if (AdConfigureManager.INSTANCE.getLocalAdPlacementMap().containsKey(localAdId) && (adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId)) != null && !StringUtils.isEmpty((String)adConfigBean.getPlacementId())) {
            AbsPlatformAdapter platformAdapter;
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("localAdId=" + localAdId + "," + adConfigBean.getAdPlatform().name()), (int)0);
            }
            if ((platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId())) != null) {
                handled = true;
                if (this.isOpenAdTimeout()) {
                    MLog.info((Object)TAG, (String)"timeoutOpen %s", (Object[])new Object[]{localAdId});
                    if (this.mAdTimeWrapperMap.size() == 0) {
                        this.mHandler.sendEmptyMessageDelayed(0, (long)this.getAdTimeoutLength());
                    }
                    this.mAdTimeWrapperMap.put(localAdId, new AdTimeWrapper(SystemClock.elapsedRealtime(), localAdId, adConfigBean.getPlacementId(), callback2));
                }
                platformAdapter.cacheAd(adConfigBean.getPlacementId(), adConfigBean.getAdContentType(), new IAdCacheCallBack(){

                    public void onAdLoadSuccess(AdEntity adEntity) {
                        adEntity.setAdPlatformId(adConfigBean.getAdPlatformId());
                        if (AdModel.this.isOpenAdTimeout()) {
                            if (AdModel.this.mAdTimeWrapperMap.containsKey(localAdId)) {
                                MLog.info((Object)AdModel.TAG, (String)"success containsKey=%d", (Object[])new Object[]{localAdId});
                                AdTimeWrapper wrapper = (AdTimeWrapper)AdModel.this.mAdTimeWrapperMap.get(localAdId);
                                if (!TextUtils.isEmpty((CharSequence)adConfigBean.getPlacementId()) && adConfigBean.getPlacementId().equals(wrapper.getPlacementId())) {
                                    IAdCacheCallBack adCacheCallBack = null;
                                    if (wrapper != null && wrapper.getCallback() != null) {
                                        adCacheCallBack = wrapper.getCallback();
                                    }
                                    AdModel.this.mAdTimeWrapperMap.remove(localAdId);
                                    if (adCacheCallBack != null) {
                                        adCacheCallBack.onAdLoadSuccess(adEntity);
                                    }
                                }
                            }
                            MLog.info((Object)AdModel.TAG, (String)"success remove=%d", (Object[])new Object[]{localAdId});
                        } else if (callback2 != null) {
                            callback2.onAdLoadSuccess(adEntity);
                        }
                    }

                    public void onError(int code, String error) {
                        if (AdModel.this.isOpenAdTimeout()) {
                            if (AdModel.this.mAdTimeWrapperMap.containsKey(localAdId)) {
                                MLog.info((Object)AdModel.TAG, (String)"error containsKey=%d", (Object[])new Object[]{localAdId});
                                AdTimeWrapper wrapper = (AdTimeWrapper)AdModel.this.mAdTimeWrapperMap.get(localAdId);
                                if (!TextUtils.isEmpty((CharSequence)adConfigBean.getPlacementId()) && adConfigBean.getPlacementId().equals(wrapper.getPlacementId())) {
                                    IAdCacheCallBack adCacheCallBack = null;
                                    if (wrapper != null && wrapper.getCallback() != null) {
                                        adCacheCallBack = wrapper.getCallback();
                                    }
                                    AdModel.this.mAdTimeWrapperMap.remove(localAdId);
                                    if (adCacheCallBack != null) {
                                        adCacheCallBack.onError(code, error);
                                    }
                                }
                            }
                            MLog.info((Object)AdModel.TAG, (String)"error remove=%d", (Object[])new Object[]{localAdId});
                        } else if (callback2 != null) {
                            callback2.onError(code, error);
                        }
                    }
                });
            }
        }
        if (!handled && callback2 != null) {
            callback2.onError(99999991, "");
        }
    }

    public void loadPlatformAd(int localAdId, ViewGroup adContainer, AdEntity adEntity, IAdCallback callback2) {
        boolean handled = false;
        if (AdConfigureManager.INSTANCE.getLocalAdPlacementMap().containsKey(localAdId)) {
            MLog.info((Object)TAG, (String)"loadPlatformAd localAdId=%d", (Object[])new Object[]{localAdId});
            AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
            if (adConfigBean != null && !StringUtils.isEmpty((String)adConfigBean.getPlacementId())) {
                int adPlatformId;
                String placementId;
                MLog.info((Object)TAG, (String)"loadPlatformAd adConfigBean.getPlacementId()=%s", (Object[])new Object[]{adConfigBean.getPlacementId()});
                if (adEntity != null && !StringUtils.isEmpty((String)adEntity.getPlacementId()) && !adEntity.getPlacementId().equals(adConfigBean.getPlacementId())) {
                    MLog.error((Object)TAG, (String)"loadPlatformAd adEntity.getPlacementId()=%s, not equal", (Object[])new Object[]{adEntity.getPlacementId()});
                }
                if (adEntity == null) {
                    placementId = adConfigBean.getPlacementId();
                    adPlatformId = adConfigBean.getAdPlatformId();
                } else {
                    placementId = adEntity.getPlacementId();
                    adPlatformId = adEntity.getAdPlatformId();
                }
                AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adPlatformId);
                if (platformAdapter != null) {
                    handled = true;
                    int adBannerSize = 0;
                    if (localAdId == 2) {
                        adBannerSize = 1;
                    } else if (localAdId == 3) {
                        adBannerSize = 2;
                    }
                    platformAdapter.loadAd(placementId, adEntity, adConfigBean.getAdContentType(), adContainer, callback2, adBannerSize);
                }
            }
        }
        if (!handled && callback2 != null) {
            callback2.onError(99999991, "");
        }
    }

    public void pauseAdView(int localAdId) {
        AbsPlatformAdapter platformAdapter;
        AdConfigBean adConfigBean;
        if (AdConfigureManager.INSTANCE.getLocalAdPlacementMap().containsKey(localAdId) && (adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId)) != null && !StringUtils.isEmpty((String)adConfigBean.getPlacementId()) && (platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId())) != null) {
            platformAdapter.pauseAdView(adConfigBean.getPlacementId());
        }
    }

    public void resumeAdView(int localAdId) {
        AbsPlatformAdapter platformAdapter;
        AdConfigBean adConfigBean;
        if (AdConfigureManager.INSTANCE.getLocalAdPlacementMap().containsKey(localAdId) && (adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId)) != null && !StringUtils.isEmpty((String)adConfigBean.getPlacementId()) && (platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId())) != null) {
            platformAdapter.resumeAdView(adConfigBean.getPlacementId());
        }
    }

    public void destroyAdView(int localAdId) {
        AbsPlatformAdapter platformAdapter;
        AdConfigBean adConfigBean;
        if (AdConfigureManager.INSTANCE.getLocalAdPlacementMap().containsKey(localAdId) && (adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId)) != null && !StringUtils.isEmpty((String)adConfigBean.getPlacementId()) && (platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId())) != null) {
            platformAdapter.destroyAdView(adConfigBean.getPlacementId());
        }
    }

    public boolean isRewardVideoAdLoaded(int localAdId, AdEntity adEntity) {
        AbsPlatformAdapter platformAdapter;
        AdConfigBean adConfigBean;
        if (AdConfigureManager.INSTANCE.getLocalAdPlacementMap().containsKey(localAdId) && (adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId)) != null && !StringUtils.isEmpty((String)adConfigBean.getPlacementId()) && (platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId())) != null) {
            if (adEntity == null) {
                adEntity = new AdEntity(adConfigBean.getPlacementId(), null);
            }
            return platformAdapter.isRewardVideoAdLoaded(adEntity);
        }
        return false;
    }

    public void initAdSdk(int adPlatformId) {
        AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adPlatformId);
        if (platformAdapter != null) {
            platformAdapter.initSdk();
        }
    }

    private AdConfigData getAdConfigData() {
        AdConfig config = (AdConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.AD_CONFIG);
        if (config != null && config.getAdConfigData() != null) {
            return config.getAdConfigData();
        }
        return null;
    }

    private boolean isOpenAdTimeout() {
        return false;
    }

    private int getAdTimeoutLength() {
        AdConfigData adConfigData = this.getAdConfigData();
        if (adConfigData != null) {
            if (NetworkUtils.isWifiActive((Context)RuntimeContext.sApplicationContext)) {
                MLog.info((Object)TAG, (String)"getAdTimeoutLength wifi %s", (Object[])new Object[]{adConfigData.getWifiTime()});
                return adConfigData.getWifiTime() * 1000;
            }
            MLog.info((Object)TAG, (String)"getAdTimeoutLength no wifi %s", (Object[])new Object[]{adConfigData.getNoWifiTime()});
            return adConfigData.getNoWifiTime() * 1000;
        }
        return 0;
    }

    private long checkTimeout() {
        MLog.info((Object)TAG, (String)"checkTimeout", (Object[])new Object[0]);
        long minTimestamp = Long.MAX_VALUE;
        for (Map.Entry<Integer, AdTimeWrapper> entry : this.mAdTimeWrapperMap.entrySet()) {
            int localId = entry.getKey();
            AdTimeWrapper wrapper = entry.getValue();
            long interval = SystemClock.elapsedRealtime() - wrapper.getTimestamp();
            if (interval > (long)this.getAdTimeoutLength()) {
                if (!this.mAdTimeWrapperMap.containsKey(localId)) continue;
                IAdCacheCallBack adCacheCallBack = null;
                if (wrapper != null && wrapper.getCallback() != null) {
                    adCacheCallBack = wrapper.getCallback();
                }
                this.mAdTimeWrapperMap.remove(localId);
                MLog.info((Object)TAG, (String)"checkTimeout remove=%s", (Object[])new Object[]{localId});
                if (adCacheCallBack == null) continue;
                adCacheCallBack.onError(100000012, "request time out");
                continue;
            }
            if (interval >= minTimestamp) continue;
            minTimestamp = interval;
        }
        if (this.mAdTimeWrapperMap.size() == 0) {
            minTimestamp = 0L;
        }
        MLog.info((Object)TAG, (String)"checkTimeout minTimestamp=%s", (Object[])new Object[]{minTimestamp});
        return minTimestamp;
    }
}

