/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.AdManager;
import com.yy.hiyo.wallet.ad.config.AdConfigModel;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import com.yy.hiyo.wallet.ad.ui.NativeAdDialog;
import com.yy.hiyo.wallet.base.IAdService;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;

public class AdController
extends DefaultController
implements IAdService {
    private static final String TAG = "AdController";
    IGameLifecycle mGameLifeWrapper = new GameLifeWrapper(){

        public void onPlayGameStart(GamePlayContext context) {
            if (context != null && context.getGameInfo() != null) {
                boolean cacheVideo = false;
                String gid = context.getGameInfo().getGid();
                FeatureLog.i((String)"FTAdv", (String)"onPlayGameStart gid=%s", (Object[])new Object[]{gid});
                AdConfigureManager.INSTANCE.setGameStartTime(System.currentTimeMillis());
                if (context.getGameInfo().getGameMode() == 3) {
                    if (AdController.this.needCacheVideoAd(102, gid)) {
                        AdController.this.cacheAd(102, null);
                        cacheVideo = true;
                    }
                    if (AdController.this.needCacheVideoAd(103, gid)) {
                        AdController.this.cacheAd(103, null);
                        cacheVideo = true;
                    }
                    if (!cacheVideo) {
                        AdController.this.cacheAd(100, null);
                        AdController.this.cacheAd(201, null);
                    }
                }
            }
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            if (context != null && context.getGameInfo() != null) {
                String gid = context.getGameInfo().getGid();
                FeatureLog.i((String)"FTAdv", (String)"onGameExited gid=%s", (Object[])new Object[]{gid});
                AdConfigureManager.INSTANCE.setGameEndTime(System.currentTimeMillis());
                if (AdController.this.needCacheVideoAd(102, gid) || AdController.this.needCacheVideoAd(103, gid)) {
                    return;
                }
                if (context.getGameInfo().getGameMode() == 3) {
                    if (AdConfigureManager.INSTANCE.canShowAdByGameConsumedTime(100)) {
                        if (AdController.this.hasAdCache(100)) {
                            if (AdConfigureManager.INSTANCE.isNativeFullScreenAd(100)) {
                                AdController.this.showNativeAdDialog(100, true);
                            } else {
                                AdController.this.loadAd(100, null);
                            }
                        }
                    } else if (AdConfigureManager.INSTANCE.canShowAdByGameConsumedTime(201) && AdController.this.hasAdCache(201)) {
                        if (AdConfigureManager.INSTANCE.isNativeFullScreenAd(201)) {
                            AdController.this.showNativeAdDialog(201, true);
                        } else {
                            AdController.this.loadAd(201, null);
                        }
                    }
                } else if (context.getGameInfo().getGameMode() == 1) {
                    AdConfigureManager.INSTANCE.addPkGameConsumedTotalTime();
                }
            }
        }
    };

    public AdController(Environment env) {
        super(env);
        AdManager.INSTANCE.init(this.mContext);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle(this.mGameLifeWrapper);
        RuntimeContext.setAdABTest((boolean)NAB.B.equals((Object)NewABDefine.AD_IMPROVE.getTest()));
        AdConfigureManager.INSTANCE.getPkGameConsumedTotalTimeFromPref();
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        this.registerMessage(BaseMsgDef.OPEN_ADMOB_TESTSUITE);
        this.registerMessage(BaseMsgDef.OPEN_ADMOB_TESTTOOL);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            boolean isForeground = (Boolean)notification.extObj;
            if (isForeground) {
                if (this.getCurrentWindow() == null) {
                    return;
                }
                if (!AdConfigureManager.INSTANCE.canShowBackToFrontInterstitialAd()) {
                    FeatureLog.i((String)"FTAdv", (String)"isForeground canShowBackToFrontInterstitialAd=no", (Object[])new Object[0]);
                    return;
                }
                int type = this.getCurrentWindow().getWindowType();
                if (type != 103 && type != 110 && type != 111 && type != 113 && type != 112 && type != 107 && type != 114) {
                    this.loadAd(101, null, true);
                }
            } else {
                AdConfigureManager.INSTANCE.setAppBackgroundTime(SystemClock.elapsedRealtime());
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS) {
            this.cacheAd(101, null);
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            AdConfigureManager.INSTANCE.getPkGameConsumedTotalTimeFromPref();
        } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            AdManager.INSTANCE.clearAdCache();
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.OPEN_ADMOB_TESTTOOL) {
            ThirdPartyPlatformHelper.getInstance().getPlatform(6).openTestTool();
        } else if (msg.what == BaseMsgDef.OPEN_ADMOB_TESTSUITE) {
            ThirdPartyPlatformHelper.getInstance().getPlatform(6).openTestSuit();
        }
    }

    public void loadAd(int localAdId, IAdCallback callback2) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            if (callback2 != null) {
                callback2.onError(-1, "\u73af\u5883\u8bbe\u7f6e\u6ca1\u6253\u5f00\u5e7f\u544a\u5f00\u5173");
            }
            return;
        }
        this.loadAdWithProxyCallback(localAdId, null, -1, callback2, false, false);
    }

    public void loadAd(int localAdId, ViewGroup adContainer, boolean needCacheFirst) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            return;
        }
        this.loadAdWithProxyCallback(localAdId, adContainer, -1, null, needCacheFirst, false);
    }

    public void cacheAd(int localAdId, IAdCallback callback2) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            if (callback2 != null) {
                callback2.onError(-1, "");
            }
            return;
        }
        this.cacheAdWithProxyCallback(localAdId, -1, callback2);
    }

    public void cacheAd(int localAdId, int adType, IAdCallback callback2) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            if (callback2 != null) {
                callback2.onError(-1, "");
            }
            return;
        }
        this.cacheAdWithProxyCallback(localAdId, adType, callback2);
    }

    public void loadAd(int localAdId, ViewGroup adContainer, IAdCallback callback2) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            if (callback2 != null) {
                callback2.onError(-1, "");
            }
            return;
        }
        this.loadAdWithProxyCallback(localAdId, adContainer, -1, callback2, false, false);
    }

    public void loadAd(int localAdId, ViewGroup adContainer, IAdCallback callback2, boolean isRefreshConfig) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            if (callback2 != null) {
                callback2.onError(-1, "");
            }
            return;
        }
        this.loadAdWithProxyCallback(localAdId, adContainer, -1, callback2, false, isRefreshConfig);
    }

    public void loadAd(int localAdId, ViewGroup adContainer, int adType, IAdCallback callback2) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            if (callback2 != null) {
                callback2.onError(-1, "");
            }
            return;
        }
        this.loadAdWithProxyCallback(localAdId, adContainer, adType, callback2, false, false);
    }

    public int getAdLineNumber(int localAdId) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            return -1;
        }
        return AdManager.INSTANCE.getAdLineNumber(localAdId);
    }

    public boolean hasAdCache(int localAdId) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            return false;
        }
        return AdManager.INSTANCE.hasAdCache(localAdId);
    }

    public void pauseAdView(int localAdId) {
        AdManager.INSTANCE.pauseAdView(localAdId);
    }

    public void resumeAdView(int localAdId) {
        AdManager.INSTANCE.resumeAdView(localAdId);
    }

    public void destroyAdView(int localAdId) {
        AdManager.INSTANCE.destroyAdView(localAdId);
    }

    public void setBackFromImAndGamePage(boolean backFromImAndGamePage) {
        AdConfigureManager.INSTANCE.setBackFromImAndGamePage(backFromImAndGamePage);
    }

    public boolean isBackFromImAndGamePage() {
        return AdConfigureManager.INSTANCE.isBackFromImAndGamePage();
    }

    public void setGameWinStreakTime(int gameWinStreakTime) {
        AdConfigureManager.INSTANCE.setGameWinStreakTime(gameWinStreakTime);
    }

    public void loadPkGameAd(int localAdId, IAdCallback callback2) {
        if (RuntimeContext.sIsDebuggable && !EnvSettings.instance().getEnvAdSwitch()) {
            return;
        }
        if (AdConfigureManager.INSTANCE.isShowPkGameAd(localAdId) && !AdConfigureManager.INSTANCE.canShowGameAd(localAdId)) {
            if (callback2 != null) {
                callback2.onError(100000003, "");
            }
            FeatureLog.i((String)"FTAdv", (String)"AdController loadAd canShowGameAd=no, localAdId=%s", (Object[])new Object[]{localAdId});
            ((IAdService)this.getServiceManager().getService(IAdService.class)).setBackFromImAndGamePage(false);
            return;
        }
        if (this.hasAdCache(localAdId)) {
            if (AdConfigureManager.INSTANCE.isNativeFullScreenAd(localAdId)) {
                this.showNativeAdDialog(localAdId, false);
            } else {
                this.loadAd(localAdId, null);
            }
            AdConfigureManager.INSTANCE.setPkGameConsumedTotalTime(0);
            ((IAdService)this.getServiceManager().getService(IAdService.class)).setBackFromImAndGamePage(false);
        }
    }

    public boolean isCanCacheTypeAD(int localAdId) {
        return AdConfigureManager.INSTANCE.canAdvertiseTypeCache(localAdId);
    }

    private boolean needCacheVideoAd(int adId, String gid) {
        if (adId == 0 || TextUtils.isEmpty((CharSequence)gid)) {
            return false;
        }
        AdvertiseConfigInfo config = AdConfigModel.getInstance().getAdConfig(adId);
        return config != null && config.getCacheGameids() != null && config.getCacheGameids().contains(gid);
    }

    private void showNativeAdDialog(int localAdId, boolean isFullScreen) {
        final NativeAdDialog dialog2 = new NativeAdDialog();
        dialog2.setFullScreen(isFullScreen);
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
            YYFrameLayout adContainer = dialog2.getAdContainer();
            this.loadAd(localAdId, (ViewGroup)adContainer, new IAdCallback(){

                public void onAdLoadSuccess(AdEntity adEntity) {
                }

                public void onError(int code, String error) {
                }

                public void onAdClickClose() {
                    super.onAdClickClose();
                    if (dialog2 != null) {
                        AdController.this.mDialogLinkManager.dismissDialog();
                    }
                }
            });
        }
    }

    private void cacheAdWithProxyCallback(final int localAdId, final int adType, final IAdCallback callback2) {
        final long timeStart = System.currentTimeMillis();
        AdManager.INSTANCE.cacheAd(localAdId, adType, new IAdCallback(){

            public void onAdLoadSuccess(AdEntity adEntity) {
                if (callback2 != null) {
                    callback2.onAdLoadSuccess(adEntity);
                }
                HashMap<String, String> content = new HashMap<String, String>();
                content.put("adType", String.valueOf(adType));
                content.put("adPlatform", String.valueOf(adEntity.getAdPlatformId()));
                content.put("biddingType", String.valueOf(adEntity.getBiddingType()));
                AdController.this.adStaticsReport(localAdId, "ad_cache/" + localAdId, System.currentTimeMillis() - timeStart, "0", content);
            }

            public void onError(int code, String error) {
                if (callback2 != null) {
                    callback2.onError(code, error);
                }
                if (code == 0) {
                    code = 200000;
                }
                if (code != 99999998) {
                    AdController.this.adStaticsReport(localAdId, "ad_cache/" + localAdId, System.currentTimeMillis() - timeStart, code + "");
                }
            }
        });
    }

    public void loadAdWithProxyCallback(final int localAdId, ViewGroup adContainer, int adType, final IAdCallback callback2, boolean needCacheFirst, boolean isRefreshConfig) {
        final long timeStart = System.currentTimeMillis();
        AdManager.INSTANCE.loadAd(localAdId, adContainer, adType, new IAdCallback(){
            boolean isShow = false;

            public void onAdLoadSuccess(AdEntity adEntity) {
                if (callback2 != null) {
                    callback2.onAdLoadSuccess(adEntity);
                }
            }

            public void onError(int code, String error) {
                if (callback2 != null) {
                    callback2.onError(code, error);
                }
                if (code == 0) {
                    code = 200000;
                }
                if (this.isShow) {
                    AdController.this.adStaticsReport(localAdId, "ad_play_result/" + localAdId, System.currentTimeMillis() - timeStart, code + "");
                } else {
                    AdController.this.adStaticsReport(localAdId, "ad_play/" + localAdId, System.currentTimeMillis() - timeStart, code + "");
                }
            }

            public void onLoggingImpression() {
                super.onLoggingImpression();
                if (callback2 != null) {
                    callback2.onLoggingImpression();
                }
                this.isShow = true;
                AdController.this.adStaticsReport(localAdId, "ad_play/" + localAdId, System.currentTimeMillis() - timeStart, "0");
            }

            public void onRewardedVideoClosed() {
                super.onRewardedVideoClosed();
                if (callback2 != null) {
                    callback2.onRewardedVideoClosed();
                }
                this.isShow = false;
                AdController.this.adStaticsReport(localAdId, "ad_play_result/" + localAdId, System.currentTimeMillis() - timeStart, "0");
            }

            public void onAdClickClose() {
                super.onAdClickClose();
                if (callback2 != null) {
                    callback2.onAdClickClose();
                }
            }

            public void onAdClicked() {
                super.onAdClicked();
                if (callback2 != null) {
                    callback2.onAdClicked();
                }
            }

            public void onRewardedVideoCompleted() {
                super.onRewardedVideoCompleted();
                if (callback2 != null) {
                    callback2.onRewardedVideoCompleted();
                }
            }

            public void onMediaDownloaded() {
                super.onMediaDownloaded();
                if (callback2 != null) {
                    callback2.onMediaDownloaded();
                }
            }

            public void onInterstitialDisplayed() {
                super.onInterstitialDisplayed();
                if (callback2 != null) {
                    callback2.onInterstitialDisplayed();
                }
            }

            public void onInterstitialDismissed() {
                super.onInterstitialDismissed();
                if (callback2 != null) {
                    callback2.onInterstitialDismissed();
                }
            }
        }, needCacheFirst, isRefreshConfig);
    }

    private void adStaticsReport(int localId, String uri, long time, String returnCode) {
        this.adStaticsReport(localId, uri, time, returnCode, null);
    }

    private void adStaticsReport(int localId, String uri, long time, String returnCode, HashMap<String, String> content) {
        if (localId <= 300) {
            return;
        }
        if (content != null) {
            HiidoStatis.reportReturnCode((String)uri, (long)time, (String)returnCode, content);
        } else {
            HiidoStatis.reportReturnCode((String)uri, (long)time, (String)returnCode);
        }
    }
}

