/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AdConfig;
import com.yy.base.logger.MLog;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.config.AdConfigModel;
import com.yy.hiyo.wallet.ad.config.AdLocalConfigModel;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import com.yy.socialplatformbase.data.AdPlatform;
import java.util.Iterator;
import java.util.Map;

public class AdConfigAllModel {
    public static AdConfigAllModel getInstance() {
        return Instance.instance;
    }

    Map<Integer, AdvertiseConfigInfo> getAdConfigs() {
        if (AdConfigModel.getInstance().getAdConfigs().isEmpty()) {
            return AdLocalConfigModel.getInstance().getAdConfigs();
        }
        return AdConfigModel.getInstance().getAdConfigs();
    }

    AdvertiseConfigInfo getAdConfig(int localAdId) {
        if (AdConfigModel.getInstance().getAdConfigs().isEmpty()) {
            return AdLocalConfigModel.getInstance().getAdConfig(localAdId);
        }
        return AdConfigModel.getInstance().getAdConfig(localAdId);
    }

    boolean needAddLocalAdConfig(int localId) {
        return AdConfigModel.getInstance().getAdConfigs().isEmpty() && (AdLocalConfigModel.getInstance().getAdConfigs().isEmpty() || !AdLocalConfigModel.getInstance().getAdConfigs().containsKey(localId));
    }

    boolean isUsingLocalAdConfig(int localId) {
        return AdConfigModel.getInstance().getAdConfigs().isEmpty() && AdLocalConfigModel.getInstance().getAdConfigs().containsKey(localId);
    }

    void addLocalAdConfig(int localId, int advertiseType) {
        MLog.info((Object)"FTAdv", (String)"addLocalAdConfig localId=%s, advertiseType=%s", (Object[])new Object[]{localId, advertiseType});
        this.setAllAdPlatform();
        AdLocalConfigModel.getInstance().addLocalAdConfig(localId, advertiseType);
    }

    private void setAllAdPlatform() {
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().clear();
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.facebook);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.google);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.vungle);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.unity);
        AdConfig config = (AdConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.AD_CONFIG);
        if (config != null && config.getAdConfigData() != null && config.getAdConfigData().getBidPlatform() != null) {
            Iterator iterator = config.getAdConfigData().getBidPlatform().iterator();
            while (iterator.hasNext()) {
                int platform = (Integer)iterator.next();
                AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().remove(AdPlatform.platform((int)platform));
            }
        }
    }

    private static class Instance {
        static AdConfigAllModel instance = new AdConfigAllModel();

        private Instance() {
        }
    }
}

