/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.activity.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.activity.ui.ActivityIconView;
import com.yy.hiyo.wallet.base.action.ActivityAction;

public class ExtendActivityIconView
extends ActivityIconView {
    private YYTextView mActionTitle;
    private YYLinearLayout mTitleLayout;

    public ExtendActivityIconView(Context context) {
        super(context);
    }

    public ExtendActivityIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ExtendActivityIconView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void createView(@Nullable AttributeSet attrs) {
        super.createView(attrs);
        this.mActionTitle = (YYTextView)this.findViewById(R.id.action_title);
        this.mTitleLayout = (YYLinearLayout)this.findViewById(R.id.title_layout);
    }

    @Override
    public void setData(ActivityAction data) {
        super.setData(data);
        this.mTitleText.setVisibility(8);
        if (data != null) {
            if (!StringUtils.isEmpty((String)data.title)) {
                this.mActionTitle.setText((CharSequence)data.title);
                this.mTitleLayout.setVisibility(0);
            } else {
                this.mTitleLayout.setVisibility(8);
            }
            if (data.pictureType == ActivityAction.PictureType.SVGA) {
                if (data.height > 0 && data.width > 0) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mSVGAImageView.getLayoutParams();
                    lp.height = ResolutionUtils.dip2Px((float)(data.height / 2));
                    lp.width = ResolutionUtils.dip2Px((float)(data.width / 2));
                    this.mSVGAImageView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    LinearLayout.LayoutParams titleLp = (LinearLayout.LayoutParams)this.mActionTitle.getLayoutParams();
                    titleLp.leftMargin = ResolutionUtils.dip2Px((float)(data.width / 2 + 5));
                    this.mActionTitle.setLayoutParams((ViewGroup.LayoutParams)titleLp);
                }
                this.mSVGAImageView.setVisibility(0);
            } else if (data.pictureType == ActivityAction.PictureType.IMAGE) {
                if (data.height > 0 && data.width > 0) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mIcon.getLayoutParams();
                    lp.height = ResolutionUtils.dip2Px((float)(data.height / 2));
                    lp.width = ResolutionUtils.dip2Px((float)(data.width / 2));
                    this.mIcon.setLayoutParams((ViewGroup.LayoutParams)lp);
                    LinearLayout.LayoutParams titleLp = (LinearLayout.LayoutParams)this.mActionTitle.getLayoutParams();
                    titleLp.leftMargin = ResolutionUtils.dip2Px((float)(data.width / 2 + 5));
                    this.mActionTitle.setLayoutParams((ViewGroup.LayoutParams)titleLp);
                }
                this.mIcon.setVisibility(0);
            } else {
                this.mSVGAImageView.setVisibility(8);
                this.mIcon.setVisibility(8);
            }
        }
    }

    @Override
    protected int getLayoutId() {
        return R.layout.layout_extend_activity_action;
    }
}

