/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.yyvoicemanager.yyvoicesdk;

import android.util.Base64;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/yy/voice/yyvoicemanager/yyvoicesdk/VoiceUtils;", "", "()V", "HMAC_SHA1", "", "getHMAC_SHA1", "()Ljava/lang/String;", "generateTokenWithValidTime", "", "appSecret", "appId", "", "uid", "time", "extData", "getBufferData", "buffer", "Ljava/nio/ByteBuffer;", "hmacSha1Signature", "datas", "key", "voice_debug"})
public final class VoiceUtils {
    @NotNull
    private static final String HMAC_SHA1 = "HmacSHA1";
    public static final VoiceUtils INSTANCE;

    @NotNull
    public final String getHMAC_SHA1() {
        return HMAC_SHA1;
    }

    private final byte[] hmacSha1Signature(byte[] datas, byte[] key) {
        String type = HMAC_SHA1;
        SecretKeySpec secret = new SecretKeySpec(key, type);
        Mac mac = Mac.getInstance(type);
        mac.init(secret);
        byte[] byArray = mac.doFinal(datas);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"mac.doFinal(datas)");
        return byArray;
    }

    private final byte[] getBufferData(ByteBuffer buffer) {
        int len = buffer.position();
        byte[] data = new byte[len];
        buffer.position(0);
        buffer.get(data);
        buffer.clear();
        buffer.put(data);
        return data;
    }

    @NotNull
    public final byte[] generateTokenWithValidTime(@NotNull String appSecret, long appId, long uid, long time, @Nullable byte[] extData) {
        Intrinsics.checkParameterIsNotNull((Object)appSecret, (String)"appSecret");
        String string2 = appSecret;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] key = byArray;
        ByteBuffer buffer = ByteBuffer.allocate(100);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)(48 + (extData != null ? extData.length : 0)));
        buffer.putLong(appId);
        buffer.putLong(uid);
        buffer.putLong(System.currentTimeMillis());
        buffer.putInt((int)time);
        if (extData != null) {
            buffer.putShort((short)extData.length);
            buffer.put(extData);
        } else {
            buffer.putShort((short)0);
        }
        try {
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            buffer.put(this.hmacSha1Signature(this.getBufferData(byteBuffer), key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        byte[] byArray2 = Base64.encode((byte[])this.getBufferData(byteBuffer), (int)8);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Base64.encode(\n         \u2026buffer), Base64.URL_SAFE)");
        return byArray2;
    }

    private VoiceUtils() {
    }

    static {
        VoiceUtils voiceUtils;
        INSTANCE = voiceUtils = new VoiceUtils();
        HMAC_SHA1 = HMAC_SHA1;
    }
}

