/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.officialvoice;

import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.voice.base.offlinevoice.IRecordBehavior;
import com.yy.hiyo.voice.base.offlinevoice.IVoiceChatHandler;
import com.yy.hiyo.voice.base.offlinevoice.IVoiceChatService;
import com.yy.hiyo.voice.base.offlinevoice.VoiceScene;
import com.yy.voice.officialvoice.VoiceChatHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/yy/voice/officialvoice/VoiceChatService;", "Lcom/yy/hiyo/voice/base/offlinevoice/IVoiceChatService;", "()V", "mHandlerMap", "", "", "Lcom/yy/hiyo/voice/base/offlinevoice/IVoiceChatHandler;", "createHandler", "roomId", "behavior", "Lcom/yy/hiyo/voice/base/offlinevoice/IRecordBehavior;", "destroyHandler", "", "isVoiceValid", "", "scene", "Lcom/yy/hiyo/voice/base/offlinevoice/VoiceScene;", "Companion", "voice_debug"})
public final class VoiceChatService
implements IVoiceChatService {
    private final Map<String, IVoiceChatHandler> mHandlerMap;
    @NotNull
    public static final String TAG = "VoiceChatService";
    public static final Companion Companion = new Companion(null);

    public boolean isVoiceValid(@NotNull VoiceScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        return true;
    }

    @NotNull
    public IVoiceChatHandler createHandler(@NotNull String roomId, @NotNull IRecordBehavior behavior) {
        Intrinsics.checkParameterIsNotNull((Object)roomId, (String)"roomId");
        Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw (Throwable)new IllegalArgumentException("roomId can not be empty");
        }
        IVoiceChatHandler handler = this.mHandlerMap.get(roomId);
        if (handler != null) {
            if (RuntimeContext.sIsDebuggable) {
                boolean switchOn = SettingFlags.getBoolean((String)"pageautoswitch", (boolean)false);
                boolean switchOnVoice = SettingFlags.getBoolean((String)"pageautovoiceswitch", (boolean)false);
                if (!switchOn && !switchOnVoice) {
                    throw (Throwable)new IllegalArgumentException("obtain duplication handler with roomId " + roomId);
                }
            }
            return handler;
        }
        handler = new VoiceChatHandler(roomId, behavior);
        this.mHandlerMap.put(roomId, handler);
        return handler;
    }

    public void destroyHandler(@NotNull String roomId) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)roomId, (String)"roomId");
            IVoiceChatHandler handler = this.mHandlerMap.remove(roomId);
            MLog.info((Object)TAG, (String)"destroyHandler roomId: %s, handler == null: %b", (Object[])new Object[]{roomId, handler == null});
            IVoiceChatHandler iVoiceChatHandler = handler;
            if (iVoiceChatHandler == null) break block0;
            IVoiceChatHandler iVoiceChatHandler2 = iVoiceChatHandler;
            boolean bl = false;
            boolean bl2 = false;
            IVoiceChatHandler it = iVoiceChatHandler2;
            boolean bl3 = false;
            it.destroy();
        }
    }

    public VoiceChatService() {
        Map map;
        VoiceChatService voiceChatService = this;
        boolean bl = false;
        voiceChatService.mHandlerMap = map = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/voice/officialvoice/VoiceChatService$Companion;", "", "()V", "TAG", "", "voice_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

