/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.search.ui.page;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.event.kvo.list.KvoListHelper;
import com.yy.base.event.kvo.list.KvoPageList;
import com.yy.base.memoryrecycle.views.YYRecyclerView;
import com.yy.base.thread.ThreadBus;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.search.R;
import com.yy.hiyo.search.base.ISearchService;
import com.yy.hiyo.search.base.SearchHelper;
import com.yy.hiyo.search.base.data.bean.ChannelModuleBean;
import com.yy.hiyo.search.base.data.bean.RoomResultBean;
import com.yy.hiyo.search.ui.page.SearchRoomsTabPage;
import com.yy.hiyo.search.ui.page.SearchRoomsTabPage$WhenMappings;
import com.yy.hiyo.search.ui.page.SearchTabPage;
import com.yy.hiyo.search.ui.viewholder.RoomModuleVH;
import com.yy.hiyo.search.ui.viewholder.RoomsResultVH;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;
import net.ihago.channel.srv.csearch.SearchChannelRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0014J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u001cH\u0016J\b\u0010-\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010,\u001a\u00020\u001cH\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0007J\u0010\u00102\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0007R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR#\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u001d\u001a\n \u0007*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000b\u001a\u0004\b\u001f\u0010 R#\u0010\"\u001a\n \u0007*\u0004\u0018\u00010#0#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u000b\u001a\u0004\b$\u0010%\u00a8\u00063"}, d2={"Lcom/yy/hiyo/search/ui/page/SearchRoomsTabPage;", "Lcom/yy/hiyo/search/ui/page/SearchTabPage;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "channelRecyclerView", "Lcom/yy/base/memoryrecycle/views/YYRecyclerView;", "kotlin.jvm.PlatformType", "getChannelRecyclerView", "()Lcom/yy/base/memoryrecycle/views/YYRecyclerView;", "channelRecyclerView$delegate", "Lkotlin/Lazy;", "loadingStatus", "Lcom/yy/appbase/ui/widget/status/CommonStatusLayout;", "getLoadingStatus", "()Lcom/yy/appbase/ui/widget/status/CommonStatusLayout;", "loadingStatus$delegate", "mAdapter", "Lme/drakeet/multitype/MultiTypeAdapter;", "getMAdapter", "()Lme/drakeet/multitype/MultiTypeAdapter;", "mAdapter$delegate", "mBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "getMBinder", "()Lcom/yy/base/event/kvo/helper/KvoBinder;", "mBinder$delegate", "mLastSearchKeywords", "", "mRefreshLayout", "Lcom/scwang/smartrefresh/layout/SmartRefreshLayout;", "getMRefreshLayout", "()Lcom/scwang/smartrefresh/layout/SmartRefreshLayout;", "mRefreshLayout$delegate", "searchService", "Lcom/yy/hiyo/search/base/ISearchService;", "getSearchService", "()Lcom/yy/hiyo/search/base/ISearchService;", "searchService$delegate", "getTabName", "onAttachedToWindow", "", "onDetachedFromWindow", "onSelect", "content", "refresh", "search", "updateHasMore", "eventIntent", "Lcom/yy/base/event/kvo/KvoEventIntent;", "updateSearchRoomResult", "search_debug"})
public final class SearchRoomsTabPage
extends SearchTabPage {
    private final Lazy loadingStatus$delegate;
    private final Lazy channelRecyclerView$delegate;
    private final Lazy mRefreshLayout$delegate;
    private final Lazy mAdapter$delegate;
    private String mLastSearchKeywords;
    private final Lazy mBinder$delegate;
    private final Lazy searchService$delegate;
    private HashMap _$_findViewCache;

    private final CommonStatusLayout getLoadingStatus() {
        Lazy lazy = this.loadingStatus$delegate;
        SearchRoomsTabPage searchRoomsTabPage = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CommonStatusLayout)lazy.getValue();
    }

    private final YYRecyclerView getChannelRecyclerView() {
        Lazy lazy = this.channelRecyclerView$delegate;
        SearchRoomsTabPage searchRoomsTabPage = this;
        Object var3_3 = null;
        boolean bl = false;
        return (YYRecyclerView)lazy.getValue();
    }

    private final SmartRefreshLayout getMRefreshLayout() {
        Lazy lazy = this.mRefreshLayout$delegate;
        SearchRoomsTabPage searchRoomsTabPage = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SmartRefreshLayout)lazy.getValue();
    }

    private final MultiTypeAdapter getMAdapter() {
        Lazy lazy = this.mAdapter$delegate;
        SearchRoomsTabPage searchRoomsTabPage = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MultiTypeAdapter)lazy.getValue();
    }

    private final KvoBinder getMBinder() {
        Lazy lazy = this.mBinder$delegate;
        SearchRoomsTabPage searchRoomsTabPage = this;
        Object var3_3 = null;
        boolean bl = false;
        return (KvoBinder)lazy.getValue();
    }

    private final ISearchService getSearchService() {
        Lazy lazy = this.searchService$delegate;
        SearchRoomsTabPage searchRoomsTabPage = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ISearchService)lazy.getValue();
    }

    private final void refresh() {
        ISearchService iSearchService = this.getSearchService();
        String string2 = this.getSearchService().data().curSearchContent;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"searchService.data().curSearchContent");
        iSearchService.search(2, string2, (ICommonCallback)new ICommonCallback<SearchChannelRes>(this){
            final /* synthetic */ SearchRoomsTabPage this$0;

            public void onSuccess(@Nullable SearchChannelRes data, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                SearchRoomsTabPage.access$getMRefreshLayout$p(this.this$0).finishRefresh();
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                SearchRoomsTabPage.access$getMRefreshLayout$p(this.this$0).finishRefresh();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @Override
    public void search(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.mLastSearchKeywords = content;
        this.getMRefreshLayout().finishRefresh();
        this.getMRefreshLayout().finishLoadMore();
        this.getLoadingStatus().showLoading();
        this.getSearchService().search(2, content, (ICommonCallback)new ICommonCallback<SearchChannelRes>(this, content){
            final /* synthetic */ SearchRoomsTabPage this$0;
            final /* synthetic */ String $content;

            public void onSuccess(@Nullable SearchChannelRes data, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                SearchRoomsTabPage.access$getLoadingStatus$p(this.this$0).hideLoading();
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                ThreadBus.callThreadSafe((int)1, (Runnable)new Runnable(this){
                    final /* synthetic */ search.1 this$0;

                    public final void run() {
                        SearchRoomsTabPage.access$getLoadingStatus$p(this.this$0.this$0).hideLoading();
                        SearchHelper.reportEvent$default((String)"net_anomaly_show", null, (int)2, null);
                        SearchRoomsTabPage.access$getLoadingStatus$p(this.this$0.this$0).showNetErrorTryAgain(new View.OnClickListener(this){
                            final /* synthetic */ search.onFail.1 this$0;

                            public final void onClick(View it) {
                                this.this$0.this$0.this$0.search(this.this$0.this$0.$content);
                                SearchHelper.reportEvent$default((String)"net_anomaly_retry_click", null, (int)2, null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$content = $captured_local_variable$1;
            }
        });
    }

    @Override
    public void onSelect(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        SearchHelper.reportEvent$default((String)"result_channel_but_click", null, (int)2, null);
        if (Intrinsics.areEqual((Object)this.mLastSearchKeywords, (Object)content) ^ true) {
            CharSequence charSequence = content;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                this.search(content);
            }
        }
    }

    @Override
    @NotNull
    public String getTabName() {
        String string2 = ResourceUtils.getString((int)R.string.title_chatroom_tab_list);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ResourceUtils.getString(\u2026.title_chatroom_tab_list)");
        return string2;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getMBinder().singleBindSourceTo((KvoSource)this.getSearchService().data().roomSearchResultList);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getMBinder().clearAllKvoConnections();
    }

    @KvoMethodAnnotation(sourceClass=KvoPageList.class, name="datas")
    public final void updateSearchRoomResult(@NotNull KvoEventIntent eventIntent) {
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)eventIntent, (String)"eventIntent");
            if (eventIntent.isStickyNotify()) {
                return;
            }
            KvoList kvoList = (KvoList)eventIntent.newValue();
            if (kvoList == null) break block10;
            KvoList kvoList2 = kvoList;
            boolean bl = false;
            boolean bl2 = false;
            KvoList it = kvoList2;
            boolean bl3 = false;
            this.getMAdapter().setItems((List)it);
            KvoListHelper.NSRange nsRange = KvoListHelper.getNotifyRange((KvoEventIntent)eventIntent);
            switch (SearchRoomsTabPage$WhenMappings.$EnumSwitchMapping$0[KvoListHelper.getNotifyType((KvoEventIntent)eventIntent).ordinal()]) {
                case 1: {
                    this.getMAdapter().notifyItemRangeInserted(nsRange.position, nsRange.length);
                    break;
                }
                case 2: {
                    this.getMAdapter().notifyItemRangeChanged(nsRange.position, nsRange.length);
                    break;
                }
                case 3: {
                    this.getMAdapter().notifyItemRangeRemoved(nsRange.position, nsRange.length);
                    break;
                }
                case 4: {
                    this.getMAdapter().notifyDataSetChanged();
                    break;
                }
                case 5: {
                    this.getMAdapter().notifyItemMoved(nsRange.position, nsRange.length + nsRange.position);
                }
            }
            if (it.size() == 0) {
                this.getLoadingStatus().showNoData(R.string.title_search_result_no_data);
                SearchHelper.reportEvent$default((String)"no_result_show", null, (int)2, null);
            } else {
                this.getLoadingStatus().hideNoData();
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=KvoPageList.class, name="hasMore")
    public final void updateHasMore(@NotNull KvoEventIntent eventIntent) {
        Intrinsics.checkParameterIsNotNull((Object)eventIntent, (String)"eventIntent");
        this.getMRefreshLayout().setNoMoreData((Boolean)eventIntent.caseNewValue((Object)false) == false);
    }

    public SearchRoomsTabPage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.loadingStatus$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CommonStatusLayout>(this){
            final /* synthetic */ SearchRoomsTabPage this$0;

            public final CommonStatusLayout invoke() {
                return (CommonStatusLayout)this.this$0._$_findCachedViewById(R.id.loading_status);
            }
            {
                this.this$0 = searchRoomsTabPage;
                super(0);
            }
        }));
        this.channelRecyclerView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<YYRecyclerView>(this){
            final /* synthetic */ SearchRoomsTabPage this$0;

            public final YYRecyclerView invoke() {
                return (YYRecyclerView)this.this$0._$_findCachedViewById(R.id.recycler_view);
            }
            {
                this.this$0 = searchRoomsTabPage;
                super(0);
            }
        }));
        this.mRefreshLayout$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SmartRefreshLayout>(this){
            final /* synthetic */ SearchRoomsTabPage this$0;

            public final SmartRefreshLayout invoke() {
                return (SmartRefreshLayout)this.this$0._$_findCachedViewById(R.id.refresh_layout);
            }
            {
                this.this$0 = searchRoomsTabPage;
                super(0);
            }
        }));
        this.mAdapter$delegate = LazyKt.lazy((Function0)mAdapter.2.INSTANCE);
        this.mLastSearchKeywords = "";
        this.mBinder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KvoBinder>(this){
            final /* synthetic */ SearchRoomsTabPage this$0;

            @NotNull
            public final KvoBinder invoke() {
                return new KvoBinder((Object)((Object)this.this$0));
            }
            {
                this.this$0 = searchRoomsTabPage;
                super(0);
            }
        }));
        this.searchService$delegate = LazyKt.lazy((Function0)searchService.2.INSTANCE);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_search_result_tab_page, (ViewGroup)this);
        this.getMAdapter().register(RoomResultBean.class, (ItemViewBinder)new RoomsResultVH(context));
        this.getMAdapter().register(ChannelModuleBean.class, (ItemViewBinder)new RoomModuleVH(context));
        YYRecyclerView yYRecyclerView = this.getChannelRecyclerView();
        Intrinsics.checkExpressionValueIsNotNull((Object)yYRecyclerView, (String)"channelRecyclerView");
        yYRecyclerView.setAdapter((RecyclerView.Adapter)this.getMAdapter());
        SmartRefreshLayout smartRefreshLayout = this.getMRefreshLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)smartRefreshLayout, (String)"mRefreshLayout");
        smartRefreshLayout.setEnableRefresh(true);
        this.getMRefreshLayout().setOnLoadMoreListener(new OnLoadMoreListener(){

            public final void onLoadMore(@NotNull RefreshLayout it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getSearchService().loadNextPage(2, (ICommonCallback)new ICommonCallback<SearchChannelRes>(){

                    public void onSuccess(@Nullable SearchChannelRes data, Object ... ext) {
                        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                        this.getMRefreshLayout().finishLoadMore();
                    }

                    public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                        this.getMRefreshLayout().finishLoadMore();
                    }
                });
            }
        });
        this.getMRefreshLayout().setOnRefreshListener(new OnRefreshListener(){

            public final void onRefresh(@NotNull RefreshLayout it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.refresh();
            }
        });
    }

    public static final /* synthetic */ CommonStatusLayout access$getLoadingStatus$p(SearchRoomsTabPage $this) {
        return $this.getLoadingStatus();
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

