/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.push.base;

import android.app.Application;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.push.base.IPushHelper;
import com.yy.hiyo.push.base.IPushService;
import com.yy.hiyo.push.base.IPushServiceCreator;

public class PushSDKHelper {
    private static final String TAG = "PushSDKHelper";
    private static volatile IPushService sPushService;
    private static IPushServiceCreator sCreator;
    private static Class sMainActivityClass;
    private static boolean isSocketStateChanged;

    public static void init(IPushServiceCreator creator) {
        sCreator = creator;
        sPushService = creator.create();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProtoManager.getInstance().isWSConnected()) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)PushSDKHelper.TAG, (String)"isWSConnected sendPushToken", (Object[])new Object[0]);
                            }
                            if (!isSocketStateChanged) {
                                PushSDKHelper.onSocketStateChanged();
                            }
                        }
                    });
                }
            }
        });
    }

    public static IPushHelper initPushSdk(Class mainActivity) {
        sMainActivityClass = mainActivity;
        return PushSDKHelper.getPushService().getPushHelper();
    }

    public static void setPushProcParam(Application application) {
        PushSDKHelper.getPushService().getPushParamUtil().setPushProcParam(application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPushService getPushService() {
        if (sPushService == null) {
            if (sCreator != null) {
                Class<PushSDKHelper> clazz = PushSDKHelper.class;
                synchronized (PushSDKHelper.class) {
                    sPushService = sCreator.create();
                    MLog.error((Object)TAG, (String)"sPushService create", (Object[])new Object[0]);
                    // ** MonitorExit[var0] (shouldn't be in output)
                }
            } else {
                if (RuntimeContext.sIsDebuggable && SystemUtils.isShowEnvSetting()) {
                    throw new IllegalStateException("PushServiceCreator is not!");
                }
                MLog.error((Object)TAG, (String)"isWSConnected sendPushToken", (Object[])new Object[0]);
            }
        }
        return sPushService;
    }

    public static Class getMainActivityClass() {
        return sMainActivityClass;
    }

    public static void onSocketStateChanged() {
        if (sPushService != null) {
            isSocketStateChanged = true;
            IPushHelper pushHelper = sPushService.getPushHelper();
            pushHelper.clearTag();
            pushHelper.sendPushToken();
            pushHelper.initTag();
        }
    }
}

