/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import android.text.TextUtils;
import biz.FanGroupBadge;
import biz.IMMsgItem;
import biz.IMMsgSection;
import biz.SimpleCardInfo;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.bean.ChannelRobotInfo;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.bean.fansgroup.FansBadgeBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.textgroup.GroupUtils;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsgWrap;
import com.yy.hiyo.component.publicscreen.callback.IMsgTransform;
import java.util.ArrayList;
import java.util.List;

public class BaseMsgTransform
implements IMsgTransform {
    public BaseImMsg transform(String msgId, IMMsgItem msgItem) {
        return BaseMsgTransform.transformBy(msgId, msgItem, null);
    }

    public static BaseImMsg transformBy(String msgId, IMMsgItem msgItem, ChannelPushContent pushContent) {
        return BaseMsgTransform.transformBy(msgId, msgItem, pushContent, true, true);
    }

    public static BaseImMsg transformBy(String msgId, IMMsgItem msgItem, ChannelPushContent pushContent, boolean setUserMark, boolean setUserTitle) {
        List sectionsList;
        BaseImMsgWrap baseImMsg = new BaseImMsgWrap();
        baseImMsg.setFlags(msgItem.flags.longValue());
        if (msgItem.from_uinfo != null) {
            baseImMsg.setFrom(msgItem.from_uinfo.uid.longValue());
            baseImMsg.setNick(msgItem.from_uinfo.nick);
            baseImMsg.setSex(msgItem.from_uinfo.sex.intValue());
        }
        if (BaseMsgTransform.isRobotMsg(msgItem)) {
            BaseMsgTransform.generateRobotInfo((BaseImMsg)baseImMsg, msgItem);
        } else {
            baseImMsg.setRobotMsgType(0);
        }
        if (msgItem.cinfo != null) {
            baseImMsg.setCid(msgItem.cinfo.cid);
            baseImMsg.setChannelName(msgItem.cinfo.name);
            baseImMsg.setChannelOwnerId(msgItem.cinfo.owner.longValue());
            baseImMsg.setPwd(msgItem.cinfo.password);
            baseImMsg.setChannelType(msgItem.cinfo.channel_type.intValue());
            baseImMsg.setChannelAvatar(msgItem.cinfo.avatar);
            baseImMsg.setVersion(msgItem.cinfo.version.intValue());
            baseImMsg.setChannelSource(msgItem.cinfo.source);
            baseImMsg.setHighActiveTitle(msgItem.cinfo.high_active_title);
            baseImMsg.setMidActiveTitle(msgItem.cinfo.mid_active_title);
            baseImMsg.setLowActiveTitle(msgItem.cinfo.low_active_title);
            baseImMsg.setShowChannelNick(msgItem.cinfo.hidden_channel_nick == false);
            baseImMsg.setShowChannelTitle(msgItem.cinfo.show_channel_title.booleanValue());
        }
        baseImMsg.setChannelNick(msgItem.remark);
        baseImMsg.setChannelTitle(msgItem.title.intValue());
        if (msgItem.title == 1) {
            baseImMsg.setChannelTitleName(baseImMsg.getHighActiveTitle());
        } else if (msgItem.title == 2) {
            baseImMsg.setChannelTitleName(baseImMsg.getMidActiveTitle());
        } else {
            baseImMsg.setChannelTitleName(baseImMsg.getLowActiveTitle());
        }
        if (setUserTitle) {
            BaseMsgTransform.initMsgChannelTitle((BaseImMsg)baseImMsg);
        }
        baseImMsg.setSeqid(msgItem.seqid.longValue());
        baseImMsg.setMsgId(msgId);
        baseImMsg.setRole(msgItem.role.intValue());
        baseImMsg.setCseq(msgItem.cseq);
        baseImMsg.setAvatarUrl(msgItem.from_uinfo.avatar);
        baseImMsg.setTs(msgItem.ts.longValue());
        baseImMsg.setIsNewComer(msgItem.from_umark.new_comer.booleanValue());
        baseImMsg.setHasPartyLabel(msgItem.from_umark.party_label.booleanValue());
        baseImMsg.setFirstCharge(msgItem.from_umark.first_recharge.booleanValue());
        if (pushContent != null) {
            ChannelPushContent groupPushContentInner = new ChannelPushContent();
            groupPushContentInner.setTitle(pushContent.getTitle());
            groupPushContentInner.setPayload(pushContent.getPayload());
            groupPushContentInner.setContent(pushContent.getContent());
            groupPushContentInner.setAvatar(pushContent.getAvatar());
            groupPushContentInner.setPayloadString(new String(pushContent.getPayload()));
            baseImMsg.setGroupPushContent(groupPushContentInner);
        }
        if ((sectionsList = msgItem.sections) != null && !sectionsList.isEmpty()) {
            for (IMMsgSection section : sectionsList) {
                ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo> list;
                FansBadgeBean fansBadgeBean;
                FanGroupBadge mBadge;
                MsgSection section1 = new MsgSection();
                section1.setContent(section.content);
                section1.setType(section.type.intValue());
                section1.setExtention(section.extention);
                section1.setColor(section.color);
                section1.setJump(section.jump);
                section1.setTrans(section.trans);
                baseImMsg.getSections().add(section1);
                if (msgItem.from_umark == null || !setUserMark) continue;
                ArrayList honorIds = new ArrayList(msgItem.from_umark.medal_id);
                baseImMsg.setHonerIds(honorIds);
                if (msgItem.from_umark.fan_group_badge != null && msgItem.from_umark.fan_group_badge.anchor_uid != 0L) {
                    mBadge = msgItem.from_umark.fan_group_badge;
                    fansBadgeBean = new FansBadgeBean(mBadge.anchor_uid.longValue(), mBadge.lv.intValue(), mBadge.name, true);
                    baseImMsg.setFansBadge(fansBadgeBean);
                }
                if (msgItem.from_umark.cards != null) {
                    list = new ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo>();
                    for (SimpleCardInfo cardInfo : msgItem.from_umark.cards) {
                        list.add(new com.yy.hiyo.channel.base.bean.SimpleCardInfo(cardInfo.card_type.intValue(), cardInfo.level.intValue(), cardInfo.name, cardInfo.fid, cardInfo.sub_type));
                    }
                    baseImMsg.getUserTagInfos().postValue(list);
                }
                if (msgItem.from_umark.cards != null) {
                    list = new ArrayList();
                    for (SimpleCardInfo cardInfo : msgItem.from_umark.cards) {
                        list.add(new com.yy.hiyo.channel.base.bean.SimpleCardInfo(cardInfo.card_type.intValue(), cardInfo.level.intValue(), cardInfo.name, cardInfo.fid, cardInfo.sub_type));
                    }
                    baseImMsg.getUserTagInfos().postValue(list);
                }
                if (msgItem.from_umark.fan_group_badge != null && msgItem.from_umark.fan_group_badge.anchor_uid != 0L) {
                    mBadge = msgItem.from_umark.fan_group_badge;
                    fansBadgeBean = new FansBadgeBean(mBadge.anchor_uid.longValue(), mBadge.lv.intValue(), mBadge.name, true);
                    baseImMsg.setFansBadge(fansBadgeBean);
                }
                if (msgItem.from_uinfo == null) continue;
                PrivilegeHelper.INSTANCE.saveChatExt(msgItem.from_uinfo.uid.longValue(), msgItem.from_umark.chat_bubble_id.intValue(), msgItem.from_umark.nick_color_id.intValue());
            }
        }
        return baseImMsg;
    }

    private static void initMsgChannelTitle(BaseImMsg baseImMsg) {
        IChannel channel;
        if (SettingFlags.getBoolean((String)"key_high_frequency_request ", (boolean)true)) {
            return;
        }
        if (ServiceManagerProxy.getService(IChannelCenterService.class) != null && (channel = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(baseImMsg.getCid())) != null) {
            String titleColor = channel.getChannelTitleBgService().getTitle(baseImMsg.getChannelTitle());
            baseImMsg.setChannelTitleBg(titleColor);
            if (channel.getDataService().getCacheDetail() != null) {
                baseImMsg.setShowChannelTitle(channel.getDataService().getCacheDetail().baseInfo.isShowChannelTitle);
            }
            if (channel.getRoleService().isOwnerOrMaster(baseImMsg.getFrom())) {
                baseImMsg.setShowChannelTitle(false);
            }
        }
    }

    private static void generateRobotInfo(BaseImMsg baseImMsg, IMMsgItem msgItem) {
        if (msgItem.robotIns != null) {
            baseImMsg.setRobotMsgType(1);
            ChannelRobotInfo channelRobotInfo = new ChannelRobotInfo();
            channelRobotInfo.avatar = msgItem.robotIns.avatar;
            channelRobotInfo.cid = msgItem.robotIns.cid;
            channelRobotInfo.instanceId = msgItem.robotIns.insId;
            channelRobotInfo.detail = msgItem.robotIns.desc;
            channelRobotInfo.robotName = msgItem.robotIns.name;
            channelRobotInfo.robotId = msgItem.robotIns.tid;
            channelRobotInfo.ttype = msgItem.robotIns.ttype;
            baseImMsg.setChannelRobotInfo(channelRobotInfo);
        } else {
            baseImMsg.setRobotMsgType(0);
        }
    }

    private static boolean isRobotMsg(IMMsgItem msgItem) {
        return GroupUtils.containFlag((long)msgItem.flags, (int)8) || msgItem.robotIns != null && !TextUtils.isEmpty((CharSequence)msgItem.robotIns.insId) && !TextUtils.isEmpty((CharSequence)msgItem.robotIns.cid);
    }
}

