/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.graphics.Typeface;
import android.os.Message;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteState;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.widge.GroupGameInviteView;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.widget.GameDownloadingView;

public class GroupRightUserGameInviteHolder
extends AbsMsgTitleBarHolder<GameInviteMsg> {
    private static final String TAG = "GroupRightUserGameInvit";
    private GroupGameInviteView giv;
    private RecycleImageView ivGame;
    private YYTextView tvName;
    private YYTextView tvCountDown;
    private GameDownloadingView gdv;
    private YYTextView tvJoin;
    private YYTextView tvInvalid;
    private GameInviteState mGameInviteState;
    private boolean hasBindDownloading = false;
    private View[] mViews = new View[1];
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public GroupRightUserGameInviteHolder(@NonNull View itemView, boolean self) {
        super(itemView, self);
        this.ivGame = (RecycleImageView)itemView.findViewById(R.id.iv_c_game);
        this.tvName = (YYTextView)itemView.findViewById(R.id.tv_c_name);
        this.tvCountDown = (YYTextView)itemView.findViewById(R.id.tv_c_count_down);
        this.tvJoin = (YYTextView)itemView.findViewById(R.id.tv_c_func);
        this.tvInvalid = (YYTextView)itemView.findViewById(R.id.tv_c_invalid);
        this.gdv = (GameDownloadingView)itemView.findViewById(R.id.gdv_c);
        this.gdv.setMarkBackground(-16126);
        this.gdv.setBgSrc(null);
        int width = ResolutionUtils.dip2Px((float)42.0f);
        this.gdv.setType(2);
        this.gdv.setProgressBarWidth(width);
        this.gdv.setDefaultProgressBarWidth(width);
        this.gdv.setDefaultLightWidth(width);
        this.gdv.setProgressShow(false);
        View.OnClickListener listener2 = new View.OnClickListener(){

            public void onClick(View v) {
                if (GroupRightUserGameInviteHolder.this.mActionHandler != null) {
                    Message msg = Message.obtain();
                    msg.what = ActionDefine.CLICK_GAME_INVITE;
                    msg.obj = GroupRightUserGameInviteHolder.this.getItemMsg();
                    GroupRightUserGameInviteHolder.this.mActionHandler.onAction(msg);
                }
            }
        };
        this.tvJoin.setOnClickListener(listener2);
        this.tvInvalid.setOnClickListener(listener2);
        FontUtils.setFontType((TextView)this.tvCountDown, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mViews[0] = itemView;
    }

    @Override
    public void bindView(GameInviteMsg newData, int position) {
        super.bindView(newData, position);
        if (newData.getGameInviteState().getGameInfo() == null) {
            this.itemView.setVisibility(8);
            MLog.error((Object)TAG, (String)"receive game invite without game info in cache", (Object[])new Object[0]);
            return;
        }
        this.itemView.setVisibility(0);
        this.bindData(newData);
    }

    private void bindData(@NonNull GameInviteMsg msg) {
        if (this.mGameInviteState != null && msg != null && msg.getGameInviteState() != this.mGameInviteState) {
            this.mBinder.clearAllKvoConnections();
            this.hasBindDownloading = false;
        }
        this.mGameInviteState = msg.getGameInviteState();
        this.mBinder.singleBindSourceTo((KvoSource)this.mGameInviteState);
        ImageLoader.loadImage((ImageView)this.ivGame, (String)(this.mGameInviteState.getGameInfo() != null ? this.mGameInviteState.getGameInfo().getIconUrl() : ""), (int)R.drawable.shape_f3f3f3_5dp_corner);
        this.tvName.setText((CharSequence)(this.mGameInviteState.getGameInfo() != null ? this.mGameInviteState.getGameInfo().getGname() : ""));
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameInviteState.class, thread=1)
    public void onInviteStateChange(KvoEventIntent event) {
        int state = this.mGameInviteState.getState();
        if (state == 1) {
            this.tvJoin.setVisibility(0);
            this.tvJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.im_push_join));
            this.gdv.setVisibility(8);
            this.tvInvalid.setVisibility(8);
            this.unbindDownloading();
        } else if (state == 2) {
            this.tvJoin.setVisibility(8);
            this.gdv.setVisibility(0);
            this.tvInvalid.setVisibility(8);
            this.bindDownloading();
        } else if (state == 3) {
            this.tvJoin.setVisibility(0);
            this.tvJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_cancel));
            this.gdv.setVisibility(8);
            this.tvInvalid.setVisibility(8);
            this.unbindDownloading();
        } else if (state == 4) {
            this.tvJoin.setVisibility(8);
            this.gdv.setVisibility(8);
            this.tvInvalid.setVisibility(0);
            this.tvCountDown.setText((CharSequence)"0");
            this.tvCountDown.setVisibility(8);
            this.tvInvalid.setText((CharSequence)ResourceUtils.getString((int)(((GameInviteMsg)this.getItemMsg()).getFrom() == AccountUtil.getUid() ? R.string.btn_cancel : R.string.joingame)));
            this.unbindDownloading();
        }
    }

    @KvoMethodAnnotation(name="countDown", sourceClass=GameInviteState.class, thread=1)
    public void onInviteCountDownChange(KvoEventIntent event) {
        int state = this.mGameInviteState.getState();
        if (state != 4 && this.mGameInviteState != null) {
            this.tvCountDown.setVisibility(0);
            this.tvCountDown.setText((CharSequence)(this.mGameInviteState.getCountDown() + ""));
        } else {
            this.tvCountDown.setText((CharSequence)"0");
            this.tvCountDown.setVisibility(8);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public void onDownLoadSuccess(KvoEventIntent event) {
        if (this.mGameInviteState != null && event.newValue() != null && event.newValue() == GameDownloadInfo.DownloadState.download_finish && this.mGameInviteState.getState() == 2) {
            this.mGameInviteState.setState(this.mGameInviteState.getPendingState());
        }
    }

    private void unbindDownloading() {
        if (this.hasBindDownloading && this.mGameInviteState != null && this.mGameInviteState.getGameInfo() != null && this.mGameInviteState.getGameInfo().downloadInfo != null) {
            this.mBinder.clearKvoConnection("GameDownloadInfo");
            this.hasBindDownloading = false;
        }
    }

    private void bindDownloading() {
        if (!this.hasBindDownloading && this.mGameInviteState != null && this.mGameInviteState.getGameInfo() != null && this.mGameInviteState.getGameInfo().downloadInfo != null) {
            this.hasBindDownloading = true;
            this.mBinder.singleBindSourceTo("GameDownloadInfo", (KvoSource)this.mGameInviteState.getGameInfo().downloadInfo);
            this.gdv.setGameInfo(this.mGameInviteState.getGameInfo());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mBinder.clearAllKvoConnections();
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }
}

