/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.os.Message;
import android.text.SpannableString;
import android.text.style.LeadingMarginSpan;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.GrabPacketMsg;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.PacketChatMsg;

public class GrabPacketMsgHolder
extends AbsMsgItemHolder<GrabPacketMsg> {
    private CircleImageView ivHead;
    private YYTextView tvContent;
    private int recyclerViewWidth = 0;

    public GrabPacketMsgHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivHead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_c_text);
        RecycleImageView ivPacket = (RecycleImageView)itemView.findViewById(R.id.iv_packet);
        if ("ae".equalsIgnoreCase(AccountUtil.registerCountry()) || "id".equalsIgnoreCase(AccountUtil.registerCountry())) {
            ivPacket.setImageResource(R.drawable.green_packet_public_chat);
        } else {
            ivPacket.setImageResource(R.drawable.packet_public_chat);
        }
        itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PacketChatMsg.OnClickListener listener2;
                PacketChatMsg.OnClickListener onClickListener = listener2 = ((GrabPacketMsg)((Object)GrabPacketMsgHolder.this.getItemMsg())).getPacketMsg() != null ? ((GrabPacketMsg)((Object)GrabPacketMsgHolder.this.getItemMsg())).getPacketMsg().getListener() : null;
                if (listener2 != null) {
                    listener2.onClick(((GrabPacketMsg)((Object)GrabPacketMsgHolder.this.getItemMsg())).getPacketMsg());
                }
            }
        });
    }

    @Override
    public void bindView(GrabPacketMsg newData, int position) {
        super.bindView(newData, position);
        PacketChatMsg packetMsg = newData.getPacketMsg();
        if (packetMsg != null) {
            ImageLoader.loadImage((RecycleImageView)this.ivHead, (String)packetMsg.getIconUrl(), (int)packetMsg.getDefaultIconRes());
            this.updateText(packetMsg.getMessage());
        }
        if (((GrabPacketMsg)((Object)this.getItemMsg())).getFrom() > 0L) {
            this.ivHead.setOnClickListener(v -> {
                if (this.mActionHandler != null) {
                    Message msg = Message.obtain();
                    msg.what = ActionDefine.SHOW_USER_PROFILE;
                    msg.obj = ((GrabPacketMsg)((Object)((Object)this.getItemMsg()))).getFrom();
                    this.mActionHandler.onAction(msg);
                }
            });
        } else {
            this.ivHead.setOnClickListener(null);
            this.ivHead.setClickable(false);
        }
        this.ivHead.requestLayout();
        if (this.recyclerViewWidth == 0) {
            this.itemView.post(() -> {
                ViewParent parent = this.itemView.getParent();
                if (parent != null) {
                    this.recyclerViewWidth = ((View)parent).getWidth();
                    this.tvContent.setMaxWidth(this.recyclerViewWidth - ResourceUtils.getDimen((int)R.dimen.dp_5));
                }
            });
        } else {
            this.tvContent.setMaxWidth(this.recyclerViewWidth - ResourceUtils.getDimen((int)R.dimen.dp_5));
        }
    }

    private void updateText(CharSequence text) {
        int indentDistance = this.tvContent.getContext().getResources().getDimensionPixelSize(R.dimen.dp_35);
        SpannableString spannableString = new SpannableString(text);
        LeadingMarginSpan.Standard what = new LeadingMarginSpan.Standard(indentDistance, 0);
        spannableString.setSpan((Object)what, 0, spannableString.length(), 18);
        this.tvContent.setText((CharSequence)spannableString);
    }
}

