/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.content.Context;
import android.os.Message;
import android.text.Spannable;
import android.text.style.LeadingMarginSpan;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import biz.SourceEntry;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.EnterRoomSourceConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.EnterRoomMsg;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;

public class EnterRoomMsgHolder
extends AbsMsgItemHolder<EnterRoomMsg> {
    private static final String TAG = "EnterRoomMsgHolder";
    private CircleImageView ivhead;
    private YYTextView tvText;
    private RecycleImageView ivIcon;
    private RecycleImageView ivTag;
    private YYTextView tvNewTag;
    private int simpleContentMarginStart = -1;
    private HashMap<String, String> mSourceMap;

    public EnterRoomMsgHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivhead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvText = (YYTextView)itemView.findViewById(R.id.tv_c_text);
        this.ivIcon = (RecycleImageView)itemView.findViewById(R.id.iv_c_img);
        this.ivTag = (RecycleImageView)itemView.findViewById(R.id.iv_tag);
        this.tvNewTag = (YYTextView)itemView.findViewById(R.id.tv_new_tag);
        this.ivhead.setOnClickListener(v -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.SHOW_USER_PROFILE;
                msg.obj = ((EnterRoomMsg)((Object)((Object)this.getItemMsg()))).getUid();
                this.mActionHandler.onAction(msg);
            }
        });
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.ENTER_ROOM_SOURCE_CONFIG);
        if (config instanceof EnterRoomSourceConfig) {
            this.mSourceMap = ((EnterRoomSourceConfig)config).getData().getData();
        }
        this.tvNewTag.setOnClickListener(v -> ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tip_new_user_tag_click));
        this.ivTag.setOnClickListener(v -> ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_click_first_charge_label));
    }

    @Override
    public void bindView(EnterRoomMsg newData, int position) {
        super.bindView(newData, position);
        MLog.info((Object)TAG, (String)("bindView source = " + newData.getSource()), (Object[])new Object[0]);
        ImageLoader.loadImage((RecycleImageView)this.ivhead, (String)(newData.getIconUrl() + YYImageUtils.getThumbSmall()));
        if (newData.isOwner() && newData.getSource() == SourceEntry.SE_FRIEND_BROADCAST.getValue()) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "owner_screen_welcome_show"));
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room_from_broadcast));
        } else {
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room));
        }
        this.setNobleIcon(newData);
        this.setTag(newData);
    }

    private void greerMessageByFrom(EnterRoomMsg newData) {
        if (FP.empty(this.mSourceMap)) {
            MLog.info((Object)TAG, (String)"config source not fetch success, source map is empty", (Object[])new Object[0]);
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room));
        } else if (this.mSourceMap.containsKey(newData.getSource() + "")) {
            this.greetMessage(newData, this.mSourceMap.get(newData.getSource() + ""));
        } else {
            MLog.info((Object)TAG, (String)"the source %s not contains in source map", (Object[])new Object[]{newData.getSource()});
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room));
        }
    }

    private void setNobleIcon(EnterRoomMsg newData) {
        if (!newData.isNobleEntry() || StringUtils.isEmpty((String)newData.getNobleIcon())) {
            this.ivIcon.setVisibility(8);
        } else {
            this.ivIcon.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.ivIcon, (String)newData.getNobleIcon());
        }
    }

    private void setTag(EnterRoomMsg data) {
        if (data.isFirstCharge()) {
            this.ivTag.setVisibility(0);
            this.tvNewTag.setVisibility(8);
        } else if (data.isNewComer()) {
            this.ivTag.setVisibility(8);
            this.tvNewTag.setVisibility(0);
        } else {
            this.ivTag.setVisibility(8);
            this.tvNewTag.setVisibility(8);
        }
    }

    private void greetMessage(EnterRoomMsg newData, String msg) {
        ChainSpan.of().append((CharSequence)newData.getNick()).space().append((CharSequence)msg, new Object[]{TextSpan.of().color(ResourceUtils.getColor((int)R.color.color_ffec87)).build()}).build(spannable -> {
            this.updateContent((Spannable)spannable);
            return null;
        });
    }

    private void updateContent(Spannable text) {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.tvText.getLayoutParams();
        layoutParams.leftMargin = this.getSimpleContentMarginStart(this.tvText.getContext());
        this.tvText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.ivhead.post(() -> {
            int indentDistance = this.ivhead.getWidth() + this.getSimpleContentMarginStart(this.ivhead.getContext());
            this.setTextIndent(text, indentDistance);
        });
    }

    private void setTextIndent(Spannable text, int indentDistance) {
        MLog.debug((Object)TAG, (String)("setTextIndent: " + text + ", indentDistance: " + indentDistance), (Object[])new Object[0]);
        LeadingMarginSpan.Standard what = new LeadingMarginSpan.Standard(indentDistance, 0);
        text.setSpan((Object)what, 0, text.length(), 18);
        this.tvText.setText((CharSequence)text);
    }

    private int getSimpleContentMarginStart(Context context) {
        if (this.simpleContentMarginStart != -1) {
            return this.simpleContentMarginStart;
        }
        this.simpleContentMarginStart = context.getResources().getDimensionPixelSize(R.dimen.dp_5);
        return this.simpleContentMarginStart;
    }
}

