/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.adapter;

import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;

public class WrapContentLinearLayoutManager
extends LinearLayoutManager {
    private static final String TAG = "WrapContentLinearLayout";
    private WeakReference<ICallback> mCallback = new WeakReference<Object>(null);

    public WrapContentLinearLayoutManager(Context context) {
        super(context);
    }

    public WrapContentLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
    }

    public WrapContentLinearLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        block3: {
            try {
                super.onLayoutChildren(recycler, state);
            }
            catch (Exception e) {
                if (SystemUtils.isShowEnvSetting()) {
                    throw e;
                }
                e.printStackTrace();
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("perftype", "public_screen_crash");
                statContent.put("ifield", this.findFirstVisibleItemPosition());
                statContent.put("ifieldtwo", this.findLastVisibleItemPosition());
                statContent.put("ifieldthree", this.getChildCount());
                statContent.put("sfield", e.getMessage());
                HiidoStatis.reportContent((StatisContent)statContent);
                MLog.info((Object)TAG, (String)"WrapContentLinearLayoutManager crash state:%s, e:%s,", (Object[])new Object[]{e, state});
                if (this.mCallback == null || this.mCallback.get() == null) break block3;
                ((ICallback)this.mCallback.get()).resetWhenException();
            }
        }
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        CenterSmoothScroller smoothScroller = new CenterSmoothScroller(recyclerView.getContext());
        smoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
    }

    public void setCallback(ICallback callback) {
        this.mCallback = new WeakReference<ICallback>(callback);
    }

    public static interface ICallback {
        public void resetWhenException();
    }

    private class CenterSmoothScroller
    extends LinearSmoothScroller {
        CenterSmoothScroller(Context context) {
            super(context);
        }

        @Nullable
        public PointF computeScrollVectorForPosition(int targetPosition) {
            return WrapContentLinearLayoutManager.this.computeScrollVectorForPosition(targetPosition);
        }

        public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
            return boxStart + (boxEnd - boxStart) / 2 - (viewStart + (viewEnd - viewStart) / 2);
        }

        protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
            return 0.2f;
        }

        protected int getVerticalSnapPreference() {
            return -1;
        }
    }
}

