/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.proto;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.StatInitDelegate;
import com.yy.base.okhttp.websocket.WsCallback;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.okhttp.websocket.WsStatus;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.GzipUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.proto.AbsCIMProtoDispatch;
import com.yy.hiyo.proto.AbsProtoDispatch;
import com.yy.hiyo.proto.CIMProtoDispatchRpc;
import com.yy.hiyo.proto.GlobalBanInterface;
import com.yy.hiyo.proto.HeartBeatTask;
import com.yy.hiyo.proto.IDispatchCallback;
import com.yy.hiyo.proto.IHeartMonitor;
import com.yy.hiyo.proto.IProtoInnerCallback;
import com.yy.hiyo.proto.IResponseInterceptor;
import com.yy.hiyo.proto.NotifyDispatch;
import com.yy.hiyo.proto.NotifyFrequencyHandler;
import com.yy.hiyo.proto.OneNotifyFrequencyHandler;
import com.yy.hiyo.proto.ProtoDispatch;
import com.yy.hiyo.proto.ProtoDispatchRpc;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.hiyo.proto.ProtoUtils;
import com.yy.hiyo.proto.ReliableBroadcastStrategy;
import com.yy.hiyo.proto.WsCIMRequest;
import com.yy.hiyo.proto.WsRequest;
import com.yy.hiyo.proto.callback.ICIMProtoCallback;
import com.yy.hiyo.proto.callback.ICIMProtoNotify;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.ISocketStateChangeListener;
import com.yy.hiyo.proto.notify.INotifyInterceptor;
import com.yy.hiyo.proto.notify.INotifyMonitor;
import com.yy.hiyo.proto.notify.NotifyData;
import com.yy.hiyo.proto.rpc.RpcMethod;
import com.yy.hiyo.proto.thirdnotify.IThirdNotify;
import com.yy.hiyo.proto.thirdnotify.ThirdNotifyDispatch;
import common.Header;
import ikxd.cproxy.EMsgType;
import ikxd.cproxy.EMsgUnpackType;
import ikxd.cproxy.InnerV2;
import ikxd.cproxy.InnerV3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.Variable;
import org.msgpack.value.impl.ImmutableStringValueImpl;

class ProtoInnerImp
implements WsCallback,
IDispatchCallback {
    private static final String TAG = "ProtoInnerImp";
    static final long TIMEOUT_INTERVAL = 10000L;
    private static final long CHECK_TIMEOUT_INTERVAL = 10000L;
    static final long MAX_RETRY_COUNT = 3L;
    private final Map<String, WsClient> mWsService = new HashMap<String, WsClient>(1);
    private final HashMap<WsClient, HeartBeatTask> mWsHeartBeat = new HashMap();
    private final ArrayList<ISocketStateChangeListener> mSocketStateChangeListeners = new ArrayList(3);
    private IQueueTaskExecutor mTaskExecutor = null;
    private ProtoDispatch mProtoDispatch;
    private ProtoDispatchRpc mProtoDispatchRpc;
    private NotifyDispatch mNotifyDispatch;
    private ThirdNotifyDispatch mThirdNotifyDispatch;
    private CIMProtoDispatchRpc mCIMProtoDispatchRpc;
    private NotifyFrequencyHandler mNotifyFrequencyHandler;
    private INotifyMonitor mNotifyMonitor;
    private long mLastTimeoutCheck = -1L;
    private String mLastTimeoutCheckStr = "";
    private Runnable mCheckTimeoutTask = new Runnable(){

        @Override
        public void run() {
            ProtoInnerImp.this.checkTimeoutReq();
            YYTaskExecutor.removeTask((Runnable)ProtoInnerImp.this.mCheckTimeoutTask);
            YYTaskExecutor.execute((Runnable)ProtoInnerImp.this.mCheckTimeoutTask, (long)10000L);
        }
    };
    private GlobalBanInterface mGlobalBanInterface;

    protected int getCurWsTaskNum() {
        int protoDispatchNum = this.mProtoDispatch != null ? this.mProtoDispatch.getCurTaskSize() : 0;
        int protoDispatchRpcNum = this.mProtoDispatchRpc != null ? this.mProtoDispatchRpc.getCurTaskSize() : 0;
        return protoDispatchNum + protoDispatchRpcNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsClient getWsClient(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        Map<String, WsClient> map = this.mWsService;
        synchronized (map) {
            return this.mWsService.get(url);
        }
    }

    @Override
    public void execute(Runnable r, long delay) {
        if (SettingFlags.getBoolean((String)"keynetopenthreadopt", (boolean)true)) {
            this.mTaskExecutor.execute(r, delay, 5);
        } else {
            this.mTaskExecutor.execute(r, delay);
        }
    }

    @Override
    public void notify(InnerV2 inner, byte[] bytes) {
        if (bytes == null) {
            return;
        }
        NotifyFrequencyHandler notifyFrequencyHandler = this.getNotifyFrequencyHandler();
        if (notifyFrequencyHandler != null) {
            notifyFrequencyHandler.notify(inner, bytes);
        } else {
            this.getNotifyDispatch().notify(inner, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProtoDispatch getProtoDispatch() {
        if (this.mProtoDispatch != null) return this.mProtoDispatch;
        Class<ProtoInnerImp> clazz = ProtoInnerImp.class;
        synchronized (ProtoInnerImp.class) {
            if (this.mProtoDispatch != null) return this.mProtoDispatch;
            this.mProtoDispatch = new ProtoDispatch(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mProtoDispatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProtoDispatchRpc getProtoDispatchRpc() {
        if (this.mProtoDispatchRpc != null) return this.mProtoDispatchRpc;
        Class<ProtoInnerImp> clazz = ProtoInnerImp.class;
        synchronized (ProtoInnerImp.class) {
            if (this.mProtoDispatchRpc != null) return this.mProtoDispatchRpc;
            this.mProtoDispatchRpc = new ProtoDispatchRpc(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mProtoDispatchRpc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NotifyDispatch getNotifyDispatch() {
        if (this.mNotifyDispatch != null) return this.mNotifyDispatch;
        Class<ProtoInnerImp> clazz = ProtoInnerImp.class;
        synchronized (ProtoInnerImp.class) {
            if (this.mNotifyDispatch != null) return this.mNotifyDispatch;
            this.mNotifyDispatch = new NotifyDispatch();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mNotifyDispatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ThirdNotifyDispatch getThirdNotifyDispatch() {
        if (this.mThirdNotifyDispatch != null) return this.mThirdNotifyDispatch;
        Class<ProtoInnerImp> clazz = ProtoInnerImp.class;
        synchronized (ProtoInnerImp.class) {
            if (this.mThirdNotifyDispatch != null) return this.mThirdNotifyDispatch;
            this.mThirdNotifyDispatch = new ThirdNotifyDispatch();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mThirdNotifyDispatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CIMProtoDispatchRpc getCIMProtoDispatchRpc() {
        if (this.mCIMProtoDispatchRpc != null) return this.mCIMProtoDispatchRpc;
        Class<ProtoInnerImp> clazz = ProtoInnerImp.class;
        synchronized (ProtoInnerImp.class) {
            if (this.mCIMProtoDispatchRpc != null) return this.mCIMProtoDispatchRpc;
            this.mCIMProtoDispatchRpc = new CIMProtoDispatchRpc(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mCIMProtoDispatchRpc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHeartBeat(WsClient cli, String wsUrl) {
        HeartBeatTask ht = null;
        HashMap<WsClient, HeartBeatTask> hashMap = this.mWsHeartBeat;
        synchronized (hashMap) {
            HeartBeatTask oldHeartBeatTask = this.mWsHeartBeat.get(cli);
            if (oldHeartBeatTask != null) {
                oldHeartBeatTask.stop();
                YYTaskExecutor.removeTask((Runnable)oldHeartBeatTask);
            }
            ht = new HeartBeatTask(cli, wsUrl);
            this.mWsHeartBeat.put(cli, ht);
        }
        MLog.error((Object)TAG, (String)"HeartBeat start exec %s!", (Object[])new Object[]{wsUrl});
        YYTaskExecutor.execute((Runnable)ht, (long)0L, (int)5);
    }

    public void onConnectSucceed(WsClient cli, String wsUrl) {
        YYTaskExecutor.removeTask((Runnable)this.mCheckTimeoutTask);
        YYTaskExecutor.execute((Runnable)this.mCheckTimeoutTask, (long)10000L);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onConnectSucceed", (Object[])new Object[0]);
        }
        this.startHeartBeat(cli, wsUrl);
        this.socketStateChanged(102, wsUrl, "");
        if (SettingFlags.getBoolean((String)"wsrequestresend", (boolean)false)) {
            if (this.mProtoDispatch != null) {
                this.mProtoDispatch.onWsConnectSucceed(cli, wsUrl);
            }
            if (this.mProtoDispatchRpc != null) {
                this.mProtoDispatchRpc.onWsConnectSucceed(cli, wsUrl);
            }
        }
    }

    public void onConnectFailed(WsClient cli, String wsUrl, int code) {
        this.onSomeError(false, "connect web socket failed and had try with max time", code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnecting(WsClient socket, String wsUrl, int code) {
        ArrayList<ISocketStateChangeListener> arrayList = this.mSocketStateChangeListeners;
        synchronized (arrayList) {
            for (ISocketStateChangeListener listener : this.mSocketStateChangeListeners) {
                if (listener == null) continue;
                listener.onSocketStateChanged(code, wsUrl, "");
            }
        }
    }

    public void onResponse(WsClient cli, String wsUrl, String text) {
    }

    public void onResponse(WsClient cli, String wsUrl, byte[] resData) {
        long networkRt = System.currentTimeMillis();
        if (resData == null) {
            MLog.error((Object)TAG, (String)"web socket response data is null", (Object[])new Object[0]);
            return;
        }
        this.execute(() -> this.handleResponse(wsUrl, resData, networkRt), 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleResponse(String wsUrl, byte[] resData, long networkRt) {
        InnerV2 inner;
        int size;
        byte[] bytes = resData;
        int n = size = bytes != null ? bytes.length : 0;
        if (WsClient.isUseSupportGzip()) {
            bytes = this.useGzip(resData);
        }
        if (bytes == null) {
            bytes = resData;
        }
        if ((inner = ProtoUtils.parseInner(bytes)) == null || inner.header == null) {
            InnerV3 innerV3 = ProtoUtils.parseInnerV3(bytes);
            MLog.debug((Object)TAG, (String)("InnerV3 decode " + (Object)((Object)innerV3)), (Object[])new Object[0]);
            if (innerV3 == null || innerV3.magic == null || innerV3.magic != 1214343022L) return;
            if (innerV3.msgtype.intValue() == EMsgType.MSG_DOWNSTREAM_RELIABLE.getValue()) {
                long localSeqId = ReliableBroadcastStrategy.getSeqId();
                if (localSeqId != 0L && localSeqId > innerV3.seqid) {
                    MLog.debug((Object)TAG, (String)("duplicated broadcast, drop it localSeqId  " + localSeqId + " innerV3.seqid " + innerV3.seqid), (Object[])new Object[0]);
                    return;
                }
                ReliableBroadcastStrategy.updateReliableBroadcastSeqId(innerV3.seqid);
            }
            if (innerV3.version.intValue() != EMsgUnpackType.MSG_UNPACK_INNERV2.getValue()) return;
            bytes = innerV3.payload.toByteArray();
            inner = ProtoUtils.parseInner(bytes);
            MLog.debug((Object)TAG, (String)("InnerV3 Msg Unpack InnerV2 decode InnerV2 " + (Object)((Object)inner)), (Object[])new Object[0]);
            if (inner == null) {
                HashMap<String, String> moreInfo = new HashMap<String, String>(1);
                moreInfo.put("seqid", innerV3.seqid + "");
                StatInitDelegate.metric((String)"ws_reliable_v3_decodeV2", (long)(System.currentTimeMillis() - networkRt), (String)"1", moreInfo, (boolean)true);
            }
        }
        if (inner == null) {
            MLog.error((Object)TAG, (String)"parse response Inner proto fail, callback will not be called, but may callback with timeout ", (Object[])new Object[0]);
            return;
        }
        Header header = inner.header;
        if (header == null) {
            MLog.error((Object)TAG, (String)"parse response Header proto fail, callback will not be called, but may callback with timeout ", (Object[])new Object[0]);
            return;
        }
        if ("cim.private.hago.proxy".equals(header.sname) || "net.ihago.im.srv.imcheck".equals(header.sname)) {
            this.getCIMProtoDispatchRpc().onResponse(wsUrl, inner.encode(), inner, size);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)header.version)) {
            if (header.msgtype == Header.MSGTYPE.MSGTYPE_NOTICE) {
                if (inner.payload != null) {
                    byte[] payload = inner.payload.toByteArray();
                    NotifyFrequencyHandler notifyFrequencyHandler = this.getNotifyFrequencyHandler();
                    if (notifyFrequencyHandler != null) {
                        notifyFrequencyHandler.notify(inner, payload);
                        return;
                    } else {
                        this.dispatchNotify(inner, payload);
                    }
                    return;
                } else {
                    MLog.error((Object)TAG, (String)"handleResponse payload is null", (Object[])new Object[0]);
                }
                return;
            } else {
                if (header.msgtype != Header.MSGTYPE.MSGTYPE_RESP) return;
                this.getProtoDispatchRpc().onResponse(wsUrl, bytes, inner, size, networkRt);
            }
            return;
        }
        this.getProtoDispatch().onResponse(wsUrl, bytes, inner, size, networkRt);
    }

    private void dispatchNotify(InnerV2 inner, byte[] payload) {
        Header header = inner.header;
        if ("net.ihago.ymicro.srv.ypush".equals(header.sname)) {
            this.getThirdNotifyDispatch().notify(inner, payload);
        } else if ("cim.impush".equals(header.sname)) {
            this.getCIMProtoDispatchRpc().onNotify(inner, payload);
        } else {
            this.getNotifyDispatch().notify(inner, payload);
        }
    }

    private void dispatchNotifys(String sname, List<NotifyData> notifys) {
        if (notifys == null) {
            return;
        }
        if ("net.ihago.ymicro.srv.ypush".equals(sname)) {
            this.getThirdNotifyDispatch().notify(notifys);
        } else if ("cim.impush".equals(sname)) {
            for (NotifyData data : notifys) {
                this.getCIMProtoDispatchRpc().onNotify(data.innerV2(), data.payload());
            }
        } else {
            this.getNotifyDispatch().notify(notifys);
        }
    }

    public void setNotifyMonitor(INotifyMonitor notifyMonitor) {
        this.mNotifyMonitor = notifyMonitor;
    }

    private NotifyFrequencyHandler getNotifyFrequencyHandler() {
        if (this.mNotifyFrequencyHandler == null && this.mNotifyMonitor != null) {
            this.mNotifyFrequencyHandler = new NotifyFrequencyHandler(new OneNotifyFrequencyHandler.INotifySender(){

                @Override
                public void notify(InnerV2 inner, byte[] payload) {
                    ProtoInnerImp.this.dispatchNotify(inner, payload);
                }

                @Override
                public void notify(String sname, List<NotifyData> notifys) {
                    ProtoInnerImp.this.dispatchNotifys(sname, notifys);
                }

                @Override
                public boolean isFrequencyLimitSwitchOn(String sname) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.isFrequencyLimitSwitchOn(sname) : false;
                }

                @Override
                public boolean isFrequencyLimitSwitchOn(String sname, int uri) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.isFrequencyLimitSwitchOn(sname, uri) : false;
                }

                @Override
                public long getFrequencyTime(String sname, int uri) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.getFrequencyTime(sname, uri) : 50L;
                }

                @Override
                public boolean isReplaceable(String sname, int uri) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.isReplaceable(sname, uri) : false;
                }

                @Override
                public boolean canNotifyList(String sname, int uri) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.canNotifyList(sname, uri) : false;
                }

                @Override
                public int getForceClearThreshold(String sname, int uri) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.getForceClearThreshold(sname, uri) : Integer.MAX_VALUE;
                }

                @Override
                public void setConfigUpdateCommand(Runnable command) {
                    if (ProtoInnerImp.this.mNotifyMonitor != null) {
                        ProtoInnerImp.this.mNotifyMonitor.setConfigUpdateCommand(command);
                    }
                }

                @Override
                public void setLowMemeryCommand(Runnable command) {
                    if (ProtoInnerImp.this.mNotifyMonitor != null) {
                        ProtoInnerImp.this.mNotifyMonitor.setLowMemeryCommand(command);
                    }
                }

                @Override
                public List<NotifyData> intercept(List<NotifyData> originData) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.intercept(originData) : originData;
                }

                @Override
                public boolean isNeedStatCacheExceedNumLimit() {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.isNeedStatCacheExceedNumLimit() : false;
                }

                @Override
                public int getCacheNumLimit(String name) {
                    return ProtoInnerImp.this.mNotifyMonitor != null ? ProtoInnerImp.this.mNotifyMonitor.getCacheNumLimit(name) : Integer.MAX_VALUE;
                }

                @Override
                public void onCacheExceedNumLimit(String name, long cacheNum, List<Integer> uris) {
                    if (ProtoInnerImp.this.mNotifyMonitor != null) {
                        ProtoInnerImp.this.mNotifyMonitor.onCacheExceedNumLimit(name, cacheNum, uris);
                    }
                }
            });
        }
        return this.mNotifyFrequencyHandler;
    }

    private byte[] useGzip(byte[] resData) {
        byte[] bytes;
        long startTime = -1L;
        if (RuntimeContext.sIsDebuggable) {
            startTime = System.currentTimeMillis();
        }
        MessageUnpacker unpacker = null;
        boolean iszip = false;
        int len = -1;
        byte[] data = null;
        try {
            unpacker = MessagePack.newDefaultUnpacker((byte[])resData);
            Variable variable = new Variable();
            unpacker.unpackValue(variable);
            Map valueMap = null;
            if (variable.isMapValue()) {
                MapValue mapValue = variable.asMapValue();
                valueMap = mapValue.map();
            }
            if (valueMap != null) {
                Value value = (Value)valueMap.get(new ImmutableStringValueImpl("IsZip"));
                if (value != null && value.isBooleanValue()) {
                    iszip = value.asBooleanValue().getBoolean();
                }
                if ((value = (Value)valueMap.get(new ImmutableStringValueImpl("ZipDataLen"))) != null && value.isIntegerValue()) {
                    len = value.asIntegerValue().asInt();
                }
            }
            if (len > 0) {
                data = new byte[len];
                unpacker.readPayload(data);
            }
            bytes = data;
            if (len > 0 && data != null) {
                if (iszip) {
                    bytes = GzipUtils.decompressForGzip((byte[])bytes);
                }
            } else {
                bytes = resData;
            }
        }
        catch (Exception e) {
            if (unpacker != null) {
                try {
                    unpacker.close();
                }
                catch (Exception e2) {
                    MLog.error((Object)TAG, (Throwable)e2);
                }
            }
            bytes = resData;
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)("onResponse gzip comsume:" + (System.currentTimeMillis() - startTime)), (Object[])new Object[0]);
        }
        return bytes;
    }

    public void onError(WsClient cli, String wsUrl, int code, String errorInfo) {
        this.socketStateChanged(code, wsUrl, errorInfo);
        if (RuntimeContext.sIsDebuggable && code >= 4000 && code <= 4100) {
            throw new RuntimeException("WsClient onError, code:" + code);
        }
        this.onSomeError(false, "web socket call onClosed or onFailure,for more detail to see WebSocketListener#onClosed or WebSocketListener#onFailure", code);
    }

    public void onDisconnect(WsClient cli, String wsUrl, int code) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onDisconnect code: %s, cli: %s, wsUrl: %s", (Object[])new Object[]{code, cli, wsUrl});
        }
        this.socketStateChanged(code, wsUrl, "");
        this.onSomeError(false, "connect web socket was close by call WebSocket.close", code);
    }

    public boolean isEnableBackgroundReconnect(WsClient socket, String wsUrl) {
        return ProtoMonitor.isEnableWsClientBackgroundReconnect(socket, wsUrl);
    }

    public void setResponseInterceptor(GlobalBanInterface instance) {
        this.mGlobalBanInterface = instance;
    }

    @Override
    public IResponseInterceptor getResponseInterceptor() {
        return this.mGlobalBanInterface;
    }

    private ProtoInnerImp() {
        this.mTaskExecutor = SettingFlags.getBoolean((String)"keynetopenthreadopt", (boolean)true) ? YYTaskExecutor.createAQueueExcuter((boolean)true) : YYTaskExecutor.createAQueueExcuter();
        YYTaskExecutor.execute((Runnable)this.mCheckTimeoutTask, (long)10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSocketStateChangeListener(ISocketStateChangeListener socketStateChangeListener) {
        ArrayList<ISocketStateChangeListener> arrayList = this.mSocketStateChangeListeners;
        synchronized (arrayList) {
            if (!this.mSocketStateChangeListeners.contains(socketStateChangeListener)) {
                this.mSocketStateChangeListeners.add(socketStateChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSocketStateChangeListener(ISocketStateChangeListener socketStateChangeListener) {
        ArrayList<ISocketStateChangeListener> arrayList = this.mSocketStateChangeListeners;
        synchronized (arrayList) {
            if (this.mSocketStateChangeListeners.contains(socketStateChangeListener)) {
                this.mSocketStateChangeListeners.remove(socketStateChangeListener);
            }
        }
    }

    static ProtoInnerImp getInstance() {
        return Holder.instance;
    }

    void connect(String wsUrl) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"connect ws url: %s", (Object[])new Object[]{wsUrl});
        }
        this.createWsClient(wsUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(String wsURL) {
        Map<String, WsClient> map = this.mWsService;
        synchronized (map) {
            WsClient cli;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"disconnect wsUrl: %s, mWsService.size: %s", (Object[])new Object[]{wsURL, this.mWsService.size()});
            }
            if ((cli = this.mWsService.get(wsURL)) != null) {
                this.mWsService.remove(wsURL);
                cli.destroy();
            }
        }
    }

    WsStatus getWsStatus(String wsURL) {
        WsStatus wsStatus = WsStatus.CONNECT_FAIL;
        return this.getWsStatus(wsURL, wsStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WsStatus getWsStatus(String wsURL, WsStatus defaultStatus) {
        WsStatus wsStatus = defaultStatus;
        Map<String, WsClient> map = this.mWsService;
        synchronized (map) {
            WsClient cli = this.mWsService.get(wsURL);
            if (cli != null) {
                wsStatus = cli.getStatuse();
            }
        }
        return wsStatus;
    }

    long getServiceTime() {
        return HeartBeatTask.getServiceTime();
    }

    long getClientRealTime() {
        return HeartBeatTask.getClientRealTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends AndroidMessage<T, ?>> void send(String wsUrl, T proto, IProtoInnerCallback<T> callback) {
        if (TextUtils.isEmpty((CharSequence)wsUrl) || proto == null) {
            return;
        }
        Map<String, WsClient> map = this.mWsService;
        synchronized (map) {
            WsClient wsClient = this.mWsService.get(wsUrl);
            if (wsClient == null) {
                return;
            }
        }
        this.getProtoDispatch().send(wsUrl, proto, callback);
    }

    <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendRpc(String wsUrl, REQ proto, @Nullable IProtoInnerCallback<RES> callback, RpcMethod<REQ, RES> rpcMethod) {
        if (TextUtils.isEmpty((CharSequence)wsUrl) || proto == null) {
            if (callback != null) {
                callback.retryWhenError(false, "illegal arg", -1);
            }
            return;
        }
        this.getProtoDispatchRpc().send(wsUrl, proto, callback, rpcMethod);
    }

    <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendRpc(String wsUrl, String roomId, REQ proto, @Nullable IProtoInnerCallback<RES> callback, RpcMethod<REQ, RES> rpcMethod) {
        if (TextUtils.isEmpty((CharSequence)wsUrl) || proto == null) {
            if (callback != null) {
                callback.retryWhenError(false, "illegal arg", -1);
            }
            return;
        }
        this.getProtoDispatchRpc().send(wsUrl, roomId, proto, callback, rpcMethod);
    }

    void sendCIMRpc(String wsUrl, String sName, String methodName, byte[] requestBytes, @Nullable ICIMProtoCallback<byte[]> callback) {
        if (TextUtils.isEmpty((CharSequence)wsUrl) || sName == null || methodName == null || requestBytes == null) {
            if (callback != null) {
                callback.retryWhenError(false, "cim illegal arg", -1);
            }
            return;
        }
        this.getCIMProtoDispatchRpc().sendCIM(wsUrl, sName, methodName, requestBytes, callback);
    }

    void registerNotify(IProtoNotify notify) {
        if (notify == null) {
            return;
        }
        this.getNotifyDispatch().registerNotify(notify);
    }

    void unregisterNotify(IProtoNotify notify) {
        if (notify == null) {
            return;
        }
        if (this.mNotifyDispatch != null) {
            this.mNotifyDispatch.unregisterNotify(notify);
        }
    }

    void addNotifyInterceptor(INotifyInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        if (this.mNotifyDispatch != null) {
            this.mNotifyDispatch.addNotifyInterceptor(interceptor);
        }
    }

    void removeNotifyInterceptor(INotifyInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        if (this.mNotifyDispatch != null) {
            this.mNotifyDispatch.removeNotifyInterceptor(interceptor);
        }
    }

    <T> void registerThirdNotify(Class<T> type, IThirdNotify<T> notify) {
        if (notify == null || type == null) {
            return;
        }
        this.getThirdNotifyDispatch().registerThirdNotify(type, notify);
    }

    void unregisterThirdNotify(IThirdNotify notify) {
        if (notify == null) {
            return;
        }
        if (this.mThirdNotifyDispatch != null) {
            this.mThirdNotifyDispatch.unregisterThirdNotify(notify);
        }
    }

    <T> void registerCIMNotify(ICIMProtoNotify<T> notify) {
        if (notify == null) {
            return;
        }
        this.getCIMProtoDispatchRpc().registerCIMNotify(notify);
    }

    void unregisterCIMNotify(ICIMProtoNotify notify) {
        if (notify == null) {
            return;
        }
        this.getCIMProtoDispatchRpc().unregisterCIMNotify(notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWsClient(String wsUrl) {
        Map<String, WsClient> map = this.mWsService;
        synchronized (map) {
            if (this.mWsService.get(wsUrl) != null) {
                return;
            }
            WsClient wsClient = new WsClient(wsUrl);
            wsClient.setWsCallback((WsCallback)this);
            wsClient.setMaxReconnectTime(-1);
            wsClient.watchNetChange();
            wsClient.open();
            this.mWsService.put(wsUrl, wsClient);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"WsService map size:%d", (Object[])new Object[]{this.mWsService.size()});
            }
            if (RuntimeContext.sIsDebuggable && this.mWsService.size() > 1) {
                throw new RuntimeException("WsService map size > 1, real size:" + this.mWsService.size());
            }
        }
    }

    private void checkTimeoutReq() {
        this.mTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ProtoInnerImp.this.monitorCheckTimeout();
                if (ProtoInnerImp.this.mProtoDispatch != null) {
                    ProtoInnerImp.this.mProtoDispatch.onCheckTimeoutReq();
                }
                if (ProtoInnerImp.this.mProtoDispatchRpc != null) {
                    ProtoInnerImp.this.mProtoDispatchRpc.onCheckTimeoutReq();
                }
                if (ProtoInnerImp.this.mCIMProtoDispatchRpc != null) {
                    ProtoInnerImp.this.mCIMProtoDispatchRpc.onCheckTimeoutReq();
                }
            }
        }, 0L);
    }

    private void onSomeError(final boolean canRetry, final String reason, final int code) {
        this.mTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (ProtoInnerImp.this.mProtoDispatch != null) {
                    ProtoInnerImp.this.mProtoDispatch.onSomeError(canRetry, reason, code);
                }
                if (ProtoInnerImp.this.mProtoDispatchRpc != null) {
                    ProtoInnerImp.this.mProtoDispatchRpc.onSomeError(canRetry, reason, code);
                }
                if (ProtoInnerImp.this.mCIMProtoDispatchRpc != null) {
                    ProtoInnerImp.this.mCIMProtoDispatchRpc.onSomeError(canRetry, reason, code);
                }
            }
        }, 0L);
    }

    public void setGameId(String gameId) {
        if (gameId == null) {
            gameId = "";
        }
        HeartBeatTask.setGameId(gameId);
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"updateGameId:%s", (Object[])new Object[]{gameId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeToForeground() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"changeToForeground", (Object[])new Object[0]);
        }
        Map<String, WsClient> map = this.mWsService;
        synchronized (map) {
            if (this.mWsService.size() == 0) {
                return;
            }
            for (Map.Entry<String, WsClient> entry : this.mWsService.entrySet()) {
                WsClient cli = entry.getValue();
                if (cli == null) continue;
                cli.changeToForeground();
                HeartBeatTask beatTask = null;
                HashMap<WsClient, HeartBeatTask> hashMap = this.mWsHeartBeat;
                synchronized (hashMap) {
                    beatTask = this.mWsHeartBeat.get(cli);
                }
                if (beatTask == null) continue;
                this.startHeartBeat(cli, beatTask.getUrl());
            }
        }
        this.statBgChange(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeToBackground() {
        Map<String, WsClient> map = this.mWsService;
        synchronized (map) {
            if (this.mWsService.size() == 0) {
                return;
            }
            for (Map.Entry<String, WsClient> entry : this.mWsService.entrySet()) {
                WsClient cli = entry.getValue();
                cli.changeToBackground();
            }
        }
        this.statBgChange(false);
    }

    private void statBgChange(boolean fore) {
        if (RuntimeContext.sIsDebuggable) {
            long cur = System.currentTimeMillis();
            if (this.mProtoDispatch != null) {
                this.setBgChange(cur, fore, this.mProtoDispatch);
            }
            if (this.mProtoDispatchRpc != null) {
                this.setBgChange(cur, fore, this.mProtoDispatchRpc);
            }
            if (this.mCIMProtoDispatchRpc != null) {
                this.setBgChange(cur, fore, this.mCIMProtoDispatchRpc);
            }
            this.mLastTimeoutCheckStr = this.mLastTimeoutCheckStr + (RuntimeContext.sIsForeground ? " fore" : " back") + (SystemClock.uptimeMillis() - this.mLastTimeoutCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBgChange(long cur, boolean fore, AbsProtoDispatch dispatch) {
        if (dispatch == null) {
            return;
        }
        Map<Long, WsRequest> map = dispatch.getRequestMap();
        synchronized (map) {
            for (Map.Entry<Long, WsRequest> entry : dispatch.getRequestMap().entrySet()) {
                WsRequest request = entry.getValue();
                if (request == null) continue;
                long timeCheck = cur - request.time;
                request.statKey = request.statKey + (fore ? "fore" : " back") + timeCheck;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBgChange(long cur, boolean fore, AbsCIMProtoDispatch dispatch) {
        if (dispatch == null) {
            return;
        }
        Map<Long, WsCIMRequest> map = dispatch.getRequestMap();
        synchronized (map) {
            for (Map.Entry<Long, WsCIMRequest> entry : dispatch.getRequestMap().entrySet()) {
                WsCIMRequest request = entry.getValue();
                if (request == null) continue;
                long timeCheck = cur - request.time;
                request.statKey = request.statKey + (fore ? "fore" : " back") + timeCheck;
            }
        }
    }

    private void monitorCheckTimeout() {
        if (RuntimeContext.sIsDebuggable) {
            if (this.mLastTimeoutCheck > 0L) {
                long cur = SystemClock.uptimeMillis();
                long consume = cur - this.mLastTimeoutCheck;
                if (consume > 10000L && consume < Integer.MAX_VALUE) {
                    ProtoMonitor.onCheckOutExe((int)consume, this.mLastTimeoutCheckStr);
                }
                this.mLastTimeoutCheckStr = RuntimeContext.sIsForeground ? " fore" : " back";
                this.mLastTimeoutCheck = SystemClock.uptimeMillis();
            } else {
                this.mLastTimeoutCheckStr = RuntimeContext.sIsForeground ? " fore" : " back";
                this.mLastTimeoutCheck = SystemClock.uptimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void socketStateChanged(int code, String wsUrl, String errorInfo) {
        ArrayList<ISocketStateChangeListener> arrayList = this.mSocketStateChangeListeners;
        synchronized (arrayList) {
            for (ISocketStateChangeListener listener : this.mSocketStateChangeListeners) {
                if (listener == null) continue;
                listener.onSocketStateChanged(code, wsUrl, errorInfo);
            }
        }
    }

    public static void setHeartMonitor(IHeartMonitor monitor) {
        HeartBeatTask.setHeartMonitor(monitor);
    }

    private static class Holder {
        static ProtoInnerImp instance = new ProtoInnerImp();

        private Holder() {
        }
    }
}

