/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.pickme.R;

public class PickMeTipView
extends YYRelativeLayout {
    private static final int ANIMATION_TIME = 600;
    private static final int VIEW_STAY_TIME = 2000;
    private YYTextView tvTitle;
    private Runnable dismissRunnable = () -> {
        this.clearAnimation();
        this.setVisibility(8);
        if (this.getParent() != null && this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
    };

    public PickMeTipView(Context context) {
        super(context);
        this.initView(context);
    }

    public PickMeTipView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public PickMeTipView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_pick_me_tip_channel, (ViewGroup)this);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.tvTitle = (YYTextView)this.findViewById(R.id.tv_title);
    }

    public void updateView(int status) {
        if (this.getVisibility() != 0) {
            this.setVisibility(0);
        }
        this.tvTitle.setText((CharSequence)this.getTitle(status));
        FontUtils.setFontType((TextView)this.tvTitle, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.setBackgroundResource(this.getBackground(status));
        this.startEntryAnim();
    }

    @DrawableRes
    private int getBackground(int status) {
        if (status == 4) {
            return R.drawable.bg_pick_me_pick;
        }
        if (status == 1) {
            return R.drawable.bg_pick_me_pick;
        }
        return R.drawable.bg_pick_me_announce;
    }

    private String getTitle(int status) {
        if (status == 4) {
            return ResourceUtils.getString((int)R.string.title_pick_me_introduce);
        }
        if (status == 1) {
            return ResourceUtils.getString((int)R.string.title_pick_me);
        }
        return ResourceUtils.getString((int)R.string.title_announce);
    }

    protected void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    private void startEntryAnim() {
        ObjectAnimator scaleAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.2f, 0.8f, 1.0f});
        ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.3f, 1.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)scaleAnim).with((Animator)alphaAnim);
        animatorSet.setDuration(600L);
        animatorSet.start();
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                YYTaskExecutor.postToMainThread((Runnable)PickMeTipView.this.dismissRunnable, (long)2000L);
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        YYTaskExecutor.removeTask((Runnable)this.dismissRunnable);
        this.setVisibility(8);
        this.clearAnimation();
    }
}

