/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.hago.party.imp.base;

import android.app.Activity;
import android.content.Intent;
import com.duowan.hago.party.api.base.IBase;
import com.duowan.hago.party.api.base.bean.DataEvent;
import com.duowan.hago.party.imp.PartySdkJumpUtils;
import com.yy.appbase.DiskCacheChecker;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.main.base.PartySdkLocale;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u0004H\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/duowan/hago/party/imp/base/BaseImpl;", "Lcom/duowan/hago/party/api/base/IBase;", "()V", "debugEnvEnable", "", "debug", "", "env", "handleIntent", "activity", "Landroid/app/Activity;", "intent", "Landroid/content/Intent;", "isHagoIntent", "isHagoPush", "isHagoScheme", "onBackground", "onForeground", "onForegroundChanged", "isForeground", "reportData", "event", "Lcom/duowan/hago/party/api/base/bean/DataEvent;", "setLocal", "locale", "Ljava/util/Locale;", "setServiceEnvironment", "isTest", "partyimp_release"})
public final class BaseImpl
implements IBase {
    public boolean handleIntent(@NotNull Activity activity, @NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        boolean handle = this.isHagoIntent(intent);
        MLog.info((Object)"BaseImpl", (String)"handleIntent handle: %b, intent: %s", (Object[])new Object[]{handle, intent});
        if (handle) {
            PartySdkJumpUtils.INSTANCE.jumpHagoByIntent(activity, intent);
        }
        return handle;
    }

    public void onForegroundChanged(boolean isForeground) {
        MLog.info((Object)"BaseImpl", (String)"onForegroundChanged isForeground: %b", (Object[])new Object[]{isForeground});
        if (isForeground) {
            this.onForeground();
        } else {
            this.onBackground();
        }
    }

    public void reportData(@NotNull DataEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
    }

    public void debugEnvEnable(boolean debug, boolean env) {
        if (RuntimeContext.sIsDebuggable || SystemUtils.isShowEnvSetting()) {
            RuntimeContext.sIsDebuggable = debug;
            SystemUtils.setEnvShow((int)(!env ? 1 : 0));
        }
    }

    public void setLocal(@NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        PartySdkLocale.INSTANCE.setGlobalLocale(locale);
    }

    private final boolean isHagoIntent(Intent intent) {
        return this.isHagoPush(intent) || this.isHagoScheme(intent);
    }

    private final boolean isHagoPush(Intent intent) {
        return intent.hasExtra("payload");
    }

    private final boolean isHagoScheme(Intent intent) {
        String scheme = intent.getScheme();
        return Intrinsics.areEqual((Object)scheme, (Object)"hago");
    }

    private final void onForeground() {
        RuntimeContext.sIsForeground = true;
        DiskCacheChecker.onForeGroundChange((boolean)true);
        if (RuntimeContext.sIsAppStartFinished) {
            NotificationCenter.getGlobalInstance().notify(new Notification(NotificationDef.N_FOREGROUND_CHANGE, (Object)RuntimeContext.sIsForeground));
            RuntimeContext.onForeGroundChanged((boolean)true);
        }
        NotificationCenter.getGlobalInstance().notify(new Notification(NotificationIdDef.PERMISSION_ON_RESUME, (Object)RuntimeContext.sIsForeground));
    }

    private final void onBackground() {
        RuntimeContext.sIsForeground = false;
        DiskCacheChecker.onForeGroundChange((boolean)false);
        FileStorageUtils.getInstance().onForeGroundChange(false);
        NotificationCenter.getGlobalInstance().notify(new Notification(NotificationDef.N_FOREGROUND_CHANGE, (Object)RuntimeContext.sIsForeground));
        HiidoEvent event = HiidoEvent.obtain().eventId("20035569").put("function_id", "outapp");
        HiidoStatis.reportEvent((HiidoEvent)event);
        RuntimeContext.onForeGroundChanged((boolean)false);
    }

    public void setServiceEnvironment(boolean isTest) {
        if (isTest) {
            EnvSettings.instance().setUriEnvSettingValue(EnvSettingType.Test);
        } else {
            EnvSettings.instance().setUriEnvSettingValue(EnvSettingType.Product);
        }
    }
}

