/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.multivideo.profile;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardData;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardManager;
import com.yy.hiyo.channel.plugins.multivideo.R;

public class MultiVideoProfileCardManager
extends VoiceRoomProfileCardManager {
    public MultiVideoProfileCardManager(@NonNull Context context, @NonNull VoiceRoomProfileCardData data, IChannel channel) {
        super(context, data, channel);
    }

    protected void updateMicStatus() {
        this.updateMicOperationView();
    }

    private void updateMicOperationView() {
        if (this.mMicOperationView == null) {
            return;
        }
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            if (this.mMicStatus.isMicForbidden()) {
                this.mMicOperationView.updateIcon(R.drawable.icon_profile_card_mic_forbidden_disable);
                this.mMicOperationView.updateText(R.string.title_voice_off);
            } else if (this.mMicStatus.isMicClosedBySelf()) {
                this.mMicOperationView.updateIcon(R.drawable.icon_profile_card_mic_off);
                this.mMicOperationView.updateText(R.string.title_voice_off);
            } else {
                this.mMicOperationView.updateIcon(R.drawable.icon_profile_card_mic_on);
                this.mMicOperationView.updateText(R.string.title_voice_on);
            }
        } else {
            this.mMicOperationView.updateIcon(R.drawable.icon_profile_card_mic_forbidden);
            if (this.mMicStatus.isMicForbidden()) {
                this.mMicOperationView.updateText(R.string.btn_disabled);
            } else {
                this.mMicOperationView.updateText(R.string.btn_disable);
            }
        }
    }

    protected void updateVideoStatus() {
        this.updateVideoOperationView();
    }

    private void updateVideoOperationView() {
        if (this.mVideoOperationView == null) {
            return;
        }
        if (this.mProfileCardData.uid == AccountUtil.getUid()) {
            if (this.mMicStatus.isVideoForbidden()) {
                this.mVideoOperationView.updateIcon(R.drawable.icon_profile_card_video_forbidden_disable);
                this.mVideoOperationView.updateText(R.string.title_video_off);
            } else if (this.mMicStatus.isVideoClosedBySelf()) {
                this.mVideoOperationView.updateIcon(R.drawable.icon_profile_card_video_off);
                this.mVideoOperationView.updateText(R.string.title_video_off);
            } else {
                this.mVideoOperationView.updateIcon(R.drawable.icon_profile_card_video_on);
                this.mVideoOperationView.updateText(R.string.title_video_on);
            }
        } else {
            this.mVideoOperationView.updateIcon(R.drawable.icon_profile_card_video_forbidden);
            if (this.mMicStatus.isVideoForbidden()) {
                this.mVideoOperationView.updateText(R.string.btn_disabled);
            } else {
                this.mVideoOperationView.updateText(R.string.btn_disable);
            }
        }
    }
}

