/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.multivideo.profile;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.MultiVideoEventReporter;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.profile.profilecard.base.IDataProvider;
import com.yy.hiyo.channel.component.profile.profilecard.helper.ProfileCardStatistics;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.IVoiceRoomCallback;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardData;
import com.yy.hiyo.channel.component.profile.profilecard.voiceroom.VoiceRoomProfileCardPresenter;
import com.yy.hiyo.channel.plugins.multivideo.MultiVideoPresenter;
import com.yy.hiyo.channel.plugins.multivideo.R;
import com.yy.hiyo.channel.plugins.multivideo.profile.MultiVideoProfileCardManager;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import javax.annotation.Nonnull;

public class MultiProfileCardPresenter
extends VoiceRoomProfileCardPresenter {
    private static final String TAG = "MultiProfileCardPresenter";

    public void showProfileCard(long uid, boolean inChannel, @Nonnull OpenProfileFrom from) {
        if (this.isDestroyed()) {
            return;
        }
        VoiceRoomProfileCardData data = this.buildProfileCardData(uid, from);
        data.isInChannel = inChannel;
        MultiVideoProfileCardManager manager = new MultiVideoProfileCardManager((Context)((IChannelPageContext)this.getMvpContext()).getContext(), data, (IChannel)this.getChannel());
        manager.setCallback((IVoiceRoomCallback)this);
        manager.setSeatUpdateNotifier(this.createSeatUpdateNotifier());
        manager.setDataProvider((IDataProvider)this);
        manager.show();
        String userType = this.getChannel().getRoleService().getMyRoleCache() == 15 ? "1" : (this.getChannel().getSeatService().isInSeat(uid) ? "2" : "3");
        RoomTrack.INSTANCE.pictureClick(this.getChannelId(), userType, uid == AccountUtil.getUid(), this.getStatisEnterType(from.getValue()), this.getChannel().getPluginService().getCurPluginData().isVideoMode(), uid);
        if (14 == this.getChannel().getPluginService().getCurPluginData().mode) {
            ProfileCardStatistics.INSTANCE.reportRadioProfileCardShow((IChannel)this.getChannel(), from, uid, RadioUtils.INSTANCE.getMVideoMode());
        } else {
            ProfileCardStatistics.INSTANCE.reportProfileCardShow((IChannel)this.getChannel(), from, uid);
        }
    }

    public void onLeaveSeatSelf(final long uid) {
        OkCancelDialog mDialog = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_leave_seat_sure), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, true, new OkCancelDialogListener(){

            public void onCancel() {
                ((IChannelPageContext)MultiProfileCardPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
            }

            public void onOk() {
                MultiProfileCardPresenter.super.onLeaveSeatSelf(uid);
                ((IChannelPageContext)MultiProfileCardPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
            }
        });
        ((IChannelPageContext)this.getMvpContext()).getDialogLinkManager().showDialog((BaseDialog)mDialog);
        MultiVideoEventReporter.INSTANCE.selfOutClick();
    }

    public void onMakeLeaveSeat(final long uid) {
        OkCancelDialog mDialog = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_kick_off_seat_sure), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, true, new OkCancelDialogListener(){

            public void onCancel() {
                ((IChannelPageContext)MultiProfileCardPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
            }

            public void onOk() {
                MultiProfileCardPresenter.super.onMakeLeaveSeat(uid);
                ((IChannelPageContext)MultiProfileCardPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
            }
        });
        ((IChannelPageContext)this.getMvpContext()).getDialogLinkManager().showDialog((BaseDialog)mDialog);
        MultiVideoEventReporter.INSTANCE.manageOutClick();
    }

    public void onChangeMic(long uid, boolean open) {
        super.onChangeMic(uid, open);
        if (uid == AccountUtil.getUid()) {
            MultiVideoEventReporter.INSTANCE.selfMicSwitchClick(open);
        } else if (!open) {
            MultiVideoEventReporter.INSTANCE.manageMicCloseClick();
        }
    }

    public void onCameraFlip(long uid) {
        boolean useFront = ((MultiVideoPresenter)this.getPresenter(MultiVideoPresenter.class)).switchCamera();
        MultiVideoEventReporter.INSTANCE.selfFlipCameraClick(useFront);
    }

    public void onChangeVideo(long uid, boolean open) {
        super.onChangeVideo(uid, open);
        if (uid == AccountUtil.getUid()) {
            MultiVideoEventReporter.INSTANCE.selfVideoSwitchClick(open);
        } else {
            MultiVideoEventReporter.INSTANCE.manageVideoSwitchClick(open);
        }
    }
}

