/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.multivideo.business.seat;

import android.app.Activity;
import android.content.Context;
import android.view.ViewGroup;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.Callback;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ISeatUser;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.callback.IChannelNotifyListener;
import com.yy.hiyo.channel.cbase.channelhiido.MultiVideoEventReporter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.radio.beauty.BeautyPresenter;
import com.yy.hiyo.channel.cbase.module.radio.config.LiveConfigPresenter;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.multivideo.MultiVideoKtvPresenter;
import com.yy.hiyo.channel.plugins.multivideo.MultiVideoPresenter;
import com.yy.hiyo.channel.plugins.multivideo.MultiVideoUtils;
import com.yy.hiyo.channel.plugins.multivideo.bottombar.MultiVideoBottomAddPresenter;
import com.yy.hiyo.channel.plugins.multivideo.business.bottom.MultiVideoBottomPresenter;
import com.yy.hiyo.channel.plugins.multivideo.business.seat.MultiVideoSeatCore;
import com.yy.hiyo.channel.plugins.multivideo.business.seat.MultiVideoSeatWrapper;
import com.yy.hiyo.channel.plugins.multivideo.business.seat.dialog.MultiVideoSitDownInviteDialog;
import com.yy.hiyo.channel.plugins.voiceroom.base.AbsRoomSeatPresenter;
import com.yy.hiyo.multivideo.MultiVideoSeatInfo;
import com.yy.hiyo.voice.base.bean.MicInfo;
import com.yy.hiyo.voice.base.bean.MicStatusBean;
import com.yy.hiyo.voice.base.bean.VideoPositionWrapper;
import java.util.ArrayList;
import java.util.List;

public class MultiVideoSeatPresenter
extends AbsRoomSeatPresenter<MultiVideoSeatWrapper> {
    private static final String TAG = "MultiVideoSeatPresenter";
    private MutableLiveData<List<SeatItem>> mSortSeatList = new SafeLiveData();
    private ArrayList<Long> mVideoMutedUidList = new ArrayList(6);
    private MultiVideoSeatCore mMultiVideoSeatCore = new MultiVideoSeatCore();
    boolean misWearMask = false;
    boolean mDontUseMask = false;
    private BeautyPresenter mBeautyPresenter;
    private boolean mEnableBeauty;
    private Observer mSeatsObserver = new Observer<List<SeatItem>>(){

        public void onChanged(List<SeatItem> seatItems) {
            MultiVideoSeatPresenter.this.seatChanged(seatItems);
        }
    };
    private IChannelNotifyListener mNotifyListener = (channelId, notify) -> {
        if (notify.uri == ChannelNotify.Uri.UriLockAllSeat) {
            NotifyDataDefine.LockAllSeatNotify lockAllSeatNotify = notify.notify.lockAllSeatNotify;
            if (notify.cid.equals(channelId)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"notify UriLockAllSeat, %s, %s", (Object[])new Object[]{lockAllSeatNotify.cid, lockAllSeatNotify.lock});
                }
                this.getChannel().getChannelDetail().dynamicInfo.mIsAllSeatLock = lockAllSeatNotify.lock;
            }
        }
    };

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)) {
            ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).addNotifyListener(this.mNotifyListener);
        }
        this.seats().observeForever(this.mSeatsObserver);
    }

    private void seatChanged(List<SeatItem> list) {
        List<SeatItem> sortList2 = this.mMultiVideoSeatCore.sortList(list);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"sortList: %s", (Object[])new Object[]{sortList2});
        }
        this.mSortSeatList.setValue(sortList2);
        this.updateMutedUidList(sortList2);
        this.updateSeatInfo();
    }

    private void updateMutedUidList(List<SeatItem> sortList2) {
        int i;
        if (this.mVideoMutedUidList.size() <= 0) {
            return;
        }
        if (sortList2.size() <= 0) {
            this.mVideoMutedUidList.clear();
            return;
        }
        ArrayList<Long> allSeatList = new ArrayList<Long>(sortList2.size());
        ArrayList<Long> removeSeatList = new ArrayList<Long>(sortList2.size());
        for (i = 0; i < sortList2.size(); ++i) {
            allSeatList.add(sortList2.get((int)i).uid);
        }
        for (i = 0; i < this.mVideoMutedUidList.size(); ++i) {
            if (allSeatList.contains(this.mVideoMutedUidList.get(i))) continue;
            removeSeatList.add(this.mVideoMutedUidList.get(i));
        }
        this.mVideoMutedUidList.removeAll(removeSeatList);
    }

    public void updateSeatInfo() {
        ArrayList<MicInfo> micInfoList = new ArrayList<MicInfo>();
        ArrayList<MicStatusBean> micStatusList = new ArrayList<MicStatusBean>();
        List seatList = (List)this.mSortSeatList.getValue();
        if (seatList == null) {
            return;
        }
        for (int i = 0; i < seatList.size(); ++i) {
            SeatItem seatItem = (SeatItem)seatList.get(i);
            MicInfo micInfo = MultiVideoUtils.INSTANCE.parseMicInfo((ISeatUser)seatItem, i);
            if (this.mVideoMutedUidList.contains(seatItem.uid) && micInfo.getStatus() == 1) {
                micInfo.setStatus(3);
            }
            micInfoList.add(micInfo);
            micStatusList.add(MultiVideoUtils.INSTANCE.parseMicStatus((ISeatUser)seatItem, i));
        }
        MultiVideoSeatInfo seatInfo = new MultiVideoSeatInfo(micInfoList, micStatusList);
        boolean isMeInSeat = this.getChannel().getSeatService().isMeInSeat();
        this.mMultiVideoSeatCore.updateSeatInfo((Activity)this.getContext(), seatInfo, isMeInSeat);
        if (SettingFlags.getBoolean((String)"enable_multi_video_base_beauty", (boolean)true) && (NAB.C.equals((Object)NewABDefine.HAGO_MULTI_VIDEO_BASE_BEAUTY_AABB.getTest()) || NAB.D.equals((Object)NewABDefine.HAGO_MULTI_VIDEO_BASE_BEAUTY_AABB.getTest()))) {
            if (isMeInSeat) {
                this.mEnableBeauty = true;
                YYTaskExecutor.postToMainThread(() -> {
                    if (((IChannelPageContext)this.getMvpContext()).isDestroy()) {
                        return;
                    }
                    ((LiveConfigPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(LiveConfigPresenter.class)).getBeautyLevel(data -> {
                        if (data < 2 && !this.isDestroyed()) {
                            BeautyPresenter beautyPresenter = this.mBeautyPresenter;
                            if (beautyPresenter == null) {
                                this.mBeautyPresenter = new BeautyPresenter(data.intValue(), (ICommonCallback)new ICommonCallback<Boolean>(){

                                    public void onSuccess(Boolean aBoolean, Object ... ext) {
                                        if (MLog.isLogLevelBlowInfo()) {
                                            MLog.info((Object)MultiVideoSeatPresenter.TAG, (String)("create beauty success. " + aBoolean), (Object[])new Object[0]);
                                        }
                                        if (aBoolean != null && aBoolean.booleanValue() && !MultiVideoSeatPresenter.this.isDestroyed()) {
                                            MultiVideoSeatPresenter.this.mBeautyPresenter.setBaseBeautyIntensity();
                                        }
                                    }

                                    public void onFail(int errCode, String msg, Object ... ext) {
                                        if (MLog.isLogLevelBlowInfo()) {
                                            MLog.info((Object)MultiVideoSeatPresenter.TAG, (String)"create beauty failed.", (Object[])new Object[0]);
                                        }
                                    }
                                });
                            } else if (this.mEnableBeauty) {
                                beautyPresenter.setBaseBeautyIntensity();
                            }
                        }
                    });
                }, (long)200L);
            } else {
                this.mEnableBeauty = false;
            }
        }
        ((MultiVideoBottomPresenter)this.getPresenter(MultiVideoBottomPresenter.class)).updatePopTipData(seatList);
        ((MultiVideoBottomPresenter)this.getPresenter(MultiVideoBottomPresenter.class)).updateVideoMicAvatarDatas(seatList, this.mVideoMutedUidList);
        ((MultiVideoKtvPresenter)this.getPresenter(MultiVideoKtvPresenter.class)).dealMicInfos(seatList);
    }

    public LiveData<List<SeatItem>> sortSeatList() {
        return this.mSortSeatList;
    }

    protected MultiVideoSeatWrapper createSeatViewWrapper() {
        this.mSeatViewWrapper = new MultiVideoSeatWrapper();
        ((MultiVideoSeatWrapper)this.mSeatViewWrapper).setPresenter((SeatMvp.IPresenter)this);
        return (MultiVideoSeatWrapper)this.mSeatViewWrapper;
    }

    public ViewGroup getMultiVideoContainer() {
        if (null != this.mSeatViewWrapper) {
            return ((MultiVideoSeatWrapper)this.mSeatViewWrapper).getMultiVideoContainer();
        }
        return null;
    }

    public ViewGroup getAudioSeatContainer() {
        if (null != this.mSeatViewWrapper) {
            return ((MultiVideoSeatWrapper)this.mSeatViewWrapper).getAudioSeatContainer();
        }
        return null;
    }

    public ViewGroup getCoverContainer() {
        if (null != this.mSeatViewWrapper) {
            return ((MultiVideoSeatWrapper)this.mSeatViewWrapper).getCoverContainer();
        }
        return null;
    }

    protected void showSitDownPlzDialog(final String plzId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"showSitDownPlzDialog plzIc %s", (Object[])new Object[]{plzId});
        }
        if (this.mDialogLinkManager == null || !this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this.getContext());
            MultiVideoSitDownInviteDialog dialog2 = new MultiVideoSitDownInviteDialog();
            dialog2.setSitDownInviteCallback(new MultiVideoSitDownInviteDialog.ISitDownInviteCallback(){

                @Override
                public void onSelectClick(boolean isCheck) {
                    MultiVideoSeatPresenter.this.misWearMask = isCheck;
                    MultiVideoEventReporter.INSTANCE.specialEffectsVideoPartyClick(isCheck);
                }

                @Override
                public void onOkClick() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)MultiVideoSeatPresenter.TAG, (String)"showSitDownPlzDialog onOK", (Object[])new Object[0]);
                    }
                    MultiVideoSeatPresenter.this.mDialogLinkManager.dismissDialog();
                    if (PermissionHelper.hasRecordAudioPermission((Activity)((IChannelPageContext)MultiVideoSeatPresenter.this.getMvpContext()).getContext()) && PermissionHelper.hasCameraPermission((Activity)((IChannelPageContext)MultiVideoSeatPresenter.this.getMvpContext()).getContext())) {
                        MultiVideoSeatPresenter.this.applySitDownPlz(plzId, MultiVideoSeatPresenter.this.misWearMask);
                    } else {
                        MultiVideoSeatPresenter.this.sitDownPlzPermission(plzId, MultiVideoSeatPresenter.this.misWearMask);
                    }
                    MultiVideoSeatPresenter.this.mDontUseMask = !MultiVideoSeatPresenter.this.misWearMask;
                    SeatTrack.INSTANCE.downInviteYesClick(MultiVideoSeatPresenter.this.getRoomId());
                    MultiVideoEventReporter.INSTANCE.popoverAcceptClick();
                    MultiVideoEventReporter.INSTANCE.acceptInviteYesReport();
                }

                @Override
                public void onCancelClick() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)MultiVideoSeatPresenter.TAG, (String)"showSitDownPlzDialog onCancel", (Object[])new Object[0]);
                    }
                    MultiVideoSeatPresenter.this.mDialogLinkManager.dismissDialog();
                    MultiVideoSeatPresenter.this.mSeatService.applySitDownPlz(plzId, false, null);
                    SeatTrack.INSTANCE.downInviteNoClick(MultiVideoSeatPresenter.this.getRoomId());
                    MultiVideoEventReporter.INSTANCE.acceptInviteNoReport();
                }
            });
            this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
            MultiVideoEventReporter.INSTANCE.acceptInvitePopReport();
            ((LiveConfigPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(LiveConfigPresenter.class)).getBeautyLevel(data -> {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"getBeautyLevel level: %s, isDestroy:%s", (Object[])new Object[]{data, this.isDestroyed()});
                }
                if (data < 2 && !this.isDestroyed()) {
                    boolean visible = !((MultiVideoBottomAddPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(MultiVideoBottomAddPresenter.class)).getEnableBuffer();
                    dialog2.setMaskCheckBoxVisibly(visible);
                    this.misWearMask = visible;
                }
            });
            SeatTrack.INSTANCE.downInviteShow(this.getRoomId());
        }
    }

    private void applySitDownPlz(String plzId, final boolean isWearMask) {
        this.mSeatService.applySitDownPlz(plzId, true, (Callback)new Callback<Integer>(){

            public void onResponse(Integer realSeat) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)MultiVideoSeatPresenter.TAG, (String)"showSitDownPlzDialog acceptSitDownPlz seatL %s", (Object[])new Object[]{realSeat});
                }
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.RESUME_CUR_CHANNEL);
                if (realSeat != null && realSeat > 0 && isWearMask) {
                    MultiVideoSeatPresenter.this.openMaskPanel();
                }
                if (realSeat == null) {
                    MultiVideoSeatPresenter.this.mDontUseMask = false;
                }
            }
        });
    }

    private void sitDownPlzPermission(String plzId, boolean isWearMask) {
        ((MultiVideoPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(MultiVideoPresenter.class)).requestRecordAudioPermission((Callback<Boolean>)((Callback)hasPermission -> {
            if (hasPermission.booleanValue()) {
                ((MultiVideoPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(MultiVideoPresenter.class)).requestCameraPermission((Callback<Boolean>)((Callback)data -> {
                    if (data.booleanValue()) {
                        this.applySitDownPlz(plzId, isWearMask);
                    } else {
                        this.mSeatService.applySitDownPlz(plzId, false, null);
                    }
                }));
            } else {
                this.mSeatService.applySitDownPlz(plzId, false, null);
            }
        }));
    }

    public int getSeatFaceSize(long uid) {
        boolean isVideoOpen = false;
        if (null != this.getStreamSeatList()) {
            for (VideoPositionWrapper item : this.getStreamSeatList()) {
                if (item.getUid() != uid || item.getMState() != 1 && item.getMState() != 3) continue;
                isVideoOpen = true;
                break;
            }
        }
        return ResolutionUtils.dip2Px((float)(isVideoOpen ? 140.0f : 33.0f));
    }

    public void onDestroy() {
        super.onDestroy();
        if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)) {
            ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).removeNotifyListener(this.mNotifyListener);
        }
        this.seats().removeObserver(this.mSeatsObserver);
    }

    public List<VideoPositionWrapper> getStreamSeatList() {
        if (null == this.mSeatViewWrapper) {
            return null;
        }
        return ((MultiVideoSeatWrapper)this.mSeatViewWrapper).getStreamSeatList();
    }

    public void openMaskPanel() {
        ((LiveConfigPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(LiveConfigPresenter.class)).getBeautyLevel(data -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getBeautyLevel level: $data, isDestroy:$isDestroyed", (Object[])new Object[0]);
            }
            if (data < 2 && !this.isDestroyed()) {
                ((MultiVideoBottomAddPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(MultiVideoBottomAddPresenter.class)).showMaskPanel();
            }
        });
    }

    public boolean isSeatFullWithLock() {
        if (this.getChannel().getChannelDetail().dynamicInfo.mIsAllSeatLock) {
            return true;
        }
        if (null == this.sortSeatList().getValue()) {
            return false;
        }
        if (((List)this.sortSeatList().getValue()).size() < 6) {
            return false;
        }
        for (SeatItem item : (List)this.sortSeatList().getValue()) {
            if (0L != item.uid) continue;
            return false;
        }
        return true;
    }

    public void muteVideo(long uid) {
        if (uid != AccountUtil.getUid() && !this.mVideoMutedUidList.contains(uid)) {
            this.mVideoMutedUidList.add(uid);
            this.updateSeatInfo();
        }
    }

    public void unMuteVideo(long uid) {
        if (uid != AccountUtil.getUid() && this.mVideoMutedUidList.contains(uid)) {
            this.mVideoMutedUidList.remove(uid);
            this.updateSeatInfo();
        }
    }

    public List<Long> getVideoMutedList() {
        return this.mVideoMutedUidList;
    }

    public boolean isDontUseMask() {
        return this.mDontUseMask;
    }

    public void setDontUseMask(boolean dontUseMask) {
        this.mDontUseMask = dontUseMask;
    }
}

