/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import java.util.List;

public class MicUpResultRankListDiffCallback
extends DiffUtil.Callback {
    private final List<ResultInfo> mOldResultInfo;
    private final List<ResultInfo> mNewResultInfo;

    public MicUpResultRankListDiffCallback(@NonNull List<ResultInfo> oldResultInfo, @NonNull List<ResultInfo> newResultInfo) {
        this.mOldResultInfo = oldResultInfo;
        this.mNewResultInfo = newResultInfo;
    }

    public int getOldListSize() {
        return FP.empty(this.mOldResultInfo) ? 0 : this.mOldResultInfo.size();
    }

    public int getNewListSize() {
        return FP.empty(this.mNewResultInfo) ? 0 : this.mNewResultInfo.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        ResultInfo oldResultInfo = this.mOldResultInfo.get(oldItemPosition);
        ResultInfo newResultInfo = this.mNewResultInfo.get(newItemPosition);
        return oldResultInfo.uid == newResultInfo.uid;
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        ResultInfo oldResultInfo = this.mOldResultInfo.get(oldItemPosition);
        ResultInfo newResultInfo = this.mNewResultInfo.get(newItemPosition);
        if (!StringUtils.equal((String)oldResultInfo.avatar, (String)newResultInfo.avatar)) {
            return false;
        }
        if (!StringUtils.equal((String)oldResultInfo.nick, (String)newResultInfo.nick)) {
            return false;
        }
        if (oldResultInfo.micNum != newResultInfo.micNum) {
            return false;
        }
        return oldResultInfo.score == newResultInfo.score;
    }
}

