/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.DataFetchCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.common.FacePoint;
import com.yy.hiyo.channel.component.music.musicplayer.MusicPlayerPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.IOperationStrategy;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.theme.ThemePresenter;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.channel.plugins.micup.MicUpMvp;
import com.yy.hiyo.channel.plugins.micup.MicUpStatisHelper;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.MicupDataContext;
import com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.micup.bean.RoundInfo;
import com.yy.hiyo.channel.plugins.micup.common.ChannelMicUpMsgDef;
import com.yy.hiyo.channel.plugins.micup.impl.MicUpPanelManager;
import com.yy.hiyo.channel.plugins.micup.impl.MicupDataService;
import com.yy.hiyo.channel.plugins.micup.impl.MicupPrepareService;
import com.yy.hiyo.channel.plugins.micup.impl.SeatManager;
import com.yy.hiyo.channel.plugins.micup.impl.SongRepoManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.IAudioManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.IDataCallback;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpFuncBridge;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpPanelManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupDataChangeNotify;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupDataService;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupHost;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupLifeCycle;
import com.yy.hiyo.channel.plugins.micup.interfaces.ISeatManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.ISongRepoManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.SongRepoSwitchListener;
import com.yy.hiyo.channel.plugins.micup.songrepo.OnSongRepoSelectListener;
import com.yy.hiyo.channel.plugins.micup.songrepo.SongRepoInfo;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.IRoomGameService;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IGameData;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.RoomGameContainer;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare.GamePreparePresenter;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.voice.base.VoiceConstant;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicUpPresenter
extends AbsPluginPresenter
implements MicUpMvp.IPresenter,
IMicupHost,
SongRepoSwitchListener,
ISeatUpdateListener,
IOperationStrategy {
    private static final String TAG = "FTMicUpMicUpPresenter";
    private IMicUpPanelManager panelManager;
    private ISeatManager seatManager;
    private IMicupDataService dataFetcher;
    private ISongRepoManager songRepoManager;
    private ViewGroup mainContainer;
    private boolean hasSetupPlugins = false;
    private List<IMicupDataChangeNotify> dataCallbacks = new CopyOnWriteArrayList<IMicupDataChangeNotify>();
    private MutableLiveData<Map<Long, Point>> seatPositions = new MutableLiveData();
    private MutableLiveData<Map<Long, FacePoint>> mFaceSeatPoints = new MutableLiveData();
    private IMicUpFuncBridge mMicupFuncBridge;
    private IPageLifeCycle mRoomLifeListener;
    private MicupPrepareService micupPrepareService;
    private RoomGameContainer roomGameContainer;
    private CopyOnWriteArrayList<IMicupLifeCycle> lifeCycleListener = new CopyOnWriteArrayList();
    private IDataCallback dataCallback = new IDataCallback(){

        @Override
        public void onNextRound(int round) {
            for (IMicupDataChangeNotify dataCallback : MicUpPresenter.this.dataCallbacks) {
                dataCallback.onNextRoundNotify(round);
            }
        }

        @Override
        public void onUserGetTheChance(long uid, int round, String avatar, String nick) {
            for (IMicupDataChangeNotify dataCallback : MicUpPresenter.this.dataCallbacks) {
                dataCallback.onUserGetTheChanceNotify(uid, round, avatar, nick);
            }
        }

        @Override
        public void onSongIdentifyResult(RoundInfo roundInfo) {
            for (IMicupDataChangeNotify dataCallback : MicUpPresenter.this.dataCallbacks) {
                dataCallback.onSongIdentifyResultNotify(roundInfo);
            }
        }

        @Override
        public void onWaitForDetermine(int round, int term) {
            for (IMicupDataChangeNotify dataCallback : MicUpPresenter.this.dataCallbacks) {
                dataCallback.onWaitForDetermineNotify(round, term);
            }
        }

        @Override
        public void onUpdateRoundInfo(List<PlayerInfo> playerInfos, int errorCode, String errMsg) {
            for (IMicupDataChangeNotify dataCallback : MicUpPresenter.this.dataCallbacks) {
                dataCallback.onUpdateRoundInfoNotify(playerInfos, errorCode, errMsg);
            }
        }

        @Override
        public void onGameStarted() {
            MicUpPresenter.this.isRunning.setValue((Object)true);
            ((GamePreparePresenter)MicUpPresenter.this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAMING");
            MicUpPresenter.this.setSeatViewVisibility(false);
            MicUpPresenter.this.setGameContainerVisibility(true);
        }

        @Override
        public void onGameEnded() {
            MicUpPresenter.this.isRunning.setValue((Object)false);
            FeatureLog.i((String)"FTMicUpBase", (String)"on game ended.isMinized:%b", (Object[])new Object[]{!MicUpPresenter.this.getPage().isPageVisible()});
            if (MicUpPresenter.this.getPage().isPageVisible()) {
                MicUpPresenter.this.showResultPage();
                if (SettingFlags.getBoolean((String)"key_micup_first_play_get_guide", (boolean)true)) {
                    SettingFlags.setBoolean((String)"key_micup_first_play_get_guide", (boolean)false);
                }
            }
            MicUpPresenter.this.getRoomData().getRoomGame().update(false, "", "");
            MicUpPresenter.this.exitMicUp(0, null);
        }

        @Override
        public void onRoomExceptionFinish() {
            MicUpPresenter.this.isRunning.setValue((Object)false);
            FeatureLog.i((String)"FTMicUpBase", (String)"on onRoomExceptionFinish.", (Object[])new Object[0]);
            for (IMicupDataChangeNotify dataCallback : MicUpPresenter.this.dataCallbacks) {
                dataCallback.onGameExitedNotify();
            }
            MicUpPresenter.this.exitMicUp(0, null);
        }

        @Override
        public IMvpContext getMvpContext() {
            return MicUpPresenter.this.getMvpContext();
        }
    };
    private IMicupLifeCycle micupLifeCycle = new IMicupLifeCycle(){

        @Override
        public void onMicUpStarted() {
            if (MicUpPresenter.this.isDestroyed()) {
                return;
            }
            long modeValue = MicUpPresenter.this.getRoomData().getRoomInfo().getMode();
            String logString = StringUtils.formatWitUSLocal((String)"onPrepareMicUp started!!! mode %d, isGameStarted %b, gameId %s", (Object[])new Object[]{modeValue, MicUpPresenter.this.getRoomData().getGameInfo().isStarted(), MicUpPresenter.this.getRoomData().getGameInfo().getPluginId()});
            MLog.info((Object)MicUpPresenter.TAG, (String)logString, (Object[])new Object[0]);
            MicUpPresenter.this.startMicUp();
            for (IMicupLifeCycle item : MicUpPresenter.this.lifeCycleListener) {
                item.onMicUpStarted();
            }
        }

        @Override
        public void onMicUpEnded() {
            if (MicUpPresenter.this.isDestroyed()) {
                return;
            }
            long modeValue = MicUpPresenter.this.getRoomData().getRoomInfo().getMode();
            MLog.info((Object)MicUpPresenter.TAG, (String)"onPrepareMicUp ended!!!, mode %d, isGameStarted %b, gameId %s", (Object[])new Object[]{modeValue, MicUpPresenter.this.isMicupRunning(), MicUpPresenter.this.getRoomData().getGameInfo().getPluginId()});
            MicUpPresenter.this.getRoomData().getGameInfo().update(false, "", "");
            MicUpPresenter.this.resumeStateAfterExit();
            for (IMicupLifeCycle item : MicUpPresenter.this.lifeCycleListener) {
                item.onMicUpEnded();
            }
        }
    };
    private IMicUpFuncBridge micUpFuncBridge = new IMicUpFuncBridge(){

        @Override
        public void showGiftPan(long uid) {
            if (uid == 0L) {
                ((IRevenueToolsModulePresenter)MicUpPresenter.this.getPresenter(IRevenueToolsModulePresenter.class)).getGiftPresenter().showGiftPanel(4);
            } else {
                ShowGiftPanelParam param = new ShowGiftPanelParam(4);
                param.setSelectedUid(Collections.singletonList(uid));
                ((IRevenueToolsModulePresenter)MicUpPresenter.this.getPresenter(IRevenueToolsModulePresenter.class)).getGiftPresenter().showGiftPanel(param);
            }
        }
    };
    Observer<Map<Long, Point>> mObserver = new Observer<Map<Long, Point>>(){

        public void onChanged(@Nullable Map<Long, Point> longPointMap) {
            MicUpPresenter.this.handleMicSeat(longPointMap);
        }
    };

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.initRoomLifeListener();
        this.micupPrepareService = new MicupPrepareService((IChannel)this.getChannel());
        ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).setRoomGameService((IRoomGameService)this.micupPrepareService);
        this.isRunning.setValue((Object)false);
        this.getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            this.mainContainer = this.getGameContainer().getGamingContainer();
        }
    }

    private void showResultPage() {
        Message msg = Message.obtain();
        msg.what = ChannelMicUpMsgDef.MSG_SHOW_RESULT_PAGE;
        msg.obj = isAutoReady -> {
            if (isAutoReady) {
                this.changeReady();
            }
        };
        Bundle params = new Bundle();
        params.putString("room_id", this.getRoomData().getRoomId());
        params.putBoolean("is_audience", this.getDataContext().isAudience(AccountUtil.getUid()));
        params.putInt("term", this.getDataContext().getTerm());
        params.putInt("role_type", this.getChannel().getSeatService().isInSeat(AccountUtil.getUid()) ? 5 : 4);
        msg.setData(params);
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    @Override
    public void onPrepareMicUp(ViewGroup funcContainer, boolean isGameStarted, IMicupLifeCycle callback, IMicUpFuncBridge funcBridge) {
        this.mMicupFuncBridge = funcBridge;
        this.getDataFetcher().onPrepare(callback, isGameStarted);
    }

    @Override
    public void startMicUp() {
        if (this.mainContainer == null || this.hasSetupPlugins) {
            MLog.info((Object)TAG, (String)"startMicUp return!!! mainContainer:%s, hasSetUp:%b, state:%d", (Object[])new Object[]{this.mainContainer, this.hasSetupPlugins, this.getDataContext().getState()});
            return;
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableMediaMode(true);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSceneId(this.getChannelId(), VoiceConstant.SCENE_ID_MICIP);
        this.hasSetupPlugins = true;
        MLog.info((Object)TAG, (String)"startMicUp...", (Object[])new Object[0]);
        if (this.mainContainer != null) {
            this.mainContainer.setVisibility(0);
            this.mainContainer.removeAllViews();
            ConstraintSet set = new ConstraintSet();
            RoomGameContainer parent = this.getGameContainer();
            set.clone((ConstraintLayout)parent);
            set.setDimensionRatio(R.id.gaming_container, "");
            set.applyTo((ConstraintLayout)parent);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mainContainer.getLayoutParams();
            params.leftMargin = 0;
            params.rightMargin = 0;
            this.mainContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            LayoutInflater.from((Context)((IChannelPageContext)this.getMvpContext()).getContext()).inflate(R.layout.layout_micup_container_channel, this.mainContainer);
        }
        RoomData roomDataContainer = this.getRoomData();
        if (this.panelManager == null) {
            this.panelManager = new MicUpPanelManager(roomDataContainer, this.getDataContext());
        }
        this.panelManager.onCreate(this, this.getMvpContext());
        this.panelManager.showPanel((YYFrameLayout)this.mainContainer.findViewById(R.id.main_container));
        if (this.seatManager == null) {
            this.seatManager = new SeatManager(roomDataContainer, this.getDataContext());
            this.seatManager.setSeatActionListener(new SeatManager.OnSeatActionListener(){

                @Override
                public void onAvatarClick(com.yy.hiyo.channel.plugins.micup.bean.SeatUser seatUser) {
                    ((ProfileCardPresenter)MicUpPresenter.this.getPresenter(ProfileCardPresenter.class)).showProfileCard(seatUser.userInfoKS.uid, OpenProfileFrom.FROM_MICUP);
                }
            });
        }
        this.seatManager.onCreate(this, this.getMvpContext());
        this.seatManager.setViewContainer((YYFrameLayout)this.mainContainer.findViewById(R.id.seat_container));
    }

    @Override
    public boolean isMicupRunning() {
        return this.getDataContext() != null && this.getDataContext().getState() == 1;
    }

    @Override
    public IMicupDataService getDataFetcher() {
        if (this.dataFetcher == null) {
            this.dataFetcher = new MicupDataService((IChannel)this.getChannel(), this.getRoomData());
            this.dataFetcher.setDataCallback(this.dataCallback);
        }
        return this.dataFetcher;
    }

    @Override
    public void onHandleEvent(int messageId, Map<String, Object> params) {
        if (messageId == 0) {
            Object obj;
            if (this.mMicupFuncBridge == null) {
                MLog.error((Object)TAG, (String)"onHandleEvent error!!!,messageId:%d, params:%s", (Object[])new Object[]{messageId, params});
                return;
            }
            long uid = 0L;
            if (params != null && (obj = params.get("uid")) instanceof Long) {
                uid = (Long)obj;
            }
            this.mMicupFuncBridge.showGiftPan(uid);
        } else if (messageId == 1) {
            Object audio;
            if (params != null && (audio = params.get("audio")) instanceof String && StringUtils.isNotEmpty((String)((String)audio))) {
                this.playAudio((String)audio);
            }
        } else if (messageId == 2 && params != null) {
            Map obj = (Map)params.get("seat");
            this.seatPositions.postValue((Object)obj);
        }
    }

    private MicupDataContext getDataContext() {
        return this.getDataFetcher().getDataContext();
    }

    @Override
    public void exitMicUp(int exitReason, ICommonCallback callback) {
        MLog.info((Object)TAG, (String)"exitMicUp reason:%d", (Object[])new Object[]{exitReason});
        if (exitReason == 1) {
            this.getDataContext().setState(2);
        } else {
            this.getDataContext().setState(3);
        }
        this.destroySongRepoComponent();
        if (this.dataFetcher != null) {
            this.dataFetcher.onDestroy(exitReason);
        }
        if (this.seatManager != null) {
            this.seatManager.onDestroy(exitReason);
        }
        if (this.panelManager != null) {
            this.panelManager.onDestroy(exitReason);
        }
        if (this.mainContainer != null) {
            this.mainContainer.removeAllViews();
            this.mainContainer.setVisibility(8);
        }
        this.hasSetupPlugins = false;
        this.mMicupFuncBridge = null;
        this.panelManager = null;
        if (exitReason == 0) {
            this.setSeatViewVisibility(true);
            this.setGameContainerVisibility(false);
            if (this.getMvpContext() != null && !((IChannelPageContext)this.getMvpContext()).isDestroy()) {
                ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_PREPARE");
            }
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableMediaMode(false);
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSceneId(this.getChannelId(), VoiceConstant.SCENE_ID_MULTI_AUDIO);
            this.dataCallbacks.clear();
            this.seatManager = null;
            this.dataFetcher = null;
        }
    }

    @Override
    public MutableLiveData<Map<Long, Point>> getSeatPositions() {
        return this.seatPositions;
    }

    @Override
    public void registerDataNotify(IMicupDataChangeNotify dataCallback) {
        if (dataCallback == null) {
            return;
        }
        if (!this.dataCallbacks.contains(dataCallback)) {
            this.dataCallbacks.add(dataCallback);
        }
    }

    @Override
    public void unRegisterDataNotify(IMicupDataChangeNotify notify) {
        this.dataCallbacks.remove(notify);
    }

    @Override
    public IAudioManager getAudioManager() {
        return this.getDataFetcher().getAudioManager();
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"on destroy", (Object[])new Object[0]);
        this.exitMicUp(0, null);
        if (this.roomGameContainer != null) {
            this.roomGameContainer.destroy();
        }
        this.removeRoomLifeListener();
        this.getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
    }

    private void playAudio(String key) {
        ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).play(key);
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        ISeatService seatService = this.getChannel().getSeatService();
        int seatIndex = this.getChannel().getSeatService().getSeatIndex(AccountUtil.getUid());
        if (seatIndex >= 1 && !seatService.isMeReady() && seatService.isFirstSeatIndex(seatIndex)) {
            this.getChannel().getPluginService().ready(true, null);
        }
        if (seatService.isInFirstSeat(AccountUtil.getUid())) {
            ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).funcBtns().setValue(this.createFuncBtns());
        } else {
            ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).funcBtns().setValue(null);
        }
    }

    private void initRoomLifeListener() {
        this.mRoomLifeListener = new IPageLifeCycle(){

            public void preDestroy() {
                MicUpPresenter.this.closeResultPageByCurrRoomId();
            }
        };
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(this.mRoomLifeListener);
        this.seatPositions.observe((LifecycleOwner)this.getLifeCycleOwner(), this.mObserver);
    }

    private void removeRoomLifeListener() {
        if (this.mRoomLifeListener != null) {
            ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().removeLifeListener(this.mRoomLifeListener);
        }
    }

    private void closeResultPageByCurrRoomId() {
        if (this.getRoomData() != null) {
            String roomId = this.getRoomData().getRoomId();
            Bundle data = new Bundle();
            data.putString("room_id", roomId);
            data.putBoolean("with_anim", false);
            Message message = Message.obtain();
            message.what = ChannelMicUpMsgDef.MSG_HIDE_RESULT_PAGE;
            message.setData(data);
            MsgDispatcher.getInstance().sendMessage(message);
        }
    }

    private void changeReady() {
        String gid = this.getRoomData().getGameInfo().getPluginId();
        if (!"micup".equals(gid)) {
            return;
        }
        this.getChannel().getPluginService().ready(true, null);
    }

    public boolean isShowing() {
        return this.isMicupRunning() || this.mainContainer != null && this.mainContainer.getVisibility() == 0;
    }

    @SuppressLint(value={"colorParseUsage"})
    public void handleModeChange(long mode) {
        super.handleModeChange(mode);
        if (!this.isMicupRunning()) {
            ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().setValue((Object)new DrawableResThemeBean(R.drawable.bg_mic_up));
            ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_PREPARE");
            this.onPrepareMicUp(this.mainContainer, this.getRoomData().getGameInfo().isStarted(), this.micupLifeCycle, this.micUpFuncBridge);
            ((MusicPlayerPresenter)this.getPresenter(MusicPlayerPresenter.class)).stopMusic(false);
            this.initSongRepoComponent();
        }
    }

    public void resumePlugin() {
        super.resumePlugin();
        if (!this.isMicupRunning()) {
            this.onPrepareMicUp(this.mainContainer, this.getRoomData().getGameInfo().isStarted(), this.micupLifeCycle, this.micUpFuncBridge);
        }
    }

    public void handleGameStateChange(boolean started) {
        super.handleGameStateChange(started);
        if (started) {
            MLog.info((Object)TAG, (String)"mic up running :%b", (Object[])new Object[]{this.isMicupRunning()});
            if (!this.isMicupRunning()) {
                this.onPrepareMicUp(this.mainContainer, true, this.micupLifeCycle, this.micUpFuncBridge);
            }
        }
    }

    public boolean interceptModeChange() {
        this.destroySongRepoComponent();
        return this.isMicupRunning();
    }

    public IPlugin.InterceptPluginChange canBeRemoveWhileRunning(@Nullable GameInfo cur, @Nullable GameInfo next) {
        IPlugin.InterceptPluginChange intercept = new IPlugin.InterceptPluginChange();
        intercept.canChange = !this.isMicupRunning();
        return intercept;
    }

    private void initSongRepoComponent() {
        this.getSongRepoManager().init();
        SongRepoInfo currSongRepo = this.getSongRepoManager().getCurrSongRepo();
        if (currSongRepo != null) {
            ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).gameSubName().setValue((Object)currSongRepo.getName());
        } else {
            this.getSongRepoManager().requestCurrSongRepo(new DataFetchCallback<SongRepoInfo>(){

                public void onSuccess(@Nullable SongRepoInfo data) {
                    if (MicUpPresenter.this.isDestroyed()) {
                        return;
                    }
                    if (data != null) {
                        ((GamePreparePresenter)MicUpPresenter.this.getPresenter(GamePreparePresenter.class)).gameSubName().setValue((Object)data.getName());
                    }
                }

                public void onFailure(long code, @NotNull String msg) {
                    MLog.error((Object)MicUpPresenter.TAG, (String)"requestCurrSongRepo error, code=%d, msg=%s", (Object[])new Object[]{code, msg});
                }
            });
        }
    }

    private List<View> createFuncBtns() {
        YYImageView ivSwitchBtn = new YYImageView((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        ivSwitchBtn.setImageResource(R.drawable.ic_song_repo_switch);
        int paddingSize = ResolutionUtils.dip2Px((float)4.0f);
        ivSwitchBtn.setPadding(paddingSize, paddingSize, paddingSize, paddingSize);
        ivSwitchBtn.setOnClickListener(v -> this.openSongRepoSwitchPanel());
        LinkedList<View> viewList = new LinkedList<View>();
        viewList.add((View)ivSwitchBtn);
        return viewList;
    }

    private void destroySongRepoComponent() {
        if (this.songRepoManager != null) {
            this.songRepoManager.destroy();
        }
    }

    private ISongRepoManager getSongRepoManager() {
        if (this.songRepoManager == null) {
            this.songRepoManager = new SongRepoManager(this.getChannel().getChannelId());
            this.songRepoManager.setSongRepoSwitchListener(this);
        }
        return this.songRepoManager;
    }

    public void openMicUpFromSongRepo(final OnSongRepoSelectListener listener) {
        MLog.info((Object)TAG, (String)"openMicUpFromSongRepo", (Object[])new Object[0]);
        this.showSongRepoSelectPanel(songRepo -> this.getSongRepoManager().requestSwitchSongRepo(songRepo, new DataFetchCallback<Boolean>(){

            public void onSuccess(@Nullable Boolean data) {
                MLog.info((Object)MicUpPresenter.TAG, (String)("openMicUpFromSongRepo requestSwitchSongRepo success, " + songRepo), (Object[])new Object[0]);
                if (listener != null) {
                    listener.onSongRepoSelect(songRepo);
                }
                MicUpPresenter.this.getSongRepoManager().setCurrSongRepo(songRepo);
            }

            public void onFailure(long code, @NotNull String msg) {
                MLog.error((Object)MicUpPresenter.TAG, (String)"openMicUpFromSongRepo requestSwitchSongRepo, code=%d, msg=%s", (Object[])new Object[]{code, msg});
            }
        }));
        if (this.getRoomData() != null) {
            String roomId = this.getRoomData().getRoomId();
            MicUpStatisHelper.reportMuSetPgShow(roomId, 3);
        }
    }

    private void openSongRepoSwitchPanel() {
        MLog.info((Object)TAG, (String)"openSongRepoSwitchPanel", (Object[])new Object[0]);
        this.showSongRepoSelectPanel(songRepo -> this.getSongRepoManager().requestSwitchSongRepo(songRepo, new DataFetchCallback<Boolean>(){

            public void onSuccess(@Nullable Boolean data) {
                MLog.info((Object)MicUpPresenter.TAG, (String)("openSongRepoSwitchPanel requestSwitchSongRepo success, " + songRepo), (Object[])new Object[0]);
            }

            public void onFailure(long code, @NotNull String msg) {
                MLog.error((Object)MicUpPresenter.TAG, (String)"openSongRepoSwitchPanel requestSwitchSongRepo error, code=%d, msg=%s", (Object[])new Object[]{code, msg});
            }
        }));
        if (this.getRoomData() != null) {
            String roomId = this.getRoomData().getRoomId();
            MicUpStatisHelper.reportMuSetPgMuButClick(roomId, 4L);
        }
    }

    private void showSongRepoSelectPanel(OnSongRepoSelectListener listener) {
        this.getSongRepoManager().showSongRepoSelectPanel((DefaultWindow)this.getWindow(), listener);
    }

    @Override
    public void onSongRepoSwitch(SongRepoInfo songRepo) {
        ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).gameSubName().setValue((Object)songRepo.getName());
    }

    public boolean canChangeSeat() {
        int state = this.getDataContext().getCurrentRoundInfo().getRoundState();
        return state == 0 || state == 1;
    }

    public boolean haveSelfFaceLocation() {
        return true;
    }

    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return this.mFaceSeatPoints;
    }

    public boolean interceptRunningState() {
        return true;
    }

    private MutableLiveData<Map<Long, FacePoint>> handleMicSeat(Map<Long, Point> mSeat) {
        if (mSeat != null) {
            HashMap<Long, FacePoint> facePointMap = new HashMap<Long, FacePoint>();
            for (Map.Entry<Long, Point> entry : mSeat.entrySet()) {
                FacePoint point = new FacePoint();
                Point tempPoint = entry.getValue();
                long uid = entry.getKey();
                if (tempPoint == null) continue;
                point.set(tempPoint.x, tempPoint.y);
                point.setWidth(ResolutionUtils.dip2Px((float)30.0f));
                point.setHeight(ResolutionUtils.dip2Px((float)30.0f));
                point.setType(1);
                facePointMap.put(uid, point);
            }
            this.mFaceSeatPoints.setValue(facePointMap);
        }
        return this.mFaceSeatPoints;
    }

    public boolean canOpSeat() {
        return !this.isMicupRunning();
    }

    public boolean canOpMic() {
        return !this.isMicupRunning();
    }

    public boolean canOpVideo() {
        return false;
    }

    public void setContainer(@NonNull YYPlaceHolderView container) {
        super.setContainer(container);
        this.roomGameContainer = this.getGameContainer();
        container.inflate((View)this.roomGameContainer);
        this.roomGameContainer.setPresenter((IGameData)this);
        this.getGameContainer().setPreparePresenter((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class));
    }

    protected RoomGameContainer getGameContainer() {
        if (this.roomGameContainer == null) {
            this.roomGameContainer = new RoomGameContainer((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        }
        return this.roomGameContainer;
    }

    @Override
    public void addMicUpListener(@NonNull IMicupLifeCycle listener) {
        this.lifeCycleListener.add(listener);
    }

    @Override
    public void removeMicUpListener(@NonNull IMicupLifeCycle listener) {
        this.lifeCycleListener.remove(listener);
    }
}

