/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.splash;

import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.push.tips.PushPermissionTipManager;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.module.splash.AED;
import com.yy.hiyo.module.splash.AID;
import com.yy.hiyo.module.splash.AfD;
import com.yy.hiyo.module.splash.ApD;
import com.yy.hiyo.module.splash.SplashShowData;
import com.yy.hiyo.module.splash.aBD;
import com.yy.hiyo.module.splash.aGD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public enum SplashManager {
    INSTANCE;

    private static final String TAG = "SplashManager";
    private static final String CONFIG_PATH = "/splash/sconfig.txt";
    private static final String SHOW_CONFIG_PATH = "/splash/showConfig.txt";
    private static final String GAME_IDS_PATH = "/splash/splash_cache_game_ids.txt";
    private boolean splashViewShowIng = false;
    private final Object fileLock = new Object();
    private AfD mLocalSplashDataRes;
    private volatile List<com.yy.hiyo.module.splash.AhD> mSplashs = null;
    public com.yy.hiyo.module.splash.AhD mLastConfigureSplashData;
    private boolean mNeedSplash = false;
    private SplashShowData mSplashShowData;
    private List<String> cacheGameIds = new ArrayList<String>();
    private boolean hasReadGidConfig = false;
    private IFrequencyLimitExecutor mLimitExecutor;
    private volatile boolean hasLoadSplash = false;

    public void loadSplash() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        if (PageResponse.isBusinessOpRiskEnable() && this.hasLoadSplash) {
            return;
        }
        this.hasLoadSplash = true;
        String string2 = UriProvider.getIkxdSvrHost() + "/boss/app_get_splash";
        String string3 = this.getSaveCampaign();
        if (StringUtils.isNotEmpty((String)string3)) {
            string2 = string2 + "?campaign=" + string3;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("url: " + string2), (Object[])new Object[0]);
        }
        if (!string2.startsWith("http")) {
            return;
        }
        HttpUtil.httpReq((String)string2, null, (int)1, (INetRespCallback)new AED(this));
    }

    private void handleSplash(AfD afD) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleSplash ", (Object[])new Object[0]);
        }
        if (afD == null || FP.empty(afD.AhD)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"handleSplash splash is empty", (Object[])new Object[0]);
            }
            return;
        }
        for (com.yy.hiyo.module.splash.AhD ahD : afD.AhD) {
            if (this.isPreload(afD.AWD, ahD.aRD) || !ahD.AnD()) continue;
            ahD.ADD();
        }
    }

    private void preloadResource(List<AfD.AhD> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"preloadResource size: %d", (Object[])new Object[]{FP.size(list)});
        }
        if (FP.empty(list)) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (AfD.AhD ahD : list) {
            if (TextUtils.isEmpty((CharSequence)ahD.AhD)) continue;
            hashSet.add(ahD.AhD);
        }
        ResPersistUtils.preLoad((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, hashSet);
    }

    private void preloadGame(AfD afD) {
        if (afD == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (!FP.empty(afD.AhD)) {
            for (com.yy.hiyo.module.splash.AhD object : afD.AhD) {
                hashSet.add(object.AED);
            }
        }
        if (!FP.empty(afD.AWD)) {
            for (AfD.AhD ahD : afD.AWD) {
                hashSet.add(ahD.AWD);
            }
        }
        for (String string2 : hashSet) {
            GameInfo gameInfo;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"preloadGame gameId: %s", (Object[])new Object[]{string2});
            }
            if ((gameInfo = ServiceManager.AhD().getService(IGameInfoService.class).getGameInfoByGid(string2)) != null) {
                ServiceManager.AhD().getService(IGameService.class).downloadGame(gameInfo, GameDownloadInfo.DownloadType.silent, 50);
                continue;
            }
            if (!MLog.isLogLevelBlowInfo()) continue;
            MLog.info((Object)TAG, (String)"preloadGame gid: %s, game info is null", (Object[])new Object[]{string2});
        }
    }

    private boolean isPreload(List<AfD.AhD> list, String string2) {
        if (!FP.empty(list)) {
            for (AfD.AhD ahD : list) {
                if (!StringUtils.equal((String)string2, (String)ahD.AhD)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needShowSplash() {
        return this.checkSplashDataValid();
    }

    private boolean checkSplashDataValid() {
        com.yy.hiyo.module.splash.AhD ahD = this.getWillLoadSplashData();
        return ahD != null && ahD.AnD() && ahD.alD();
    }

    public com.yy.hiyo.module.splash.AhD getWillLoadSplashData() {
        return SplashManager.INSTANCE.mLastConfigureSplashData != null ? SplashManager.INSTANCE.mLastConfigureSplashData : INSTANCE.getFirstValidSplash();
    }

    public com.yy.hiyo.module.splash.AhD getFirstValidSplash() {
        List<com.yy.hiyo.module.splash.AhD> list = this.getSavedSplashData();
        com.yy.hiyo.module.splash.AhD ahD = this.getLoadStategy().AhD(list, false);
        if (ahD != null) {
            this.mNeedSplash = true;
        }
        return ahD;
    }

    public boolean isSplashViewShowIng() {
        return this.splashViewShowIng;
    }

    public void setSplashViewShowIng(boolean bl) {
        this.splashViewShowIng = bl;
        PushPermissionTipManager.setIsSplashViewShowIng((boolean)bl);
    }

    public void loadSplashConfigAsyn() {
        YYTaskExecutor.execute((Runnable)new aGD(this));
    }

    public void preloadSplashIcon() {
        aBD aBD2 = new aBD(this);
        YYTaskExecutor.execute((Runnable)aBD2);
    }

    public synchronized List<com.yy.hiyo.module.splash.AhD> getSavedSplashData() {
        if (this.mSplashs != null) {
            return this.mSplashs;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getSavedSplashData", (Object[])new Object[0]);
        }
        this.cacheGameIds = this.getCacheGameIds();
        AfD afD = this.readConfig();
        if (afD != null && !FP.empty(afD.AhD)) {
            this.mSplashs = afD.AhD;
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute(this::preloadPath);
            } else {
                this.preloadPath();
            }
        }
        return this.mSplashs;
    }

    private synchronized void preloadPath() {
        if (FP.empty(this.mSplashs)) {
            return;
        }
        for (com.yy.hiyo.module.splash.AhD ahD : this.mSplashs) {
            if (ahD == null || TextUtils.isEmpty((CharSequence)ahD.aRD)) continue;
            ResPersistUtils.fetchFilePath((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, (String)ahD.aRD);
        }
    }

    public synchronized void releaseData() {
        if (this.mSplashs != null) {
            this.mSplashs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AfD readConfig() {
        if (this.mLocalSplashDataRes != null) {
            return this.mLocalSplashDataRes;
        }
        try {
            Object object = this.fileLock;
            synchronized (object) {
                String string2 = this.getSaveConfigPath();
                if (YYFileUtils.isPathExist((String)string2)) {
                    this.mLocalSplashDataRes = (AfD)JsonParser.parseJsonFile((String)string2, AfD.class);
                    return this.mLocalSplashDataRes;
                }
                MLog.error((Object)TAG, (String)"readConfig path is not exist: %s", (Object[])new Object[]{string2});
            }
        }
        catch (Exception exception) {
            MLog.error((Object)TAG, (Throwable)exception);
        }
        return null;
    }

    void writeConfig(AfD afD) {
        if (afD == null) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new AID(this, afD));
    }

    private String getSaveConfigPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + CONFIG_PATH;
    }

    private String getGameIdsPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + GAME_IDS_PATH;
    }

    public void setGameIds(List<GameInfo> list) {
        this.cacheGameIds.clear();
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (GameInfo gameInfo : list) {
                stringBuilder.append(gameInfo.gid).append(",");
                this.cacheGameIds.add(gameInfo.gid);
            }
        }
        MLog.debug((Object)TAG, (String)"setGameIds :%s", (Object[])new Object[]{stringBuilder.toString()});
        if (this.mLimitExecutor == null) {
            this.mLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)8000L, (boolean)false);
        }
        this.mLimitExecutor.execute((Runnable)new ApD(this, stringBuilder));
    }

    private List<String> getCacheGameIds() {
        if (this.hasReadGidConfig) {
            return this.cacheGameIds;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        byte[] byArray = YYFileUtils.readBytes((String)this.getGameIdsPath());
        String string2 = null;
        if (byArray != null && byArray.length > 0 && !StringUtils.isEmpty((String)(string2 = new String(byArray)))) {
            String[] stringArray = string2.split(",");
            arrayList.addAll(Arrays.asList(stringArray));
        }
        this.hasReadGidConfig = true;
        if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getCacheGameIds :%s", (Object[])new Object[]{string2});
        }
        return arrayList;
    }

    private AWD getLoadStategy() {
        return new AhD(null);
    }

    public void clickSplash(String string2) {
        SplashShowData.AhD ahD = this.getTargetShowData(string2);
        if (ahD != null) {
            ahD.AnD = true;
            if (this.mSplashShowData != null) {
                this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
                YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
            }
        }
    }

    public void splashShow(String string2) {
        SplashShowData.AhD ahD = this.getTargetShowData(string2);
        if (ahD != null) {
            ++ahD.AWD;
        }
        if (this.mSplashShowData != null) {
            this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
            YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
        }
    }

    private SplashShowData.AhD getTargetShowData(String string2) {
        SplashShowData.AhD ahD = null;
        if (StringUtils.isNotEmpty((String)string2) && this.mSplashShowData != null) {
            boolean bl = false;
            List<SplashShowData.AhD> list = this.mSplashShowData.mSplashShows;
            if (list == null) {
                this.mSplashShowData.mSplashShows = list = new CopyOnWriteArrayList<SplashShowData.AhD>();
            }
            if (!list.isEmpty()) {
                for (SplashShowData.AhD ahD2 : list) {
                    if (!string2.equals(ahD2.AhD)) continue;
                    bl = true;
                    ahD = ahD2;
                    break;
                }
            }
            if (!bl) {
                ahD = new SplashShowData.AhD();
                ahD.AhD = string2;
                list.add(ahD);
            }
        }
        return ahD;
    }

    private void loadShowData() {
        if (this.mSplashShowData == null) {
            String string2 = this.getShowDataSaveConfigPath();
            if (YYFileUtils.isPathExist((String)string2)) {
                this.mSplashShowData = (SplashShowData)JsonParser.parseJsonFile((String)string2, SplashShowData.class);
            }
            if (this.mSplashShowData == null || !TimeUtils.isSameDay((long)this.mSplashShowData.lastUpdateTime, (long)System.currentTimeMillis())) {
                this.mSplashShowData = new SplashShowData();
            }
        }
    }

    private String getShowDataSaveConfigPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + SHOW_CONFIG_PATH;
    }

    private String getSaveCampaign() {
        String string2 = SettingFlags.getStringValue((String)"key_dl_campaign_for_splash", null);
        String string3 = null;
        if (StringUtils.isNotEmpty((String)string2)) {
            try {
                long l2;
                String[] stringArray = string2.split("`");
                if (stringArray.length == 2 && (l2 = Long.parseLong(stringArray[1])) > 0L && l2 < System.currentTimeMillis() && l2 + 172800000L > System.currentTimeMillis()) {
                    string3 = stringArray[0];
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string3;
    }

    static /* synthetic */ void access$000(SplashManager splashManager, AfD afD) {
        splashManager.handleSplash(afD);
    }

    static /* synthetic */ void access$100(SplashManager splashManager, List list) {
        splashManager.preloadResource(list);
    }

    static /* synthetic */ void access$200(SplashManager splashManager, AfD afD) {
        splashManager.preloadGame(afD);
    }

    static /* synthetic */ AWD access$300(SplashManager splashManager) {
        return splashManager.getLoadStategy();
    }

    static /* synthetic */ void access$400(SplashManager splashManager) {
        splashManager.loadShowData();
    }

    static /* synthetic */ Object access$500(SplashManager splashManager) {
        return splashManager.fileLock;
    }

    static /* synthetic */ String access$600(SplashManager splashManager) {
        return splashManager.getSaveConfigPath();
    }

    static /* synthetic */ String access$700(SplashManager splashManager) {
        return splashManager.getGameIdsPath();
    }

    private class AhD
    implements AWD {
        private AhD() {
        }

        @Override
        public com.yy.hiyo.module.splash.AhD AhD(List<com.yy.hiyo.module.splash.AhD> list, boolean bl) {
            if (FP.empty(list)) {
                MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData empty!!!", (Object[])new Object[0]);
                return null;
            }
            com.yy.hiyo.module.splash.AhD ahD = null;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                com.yy.hiyo.module.splash.AhD ahD2 = list.get(i2);
                if (ahD2 == null || !ahD2.AnD()) {
                    MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData check Splash id not Valid:%s !!!", (Object[])new Object[]{ahD2 != null ? ahD2.AWD : ""});
                    continue;
                }
                if (ahD2.alD()) {
                    if (ahD != null) continue;
                    String string2 = ahD2.AWD;
                    if (StringUtils.isEmpty((String)string2)) {
                        MLog.error((Object)SplashManager.TAG, (String)"splashId empty!!!, res:%s", (Object[])new Object[]{ahD2.aRD});
                        continue;
                    }
                    boolean bl2 = this.AhD(string2);
                    if (!bl2) continue;
                    String string3 = ahD2.AED;
                    if (StringUtils.isNotEmpty((String)string3)) {
                        IGameInfoService iGameInfoService = null;
                        if (RuntimeContext.sIsAppStartFinished) {
                            iGameInfoService = ServiceManager.AhD().getService(IGameInfoService.class);
                        }
                        if (iGameInfoService != null) {
                            GameInfo gameInfo = iGameInfoService.getGameInfoByGid(string3);
                            if (gameInfo == null) {
                                MLog.error((Object)SplashManager.TAG, (String)"gInfo null!!! splashId:%s, gameId:%s ", (Object[])new Object[]{string2, string3});
                                continue;
                            }
                        } else {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)SplashManager.TAG, (String)"gameInfoService null, skip check game info!!!!", (Object[])new Object[0]);
                            }
                            if (!SplashManager.this.cacheGameIds.contains(string3)) {
                                if (!MLog.isLogLevelBlowInfo()) continue;
                                MLog.info((Object)SplashManager.TAG, (String)"cache gid not contain gid:%s !!!!", (Object[])new Object[]{string3});
                                continue;
                            }
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)SplashManager.TAG, (String)"cache gid contain gid:%s", (Object[])new Object[]{string3});
                            }
                        }
                    }
                    ahD = ahD2;
                    if (bl) continue;
                    break;
                }
                if (!bl) continue;
                ahD2.ADD();
            }
            if (ahD == null && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SplashManager.TAG, (String)"mLastConfigureSplashData null!!!", (Object[])new Object[0]);
            }
            return ahD;
        }

        private boolean AhD(String string2) {
            boolean bl = SettingFlags.getBoolean((String)"ENV_AD_DIALOG", (boolean)false);
            if (SystemUtils.isShowEnvSetting() && bl) {
                return true;
            }
            if (SplashManager.this.mSplashShowData != null && ((SplashManager)SplashManager.this).mSplashShowData.mSplashShows != null) {
                for (SplashShowData.AhD ahD : ((SplashManager)SplashManager.this).mSplashShowData.mSplashShows) {
                    if (!string2.equals(ahD.AhD) || ahD.AhD()) continue;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SplashManager.TAG, (String)"is not valid!!! splashShow:%s", (Object[])new Object[]{ahD});
                    }
                    return false;
                }
            }
            return true;
        }

        /* synthetic */ AhD(AED aED) {
            this();
        }
    }

    private static interface AWD {
        public com.yy.hiyo.module.splash.AhD AhD(List<com.yy.hiyo.module.splash.AhD> var1, boolean var2);
    }
}

