/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.crashprotect;

import android.os.Looper;
import android.util.Log;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CrashProtectConfig;
import com.yy.appbase.unifyconfig.config.TryCatchSwitchConfig;
import com.yy.base.crash.CrashMonitor;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ThrowUtils;
import com.yy.hiyo.crashprotect.AhD;
import com.yy.hiyo.crashprotect.AqD;

public class ADD {
    private static volatile boolean AhD = false;
    private static volatile boolean AWD = false;
    private static volatile int AnD = 0;
    private static Thread.UncaughtExceptionHandler alD;

    public static synchronized void AhD() {
        ADD.AdD();
        ADD.AqD();
    }

    private static void AdD() {
        if (AhD) {
            return;
        }
        if (SystemUtils.isShowEnvSetting()) {
            return;
        }
        if (!RuntimeContext.sIsDebuggable && !SettingFlags.getBoolean((String)"crashprotectswitch", (boolean)true)) {
            return;
        }
        ADD.AWD("CrashProtecter", "init!");
        AhD = true;
        alD = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new AqD());
    }

    private static void AWD(String string2, String string3) {
        MLog.error((Object)string2, (String)string3, (Object[])new Object[0]);
        Log.e((String)string2, (String)string3);
    }

    private static void AqD() {
        if (AWD) {
            return;
        }
        if (!TryCatchSwitchConfig.isOpen()) {
            return;
        }
        AWD = true;
        CrashMonitor.setTryCatchChecker((string2, throwable) -> {
            if (RuntimeContext.sIsDebuggable) {
                return false;
            }
            return ADD.AhD(string2, throwable);
        });
    }

    private static void aRD() {
        ++com.yy.hiyo.crashprotect.AhD.AhD;
        ++AnD;
        try {
            Looper.loop();
        }
        catch (Throwable throwable) {
            String string2 = throwable != null ? throwable.toString() : "";
            ADD.AWD("CrashProtecter", "Looper.loop catch:" + string2);
            if (ADD.AWD(throwable, true, string2)) {
                ADD.aRD();
            }
            if (alD != null) {
                alD.uncaughtException(Looper.getMainLooper().getThread(), throwable);
            }
            ThrowUtils.throwException((Throwable)throwable);
        }
    }

    private static boolean AhD(String string2, Throwable throwable) {
        if (TryCatchSwitchConfig.isTryCatch((String)string2, (Throwable)throwable)) {
            if (TryCatchSwitchConfig.isTryCatchReport((String)string2)) {
                com.yy.hiyo.app.perf.AhD.AhD(throwable, string2, TryCatchSwitchConfig.stack((String)string2));
            }
            return true;
        }
        return false;
    }

    private static boolean AWD(Throwable throwable, boolean bl, String string2) {
        try {
            if (throwable == null) {
                return false;
            }
            if (ADD.AhD(throwable, string2)) {
                return true;
            }
            AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.CRASH_PROTECT);
            if (aConfigData instanceof CrashProtectConfig) {
                CrashProtectConfig crashProtectConfig = (CrashProtectConfig)aConfigData;
                boolean bl2 = crashProtectConfig.needCatchByExtInfoContain(bl, AnD, string2);
                if (bl2) {
                    com.yy.hiyo.app.perf.AhD.AhD(throwable, string2);
                    return bl2;
                }
                StackTraceElement[] stackTraceElementArray = throwable.getMessage();
                if (stackTraceElementArray != null) {
                    bl2 = crashProtectConfig.needCatchByExtInfoContain(bl, AnD, (String)stackTraceElementArray);
                }
                if (bl2) {
                    com.yy.hiyo.app.perf.AhD.AhD(throwable, (String)stackTraceElementArray);
                    ADD.AWD("CrashProtecter", AnD + ",catched by detailMsg:" + (String)stackTraceElementArray);
                    return bl2;
                }
                ADD.AWD("CrashProtecter", AnD + ",not catched by detailMsg:" + (String)(stackTraceElementArray != null ? stackTraceElementArray : ""));
                stackTraceElementArray = null;
                try {
                    stackTraceElementArray = throwable.getStackTrace();
                }
                catch (Throwable throwable2) {
                    return false;
                }
                bl2 = crashProtectConfig.needCatch(bl, stackTraceElementArray, AnD);
                if (bl2) {
                    com.yy.hiyo.app.perf.AhD.AhD(throwable, string2);
                } else if (stackTraceElementArray != null) {
                    if (stackTraceElementArray.length <= 4) {
                        if (stackTraceElementArray.length >= 1) {
                            StackTraceElement stackTraceElement = stackTraceElementArray[0];
                            ADD.AhD(stackTraceElement, "StackTraceElement elementOne");
                        }
                        ADD.AWD("CrashProtecter", AnD + ",StackTraceElement length not valid:" + stackTraceElementArray.length);
                    } else {
                        StackTraceElement stackTraceElement = stackTraceElementArray[0];
                        StackTraceElement stackTraceElement2 = stackTraceElementArray[1];
                        ADD.AhD(stackTraceElement, "StackTraceElement elementOne");
                        ADD.AhD(stackTraceElement2, "StackTraceElement elementTwo");
                    }
                }
                return bl2;
            }
            ADD.AWD("CrashProtecter", "config is Empty!");
            return com.yy.hiyo.crashprotect.AhD.AhD(throwable, bl);
        }
        catch (Throwable throwable3) {
            ADD.AWD("CrashProtecter", "needCatch:" + (throwable3 != null ? throwable3.toString() : ""));
            return false;
        }
    }

    private static void AhD(StackTraceElement stackTraceElement, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n2 = -1;
        if (stackTraceElement != null) {
            string3 = stackTraceElement.getClassName();
            string4 = stackTraceElement.getFileName();
            string5 = stackTraceElement.getMethodName();
            n2 = stackTraceElement.getLineNumber();
            ADD.AWD("CrashProtecter", string2 + " className:" + (string3 != null ? string3 : "") + ",fileName:" + (string4 != null ? string4 : "") + ",methodName:" + (string5 != null ? string5 : "") + ",lineNumber" + n2);
        } else {
            ADD.AWD("CrashProtecter", string2 + " null");
        }
    }

    private static boolean AhD(Throwable throwable, String string2) {
        if (throwable != null && StringUtils.isNotEmpty((String)throwable.getMessage()) && throwable.getMessage().contains("did not then call Service.startForeground")) {
            com.yy.hiyo.app.perf.AhD.AhD(throwable, string2);
            return true;
        }
        if (throwable == null) {
            return false;
        }
        String string3 = throwable.getMessage();
        if (StringUtils.isEmpty((String)string3)) {
            return false;
        }
        if (string3.contains("Bad notification posted from package com.yy.hiyo")) {
            com.yy.hiyo.app.perf.AhD.AhD(throwable, string2);
            return true;
        }
        if (string3.contains("Using WebView from more than one process at once with the same data directory") || throwable instanceof RuntimeException && string3.contains("at org.chromium.android_webview.AwBrowserProcess.b(PG:11)")) {
            if (SettingFlags.hasInited()) {
                SettingFlags.setBoolean((String)"adnotusemultiprocess", (boolean)true);
            }
            com.yy.hiyo.app.perf.AhD.AhD(throwable, string2);
            return true;
        }
        if (string3.contains("android.app.RemoteServiceException") && string3.contains("Bad notification posted from package")) {
            com.yy.hiyo.app.perf.AhD.AhD(throwable, string2);
            return true;
        }
        return false;
    }

    public static boolean AhD(Throwable throwable, boolean bl) {
        String string2 = throwable != null ? throwable.toString() : "";
        ADD.AWD("CrashProtecter", "handleCachedExe:" + string2);
        boolean bl2 = ADD.AWD(throwable, bl, string2);
        if (!bl2) {
            ThrowUtils.throwException((Throwable)throwable);
        }
        return bl2;
    }

    static /* synthetic */ boolean AhD(Throwable throwable, boolean bl, String string2) {
        return ADD.AWD(throwable, bl, string2);
    }

    static /* synthetic */ void AhD(String string2, String string3) {
        ADD.AWD(string2, string3);
    }

    static /* synthetic */ void AWD() {
        ADD.aRD();
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler AnD() {
        return alD;
    }

    static /* synthetic */ int alD() {
        return AnD;
    }

    static /* synthetic */ int ADD() {
        return ++AnD;
    }
}

