/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.vk;

import android.content.Context;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.callback.OnProfileSingleCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.login.AbstractHandleUserInfoLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.basicprofile.BasicProfileController;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.request.ILoginRequestCallBack;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.UserDetainInfo;
import com.yy.socialplatformbase.callback.ILoginCallBack;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.socialplatformbase.data.MetricCode;
import java.io.File;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class VkLoginController
extends AbstractHandleUserInfoLoginer {
    private static final String TAG = "VkLoginController";
    private static final String VK_DIR = "vk";
    private ILoginActionCallBack mMyCallBack;

    public VkLoginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 5);
        this.mMyCallBack = callBack;
        ThirdPartyPlatformHelper.getInstance().getPlatform(8);
    }

    @Override
    public void openLoginWindow() {
        this.startLogin();
    }

    public void logout() {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(8);
        if (adapter != null) {
            adapter.logout();
        }
    }

    private void startLogin() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startLogin!", (Object[])new Object[0]);
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        this.authorization(new IThirdPartyAuthorizationCallBack(){

            public void onSuccess(LoginSuccessResult result) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)VkLoginController.TAG, (String)"startLogin success!", (Object[])new Object[0]);
                }
                if (result != null && result.authorizedData != null) {
                    VkLoginController.this.handleLoginResult(result);
                } else {
                    VkLoginController.this.handleLoginError("114", "");
                }
            }

            public void onCancel() {
                VkLoginController.this.handleLoginError("116", "");
            }

            public void onError(int errorCode, Exception e) {
                VkLoginController.this.handleLoginError("212", e != null ? e.getMessage() : "");
            }
        });
    }

    private void handleLoginResult(LoginSuccessResult result) {
        this.mMyCallBack.onLoginStart(this);
        String userId = result.authorizedData.userId;
        String tokenStr = result.authorizedData.tokenStr;
        String appId = result.authorizedData.appId;
        String mail = result.authorizedData.mail;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleLoginResult!", (Object[])new Object[0]);
        }
        final long startTime = System.currentTimeMillis();
        this.mMyCallBack.getLoginRequester().loginWithThirdParty(8, appId, tokenStr, userId, mail, new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)VkLoginController.TAG, (String)"handleLoginResult success!", (Object[])new Object[0]);
                }
                if (data == null) {
                    VkLoginController.this.handleLoginError("212", "get vk userinfo error!");
                    return;
                }
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/thirdpartyAuth");
                LoginData vkLoginData = data;
                AccountInfo accountInfo = AccountInfo.obtain((LoginData)vkLoginData);
                accountInfo.loginType = 5;
                if (VkLoginController.this.mLoginCallBack != null) {
                    VkLoginController.this.mLoginCallBack.onLoginSuccess(VkLoginController.this, accountInfo);
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                VkLoginController.this.handleLoginError(errorCode, errorDescription);
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/thirdpartyAuth");
            }
        });
    }

    private void handleLoginError(final String errorCode, final String des) {
        MLog.error((Object)TAG, (String)"login error:%s %s", (Object[])new Object[]{errorCode, des});
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VkLoginController.this.mLoginCallBack != null) {
                    VkLoginController.this.mLoginCallBack.onLoginError(VkLoginController.this, errorCode, des);
                }
                VkLoginController.this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
                VkLoginController.this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
            }
        });
    }

    @Override
    protected void authorization(final IThirdPartyAuthorizationCallBack callBack) {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(8);
        if (adapter != null) {
            adapter.login(new ILoginCallBack(){

                public void onSuccess(@NotNull LoginSuccessResult result) {
                    if (result.authorizedData != null) {
                        LoginMetricHelper.reportToMetric((int)5, (String)"0");
                        if (callBack != null) {
                            callBack.onSuccess(result);
                        }
                    } else {
                        if (callBack != null) {
                            callBack.onError(-1, (Exception)new RuntimeException(""));
                        }
                        String metricCode = MetricCode.getSelfCode((String)"400");
                        LoginMetricHelper.reportToMetric((int)5, (String)metricCode);
                    }
                }

                public void onCancel() {
                    if (callBack != null) {
                        callBack.onCancel();
                    }
                }

                public void onError(@NotNull LoginErrorResult result) {
                    if (callBack != null) {
                        callBack.onError(result.errorCode, result.exception);
                        LoginMetricHelper.reportToMetric((int)5, (String)result.metricCode);
                    }
                }
            });
        }
    }

    private void deleteVkIcon(final String path) {
        if (StringUtils.isEmpty((String)path)) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                File iconFile = new File(path);
                FileUtils.deleteFile((File)iconFile);
            }
        });
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        this.getUserInfo(true, 8, accountInfo, callBack);
    }

    @Override
    public void handleLoginWithUpdateUserInfo(final IUserInfoCallBack callBack, final String iconPath, AccountInfo accountInfo, UserDetainInfo info) {
        if (info == null || accountInfo == null || !accountInfo.isValid()) {
            this.handleUpdateHagoUserInfoError(callBack, "212", "get vk userinfo error!");
            return;
        }
        if (StringUtils.isEmpty((String)iconPath)) {
            this.handleUpdateHagoUserInfoError(callBack, "212", "get icon error!");
            return;
        }
        UserInfoBean userInfo = this.transform(info);
        userInfo.setUid(accountInfo.uuid);
        BasicProfileController.updateUserInfo(this.getServiceManager(), iconPath, userInfo, new OnProfileSingleCallback(){

            public void onError(Call call, Exception e, int id2) {
                VkLoginController.this.deleteVkIcon(iconPath);
                VkLoginController.this.handleUpdateHagoUserInfoError(callBack, "112", e != null ? e.toString() : "");
            }

            public void onResponseError(int id2, String message, String response) {
                VkLoginController.this.deleteVkIcon(iconPath);
                VkLoginController.this.handleUpdateHagoUserInfoError(callBack, message, response);
            }

            public void onUISuccess(final UserInfoBean userInfo) {
                VkLoginController.this.deleteVkIcon(iconPath);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onSuccess(userInfo);
                        }
                        if (userInfo != null) {
                            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_USER_INFO_UPDATED, (Object)userInfo.getUid()));
                        }
                    }
                });
            }
        });
    }

    @Override
    public String getIconDir() {
        return VK_DIR;
    }

    @Override
    public String getThirdpartyError() {
        return "212";
    }
}

