/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.view;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.ui.press.ClickScaleAnimProvider;
import com.yy.base.crash.CrashMonitor;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.bean.LoginBigButtonInfo;
import com.yy.hiyo.login.phone.windows.ShakeAnim;
import com.yy.hiyo.login.phone.windows.SplashLightAnim;
import com.yy.hiyo.login.view.ILoginTypeView;
import com.yy.hiyo.login.view.LoginButtonInfoHelper;
import com.yy.hiyo.mvp.base.ICustomView;
import javax.annotation.Nonnull;

public class LoginBigButton
extends YYConstraintLayout
implements ICustomView,
ILoginTypeView<LoginBigButtonInfo> {
    private RecycleImageView mIcon;
    private YYTextView mName;
    private YYView mLightView;
    private LoginBigButtonInfo mData;
    private SplashLightAnim mSplashAnim;
    private ShakeAnim mShakeAnim;
    private boolean mSplashEnable = false;
    private boolean mShakeEnable = false;

    public static LoginBigButton create(LoginTypeData type) {
        LoginBigButton btn = new LoginBigButton(RuntimeContext.sApplicationContext);
        btn.setData(LoginButtonInfoHelper.createBigBtnInfo(type));
        btn.setVisibility(type.isVisible() ? 0 : 8);
        if (type == LoginTypeData.PHONE) {
            btn.setContentDescription("login with phone");
        }
        return btn;
    }

    public LoginBigButton(Context context) {
        super(context);
        this.createView(null);
    }

    public LoginBigButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public LoginBigButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(attrs);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkAnim(enabled);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.checkAnim(this.isEnabled());
        } else {
            if (this.mSplashEnable && this.mSplashAnim != null) {
                this.mSplashAnim.stop();
            }
            if (this.mShakeEnable && this.mShakeAnim != null) {
                this.mShakeAnim.stop(true);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.post(new Runnable(){

            @Override
            public void run() {
                LoginBigButton.this.mSplashAnim = SplashLightAnim.of((View)LoginBigButton.this.mLightView, LoginBigButton.this.getMeasuredWidth(), 0L);
                LoginBigButton.this.mSplashAnim.setDuration(1000L);
                LoginBigButton.this.mShakeAnim = ShakeAnim.of((View)LoginBigButton.this, 0L).ofCount(5).ofScale(1.0f, 1.1f, 0.95f, 1.0f);
                LoginBigButton.this.checkAnim(LoginBigButton.this.isEnabled());
            }
        });
    }

    public void createView(@Nullable AttributeSet attrs) {
        LoginBigButton.inflate((Context)this.getContext(), (int)R.layout.login_big_button, (ViewGroup)this);
        ClickScaleAnimProvider.apply((View)this);
        this.mIcon = (RecycleImageView)this.findViewById(R.id.type_icon);
        this.mName = (YYTextView)this.findViewById(R.id.type_name);
        this.mLightView = (YYView)this.findViewById(R.id.type_light);
    }

    @Override
    public void setData(@Nonnull LoginBigButtonInfo data) {
        this.mData = data;
        if (data.btnIconResId != 0) {
            this.mIcon.setVisibility(0);
            this.mIcon.setImageResource(data.btnIconResId);
        } else {
            this.mIcon.setVisibility(8);
        }
        if (data.btnText != 0) {
            this.mName.setText(data.btnText);
        }
        if (data.textColor != 0) {
            this.mName.setTextColor(ResourceUtils.getColor((int)data.textColor));
        }
        this.setBackgroundResource(data.btnBackgroundResId);
    }

    @Override
    public LoginBigButtonInfo getData() {
        return this.mData;
    }

    public void draw(Canvas canvas) {
        CrashMonitor.tryCatch((Object)this, (String)"com.yy.hiyo.login.view.LoginBigButton#draw", () -> LoginBigButton.super.draw(canvas));
    }

    public void dispatchDraw(Canvas canvas) {
        CrashMonitor.tryCatch((Object)this, (String)"com.yy.hiyo.login.view.LoginBigButton#dispatchDraw", () -> LoginBigButton.super.dispatchDraw(canvas));
    }

    public void setSplashEnable(boolean enable) {
        this.mSplashEnable = enable;
        this.post(() -> this.checkAnim(this.isEnabled()));
    }

    private void checkAnim(boolean enabled) {
        if (this.mSplashAnim != null && this.mSplashEnable) {
            if (enabled) {
                this.mSplashAnim.start();
            } else {
                this.mSplashAnim.stop();
            }
        }
        if (this.mShakeAnim != null && this.mShakeEnable) {
            if (enabled) {
                this.mShakeAnim.start();
            } else {
                this.mShakeAnim.stop(true);
            }
        }
    }

    public void setShakeEnable(boolean enable) {
        this.mShakeEnable = enable;
        this.post(() -> this.checkAnim(this.isEnabled()));
    }
}

