/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.solid;

import android.content.Context;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.dw.android.itna.DwItna;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.request.ILoginRequester;
import com.yy.hiyo.login.request.IReportAntiCallBack;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import org.json.JSONObject;

public class SolidManager {
    private static final String TAG = "SolidManager";
    private static final String EVENT_ID = "20042965";
    private static final String ANTI_CODE_EMPTY = "100";
    private static final String ACCOUNT_INFO_ERROR = "101";
    private static final String BASE64_DECODE_ERROR = "102";
    private static final String DWITNA_EXEC_REEOR = "103";
    private static final String REQUEST_ERROR = "104";
    private static final String REPORT_ANTI_SUCCESS = "0";

    public static SolidManager getInstance() {
        return SingleHolder.mInstance;
    }

    private SolidManager() {
    }

    public void startSolidProcess(AccountInfo accountInfo, @NonNull ILoginRequester loginRequester) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute(() -> this.realSolidProcess(accountInfo, loginRequester));
        } else {
            this.realSolidProcess(accountInfo, loginRequester);
        }
    }

    private void realSolidProcess(AccountInfo accountInfo, ILoginRequester loginRequester) {
        byte[] buffer;
        block10: {
            if (FP.empty((CharSequence)accountInfo.anti)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"startSolidProcess anti is empty!!", (Object[])new Object[0]);
                }
                this.reportAntiCode(ANTI_CODE_EMPTY);
                return;
            }
            if (accountInfo == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"startSolidProcess account is null!!", (Object[])new Object[0]);
                }
                this.reportAntiCode(ACCOUNT_INFO_ERROR);
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"startSolidProcess uid: %s  anti: %s", (Object[])new Object[]{accountInfo.uuid, accountInfo.anti});
            }
            buffer = null;
            try {
                buffer = Base64.decode((String)accountInfo.anti, (int)0);
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block10;
                MLog.info((Object)TAG, (String)"startSolidProcess Base64.decode ex: %s", (Object[])new Object[]{e});
            }
        }
        if (buffer == null || buffer.length == 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"startSolidProcess getFromBase64 is empty!!", (Object[])new Object[0]);
            }
            this.reportAntiCode(BASE64_DECODE_ERROR);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"byte length: %s bytes2hexStr: %s", (Object[])new Object[]{buffer.length, this.bytes2hex(buffer)});
        }
        DwItna.setUdbId((String)HiidoUtils.getHdid());
        this.doRecv(buffer, accountInfo, loginRequester);
    }

    private void doRecv(byte[] buffer, AccountInfo accountInfo, ILoginRequester loginRequester) {
        try {
            byte[] ret = DwItna.exec((Context)RuntimeContext.sApplicationContext, (byte[])buffer, (String)"yym-hago-and", (int)0);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"doRecv Anti execute code len = %s, result len = %s", (Object[])new Object[]{buffer.length, ret == null ? 0 : ret.length});
            }
            if (ret != null && ret.length > 0) {
                this.reportToService(ret, accountInfo, loginRequester);
            } else {
                this.reportAntiCode(DWITNA_EXEC_REEOR);
            }
        }
        catch (Exception e) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"doRecv ex: %s", (Object[])new Object[]{String.valueOf(buffer.length)});
            }
            this.reportAntiCode(DWITNA_EXEC_REEOR);
        }
    }

    private void reportToService(byte[] ret, final AccountInfo accountInfo, ILoginRequester loginRequester) {
        String base64Str = Base64.encodeToString((byte[])ret, (int)0);
        if (SystemUtils.isShowEnvSetting()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"start reportToService base64Str: %s", (Object[])new Object[]{base64Str});
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"start reportToService base64Str: %d", (Object[])new Object[]{base64Str != null ? Integer.valueOf(base64Str.length()) : ""});
        }
        loginRequester.reportAnti(base64Str, accountInfo, new IReportAntiCallBack(){

            @Override
            public void onFailed(Throwable ex) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SolidManager.TAG, (String)"reportToService ex: %s", (Object[])new Object[]{ex});
                }
                SolidManager.this.reportAntiCode(SolidManager.REQUEST_ERROR);
            }

            @Override
            public void onSuccess(String response) {
                String code;
                block7: {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SolidManager.TAG, (String)"reportToService response: %s", (Object[])new Object[]{response});
                    }
                    if (RuntimeContext.sIsDebuggable) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("Solid report Success: uid: " + accountInfo.uuid + "  " + response), (int)0);
                    }
                    code = null;
                    try {
                        JSONObject jsonObject = JsonParser.obtainJSONObject((String)response);
                        code = jsonObject.getString("result_code");
                    }
                    catch (Exception e) {
                        if (!MLog.isLogLevelBlowInfo()) break block7;
                        MLog.info((Object)SolidManager.TAG, (String)"reportToService onSuccess ex: %s", (Object[])new Object[]{e});
                    }
                }
                if (StringUtils.equalsIgnoreCase((String)code, (String)"00000")) {
                    SolidManager.this.reportAntiCode(SolidManager.REPORT_ANTI_SUCCESS);
                } else {
                    if (code == null) {
                        code = "112";
                    }
                    SolidManager.this.reportAntiCode(code);
                }
            }
        });
    }

    private void reportAntiCode(String code) {
        MLog.debug((Object)TAG, (String)"reportAntiCode code: %s", (Object[])new Object[]{code});
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put("function_id", "anti_report").put("result", code));
    }

    private String bytes2hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String tmp = Integer.toHexString(0xFF & b);
            if (tmp.length() == 1) {
                tmp = REPORT_ANTI_SUCCESS + tmp;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    private static class SingleHolder {
        public static SolidManager mInstance = new SolidManager();

        private SingleHolder() {
        }
    }
}

