/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.request.udb;

import android.content.Context;
import android.os.SystemClock;
import android.util.SparseArray;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.constant.CommonPerfUtils;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DES3Utils;
import com.yy.base.utils.SHAUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.account.PhoneLoginData;
import com.yy.hiyo.login.base.OnReportCallback;
import com.yy.hiyo.login.request.ILoginRequestCallBack;
import com.yy.hiyo.login.request.ILoginRequester;
import com.yy.hiyo.login.request.IQueryThirdPartyAccountCallBack;
import com.yy.hiyo.login.request.IQueryWhatsAppTokenCallback;
import com.yy.hiyo.login.request.IReportAntiCallBack;
import com.yy.hiyo.login.request.IRequestSmsCodeCallBack;
import com.yy.hiyo.login.request.LoginRequestManager;
import com.yy.hiyo.login.request.LoginUtil;
import com.yy.hiyo.login.request.udb.IPcid;
import com.yy.hiyo.login.request.udb.UdbDataMapper;
import com.yy.platform.loginlite.AuthCore;
import com.yy.platform.loginlite.HagoInfo;
import com.yy.platform.loginlite.IAuthCore;
import com.yy.platform.loginlite.ICreditLoginCallback;
import com.yy.platform.loginlite.IFindOpenIdCallback;
import com.yy.platform.loginlite.IGetSmsCallback;
import com.yy.platform.loginlite.IGetWhatsappTokenCallback;
import com.yy.platform.loginlite.IGuestLoginCallback;
import com.yy.platform.loginlite.ILog;
import com.yy.platform.loginlite.ILoginliteListener;
import com.yy.platform.loginlite.ISmsLoginCallback;
import com.yy.platform.loginlite.IThirdLoginCallback;
import com.yy.platform.loginlite.NextVerify;
import com.yy.platform.loginlite.ThirdInfo;
import com.yy.platform.loginlite.YYInfo;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UdbLoginManager
implements ILoginRequester,
IPcid {
    private static final String TAG = "UdbLoginManager";
    public static String SDK_TAG = "UdbLoginManager";
    private static final long PRODUCT_APP_ID = 1164671593L;
    private static final long TEST_APP_ID = 1365812526L;
    private static long APP_ID = 1365812526L;
    private static final String ANTI_BIZ_NAME = "hago_andr";
    private static String FIND_OPENID_URL = "https://os-lgn.yy.com/lgn/ws/openid.do";
    private volatile IAuthCore auth = null;
    private static final String KEY_RESPONSE_UUID = "uuid";
    private static final String KEY_RESPONSE_LOGIN_TIMESTAMP = "timestamp";
    private static final String KEY_RESPONSE_LIFECYCLE = "lifecycle";
    private static final String KEY_RESPONSE_S_SESSIONKEY_KEY = "sSessionKey";
    private static final String TOKEN_SPLIT = ",";

    @Override
    public synchronized void syncPcid(String sceneName) {
        UdbLoginManager.getInstance().auth.getRisk().syncPcid(sceneName);
    }

    @Override
    public synchronized String getPcid() {
        return UdbLoginManager.getInstance().auth.getRisk().getPcid();
    }

    private UdbLoginManager() {
    }

    public static UdbLoginManager getInstance() {
        return SingleHolder.INSTANCE.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UdbLoginManager init() {
        if (this.auth != null) {
            return this;
        }
        Class<UdbLoginManager> clazz = UdbLoginManager.class;
        synchronized (UdbLoginManager.class) {
            this.initEnv();
            this.initAuth();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this;
        }
    }

    private void initEnv() {
        EnvSettingType uriSetting = EnvSettings.instance().getUriSettingValue();
        if (uriSetting == EnvSettingType.Product) {
            APP_ID = 1164671593L;
        } else {
            ServiceUrls.setTestUrl((String)"https://lgglobalb-test.yy.com", (String)"https://lgglobal-test.yy.com");
            FIND_OPENID_URL = "https://os-lgn-test.yy.com/lgn/ws/openid.do";
        }
        String configString = SettingFlags.getStringValue((String)"key_udb_hosts", (String)"{}");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("get dynamic host config : " + configString), (Object[])new Object[0]);
        }
        try {
            com.google.gson.JsonParser jsonParser = new com.google.gson.JsonParser();
            JsonObject jo = (JsonObject)jsonParser.parse(configString);
            JsonElement jsonElement = jo.get("useDefault");
            if (jsonElement == null) {
                return;
            }
            boolean useDefault = jsonElement.getAsBoolean();
            JsonArray jsonUrlsArr = jo.getAsJsonArray("urls");
            JsonArray jsonIpsArr = jo.getAsJsonArray("ips");
            Gson googleJson = new Gson();
            Type listType = new TypeToken<List<String>>(){}.getType();
            List urls = (List)googleJson.fromJson((JsonElement)jsonUrlsArr, listType);
            List ips = (List)googleJson.fromJson((JsonElement)jsonIpsArr, listType);
            if (ips != null && ips.size() > 0) {
                ServiceUrls.setRequestHttpIps((List)ips);
            }
            if (urls != null && urls.size() > 0) {
                ServiceUrls.setBizRequestUrls((List)urls, (boolean)useDefault);
                if (uriSetting != EnvSettingType.Product) {
                    ServiceUrls.setTestUrl((String)((String)urls.get(0)), null);
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"get dynamic host config error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void initAuth() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            LoginUtil.INSTANCE.initCountryCodeParam(params);
            this.auth = AuthCore.init((Context)RuntimeContext.sApplicationContext, (String)String.valueOf(APP_ID), (String)"hago", (String)"1", (String)SystemUtils.getLangAndCountryForUdb(), (String)ANTI_BIZ_NAME, (String)this.getDeviceId(), params, (ILog)new ILog(){

                public void i(String tag, String msg) {
                    if (!RuntimeContext.sIsDebuggable) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)tag, (String)msg, (Object[])new Object[0]);
                        }
                    } else if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)UdbLoginManager.TAG, (String)msg, (Object[])new Object[0]);
                    }
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"AuthCore.init error", (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        if (APP_ID == 1164671593L) {
            SDK_TAG = this.auth.getLogTag();
        }
        this.auth.setHiidoMetricsApi(new ILoginliteListener.ILoginliteHiidoMetricsStatisApi(){

            public void reportReturnCode(int scode, String uri, long timeConsumption, String code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SDK_TAG, (String)"report loginlite,uri=%s,rtt=%d,code=%s", (Object[])new Object[]{uri, timeConsumption, code});
                }
                if (!RuntimeContext.sIsDebuggable) {
                    HiidoSDK.instance().reportReturnCode(scode, uri, timeConsumption, code);
                }
            }

            public void reportCount(int scode, String uri, String countName, long count) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SDK_TAG, (String)"report loginlite uri=%s,countName=%s,count=%d", (Object[])new Object[]{uri, countName, count});
                }
                if (!RuntimeContext.sIsDebuggable) {
                    HiidoSDK.instance().reportCount(scode, uri, countName, count);
                }
            }

            public void reportCount(int scode, String uri, String countName, long count, int times) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SDK_TAG, (String)"report loginlite uri=%s,countName=%s,count=%d", (Object[])new Object[]{uri, countName, count});
                }
                if (!RuntimeContext.sIsDebuggable) {
                    HiidoSDK.instance().reportCount(scode, uri, countName, count);
                }
            }

            public void reportStatisticContentTemporary(String act, Map<String, Integer> intFields, Map<String, Long> longFields, Map<String, String> stringFields) {
                StatisContent content = new StatisContent();
                for (Map.Entry<String, Integer> entry : intFields.entrySet()) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SDK_TAG, (String)"report loginlite act=%s,key=%s,int value=%d", (Object[])new Object[]{act, entry.getKey(), entry.getValue()});
                    }
                    content.put(entry.getKey(), entry.getValue().intValue());
                }
                for (Map.Entry<String, Number> entry : longFields.entrySet()) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SDK_TAG, (String)"report loginlite act=%s,key=%s,long value=%d", (Object[])new Object[]{act, entry.getKey(), entry.getValue()});
                    }
                    content.put(entry.getKey(), ((Long)entry.getValue()).longValue());
                }
                for (Map.Entry<String, Object> entry : stringFields.entrySet()) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SDK_TAG, (String)"report loginlite act=%s,key=%s,string value=%s", (Object[])new Object[]{act, entry.getKey(), entry.getValue()});
                    }
                    content.put(entry.getKey(), (String)entry.getValue());
                }
                if (!RuntimeContext.sIsDebuggable) {
                    HiidoSDK.instance().reportStatisticContentTemporary(act, content);
                }
            }
        });
    }

    @Override
    public void queryWhatsAppToken(String whatsAppToken, final IQueryWhatsAppTokenCallback callback) {
        this.init();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"queryWhatsAppToken: whatsAppToken=%s", (Object[])new Object[]{whatsAppToken});
        }
        this.auth.getWhatsappToken("", new IGetWhatsappTokenCallback(){

            public void onSuccess(String token, String context) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"getWhatsappToken success: token=%s, context=%s", (Object[])new Object[]{token, context});
                }
                callback.onSuccess(token);
            }

            public void onFail(int errorCode, String errMsg) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"getWhatsappToken onFail: errorCode=%s, errMsg=%s", (Object[])new Object[]{errorCode, errMsg});
                callback.onError(String.valueOf(errorCode), new Exception(errMsg));
            }
        });
    }

    @Override
    public void requestSmsCode(String phoneNum, String countryCode, String whatsAppToken, final IRequestSmsCodeCallBack callBack) {
        this.init();
        String phoneNumFull = "00" + countryCode + phoneNum;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestVerificationCode: phoneNumFull=%s,countryCode=%s", (Object[])new Object[]{phoneNumFull, countryCode});
        }
        this.auth.getSms(phoneNumFull, "0", "", "", whatsAppToken, new IGetSmsCallback(){

            public void onSuccess(int requestId, boolean isSendToWhatapp) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"getSms success:requestId=%s, isSendToWhatapp=%s", (Object[])new Object[]{requestId, isSendToWhatapp});
                }
                callBack.onSuccess(isSendToWhatapp);
            }

            public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"getSms onNext requestId=%s,authCode=%s, authDesc=%s, dynVerify url= %s", (Object[])new Object[]{requestId, authCode, authDesc, dynVerify.mDynVer});
                }
            }

            public void onFail(int requestId, int codeType, int resCode, String resDesc) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"getSms onFail requestId=%s,codeType=%s, resCode=%s, resDesc= %s", (Object[])new Object[]{requestId, codeType, resCode, resDesc});
                String errorCode = UdbDataMapper.getErrorCode(resCode);
                callBack.onError(errorCode, resDesc);
            }
        });
    }

    @Override
    public void phoneLogin(String phoneNum, final String countryCode, final String smsCheckCode, final ILoginRequestCallBack callBack) {
        this.init();
        final String phoneNumFull = countryCode + phoneNum;
        String phoneNumFullReal = "00" + phoneNumFull;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"loginWithVerificationCode: phoneNumFull= %s, smsCheckCode=%s", (Object[])new Object[]{phoneNumFullReal, smsCheckCode});
        }
        String otpStr = "";
        try {
            if (AccountUtil.isLoginByGuest()) {
                otpStr = new String(this.auth.getOtp("", AccountUtil.getUid()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final long startTime = SystemClock.elapsedRealtime();
        this.auth.smsLogin(phoneNumFullReal, smsCheckCode, "", otpStr, new ISmsLoginCallback(){

            public void onSuccess(int requestId, YYInfo uinfo) {
                boolean result;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"smsLogin success requestId=%s\uff0cuinfo=%s", (Object[])new Object[]{requestId, uinfo});
                }
                PhoneLoginData loginItem = new PhoneLoginData();
                loginItem.phoneNumFull = phoneNumFull;
                loginItem.countryCode = countryCode;
                String sessionSecret = null;
                if (!StringUtils.isEmpty((String)smsCheckCode)) {
                    sessionSecret = SHAUtils.getSHA256((String)smsCheckCode);
                }
                CommonPerfUtils.statUdbLoginEvent((int)4, (boolean)result, (String)((result = UdbLoginManager.this.handleLoginTokenDataInternal((HagoInfo)uinfo, sessionSecret, callBack, false, (LoginData)loginItem)) ? "" : "parse data error"), (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)"0");
            }

            public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"smsLogin onNext requestId=%s,authCode=%s, authDesc=%s, dynVerify url= %s", (Object[])new Object[]{requestId, authCode, authDesc, dynVerify.mDynVer});
                }
            }

            public void onFail(int requestId, int codeType, int resCode, String resDesc) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"smsLogin onFail requestId=%s,codeType=%s, resCode=%s, resDesc= %s", (Object[])new Object[]{requestId, codeType, resCode, resDesc});
                String errorCode = UdbDataMapper.getErrorCode(resCode);
                callBack.onError(errorCode, resDesc, resDesc);
                CommonPerfUtils.statUdbLoginEvent((int)4, (boolean)false, (String)resDesc, (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)String.valueOf(resCode));
            }
        });
    }

    @Override
    public void phoneLogin(String phoneNum, String countryCode, String smsCheckCode, String password, ILoginRequestCallBack callBack) {
        MLog.error((Object)TAG, (String)"loginWithVerificationCode not support", (Object[])new Object[0]);
    }

    @Override
    public void phoneLoginWithHashPwd(String phoneNum, String countryCode, String passwordHash, ILoginRequestCallBack callBack) {
        MLog.error((Object)TAG, (String)"phoneLoginWithHashPwd not support", (Object[])new Object[0]);
    }

    @Override
    public void phoneLoginWithPwd(String phoneNum, String countryCode, String password, ILoginRequestCallBack callBack) {
        MLog.error((Object)TAG, (String)"loginWithPassword not support", (Object[])new Object[0]);
    }

    @Override
    public void setLoginPassword(String smsCheckCode, String password, ILoginRequestCallBack callBack) {
        MLog.error((Object)TAG, (String)"setLoginPassword not support", (Object[])new Object[0]);
    }

    @Override
    public void resetLoginPassword(String originPwd, String newPwd, ILoginRequestCallBack callBack) {
        MLog.error((Object)TAG, (String)"resetLoginPassword not support", (Object[])new Object[0]);
    }

    @Override
    public void refreshAccountToken(long uuid, String token, final String sessionKey, final ILoginRequestCallBack callBack) {
        this.init();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"refreshAccountToken: uuid=%s , token= %s", (Object[])new Object[]{uuid, token});
        }
        this.auth.creditLogin(uuid, token, new ICreditLoginCallback(){

            public void onSuccess(int requestId, YYInfo uinfo) {
                boolean result;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"refreshAccountToken onSuccess requestId=%s, uinfo= %s", (Object[])new Object[]{requestId, uinfo});
                }
                CommonPerfUtils.statUdbLoginEvent((int)3, (boolean)result, (String)((result = UdbLoginManager.this.handleLoginTokenDataInternal((HagoInfo)uinfo, sessionKey, callBack, false, null)) ? "" : "parse data error"), (int)-1, (String)"0");
            }

            public void onNext(int requestId, NextVerify dynVerify) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"refreshAccountToken onNext requestId=%s, dynVerify url= %s", (Object[])new Object[]{requestId, dynVerify.mDynVer});
                }
            }

            public void onFail(int requestId, int codeType, int resCode, String resDesc) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"refreshAccountToken onFail requestId=%s,codeType=%s, resCode=%s, resDesc= %s", (Object[])new Object[]{requestId, codeType, resCode, resDesc});
                String errorCode = UdbDataMapper.getErrorCode(resCode);
                callBack.onError(errorCode, resDesc, resDesc);
                CommonPerfUtils.statUdbLoginEvent((int)3, (boolean)false, (String)resDesc, (int)-1, (String)String.valueOf(resCode));
            }
        });
    }

    @Override
    public void loginWithThirdParty(int platformId, String appIdFromPlatform, String token, String userId, String mail, ILoginRequestCallBack callBack) {
        this.loginWithThirdParty(platformId, appIdFromPlatform, token, null, userId, mail, callBack);
    }

    @Override
    public void loginWithThirdParty(int platformId, String appIdFromPlatform, String accessToken, String idToken, String userId, String mail, final ILoginRequestCallBack callBack) {
        this.init();
        CommonPerfUtils.statThirdpartyLoginStartEvent((int)10, (boolean)true);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"loginWithThirdParty...", (Object[])new Object[0]);
        }
        String channel = UdbDataMapper.getChannel(platformId);
        String channelAppId = UdbDataMapper.getChannelAppId(platformId);
        String token = accessToken;
        int tokenType = 1;
        if (StringUtils.isNotEmpty((String)idToken)) {
            token = idToken;
            tokenType = 3;
        }
        final String sessionSecret = SHAUtils.getSHA256((String)userId);
        final long startTime = SystemClock.elapsedRealtime();
        this.auth.thirdLogin(channel, token, tokenType, userId, "", "{\"thirdAppid\":\"" + channelAppId + "\"}", new IThirdLoginCallback(){

            public void onSuccess(int requestId, ThirdInfo thirdInfo) {
                boolean result;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"loginWithThirdParty onSuccess requestId=%s, thirdInfo= %s", (Object[])new Object[]{requestId, thirdInfo});
                }
                CommonPerfUtils.statUdbLoginEvent((int)1, (boolean)result, (String)((result = UdbLoginManager.this.handleLoginTokenDataInternal((HagoInfo)thirdInfo, sessionSecret, callBack, false, null)) ? "" : "parse data error"), (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)"114");
            }

            public void onFail(int requestId, int codeType, int resCode, String resDesc) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"loginWithThirdParty onFail requestId=%s,codeType=%s, resCode=%s, resDesc= %s", (Object[])new Object[]{requestId, codeType, resCode, resDesc});
                String errorCode = UdbDataMapper.getErrorCode(resCode);
                callBack.onError(errorCode, resDesc, resDesc);
                CommonPerfUtils.statUdbLoginEvent((int)1, (boolean)false, (String)resDesc, (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)String.valueOf(resCode));
            }
        });
    }

    @Override
    public void bingThirdParty(AccountInfo accountInfo, int platformId, String appIdFromPlatform, String token, String userId, String mail, final ILoginRequestCallBack callBack) {
        this.init();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"bingThirdParty... platformId=%s , appIdFromPlatform=%s, userId=%s", (Object[])new Object[]{platformId, appIdFromPlatform, userId});
        }
        String channel = UdbDataMapper.getChannel(platformId);
        String channelAppId = UdbDataMapper.getChannelAppId(platformId);
        int tokenType = 1;
        if (StringUtils.equal((String)"google", (String)channel)) {
            tokenType = 3;
        }
        final String sessionSecret = SHAUtils.getSHA256((String)userId);
        String otpStr = "";
        try {
            otpStr = new String(this.auth.getOtp("", AccountUtil.getUid()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.auth.bindThirdToken(channel, token, tokenType, userId, String.valueOf(AccountUtil.getUid()), otpStr, "", "{\"thirdAppid\":\"" + channelAppId + "\"}", new IThirdLoginCallback(){

            public void onSuccess(int requestId, ThirdInfo thirdInfo) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"bingThirdParty onSuccess requestId=%s, thirdInfo= %s", (Object[])new Object[]{requestId, thirdInfo});
                }
                UdbLoginManager.this.handleLoginTokenDataInternal((HagoInfo)thirdInfo, sessionSecret, callBack, false, null);
            }

            public void onFail(int requestId, int codeType, int resCode, String resDesc) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"bingThirdParty onFail requestId=%s,codeType=%s, resCode=%s, resDesc= %s", (Object[])new Object[]{requestId, codeType, resCode, resDesc});
                String errorCode = UdbDataMapper.getErrorCode(resCode);
                callBack.onError(errorCode, resDesc, resDesc);
            }
        });
    }

    @Override
    public void loginGuest(final ILoginRequestCallBack callBack) {
        this.init();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"loginGuest...", (Object[])new Object[0]);
        }
        final String sessionSecret = SHAUtils.getSHA256((String)this.getDeviceId());
        final long startTime = SystemClock.elapsedRealtime();
        this.auth.guestLogin("", new IGuestLoginCallback(){

            public void onSuccess(int requestId, YYInfo uinfo) {
                boolean result;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"guestLogin onSuccess, requestId=%s, uinfo=%s", (Object[])new Object[]{requestId, uinfo});
                }
                CommonPerfUtils.statUdbLoginEvent((int)2, (boolean)result, (String)((result = UdbLoginManager.this.handleLoginTokenDataInternal((HagoInfo)uinfo, sessionSecret, callBack, true, null)) ? "" : "parse data error"), (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)"0");
            }

            public void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"guestLogin onNext, requestId=%s, authCode=%s, authDesc=%s, dynVerify url=%s", (Object[])new Object[]{requestId, authCode, authDesc, dynVerify.mDynVer});
                }
            }

            public void onFail(int requestId, int codeType, int resCode, String resDesc) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"guestLogin onFail, requestId=%s, codeType=%s, resCode=%s, resDesc=%s", (Object[])new Object[]{requestId, codeType, resCode, resDesc});
                String errorCode = UdbDataMapper.getErrorCode(resCode);
                callBack.onError(errorCode, resDesc, resDesc);
                CommonPerfUtils.statUdbLoginEvent((int)2, (boolean)false, (String)resDesc, (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)String.valueOf(resCode));
            }
        });
    }

    @Override
    public void queryThirdParty(AccountInfo accountInfo, final IQueryThirdPartyAccountCallBack callBack) {
        this.init();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"queryThirdParty...  uuid=%s ", (Object[])new Object[]{accountInfo.uuid});
        }
        byte[] otp = this.auth.getOtp("", accountInfo.uuid);
        this.auth.findOpenId(FIND_OPENID_URL, APP_ID, accountInfo.uuid, otp, new IFindOpenIdCallback(){

            public void onSuccess(int requestId, String json) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)UdbLoginManager.TAG, (String)"findOpenId onSuccess, requestId=%s , result=%s", (Object[])new Object[]{requestId, json});
                }
                UdbLoginManager.this.handleQueryThirdPartyAccountCallBack(json, callBack);
            }

            public void onFail(int requestId, String code, String msg) {
                MLog.error((Object)UdbLoginManager.TAG, (String)"findOpenId onFail, requestId=%s , code=%s, msg=%s", (Object[])new Object[]{requestId, code, msg});
                callBack.onError(code, new Exception(msg));
            }
        });
    }

    @Override
    public void reportLocation(String location, String longitude, String latitude, OnReportCallback callback) {
        LoginRequestManager.getInstance().reportLocation(location, longitude, latitude, callback);
    }

    @Override
    public void reportAnti(String anti, AccountInfo accountInfo, IReportAntiCallBack callBack) {
        LoginRequestManager.getInstance().reportAnti(anti, accountInfo, callBack);
    }

    private boolean handleLoginTokenDataInternal(HagoInfo uinfo, String sessionSecret, ILoginRequestCallBack callBack, boolean guest, LoginData originLoginItem) {
        LoginData loginItem = originLoginItem;
        if (loginItem == null) {
            loginItem = new LoginData();
        }
        String sSession = uinfo.session;
        String st = uinfo.st;
        if (!StringUtils.isEmpty((String)sSession) && !StringUtils.isEmpty((String)st)) {
            this.parseHostInfo(uinfo);
            long timestamp = loginItem.localTimestamp = System.currentTimeMillis();
            long uuid = -1L;
            long lifecycle = -1L;
            String sSessionKey = "";
            String loginToken = "";
            String sSessionDecode = null;
            if (!StringUtils.isEmpty((String)sessionSecret)) {
                try {
                    sSessionDecode = DES3Utils.decrypt((String)sSession, (String)sessionSecret);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            }
            if (!StringUtils.isEmpty(sSessionDecode)) {
                try {
                    JSONObject loginData = JsonParser.obtainJSONObject((String)sSessionDecode);
                    uuid = loginData.optLong(KEY_RESPONSE_UUID, -1L);
                    sSessionKey = loginData.optString(KEY_RESPONSE_S_SESSIONKEY_KEY);
                    lifecycle = StringUtils.parseLong((String)loginData.optString(KEY_RESPONSE_LIFECYCLE), (long)-1L);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                    callBack.onError("112", null, null);
                    return false;
                }
                if (uuid > 0L) {
                    JSONObject tokenJoson = JsonParser.obtainJSONObject();
                    try {
                        tokenJoson.put(KEY_RESPONSE_UUID, uuid);
                        tokenJoson.put(KEY_RESPONSE_LOGIN_TIMESTAMP, timestamp);
                        String clientJosn = tokenJoson.toString();
                        String clientToken = DES3Utils.encrypt((String)clientJosn, (String)sSessionKey);
                        if (StringUtils.isNotEmpty((String)clientJosn) && StringUtils.isNotEmpty((String)clientToken)) {
                            loginToken = URLEncoder.encode(clientToken + TOKEN_SPLIT + st, "UTF-8");
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, (Throwable)e);
                        callBack.onError("112", null, null);
                        return false;
                    }
                }
            }
            loginItem.uuid = uuid;
            loginItem.lifecycle = lifecycle;
            loginItem.loginToken = loginToken;
            loginItem.sessionKey = sSessionKey;
            loginItem.guest = guest;
            loginItem.registerCountry = uinfo.registerCountry;
            loginItem.realCountry = uinfo.realCountry;
            if (uinfo instanceof YYInfo) {
                loginItem.auth_app = ((YYInfo)uinfo).isAuthed;
                loginItem.resultType = ((YYInfo)uinfo).mIsNewUser ? 2 : 1;
                loginItem.credit = ((YYInfo)uinfo).mCredit;
            }
            if (uinfo instanceof ThirdInfo) {
                loginItem.auth_app = ((ThirdInfo)uinfo).isAuthed;
                loginItem.resultType = ((ThirdInfo)uinfo).mIsNewUser ? 2 : 1;
                loginItem.credit = ((ThirdInfo)uinfo).mCredit;
                try {
                    String thirdInfoJson = ((ThirdInfo)uinfo).mThirdInfo;
                    JSONObject thirdInfo = JsonParser.obtainJSONObject((String)thirdInfoJson);
                    String nickname = thirdInfo.optString("nickname", "");
                    String avatar = thirdInfo.optString("avatar", "");
                    String birthday = thirdInfo.optString("birthday", "");
                    String sex = thirdInfo.optString("sex", "");
                    loginItem.nick = nickname;
                    loginItem.avatar = avatar;
                    loginItem.birthday = birthday;
                    if (StringUtils.equal((String)sex, (String)"\u7537")) {
                        loginItem.sex = 1;
                    } else if (StringUtils.equal((String)sex, (String)"\u5973")) {
                        loginItem.sex = 0;
                    }
                }
                catch (JSONException e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            }
            if (!loginItem.isValid()) {
                callBack.onError("114", null, null);
                return false;
            }
            callBack.onSuccess(loginItem);
            return true;
        }
        callBack.onError("113", null, null);
        return false;
    }

    private void handleQueryThirdPartyAccountCallBack(String response, IQueryThirdPartyAccountCallBack callBack) {
        String resultCode = null;
        String resultDescrip = null;
        JSONArray bindInfo = null;
        SparseArray items = new SparseArray(1);
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)response);
            if (jsonObject.has("rescode")) {
                resultCode = jsonObject.getString("rescode");
            }
            if (jsonObject.has("resmsg")) {
                resultDescrip = jsonObject.getString("resmsg");
            }
            if (jsonObject.has("data")) {
                bindInfo = jsonObject.optJSONArray("data");
            }
            if (bindInfo != null) {
                JSONObject itemJson = null;
                int size = bindInfo.length();
                int openSource = -1;
                String userId = "";
                for (int i = 0; i < size; ++i) {
                    itemJson = bindInfo.optJSONObject(i);
                    if (itemJson == null || !itemJson.has("channel")) continue;
                    String channel = itemJson.getString("channel");
                    openSource = UdbDataMapper.getPlatformId(channel);
                    if (!itemJson.has("openid") || !StringUtils.isNotEmpty((String)(userId = itemJson.getString("openid")))) continue;
                    items.put(openSource, (Object)userId);
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            resultCode = "112";
            resultDescrip = null;
        }
        if (resultCode != null && (resultCode.equals("0") || resultCode.equals("-9"))) {
            if (callBack != null) {
                callBack.onSuccess((SparseArray<String>)items);
            }
        } else {
            if (callBack != null) {
                callBack.onError(resultCode, new Exception(resultDescrip));
            }
            MLog.error((Object)TAG, (String)"handleQueryThirdPartyAccountCallBack %s, %s ", (Object[])new Object[]{resultCode, resultDescrip});
        }
    }

    private String getDeviceId() {
        return HiidoUtils.getHdid();
    }

    private void parseHostInfo(HagoInfo uinfo) {
        String localHost = uinfo.localHost;
        String preRegisterHost = uinfo.cproxyHost;
        String registerHost = uinfo.registerHost;
        String lcid = uinfo.lcid;
        if (StringUtils.isNotEmpty((String)lcid)) {
            SettingFlags.setStringValue((String)"lcid", (String)lcid);
        }
        String webgameHost = uinfo.gameHost;
        String turnoverHost = uinfo.turnoverHost;
        int idc = 0;
        try {
            idc = Integer.parseInt(uinfo.registerIdc);
        }
        catch (NumberFormatException e) {
            MLog.error((Object)TAG, (String)"parse registerIdc error", (Throwable)e, (Object[])new Object[0]);
        }
        LoginRequestManager.updateUrl(localHost, preRegisterHost, registerHost, idc, webgameHost, turnoverHost);
    }

    private static final class SingleHolder {
        private static final UdbLoginManager INSTANCE = new UdbLoginManager();

        private SingleHolder() {
        }
    }
}

