/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.relogin;

import android.content.DialogInterface;
import android.os.SystemClock;
import com.yy.appbase.abtest.StartABTestUtil;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountListManager;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IAutoReloginCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.request.ILoginRequestCallBack;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class AccountSilentReloginController
extends AbstractLoginer {
    private static int sSwitchOn = -1;
    private int loginIndex;
    private static int sIndex = 1;
    private int mLoginOutBy;
    private AccountInfo needReLoginWhenToForeground;

    public AccountSilentReloginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 11);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
    }

    public void handleAutoRelogin(final IAutoReloginCallBack callBack) {
        if (!AccountSilentReloginController.openAutoRelogin()) {
            callBack.onNoAccountToRelogin();
            return;
        }
        final long needReloginUid = AccountModel.getInstance().getAutoReloginAccountId();
        if (needReloginUid <= 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"AccountSlientRelogin", (String)"needReloginUid invalid", (Object[])new Object[0]);
            }
            callBack.onNoAccountToRelogin();
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"AccountSlientRelogin", (String)"needReloginUid:%s", (Object[])new Object[]{String.valueOf(needReloginUid)});
        }
        AccountModel.getInstance().getAccountsHasLogined(new AccountListManager.IObtainCallBack(){

            public void onCallBackOnUiThread(List<AccountInfo> list) {
                if (list == null || list.size() <= 0) {
                    callBack.onNoAccountToRelogin();
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AccountSlientRelogin", (String)"AccountsHasLogined is empty!", (Object[])new Object[0]);
                    }
                    return;
                }
                final MyAutoReloginCallBack myAutoReloginCallBack = new MyAutoReloginCallBack(callBack);
                for (AccountInfo info : list) {
                    if (info == null || info.uuid != needReloginUid || !AccountSilentReloginController.this.isAccountValid(info)) continue;
                    callBack.onReloginStart();
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)"AccountSlientRelogin", (String)"relogin timeout!", (Object[])new Object[0]);
                            }
                            myAutoReloginCallBack.timeOut = true;
                            myAutoReloginCallBack.onReloginTimeout();
                        }
                    }, (long)15000L);
                    AccountSilentReloginController.this.loginBy(info, true, myAutoReloginCallBack);
                    return;
                }
                callBack.onNoAccountToRelogin();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AccountSlientRelogin", (String)"needreloginuid in accountsHasLogined:%d not find!", (Object[])new Object[]{list.size()});
                }
            }
        });
    }

    public boolean handleKickOffByOurApp(AccountInfo curKickOffAccountInfo) {
        if (!AccountSilentReloginController.openAutoRelogin()) {
            return false;
        }
        if (!this.isAccountValid(curKickOffAccountInfo) || !RuntimeContext.sIsAppStartFinished) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"AccountSlientRelogin", (String)"handleKickOffByOurApp not handled", (Object[])new Object[0]);
            }
            this.needReLoginWhenToForeground = null;
            return false;
        }
        if (RuntimeContext.sIsForeground) {
            this.needReLoginWhenToForeground = null;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"AccountSlientRelogin", (String)"showLoginOutByOurOtherApp dialog:%s!", (Object[])new Object[]{String.valueOf(curKickOffAccountInfo.uuid)});
            }
            this.showLoginOutByOurOtherApp(curKickOffAccountInfo);
        } else {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"AccountSlientRelogin", (String)"handleKickOffByOurApp is background:%s!", (Object[])new Object[]{String.valueOf(curKickOffAccountInfo.uuid)});
            }
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "preempt_login").put("foreground", "2"));
            this.needReLoginWhenToForeground = curKickOffAccountInfo;
            AccountModel.getInstance().setAutoReloginAccountId(this.needReLoginWhenToForeground.uuid);
        }
        return true;
    }

    public void updateLoginOutBy(int loginOutBy) {
        this.mLoginOutBy = loginOutBy;
        if (this.mLoginOutBy != 9) {
            this.needReLoginWhenToForeground = null;
            AccountModel.getInstance().setAutoReloginAccountId(-1L);
            this.loginIndex = -1;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"AccountSlientRelogin", (String)"updateLoginOutBy:%d!", (Object[])new Object[]{loginOutBy});
        }
    }

    private boolean showLoginOutByOurOtherApp(final AccountInfo accountInfo) {
        HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "temporary_offline"));
        OkCancelDialog dialog = new OkCancelDialog(new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.login_out_tips_by_ourapp_kick)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.login_again_with_this_account)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_cancel)).cancelable(true).outSideCancelable(false).withCloseBtn(true).listener(new OkCancelDialogListener(){

            public void onClose() {
                MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_OUT, 10, -1, null);
                HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "temporary_cancel"));
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AccountSlientRelogin", (String)"LoginOutByOurOtherApp dialog onClose!", (Object[])new Object[0]);
                }
            }

            public void onCancel() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AccountSlientRelogin", (String)"LoginOutByOurOtherApp dialog onCancel!", (Object[])new Object[0]);
                }
                MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_OUT, 10, -1, null);
                HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "temporary_cancel"));
            }

            public void onOk() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AccountSlientRelogin", (String)"LoginOutByOurOtherApp dialog onOk!", (Object[])new Object[0]);
                }
                AccountSilentReloginController.this.loginBy(accountInfo, false, null);
                HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "temporary_login"));
            }
        }));
        dialog.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_OUT, 10, -1, null);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AccountSlientRelogin", (String)"LoginOutByOurOtherApp dialog onCancel!", (Object[])new Object[0]);
                }
            }
        });
        this.getDialogLinkManager().showDialog((BaseDialog)dialog);
        return true;
    }

    @Override
    public void openLoginWindow() {
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        if (callBack != null) {
            callBack.onError("", "");
        }
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (!AccountSilentReloginController.openAutoRelogin()) {
            return;
        }
        if (NotificationDef.N_LOGIN_SUCCESS == notification.id || NotificationDef.N_LOGIN_LOGIN_OUT == notification.id) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"AccountSlientRelogin", (String)"receive loginOut or loginSuccess!", (Object[])new Object[0]);
            }
        } else if (NotificationDef.N_FOREGROUND_CHANGE == notification.id && ((Boolean)notification.extObj).booleanValue() && this.needReLoginWhenToForeground != null) {
            final long lastUid = this.needReLoginWhenToForeground.uuid;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"AccountSlientRelogin", (String)"change to foreGround:%s!", (Object[])new Object[]{String.valueOf(lastUid)});
            }
            this.loginBy(this.needReLoginWhenToForeground, true, new IAutoReloginCallBack(){

                public void onReloginStart() {
                }

                public void onReloginSuccess() {
                }

                public void onReloginError() {
                    if (AccountSilentReloginController.this.needReLoginWhenToForeground == null || lastUid != ((AccountSilentReloginController)AccountSilentReloginController.this).needReLoginWhenToForeground.uuid) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"AccountSlientRelogin", (String)"change to foreGround, relogin error and lastuid invalid:%s!", (Object[])new Object[]{String.valueOf(lastUid)});
                        }
                        return;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AccountSlientRelogin", (String)"change to foreGround, relogin error:%s!", (Object[])new Object[]{String.valueOf(lastUid)});
                    }
                    MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_OUT, 11, -1, null);
                }

                public void onReloginTimeout() {
                }

                public void onNoAccountToRelogin() {
                }
            });
        }
    }

    private boolean isAccountValid(AccountInfo accountInfo) {
        return AccountModel.getInstance().isAccountValidIncludeToken(accountInfo) && StringUtils.isNotEmpty((String)accountInfo.sessionKey);
    }

    private void loginBy(final AccountInfo accountInfo, final boolean slient, final IAutoReloginCallBack callBack) {
        final int thisLoginIndex = this.loginIndex = sIndex++;
        this.mLoginCallBack.onLoginStart(this, slient);
        HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "silent_relogin"));
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"AccountSlientRelogin", (String)"relogin start!", (Object[])new Object[0]);
        }
        final long startTime = SystemClock.uptimeMillis();
        this.mLoginCallBack.getLoginRequester().refreshAccountToken(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey, new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AccountSlientRelogin", (String)"slient login success %s!", (Object[])new Object[]{data != null ? data : ""});
                }
                if (data != null && thisLoginIndex == AccountSilentReloginController.this.loginIndex) {
                    AccountInfo account = AccountInfo.obtain((LoginData)data);
                    account.loginType = accountInfo.loginType;
                    account.resultType = 1;
                    AccountSilentReloginController.this.mLoginCallBack.onLoginSuccess(AccountSilentReloginController.this, account);
                    HiidoStatis.reportAppMonitorReturnCode((String)"hylogin/accouttoken_slient", (long)(SystemClock.uptimeMillis() - startTime), (String)"0");
                    if (callBack != null) {
                        callBack.onReloginSuccess();
                    }
                } else {
                    if (thisLoginIndex != AccountSilentReloginController.this.loginIndex) {
                        MLog.error((Object)"AccountSlientRelogin", (String)"slient login success, but this login isinvalid %s!", (Object[])new Object[]{String.valueOf(AccountUtil.getUid())});
                    }
                    AccountSilentReloginController.this.mLoginCallBack.onLoginError(AccountSilentReloginController.this, true, "loginData null", "");
                    if (!slient) {
                        MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_OUT, 11, -1, null);
                    }
                    HiidoStatis.reportAppMonitorReturnCode((String)"hylogin/accouttoken_slient", (long)(SystemClock.uptimeMillis() - startTime), (String)"10000");
                    if (callBack != null) {
                        callBack.onReloginError();
                    }
                }
                AccountSilentReloginController.this.loginIndex = -1;
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                if (thisLoginIndex != AccountSilentReloginController.this.loginIndex) {
                    MLog.error((Object)"AccountSlientRelogin", (String)"onError but this login invalid", (Object[])new Object[0]);
                }
                HiidoStatis.reportAppMonitorReturnCode((String)"hylogin/accouttoken_slient", (long)(SystemClock.uptimeMillis() - startTime), (String)errorCode);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"AccountSlientRelogin", (String)"slient login error:errorCode %s errorDescription:%s exceptionDue\uff1a%s!", (Object[])new Object[]{errorCode, errorDescription, exceptionDue});
                }
                AccountSilentReloginController.this.mLoginCallBack.onLoginError(AccountSilentReloginController.this, true, errorCode, errorDescription + exceptionDue);
                if (!slient) {
                    MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_OUT, 11, -1, null);
                }
                AccountSilentReloginController.this.loginIndex = -1;
                if (callBack != null) {
                    callBack.onReloginError();
                }
            }
        });
    }

    private static boolean openAutoRelogin() {
        if (sSwitchOn == -1) {
            if (!StartABTestUtil.INSTANCE.isStartTest()) {
                sIndex = 1;
            } else {
                sSwitchOn = SettingFlags.getBoolean((String)"key_multi_app_account_auto_relogin", (boolean)true) ? 1 : 0;
            }
        }
        return sSwitchOn == 1;
    }

    private class MyAutoReloginCallBack
    implements IAutoReloginCallBack {
        private IAutoReloginCallBack mAutoReloginCallBack;
        boolean timeOut = false;

        MyAutoReloginCallBack(IAutoReloginCallBack callBack) {
            this.mAutoReloginCallBack = callBack;
        }

        public void onReloginSuccess() {
            if (this.timeOut) {
                return;
            }
            this.mAutoReloginCallBack.onReloginSuccess();
        }

        public void onReloginError() {
            if (this.timeOut) {
                return;
            }
            this.mAutoReloginCallBack.onReloginError();
        }

        public void onReloginTimeout() {
            this.mAutoReloginCallBack.onReloginTimeout();
        }

        public void onNoAccountToRelogin() {
            if (this.timeOut) {
                return;
            }
            this.mAutoReloginCallBack.onNoAccountToRelogin();
        }

        public void onReloginStart() {
        }
    }
}

