/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone.windows;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.TranslateAnimation;

public class SplashLightAnim {
    private View mLightView;
    private int mAnimWidth;
    private TranslateAnimation mLightAnim;
    private long mDuration = 500L;
    private long mDelay = 1000L;

    public static SplashLightAnim of(View lightView, int animWidth, long delay) {
        SplashLightAnim anim2 = new SplashLightAnim();
        anim2.mLightView = lightView;
        anim2.mAnimWidth = animWidth;
        anim2.mDelay = delay;
        return anim2;
    }

    public void start() {
        this.startInner();
    }

    private void startInner() {
        if (this.mLightAnim == null) {
            this.mLightView.setVisibility(0);
            this.mLightAnim = new TranslateAnimation((float)(-this.mLightView.getMeasuredWidth()), (float)(this.mAnimWidth + this.mLightView.getMeasuredWidth()), 0.0f, 0.0f);
            this.mLightAnim.setFillAfter(false);
            this.mLightAnim.setRepeatCount(-1);
            this.mLightAnim.setDuration(this.mDuration);
            this.mLightAnim.setStartOffset(1000L);
            this.mLightView.startAnimation((Animation)this.mLightAnim);
            this.mLightAnim.setStartTime(AnimationUtils.currentAnimationTimeMillis() + this.mDelay);
        }
    }

    public void stop() {
        this.mLightView.setVisibility(8);
        if (this.mLightAnim != null) {
            this.mLightAnim.cancel();
            this.mLightAnim = null;
        }
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }
}

