/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.language;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.hiyo.login.R;
import com.yy.hiyo.mvp.base.ICustomView;

public class SelectLanguageView
extends YYLinearLayout
implements ICustomView {
    private OnLanguageSelectListener mLanguageSelectListener;

    public SelectLanguageView(Context context) {
        super(context);
        this.createView(null);
    }

    public SelectLanguageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public SelectLanguageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(attrs);
    }

    public void createView(@Nullable AttributeSet attrs) {
        SelectLanguageView.inflate((Context)this.getContext(), (int)R.layout.login_select_lanague, (ViewGroup)this);
        this.setOrientation(1);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        RadioGroup radioGroup = (RadioGroup)this.findViewById(R.id.radio_group);
        if (LanguageUtils.isHindi()) {
            radioGroup.check(R.id.lang_hindi);
        } else if (LanguageUtils.isEnglish()) {
            radioGroup.check(R.id.lang_en);
        }
        radioGroup.setOnCheckedChangeListener((group, checkedId) -> {
            if (checkedId == R.id.lang_en) {
                this.mLanguageSelectListener.onLanguageSelected(LanguageType.EN);
            } else if (checkedId == R.id.lang_hindi) {
                this.mLanguageSelectListener.onLanguageSelected(LanguageType.HINDI);
            }
        });
    }

    public void setLanguageSelectListener(OnLanguageSelectListener languageSelectListener) {
        this.mLanguageSelectListener = languageSelectListener;
    }

    public static enum LanguageType {
        EN("en"),
        HINDI("hi");

        private String lang;

        private LanguageType(String lang) {
            this.lang = lang;
        }

        public String getLanguage() {
            return this.lang;
        }
    }

    public static interface OnLanguageSelectListener {
        public void onLanguageSelected(LanguageType var1);
    }
}

