/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.guest;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.account.LoginType;
import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.base.IGuestLoginChangedCallback;
import com.yy.hiyo.login.base.ILoginWindowFinish;
import com.yy.hiyo.login.base.LoginGuideDialogCallback;
import com.yy.hiyo.login.guest.LoginGuideDialog;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class LoginGuideDialogController
extends DefaultController {
    private static String TAG = "LoginGuideDialogController";
    private String mGid;
    protected boolean isLogining = false;
    private int fromType = 6;
    private LoginGuideDialogCallback loginGuideDialogCallback;
    private LoginCallback mLoginCallback;
    @SuppressLint(value={"WrongConstant"})
    private LoginGuideDialog mLoginGuideDialog = new LoginGuideDialog(new LoginGuideDialog.LoginGuideCallback(){

        @Override
        public void onClickClose() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onLoginFacebook", (Object[])new Object[0]);
            }
            LoginGuideDialogController.this.hideLoginGuide();
            if (LoginGuideDialogController.this.loginGuideDialogCallback != null) {
                LoginGuideDialogController.this.loginGuideDialogCallback.onCancel();
            }
        }

        @Override
        public void onLogin(int type) {
            LoginGuideDialogController.this.hideLoginGuide();
            Message msg = Message.obtain();
            Bundle bundle = LoginGuideDialogController.this.generateLoginBundle();
            bundle.putInt("key_login_type", type);
            if (LoginGuideDialogController.this.fromType == 5 || LoginGuideDialogController.this.fromType == 4) {
                bundle.putString("gid", LoginGuideDialogController.this.mGid);
            }
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            msg.obj = LoginGuideDialogController.this.mLoginCallback;
            msg.arg1 = 4;
            msg.arg2 = type;
            msg.setData(bundle);
            LoginGuideDialogController.this.sendMessage(msg);
            LoginGuideDialogController.this.reportHiidoLoginOther(LoginType.getReportName((int)type) + "_login");
        }

        @Override
        public void onLoginOther() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onLoginOther", (Object[])new Object[0]);
            }
            LoginGuideDialogController.this.onSelectedOther();
            LoginGuideDialogController.this.hideLoginGuide();
            LoginGuideDialogController.this.reportHiidoLoginOther("other_way");
            Message msg = Message.obtain();
            msg.what = LoginMsgDef.MSG_LOGIN_OPEN_WINDOW;
            msg.obj = LoginGuideDialogController.this.mLoginCallback;
            msg.setData(LoginGuideDialogController.this.generateLoginBundle());
            LoginGuideDialogController.this.sendMessage(msg);
        }
    });

    public LoginGuideDialogController(Environment env) {
        super(env);
        this.registerMessage(BaseMsgDef.MSG_HIDE_LOGIN_GUIDE_DIALOG);
        this.mLoginCallback = new LoginCallback();
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.MSG_SHOW_LOGIN_GUIDE_DIALOG) {
            if (msg.obj instanceof LoginGuideDialogCallback) {
                this.loginGuideDialogCallback = (LoginGuideDialogCallback)msg.obj;
            }
            if (msg.getData() != null) {
                Bundle bundle = msg.getData();
                if (bundle.containsKey("gid")) {
                    this.mGid = bundle.getString("gid");
                }
                if (bundle.containsKey("type_from_key")) {
                    this.fromType = bundle.getInt("type_from_key");
                    this.mLoginGuideDialog.setLoginTipFromType(this.fromType);
                } else if (bundle.containsKey("login_tips") && bundle.containsKey("login_icon_url")) {
                    this.mLoginGuideDialog.setLoginTips(bundle.getString("login_tips"), bundle.getString("login_icon_url"));
                }
            }
            this.showLoginGuide();
        } else if (msg.what == BaseMsgDef.MSG_HIDE_LOGIN_GUIDE_DIALOG) {
            this.hideLoginGuide();
        }
    }

    private Bundle generateLoginBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt("key_login_source", 1);
        bundle.putInt("key_guest_window_type", this.fromType);
        return bundle;
    }

    private void closePage() {
        if (this.fromType == 2) {
            this.sendMessage(BaseMsgDef.CLOSE_CHAT_SESSION_PAGE);
        } else if (this.fromType == 0) {
            this.sendMessage(BaseMsgDef.CLOSE_WINDOW_PROFILE);
        } else if (this.fromType == 8) {
            this.sendMessage(BaseMsgDef.IM_ROOM_HIDE);
        }
    }

    private void reportHiidoLoginOther(String otherWay) {
        if (this.fromType == 1) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025097").put("function_id", otherWay).put("login_location", "3"));
        } else if (this.fromType == 2) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025097").put("function_id", otherWay).put("login_location", "2"));
        } else if (this.fromType == 0) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025097").put("function_id", otherWay).put("login_location", "1"));
        }
    }

    protected void onLoginFinish() {
        this.updateLoading(false);
        if (this.checkIsRecharge()) {
            this.loginGuideDialogCallback.onLoginFinished();
        }
    }

    private boolean checkIsRecharge() {
        return (this.fromType == 5 || this.fromType == 4) && this.loginGuideDialogCallback != null;
    }

    private void updateLoading(boolean logining) {
        this.isLogining = logining;
        if (this.checkIsRecharge()) {
            this.loginGuideDialogCallback.onLoadingChange(this.isLogining);
        }
    }

    protected void onSelectedOther() {
        if (this.checkIsRecharge()) {
            this.loginGuideDialogCallback.onSelectOther();
        }
    }

    protected void hideLoginGuide() {
        this.updateLoading(false);
        this.mDialogLinkManager.dismissDialog();
    }

    protected void showLoginGuide() {
        this.updateLoading(true);
        this.mDialogLinkManager.showDialog((BaseDialog)this.mLoginGuideDialog);
        this.reportHiidoLoginOther("show");
    }

    private class LoginCallback
    implements ILoginWindowFinish,
    IGuestLoginChangedCallback {
        private LoginCallback() {
        }

        public void onSuccess() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"mGuestLoginChangedCallback onSuccess", (Object[])new Object[0]);
            }
            LoginGuideDialogController.this.closePage();
            LoginGuideDialogController.this.reportHiidoLoginOther("facebook_login_success");
            if (LoginGuideDialogController.this.loginGuideDialogCallback != null) {
                LoginGuideDialogController.this.loginGuideDialogCallback.onSuccess();
            }
        }

        public void onCancel() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"mGuestLoginChangedCallback onCancel", (Object[])new Object[0]);
            }
            if (LoginGuideDialogController.this.loginGuideDialogCallback != null) {
                LoginGuideDialogController.this.loginGuideDialogCallback.onCancel();
            }
        }

        public void onError(String errorCode, String des) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"mGuestLoginChangedCallback onError errorCode=%s, des=%s", (Object[])new Object[]{errorCode, des});
            }
            if (LoginGuideDialogController.this.loginGuideDialogCallback != null) {
                LoginGuideDialogController.this.loginGuideDialogCallback.onError(errorCode, des);
            }
        }

        public void onLoginWindowFinish() {
        }

        public void onLoginSuccess() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onLoginSuccess onSuccess", (Object[])new Object[0]);
            }
            LoginGuideDialogController.this.onLoginFinish();
            LoginGuideDialogController.this.closePage();
        }

        public void onLoginWindowClosed() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onLoginWindowClosed", (Object[])new Object[0]);
            }
            LoginGuideDialogController.this.onLoginFinish();
            if (LoginGuideDialogController.this.loginGuideDialogCallback != null) {
                LoginGuideDialogController.this.loginGuideDialogCallback.onCancel();
            }
        }
    }
}

