/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.basicprofile;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Process;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.yy.appbase.R;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountRelatedSetting;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.bar.CommonTitleBar;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.AgeUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.login.LoginTrack;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.base.utils.NextBtn;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class BasicProfileWindow
extends DefaultWindow {
    private static final String TAG = "BasicProfileWindow";
    private static final int NAME_MAX_LENGTH = 35;
    private IWindowCallBack mMyCallBack;
    private CommonTitleBar mTitleBar;
    private CircleImageView mIcon;
    private YYEditText mNameView;
    private YYTextView mBirthdayView;
    private YYTextView mHomeTownView;
    private GenderView mGenderView;
    private NextBtn mGoBtn;
    private String mIconUrl;
    private UserInfoBean defaultUserInfo;
    private IAB mABResult;
    private DialogLinkManager mDialogLinkManager;
    private boolean ageBlock;
    private final int itemLeftMargin = ResourceUtils.getDimen((int)R.dimen.login_profile_item_left);
    private final int textHeight = ResourceUtils.getDimen((int)R.dimen.login_profile_nick_name_height);
    private final int titleTextSize = ResourceUtils.getDimen((int)R.dimen.login_profile_nick_name_textsize);
    private String mHometownCode = "";
    private boolean mNeedShowHomeTown;

    public BasicProfileWindow(UserInfoBean infoBean, Context context, IWindowCallBack callBack) {
        this(context, callBack);
        this.defaultUserInfo = infoBean;
        this.inflateDefaultUserInfo();
    }

    public BasicProfileWindow(Context context, IWindowCallBack callBacks) {
        super(context, (UICallBacks)callBacks, "BasicProfile");
        this.mMyCallBack = callBacks;
        this.mWindowInfo.setCanPopByBackKey(false);
        this.mABResult = NewABDefine.HAGO_AGE_BLOCK.getTest();
        this.mDialogLinkManager = new DialogLinkManager(context);
        this.initViews();
        this.setBackgroundColor(ResourceUtils.getColor((int)R.color.common_window_white_bg));
        this.setWindowType(112);
    }

    private void initViews() {
        int iconAndGenderTopMargin = ResourceUtils.getDimen((int)R.dimen.login_profile_icon_top_margin);
        int iconAndGenderBottomMargin = ResourceUtils.getDimen((int)R.dimen.login_profile_icon_bottom_margin);
        int titleBarHeight = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_height);
        if (NAB.C.equals((Object)this.mABResult) || NAB.B.equals((Object)this.mABResult)) {
            titleBarHeight = 0;
        }
        int lineOneBottomMargin = ResourceUtils.getDimen((int)R.dimen.login_profile_first_line_bottom_margin);
        int lineTwoBottomMargin = ResourceUtils.getDimen((int)R.dimen.login_profile_second_line_bottom_margin);
        int iconHeight = ResourceUtils.getDimen((int)R.dimen.login_profile_icon_height);
        Context context = this.getContext();
        YYLinearLayout container = new YYLinearLayout(context);
        this.mTitleBar = new CommonTitleBar(context);
        this.mIcon = new CircleImageView(context);
        this.mNameView = new YYEditText(context);
        this.mBirthdayView = new YYTextView(context);
        this.mGenderView = new GenderView(context);
        this.mGoBtn = new NextBtn(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, titleBarHeight);
        this.mTitleBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new LinearLayout.LayoutParams(iconHeight, iconHeight);
        layoutParams.gravity = 1;
        layoutParams.topMargin = iconAndGenderTopMargin;
        layoutParams.bottomMargin = iconAndGenderBottomMargin;
        this.mIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mIcon.setImageResource(R.drawable.register_icon_avatar_nor);
        layoutParams = new LinearLayout.LayoutParams(-1, this.textHeight);
        layoutParams.leftMargin = this.itemLeftMargin;
        layoutParams.topMargin = iconAndGenderBottomMargin;
        LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)layoutParams);
        this.mGenderView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mNameView.setLayoutParams((ViewGroup.LayoutParams)this.createItemLayoutParams(this.itemLeftMargin, this.textHeight));
        this.mNameView.setSingleLine();
        this.mNameView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(35)});
        this.mBirthdayView.setLayoutParams((ViewGroup.LayoutParams)this.createItemLayoutParams(this.itemLeftMargin, this.textHeight));
        this.mGoBtn.setLayoutParams((ViewGroup.LayoutParams)this.mGoBtn.createLLayoutParams(lineTwoBottomMargin));
        container.setOrientation(1);
        container.addView((View)this.mTitleBar);
        container.addView((View)this.mIcon);
        container.addView((View)this.mNameView);
        container.addView((View)this.createLine(this.itemLeftMargin, lineOneBottomMargin));
        container.addView((View)this.mBirthdayView);
        container.addView((View)this.createLine(this.itemLeftMargin, 0));
        this.mNeedShowHomeTown = this.isNeedShowHomeTown();
        if (this.mNeedShowHomeTown) {
            this.initHomeTownView();
            container.addView((View)this.mHomeTownView);
            container.addView((View)this.createLine(this.itemLeftMargin, 0));
        }
        container.addView((View)this.mGenderView);
        container.addView((View)this.mGoBtn);
        this.getBaseLayer().addView((View)container, new ViewGroup.LayoutParams(-1, -1));
        this.mNameView.setTextSize(0, (float)this.titleTextSize);
        this.mNameView.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_color));
        this.mNameView.setHintTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
        this.mNameView.setGravity(17);
        this.mNameView.setBackgroundDrawable(null);
        this.mNameView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && BasicProfileWindow.this.mMyCallBack != null) {
                    BasicProfileWindow.this.mMyCallBack.clearWhite(BasicProfileWindow.this.mNameView.getText().toString());
                }
            }
        });
        this.mBirthdayView.setTextSize(0, (float)this.titleTextSize);
        this.mBirthdayView.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_color));
        this.mBirthdayView.setHintTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
        this.mBirthdayView.setGravity(17);
        this.mTitleBar.updateData(-1, "", -1, ResourceUtils.getString((int)R.string.login_profile_skip));
        this.mTitleBar.setClickListeners(null, null, new View.OnClickListener(){

            public void onClick(View view) {
                if (BasicProfileWindow.this.mMyCallBack != null) {
                    BasicProfileWindow.this.mMyCallBack.onSkipBtnClicked();
                }
            }
        });
        this.mIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BasicProfileWindow.this.mMyCallBack.onSelectIconClicked();
            }
        });
        this.mGoBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BasicProfileWindow.this.isSaveBtnEnable()) {
                    if (BasicProfileWindow.this.mMyCallBack != null) {
                        BasicProfileWindow.this.mMyCallBack.onSaveBtnClicked();
                        int pageId = 1;
                        if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 3) {
                            pageId = 2;
                        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 1) {
                            pageId = 4;
                        }
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_info_done").put("page_id", String.valueOf(pageId)).put("home_town", BasicProfileWindow.this.mHometownCode));
                        BasicProfileWindow.this.handleTrack();
                    }
                } else {
                    BasicProfileWindow.this.showInvalidToast();
                }
            }
        });
        this.mBirthdayView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BasicProfileWindow.this.mMyCallBack != null) {
                    LoginTrack.reportBirthdayBoxClick();
                    BasicProfileWindow.this.mMyCallBack.onSelectBirthDayViewClicked();
                }
            }
        });
        this.mNameView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                BasicProfileWindow.this.checkSaveClickStatus();
            }
        });
        this.checkSaveClickStatus();
        this.mNameView.setHint((CharSequence)ResourceUtils.getString((int)R.string.login_profile_nickname));
        this.mBirthdayView.setHint((CharSequence)ResourceUtils.getString((int)R.string.login_profile_birthday));
        this.mGoBtn.hideArrow();
        this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_profile_save));
    }

    private void initHomeTownView() {
        this.mHomeTownView = new YYTextView(this.getContext());
        LinearLayout.LayoutParams layoutParams = this.createItemLayoutParams(this.itemLeftMargin, this.textHeight);
        layoutParams.topMargin = ResolutionUtils.dip2Px((float)20.0f);
        this.mHomeTownView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mHomeTownView.setTextSize(0, (float)this.titleTextSize);
        this.mHomeTownView.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_color));
        this.mHomeTownView.setHintTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
        this.mHomeTownView.setGravity(17);
        this.mHomeTownView.setHint((CharSequence)ResourceUtils.getString((int)R.string.login_profile_hometown));
        this.mHomeTownView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BasicProfileWindow.this.mMyCallBack != null) {
                    BasicProfileWindow.this.mMyCallBack.onSelectHomeTownViewClicked();
                }
            }
        });
    }

    private void inflateDefaultUserInfo() {
        if (this.defaultUserInfo != null) {
            if (!TextUtils.isEmpty((CharSequence)this.defaultUserInfo.getNick())) {
                this.updateName(this.defaultUserInfo.getNick());
            }
            if (!TextUtils.isEmpty((CharSequence)this.defaultUserInfo.getBirthday())) {
                this.updateBirthDay(this.defaultUserInfo.getBirthday());
            }
            this.updateGender(this.defaultUserInfo.getSex());
        }
    }

    public void updateName(String name) {
        this.mNameView.setText((CharSequence)name);
        this.checkSaveClickStatus();
    }

    public void updateBirthDay(String birthDay) {
        this.mBirthdayView.setText((CharSequence)birthDay);
        this.checkSaveClickStatus();
        this.checkAgeIsInvalid();
    }

    public void updateHomeTown(CountryHelper.CountryInfo homeTown) {
        this.mHomeTownView.setText((CharSequence)homeTown.englishName);
        this.mHometownCode = homeTown.code;
        this.checkSaveClickStatus();
    }

    private void checkAgeIsInvalid() {
        if (this.isAgeInValid()) {
            this.toastAgeInvalid();
        }
    }

    private void toastAgeInvalid() {
        LoginTrack.reportTopRedToastShow();
        int color2 = ResourceUtils.getColor((int)R.color.error_toast_bg);
        float marginTop = this.mTitleBar.getHeight();
        TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.login_profile_birth_restriction), (int)color2, (long)4000L, (int)20, (float)marginTop, (boolean)false);
    }

    public void updateIcon(String url, int defaultId) {
        this.mIconUrl = url;
        if (!TextUtils.isEmpty((CharSequence)url) && url.startsWith("http")) {
            ImageLoader.loadImage((RecycleImageView)this.mIcon, (String)(url + YYImageUtils.getThumbnailPostfix((int)75)), (int)defaultId);
        } else {
            ImageLoader.loadImage((RecycleImageView)this.mIcon, (String)url, (int)defaultId);
        }
        this.checkSaveClickStatus();
    }

    public void updateGender(int gender) {
        this.mGenderView.updateGenderValue(gender);
        this.checkSaveClickStatus();
    }

    private void showGenderChanngeTips() {
        String tips = ResourceUtils.getString((int)R.string.login_profile_gender_change_tip);
    }

    public int getGender() {
        return this.mGenderView.getGenderValue();
    }

    public String getNickName() {
        if (this.mNameView.getText() != null) {
            return this.mNameView.getText().toString();
        }
        return null;
    }

    public String getBirthday() {
        if (this.mBirthdayView.getText() != null) {
            return this.mBirthdayView.getText().toString();
        }
        return null;
    }

    public String getHometown() {
        if (this.mNeedShowHomeTown && this.mHomeTownView.getText() != null) {
            String hometown = this.mHomeTownView.getText().toString();
            if (ResourceUtils.getString((int)R.string.other_hometown).equals(hometown)) {
                return "";
            }
            return hometown;
        }
        return "";
    }

    private boolean isSaveBtnEnable() {
        if (this.ageBlock) {
            return true;
        }
        if (this.isAgeInValid()) {
            return false;
        }
        if (this.mGenderView.getGenderValue() != 0 && this.mGenderView.getGenderValue() != 1) {
            return false;
        }
        if (this.mBirthdayView.getText() == null || StringUtils.isEmpty((String)this.mBirthdayView.getText().toString())) {
            return false;
        }
        if (this.mNameView.getText() == null || StringUtils.isEmpty((String)this.mNameView.getText().toString())) {
            return false;
        }
        if (this.isHomeTownEmpty()) {
            return false;
        }
        return !StringUtils.isEmpty((String)this.mIconUrl);
    }

    private boolean isAgeInValid() {
        return AgeUtils.isAgeInValid((String)this.getBirthday());
    }

    private boolean isHomeTownEmpty() {
        return this.mNeedShowHomeTown && (this.mHomeTownView == null || this.mHomeTownView.getText() == null || StringUtils.isEmpty((String)this.mHomeTownView.getText().toString()));
    }

    private boolean isNeedShowHomeTown() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isNeedShowHomeTown countryCode = %s ABTest = %s", (Object[])new Object[]{AccountUtil.realCountry(), NewABDefine.HAGO_SA_NEWUSERS_HOMETOWN.getTest()});
        }
        if (!"sa".equalsIgnoreCase(AccountUtil.realCountry())) {
            return false;
        }
        return NAB.A.equals((Object)NewABDefine.HAGO_SA_NEWUSERS_HOMETOWN.getTest());
    }

    public String getIconUrl() {
        return this.mIconUrl;
    }

    private void showInvalidToast() {
        int duration = 0;
        int color2 = ResourceUtils.getColor((int)R.color.error_toast_bg);
        float marginTop = this.mTitleBar.getHeight();
        if (this.isNothingEdited()) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.login_profile_invalid_all), (int)color2, (int)duration, (float)marginTop);
            return;
        }
        if (StringUtils.isEmpty((String)this.mIconUrl)) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.login_profile_invalid_avatar), (int)color2, (int)duration, (float)marginTop);
            return;
        }
        if (this.mNameView.getText() == null || StringUtils.isEmpty((String)this.mNameView.getText().toString())) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.login_profile_invalid_name), (int)color2, (int)duration, (float)marginTop);
            return;
        }
        if (this.mBirthdayView.getText() == null || StringUtils.isEmpty((String)this.mBirthdayView.getText().toString())) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.login_profile_invalid_birthday), (int)color2, (int)duration, (float)marginTop);
            return;
        }
        if (this.isHomeTownEmpty()) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.login_profile_invalid_home_town), (int)color2, (int)duration, (float)marginTop);
            return;
        }
        if (this.isAgeInValid()) {
            this.toastAgeInvalid();
            return;
        }
        if (this.mGenderView.getGenderValue() != 0 && this.mGenderView.getGenderValue() != 1) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.login_profile_invalid_gender), (int)color2, (int)duration, (float)marginTop);
            return;
        }
    }

    private boolean isNothingEdited() {
        return !(!StringUtils.isEmpty((String)this.mIconUrl) || this.mNameView.getText() != null && !StringUtils.isEmpty((String)this.mNameView.getText().toString()) || this.mBirthdayView.getText() != null && !StringUtils.isEmpty((String)this.mBirthdayView.getText().toString()) || this.mGenderView.getGenderValue() == 0 || this.mGenderView.getGenderValue() == 1 || !this.isHomeTownEmpty());
    }

    private void checkSaveClickStatus() {
        boolean enable = this.isSaveBtnEnable();
        if (enable) {
            StateListDrawable bgColorDrawable = new StateListDrawable();
            bgColorDrawable.addState(new int[]{16842919}, ResourceUtils.getDrawable((int)R.drawable.next_btn_press));
            bgColorDrawable.addState(new int[]{16842910}, ResourceUtils.getDrawable((int)R.drawable.next_btn_normal));
            bgColorDrawable.addState(new int[0], ResourceUtils.getDrawable((int)R.drawable.next_btn_unable));
            this.mGoBtn.setBg((Drawable)bgColorDrawable);
        } else {
            this.mGoBtn.setBg(ResourceUtils.getDrawable((int)R.drawable.next_btn_unable));
        }
    }

    private YYView createLine(int leftPadding, int bottom) {
        int lineHeight = ResourceUtils.getDimen((int)R.dimen.login_phone_line_height);
        YYView line = new YYView(this.getContext());
        LinearLayout.LayoutParams layoutParams = this.createItemLayoutParams(leftPadding, lineHeight);
        layoutParams.bottomMargin = bottom;
        line.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        line.setBackgroundColor(ResourceUtils.getColor((int)R.color.login_line_color));
        return line;
    }

    private LinearLayout.LayoutParams createItemLayoutParams(int leftPadding, int height) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, height);
        layoutParams.leftMargin = leftPadding;
        layoutParams.rightMargin = leftPadding;
        return layoutParams;
    }

    public void showConfirmDialog(final String birth) {
        OkCancelDialog dialog = new OkCancelDialog.Builder().cancelable(true).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.birthday_confirm_dialog_back)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.date_picker_confirm)).message((CharSequence)ResourceUtils.getString((int)R.string.birthday_confirm_dialog_info)).listener(new OkCancelDialogListener(){

            public void onCancel() {
                if (BasicProfileWindow.this.mMyCallBack != null) {
                    LoginTrack.reportBirthdayBackClick();
                    BasicProfileWindow.this.mMyCallBack.onSelectBirthDayViewClicked();
                }
            }

            public void onOk() {
                LoginTrack.reportBirthdayConfirmClick();
                BasicProfileWindow.this.updateBirthDay(birth);
                if (BasicProfileWindow.this.isAgeInValid()) {
                    BasicProfileWindow.this.toastAgeInvalid();
                    BasicProfileWindow.this.updateRestrictedStatus();
                }
            }
        }).build();
        if (!this.mDialogLinkManager.isDialogShowing()) {
            LoginTrack.reportBirthdayPopupsShow();
            this.mDialogLinkManager.showDialog((BaseDialog)dialog);
        }
    }

    private void updateRestrictedStatus() {
        this.ageBlock = true;
        this.mBirthdayView.setEnabled(false);
        this.mBirthdayView.setTextColor(ResourceUtils.getColor((int)R.color.color_e1e1e1));
        this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.exit_hago));
        this.mGoBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                System.exit(0);
                Process.killProcess((int)Process.myPid());
            }
        });
        this.checkSaveClickStatus();
    }

    private void handleTrack() {
        if (!AccountRelatedSetting.getInstance().getBoolean("key_profile_complete_report", false)) {
            int age = AgeUtils.getAgeFromBirthTime((String)this.getBirthday());
            if (age <= 0) {
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.AGE_UNKNOWN));
            } else if (age < 18) {
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.AGE_0_17));
            } else {
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.AGE_18_MORE));
                if (age < 25) {
                    AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.AGE_18_24));
                } else if (age < 35) {
                    AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.AGE_25_34));
                }
            }
            int gender = this.getGender();
            if (gender == 0) {
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.GENDER_F));
            } else if (gender == 1) {
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.GENDER_M));
            } else {
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.GENDER_UNKNOWN));
            }
            AccountRelatedSetting.getInstance().putBoolean("key_profile_complete_report", true);
        }
    }

    static interface IWindowCallBack
    extends UICallBacks {
        public void onSelectIconClicked();

        public void onSaveBtnClicked();

        public void onSelectBirthDayViewClicked();

        public String clearWhite(String var1);

        public void onSkipBtnClicked();

        public void onSelectHomeTownViewClicked();
    }

    private class GenderView
    extends YYRelativeLayout {
        private int mGenderValue;
        private RecycleImageView mMaleIcon;
        private RecycleImageView mFemaleIcon;
        private YYTextView mMaleText;
        private YYTextView mFemaleText;
        private LinearLayout mMaleLayout;
        private LinearLayout mFemaleLayout;

        GenderView(Context context) {
            super(context);
            this.mGenderValue = -1;
            this.setClipChildren(false);
            int genderIconHeight = ResourceUtils.getDimen((int)R.dimen.login_profile_gender_icon_height);
            int genderTextLeftMargin = ResourceUtils.getDimen((int)R.dimen.login_profile_gender_text_margin);
            int titleTextSize = ResourceUtils.getDimen((int)R.dimen.login_profile_nick_name_textsize);
            this.mMaleIcon = new RecycleImageView(context);
            this.mFemaleIcon = new RecycleImageView(context);
            this.mMaleText = new YYTextView(context);
            this.mFemaleText = new YYTextView(context);
            this.mMaleLayout = new YYLinearLayout(context);
            this.mFemaleLayout = new YYLinearLayout(context);
            RelativeLayout.LayoutParams relativeLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
            relativeLayoutParams.addRule(Build.VERSION.SDK_INT >= 17 ? 20 : (LanguageUtils.isLtr() ? 9 : 11));
            this.mMaleLayout.setLayoutParams((ViewGroup.LayoutParams)relativeLayoutParams);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(genderIconHeight, genderIconHeight);
            layoutParams.gravity = 16;
            this.mMaleIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mMaleText.setText((CharSequence)ResourceUtils.getString((int)R.string.male));
            this.mMaleText.setTextSize(0, (float)titleTextSize);
            this.mMaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
            layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 16;
            layoutParams.leftMargin = genderTextLeftMargin;
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)layoutParams);
            this.mMaleText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mMaleLayout.setId(R.id.login_profile_male_layout);
            this.mMaleLayout.setOrientation(0);
            this.mMaleLayout.addView((View)this.mMaleIcon);
            this.mMaleLayout.addView((View)this.mMaleText);
            relativeLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
            relativeLayoutParams.addRule(Build.VERSION.SDK_INT >= 17 ? 17 : (LanguageUtils.isLtr() ? 1 : 0), this.mMaleLayout.getId());
            relativeLayoutParams.leftMargin = ResolutionUtils.dip2Px((float)16.0f);
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)relativeLayoutParams);
            this.mFemaleLayout.setLayoutParams((ViewGroup.LayoutParams)relativeLayoutParams);
            layoutParams = new LinearLayout.LayoutParams(genderIconHeight, genderIconHeight);
            layoutParams.gravity = 16;
            this.mFemaleIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mFemaleText.setText((CharSequence)ResourceUtils.getString((int)R.string.female));
            this.mFemaleText.setTextSize(0, (float)titleTextSize);
            this.mFemaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
            layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.gravity = 16;
            layoutParams.leftMargin = genderTextLeftMargin;
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)layoutParams);
            this.mFemaleText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mFemaleLayout.setOrientation(0);
            this.mFemaleLayout.addView((View)this.mFemaleIcon);
            this.mFemaleLayout.addView((View)this.mFemaleText);
            this.addView((View)this.mMaleLayout);
            this.addView((View)this.mFemaleLayout);
            this.updateGenderValue(-1);
            this.mMaleLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GenderView.this.updateGenderValue(1);
                    BasicProfileWindow.this.checkSaveClickStatus();
                }
            });
            this.mFemaleLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GenderView.this.updateGenderValue(0);
                    BasicProfileWindow.this.checkSaveClickStatus();
                }
            });
        }

        public void updateGenderValue(int value) {
            this.mGenderValue = value;
            if (value == 1) {
                ImageLoader.loadImage((RecycleImageView)this.mFemaleIcon, (int)R.drawable.register_gander_default);
                ImageLoader.loadImage((RecycleImageView)this.mMaleIcon, (int)R.drawable.register_icon_man_sel);
                this.mFemaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
                this.mMaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_color));
            } else if (value == 0) {
                ImageLoader.loadImage((RecycleImageView)this.mFemaleIcon, (int)R.drawable.register_icon_woman_sel);
                ImageLoader.loadImage((RecycleImageView)this.mMaleIcon, (int)R.drawable.register_gander_default);
                this.mFemaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_color));
                this.mMaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
            } else {
                ImageLoader.loadImage((RecycleImageView)this.mFemaleIcon, (int)R.drawable.register_gander_default);
                ImageLoader.loadImage((RecycleImageView)this.mMaleIcon, (int)R.drawable.register_gander_default);
                this.mFemaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
                this.mMaleText.setTextColor(ResourceUtils.getColor((int)R.color.login_profile_text_hint_color));
            }
        }

        public int getGenderValue() {
            return this.mGenderValue;
        }
    }
}

