/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login;

import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.login.BaseTrack;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.bean.LoginGuestReportInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;

public class LoginTrack
extends BaseTrack {
    private static final String TAG = "LoginTrack";
    private static final String PAGE_ID = "page_id";
    private static final String CLICK_SOURCE = "click_source";
    public static final String OLD_PWD_ERROR = "0";
    public static final String NEW_PWD_INVALID = "1";
    public static final String PWD_OLD_NEW_SAME = "2";
    public static final String PWD_NEW_CONFIRM_NOT_SAME = "3";
    public static final String PWD_FAIL_EXCESS = "4";
    public static final String PWD_FAIL_RISK = "5";
    public static final String PWD_FAIL_OTHER_ERROR = "6";

    public static void phoneNumPageShow() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("function_id", "phone_num_show").put(PAGE_ID, PWD_FAIL_OTHER_ERROR));
    }

    public static void phoneNumNextClick(String phoneNumber) {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("function_id", "phone_num_click").put("phone_number", phoneNumber).put(CLICK_SOURCE, "9").put(PAGE_ID, PWD_FAIL_OTHER_ERROR));
    }

    public static void googleApiCall() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("function_id", "google_api_call"));
    }

    public static void googleApiSuccess(String phoneNumber) {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("function_id", "google_api_success").put("phone_number", phoneNumber));
    }

    public static void changeLanguageShow() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("function_id", "in_lang_show"));
    }

    public static void changeLanguageClick(String source) {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put(CLICK_SOURCE, source).put("function_id", "in_lang_click"));
    }

    public static void changeLanguageSelected(String language) {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("lang", language).put("function_id", "in_lang_switch"));
    }

    public static void googleSmsCall() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("function_id", "google_sms_call"));
    }

    public static void googleSmsSuccess() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("20023769").put("function_id", "google_sms_success"));
    }

    public static void reportBirthdayBoxClick() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("60087583").put("function_id", "register_fill_birthday_box_click"));
    }

    public static void reportBirthdayConfirmClick() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("60087583").put("function_id", "register_fill_birthday_confirm_click"));
    }

    public static void reportBirthdayPopupsShow() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("60087583").put("function_id", "register_fill_birthday_popups_show"));
    }

    public static void reportBirthdayBackClick() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("60087583").put("function_id", "register_fill_birthday_back_click"));
    }

    public static void reportTopRedToastShow() {
        HiidoStatis.reportEvent((HiidoEvent)LoginTrack.event("60087583").put("function_id", "top_red_toast_show"));
    }

    public static void checkReportAbnormalAccount(final AccountInfo accountInfo) {
        if (accountInfo == null) {
            return;
        }
        int registerSize = FP.size((CharSequence)accountInfo.registerCountry);
        int realSize = FP.size((CharSequence)accountInfo.realCountry);
        if (registerSize <= 0 || registerSize > 3 || realSize <= 0 || realSize > 3) {
            MLog.error((Object)TAG, (String)"checkReportAbnormalAccount %s, %s", (Object[])new Object[]{accountInfo.registerCountry, accountInfo.realCountry});
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("perftype", "login_country");
                    statContent.put("sfield", accountInfo.registerCountry);
                    statContent.put("sfieldtwo", accountInfo.realCountry);
                    HiidoStatis.reportContent((StatisContent)statContent);
                    if (SystemUtils.isShowEnvSetting()) {
                        throw new RuntimeException("\u540e\u53f0\u4e0b\u53d1\u975e\u6cd5\u56fd\u5bb6\u7801 " + accountInfo.registerCountry + ", " + accountInfo.realCountry);
                    }
                }
            });
        }
    }

    public static void reportLoginTypeSelect(int type, Map<String, String> extra, LoginGuestReportInfo guestReportInfo) {
        ICoinsService coinsService;
        String clickEvent = "";
        boolean isLineInstalled = false;
        switch (type) {
            case 1: {
                clickEvent = "facebook_click";
                break;
            }
            case 2: {
                clickEvent = "phone_click";
                break;
            }
            case 3: {
                clickEvent = "google_click";
                break;
            }
            case 4: {
                clickEvent = "line_click";
                isLineInstalled = SystemUtils.isAppInstalled((String)"jp.naver.line.android");
                break;
            }
            case 10: {
                clickEvent = "guest_click";
                break;
            }
            case 5: {
                clickEvent = "vk_click";
                break;
            }
            case 7: {
                clickEvent = "zalo_click";
                break;
            }
            case 8: {
                clickEvent = "wa_click";
                break;
            }
            case 9: {
                clickEvent = "snapchat_click";
                break;
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"start login:%d", (Object[])new Object[]{type});
        }
        String rewardCoins = "";
        if (ServiceManagerProxy.getServiceManager().hasRegisterService(ICoinsService.class) && (coinsService = (ICoinsService)ServiceManagerProxy.getService(ICoinsService.class)) != null) {
            rewardCoins = String.valueOf(coinsService.realGuestRewardCoins());
        }
        long stayDuration = 0L;
        Object response = MsgDispatcher.getInstance().sendMessageSync(GrowthMsgDef.LOGIN_BG_STAY_TIME);
        if (response instanceof Long) {
            stayDuration = (Long)response;
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20023769").put("function_id", clickEvent).put("reward_coins", rewardCoins).put("login_time", String.valueOf(stayDuration)).putMap(extra);
        if (type == 4) {
            String installStatus = isLineInstalled ? NEW_PWD_INVALID : OLD_PWD_ERROR;
            event.put("installed_line", installStatus);
        }
        if (guestReportInfo != null) {
            event = guestReportInfo.generateHiidoEvent(event);
        }
        HiidoStatis.reportEventNow((HiidoEvent)event);
    }

    public static void reportLoginSuccess(int loginType, long loginConsumeTime, Map<String, String> extra, LoginGuestReportInfo guestReportInfo) {
        String sucType = "phone_login_success";
        if (loginType == 3) {
            sucType = "google_login_success";
        } else if (loginType == 1) {
            sucType = "facebook_login_success";
        } else if (loginType == 10) {
            sucType = "guest_login_success";
            loginConsumeTime = 0L;
        } else if (loginType == 4) {
            sucType = "line_login_success";
        } else if (loginType == 5) {
            sucType = "vk_login_success";
        } else if (loginType == 6) {
            sucType = "token_login_success";
        } else if (loginType == 11) {
            sucType = "token_login_slient_success";
        } else if (loginType == 7) {
            sucType = "zalo_login_success";
        } else if (loginType == 8) {
            sucType = "wsp_login_success";
        } else if (loginType == 9) {
            sucType = "snapchat_login_success";
        }
        AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId(AppsFlyerEvent.LOGIN_SUCCESS));
        String rewardCoins = "";
        ICoinsService coinsService = (ICoinsService)ServiceManagerProxy.getService(ICoinsService.class);
        if (coinsService != null) {
            rewardCoins = String.valueOf(coinsService.realGuestRewardCoins());
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20023769").put("function_id", sucType).put("login_time", String.valueOf(loginConsumeTime)).put("reward_coins", rewardCoins).putMap(extra);
        if (guestReportInfo != null) {
            event = guestReportInfo.generateHiidoEvent(event);
        }
        HiidoStatis.reportEventNow((HiidoEvent)event);
    }

    public static void reportLoginError(int loginType, long loginConsumeTime, Map<String, String> extra, LoginGuestReportInfo guestReportInfo) {
        String sucType = "phone_login_fail";
        if (loginType == 3) {
            sucType = "google_login_fail";
        } else if (loginType == 1) {
            sucType = "facebook_login_fail";
        } else if (loginType == 10) {
            sucType = "guest_login_fail";
        } else if (loginType == 4) {
            sucType = "line_login_fail";
        } else if (loginType == 5) {
            sucType = "vk_login_fail";
        } else if (loginType == 6) {
            sucType = "token_login_fail";
        } else if (loginType == 11) {
            sucType = "token_login_slient_fail";
        } else if (loginType == 7) {
            sucType = "zalo_login_fail";
        } else if (loginType == 8) {
            sucType = "wsp_login_fail";
        } else if (loginType == 9) {
            sucType = "snapchat_login_fail";
        }
        String rewardCoins = "";
        ICoinsService coinsService = (ICoinsService)ServiceManagerProxy.getService(ICoinsService.class);
        if (coinsService != null) {
            rewardCoins = String.valueOf(coinsService.realGuestRewardCoins());
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20023769").put("function_id", sucType).put("login_time", String.valueOf(loginConsumeTime)).put("reward_coins", rewardCoins);
        if (guestReportInfo != null) {
            event = guestReportInfo.generateHiidoEvent(event);
        }
        HiidoStatis.reportEventNow((HiidoEvent)event);
    }

    public static void reportSignClick(String reportAB) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_sign_switch_click").put("AB_test", reportAB));
    }

    public static void reportForgetPwdClick(String reportAB) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_forget_password_click").put("AB_test", reportAB));
    }

    public static void reportSmsLoginClick(String reportAB) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_code_click").put("AB_test", reportAB));
    }

    public static void reportSmsCodeSendClick(int mode) {
        switch (mode) {
            case 4: {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_reset_send"));
                break;
            }
            case 5: 
            case 6: {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_send"));
                break;
            }
        }
    }

    public static void reportGoButtonClick(int mode) {
        if (mode != 5 && mode != 6) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_vail_next"));
        }
        switch (mode) {
            case 4: {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_reset_login"));
                break;
            }
            case 5: {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_done").put("phone_set_password_type", OLD_PWD_ERROR));
                break;
            }
            case 6: {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_done").put("phone_set_password_type", NEW_PWD_INVALID));
                break;
            }
        }
    }

    public static void reportPhoneWindowShow(int mode) {
        switch (mode) {
            case 4: {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_reset_password_show"));
                break;
            }
        }
    }

    public static void reportPhoneLogin(String reportAB) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_login").put("AB_test", reportAB));
    }

    public static void reportWhatsAppLogin() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "wsp_login"));
    }

    public static void reportPhonePwdLoginResult(boolean success, String reportAB) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_login").put("phone_password_result", success ? NEW_PWD_INVALID : OLD_PWD_ERROR).put("AB_test", reportAB));
    }

    public static void reportForgetPwdLoginResult(boolean success) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_reset_login").put("phone_set_password_result", success ? NEW_PWD_INVALID : OLD_PWD_ERROR));
    }

    public static void reportPhonePwdSetResult(boolean success, String reason) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_done").put("phone_set_password_type", OLD_PWD_ERROR).put("phone_set_password_result", success ? NEW_PWD_INVALID : OLD_PWD_ERROR).put("result_fail_reason", reason));
    }

    public static void reportPhonePwdResetResult(boolean success, String reason) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_done").put("phone_set_password_type", NEW_PWD_INVALID).put("phone_set_password_result", success ? NEW_PWD_INVALID : OLD_PWD_ERROR).put("result_fail_reason", reason));
    }
}

