/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.zalo;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.login.IZaloAccountSwitch;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.AbstractHandleUserInfoLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.request.ILoginRequestCallBack;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.hiyo.login.zalo.IBindZaloAccount;
import com.yy.hiyo.login.zalo.ZaloBindAccount;
import com.yy.hiyo.login.zalo.ZaloToken;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.UserDetainInfo;
import com.yy.socialplatformbase.callback.ILoginCallBack;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class ZaloLoginController
extends AbstractHandleUserInfoLoginer {
    private static final String TAG = "ZaloLoginController";
    private static final String ZALO_DIR = "zalo";
    private ILoginActionCallBack mMyCallBack;
    private LoginSuccessResult mLoginSuccessResult;
    private IBindZaloAccount mIBindZaloAccount;

    public ZaloLoginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 7);
        this.mMyCallBack = callBack;
    }

    @Override
    public void openLoginWindow() {
        this.startLogin();
    }

    public void logout() {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(9);
        if (adapter != null) {
            adapter.logout();
        }
    }

    public void bindAccount(IBindZaloAccount callBack) {
        this.mIBindZaloAccount = callBack;
        this.startLogin();
    }

    public void tryUpdateZaloFriendList() {
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("tryUpdateZaloFriendList isZaloLoginType = " + ZaloBindAccount.isZaloLoginType()), (Object[])new Object[0]);
        }
        if (ZaloBindAccount.isZaloLoginType() || ZaloBindAccount.isZaloBindStatu()) {
            ZaloBindAccount.checkUploadFriendList();
        }
    }

    private void startLogin() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startLogin!", (Object[])new Object[0]);
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        this.authorization(new IThirdPartyAuthorizationCallBack(){

            public void onSuccess(LoginSuccessResult result) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ZaloLoginController.TAG, (String)"startLogin success!", (Object[])new Object[0]);
                }
                if (result != null && result.authorizedData != null) {
                    ZaloLoginController.this.mLoginSuccessResult = result;
                    ZaloLoginController.this.getAccessToken(result);
                } else {
                    ZaloLoginController.this.handleLoginError("114", "");
                }
            }

            public void onCancel() {
                ZaloLoginController.this.handleLoginError("116", "");
            }

            public void onError(int errorCode, Exception e) {
                ZaloLoginController.this.handleLoginError("213", e != null ? e.getMessage() : "");
            }
        });
    }

    private void getAccessToken(final LoginSuccessResult result) {
        if (result != null) {
            String appId = ResourceUtils.getString((int)R.string.com_zalo_sdk_appId_debug);
            String appSecret = ResourceUtils.getString((int)R.string.com_zalo_sdk_secret_debug);
            String code = result.authorizedData.tokenStr;
            String url = "https://oauth.zaloapp.com/v3/access_token?app_id=" + appId + "&app_secret=" + appSecret + "&code=" + code;
            HttpUtil.httpReq((String)url, null, (int)1, (INetRespCallback)new INetRespCallback<ZaloToken>(){

                public boolean needToken() {
                    return false;
                }

                public void onError(Call call, Exception e, int id2) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ZaloLoginController.TAG, (String)"getAccessToken error=%s", (Object[])new Object[]{e});
                    }
                    ZaloLoginController.this.handleLoginError("213", "");
                }

                public void onResponse(String response, BaseResponseBean<ZaloToken> res, int id2) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ZaloLoginController.TAG, (String)"getAccessToken onResponse=%s", (Object[])new Object[]{response});
                    }
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        YYTaskExecutor.execute(() -> {
                            String accessToken = "";
                            try {
                                JSONObject jsonObject = JsonParser.obtainJSONObject((String)response);
                                accessToken = jsonObject.getString("access_token");
                            }
                            catch (Exception e) {
                                MLog.error((Object)ZaloLoginController.TAG, (String)"[getAccessToken]", (Throwable)e, (Object[])new Object[0]);
                            }
                            String finalAccessToken = accessToken;
                            YYTaskExecutor.postToMainThread(() -> {
                                result2.authorizedData.tokenStr = finalAccessToken;
                                if (ZaloLoginController.this.mIBindZaloAccount != null) {
                                    ZaloLoginController.this.bindZalo(result);
                                } else {
                                    ZaloLoginController.this.handleLoginResult(result, null);
                                }
                            });
                        });
                    } else {
                        MLog.error((Object)ZaloLoginController.TAG, (String)"[getAccessToken] empty response", (Object[])new Object[0]);
                        ZaloLoginController.this.handleLoginError("213", "getAccessToken empty response");
                    }
                }
            });
        }
    }

    public void handleSwitchLoginResult(IZaloAccountSwitch iZaloAccountSwitch) {
        this.handleLoginResult(this.mLoginSuccessResult, iZaloAccountSwitch);
    }

    private void handleLoginResult(LoginSuccessResult result, final IZaloAccountSwitch iZaloAccountSwitch) {
        this.mMyCallBack.onLoginStart(this);
        String userId = result.authorizedData.userId;
        String tokenStr = result.authorizedData.tokenStr;
        String appId = result.authorizedData.appId;
        String mail = result.authorizedData.mail;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleLoginResult!", (Object[])new Object[0]);
        }
        final long startTime = System.currentTimeMillis();
        this.mMyCallBack.getLoginRequester().loginWithThirdParty(9, appId, tokenStr, userId, mail, new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ZaloLoginController.TAG, (String)("LoginData = " + data), (Object[])new Object[0]);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ZaloLoginController.TAG, (String)"handleLoginResult success! LoginData", (Object[])new Object[0]);
                }
                if (data == null) {
                    ZaloLoginController.this.handleLoginError("213", "get zalo third login error!");
                    return;
                }
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/thirdpartyAuth");
                LoginData zaloLoginData = data;
                AccountInfo accountInfo = AccountInfo.obtain((LoginData)zaloLoginData);
                accountInfo.loginType = 7;
                YYTaskExecutor.postToMainThread(() -> {
                    if (KvoModuleManager.isKvoInitEnved()) {
                        ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).notifyZaloLogin();
                    } else {
                        KvoModuleManager.addInitEnvCallback((KvoModuleManager.InitEnvCallback)new KvoModuleManager.InitEnvCallback(){

                            public void onInitEnv() {
                                ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).notifyZaloLogin();
                            }
                        });
                    }
                    if (ZaloLoginController.this.mLoginCallBack != null) {
                        ZaloLoginController.this.mLoginCallBack.onLoginSuccess(ZaloLoginController.this, accountInfo);
                    }
                    if (iZaloAccountSwitch != null) {
                        iZaloAccountSwitch.onSuccess();
                    }
                });
                ZaloBindAccount.checkUploadFriendList();
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                ZaloLoginController.this.handleLoginError(errorCode, errorDescription);
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/thirdpartyAuth");
                YYTaskExecutor.postToMainThread(() -> {
                    if (iZaloAccountSwitch != null) {
                        iZaloAccountSwitch.onError(StringUtils.parseInt((String)errorCode), new Exception("code: " + errorCode + " des: " + errorDescription));
                    }
                });
            }
        });
    }

    private void handleLoginError(String errorCode, String des) {
        MLog.error((Object)TAG, (String)"login error:%s %s", (Object[])new Object[]{errorCode, des});
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mIBindZaloAccount != null) {
                this.mIBindZaloAccount.onError(StringUtils.parseInt((String)errorCode), new Exception("code: " + errorCode + " des: " + des));
                this.mIBindZaloAccount = null;
            } else {
                if (this.mLoginCallBack != null) {
                    this.mLoginCallBack.onLoginError(this, errorCode, des);
                }
                this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
                this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
            }
        });
    }

    @Override
    protected void authorization(final IThirdPartyAuthorizationCallBack callBack) {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(9);
        if (adapter != null) {
            adapter.login(new ILoginCallBack(){

                public void onSuccess(@NotNull LoginSuccessResult result) {
                    if (result.authorizedData != null) {
                        if (callBack != null) {
                            callBack.onSuccess(result);
                        }
                    } else if (callBack != null) {
                        callBack.onError(-1, (Exception)new RuntimeException(""));
                    }
                }

                public void onCancel() {
                    if (callBack != null) {
                        callBack.onCancel();
                    }
                }

                public void onError(@NotNull LoginErrorResult result) {
                    if (callBack != null) {
                        callBack.onError(result.errorCode, result.exception);
                    }
                }
            });
        }
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        this.getUserInfo(false, 9, accountInfo, callBack);
    }

    @Override
    public void handleLoginWithUpdateUserInfo(IUserInfoCallBack callBack, String iconPath, AccountInfo accountInfo, UserDetainInfo info) {
        if (info == null || accountInfo == null || !accountInfo.isValid()) {
            this.handleUpdateHagoUserInfoError(callBack, "213", "get zalo userinfo error!");
            return;
        }
        UserInfoBean userInfo = this.transform(info);
        userInfo.setUid(accountInfo.uuid);
        if (callBack != null) {
            callBack.onSuccess(userInfo);
        }
    }

    @Override
    protected String getIconDir() {
        return ZALO_DIR;
    }

    @Override
    protected String getThirdpartyError() {
        return "213";
    }

    private void bindZalo(LoginSuccessResult result) {
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.logining), false, false, null));
        AccountInfo info = AccountModel.getInstance().getAccountInfo();
        if (result == null || info == null) {
            if (this.mIBindZaloAccount != null) {
                this.mIBindZaloAccount.onError(-1, new RuntimeException("login result empty!"));
                this.mIBindZaloAccount = null;
            }
            this.mDialogLinkManager.dismissDialog();
            MLog.error((Object)TAG, (String)"handleBindZalo accountInfo null! ", (Object[])new Object[0]);
            return;
        }
        final long uuid = info.uuid;
        final String userid = result.authorizedData.userId;
        String tokenStr = result.authorizedData.tokenStr;
        String appId = result.authorizedData.appId;
        String mail = result.authorizedData.mail;
        this.mMyCallBack.getLoginRequester().bingThirdParty(info, 9, appId, tokenStr, userid, mail, new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                ZaloLoginController.this.mDialogLinkManager.dismissDialog();
                AccountInfo curInfo = AccountModel.getInstance().getAccountInfo();
                if (curInfo != null && curInfo.uuid == uuid) {
                    curInfo = AccountInfo.obtain((LoginData)data);
                }
                ZaloBindAccount.updateZaloBindStatu(uuid, userid);
                AccountInfo ci = curInfo;
                if (ZaloLoginController.this.mIBindZaloAccount != null) {
                    YYTaskExecutor.postToMainThread(() -> {
                        if (ZaloLoginController.this.mIBindZaloAccount != null) {
                            ZaloLoginController.this.mIBindZaloAccount.onSuccess(ci);
                            ZaloLoginController.this.mIBindZaloAccount = null;
                        }
                    });
                }
                ZaloBindAccount.checkUploadFriendList();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ZaloLoginController.TAG, (String)"handleBindZalo bind success! ", (Object[])new Object[0]);
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                ZaloLoginController.this.mDialogLinkManager.dismissDialog();
                if (errorCode != null && errorCode.equals("20411")) {
                    ZaloBindAccount.updateZaloBindStatu(uuid, userid);
                    if (ZaloLoginController.this.mIBindZaloAccount != null) {
                        YYTaskExecutor.postToMainThread(() -> {
                            if (ZaloLoginController.this.mIBindZaloAccount != null) {
                                ZaloLoginController.this.mIBindZaloAccount.onSuccess(AccountModel.getInstance().getAccountInfo());
                                ZaloLoginController.this.mIBindZaloAccount = null;
                            }
                        });
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ZaloLoginController.TAG, (String)"handleBindZalo bind success! ", (Object[])new Object[0]);
                    }
                    return;
                }
                if (ZaloLoginController.this.mIBindZaloAccount != null) {
                    YYTaskExecutor.postToMainThread(() -> {
                        if (ZaloLoginController.this.mIBindZaloAccount != null) {
                            ZaloLoginController.this.mIBindZaloAccount.onError(StringUtils.parseInt((String)errorCode), new RuntimeException(errorDescription));
                            ZaloLoginController.this.mIBindZaloAccount = null;
                        }
                    });
                }
                MLog.error((Object)ZaloLoginController.TAG, (String)"handleBindZalo bind error:%s %s! ", (Object[])new Object[]{errorCode, errorDescription});
            }
        });
    }
}

