/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.relogin;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.LoginTypeConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRecyclerView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.relogin.AccountInfoEx;
import com.yy.hiyo.login.relogin.IDialogCallBack;
import java.util.List;

public class AccountSelectDialog
implements BaseDialog,
IDialogCallBack {
    private static final String TAG = "AccountSelectDialog";
    private List<AccountInfoEx> accountInfosToShow;
    private final IDialogCallBack mListener;
    private final boolean mCancelable;
    private final boolean mOutSideCancelable;
    private YYRecyclerView mListView;
    private Dialog mDialog;
    private int mCallFrom;
    private RecyclerView.Adapter mAdapter;
    private PopupWindow mLastPopWindow;

    public AccountSelectDialog(int callFrom, List<AccountInfoEx> accountInfosToShow, boolean cancelable, boolean outSideCancelable, IDialogCallBack callBack) {
        this.mCallFrom = callFrom;
        this.mCancelable = cancelable;
        this.mOutSideCancelable = outSideCancelable;
        this.mListener = callBack;
        this.accountInfosToShow = accountInfosToShow;
    }

    public List<AccountInfoEx> getAccountInfosToShow() {
        return this.accountInfosToShow;
    }

    private View createPage(Context context) {
        View container = LayoutInflater.from((Context)context).inflate(R.layout.dialog_login_account_select_layout, null);
        YYImageView topCloseView = (YYImageView)container.findViewById(R.id.selectCloseIv);
        YYTextView bottomCloseView = (YYTextView)container.findViewById(R.id.selectBottomTv);
        YYTextView titleView = (YYTextView)container.findViewById(R.id.selectTitleTv);
        titleView.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mListView = (YYRecyclerView)container.findViewById(R.id.selectListLv);
        if (this.mCallFrom == 14) {
            bottomCloseView.setVisibility(8);
            topCloseView.setVisibility(0);
        } else {
            bottomCloseView.setVisibility(0);
            topCloseView.setVisibility(8);
        }
        topCloseView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AccountSelectDialog.this.onNoneAboveClicked();
            }
        });
        bottomCloseView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountSelectDialog.this.onNoneAboveClicked();
            }
        });
        return container;
    }

    private void notifyAdapter() {
        MLog.debug((Object)TAG, (String)("notifyAdapter adapter == null: " + (this.mAdapter == null)), (Object[])new Object[0]);
        if (this.mAdapter == null) {
            this.mAdapter = new RecyclerView.Adapter(){

                @NonNull
                public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
                    return new SelectItemHolder(parent, AccountSelectDialog.this);
                }

                public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
                    if (holder instanceof SelectItemHolder) {
                        ((SelectItemHolder)holder).update(AccountSelectDialog.this.accountInfosToShow, position, AccountSelectDialog.this.mCallFrom);
                    }
                }

                public int getItemCount() {
                    return AccountSelectDialog.this.accountInfosToShow == null ? 0 : AccountSelectDialog.this.accountInfosToShow.size();
                }
            };
            this.mListView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mListView.getContext()));
            this.mListView.setAdapter(this.mAdapter);
        } else {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void updateList(List<AccountInfoEx> accountInfosToShow) {
        this.accountInfosToShow = accountInfosToShow;
        this.notifyAdapter();
    }

    public void init(Dialog dialog) {
        WindowManager.LayoutParams lp;
        this.mDialog = dialog;
        Window win = dialog.getWindow();
        if (win != null && (lp = win.getAttributes()) != null) {
            lp.dimAmount = 0.3f;
            win.setAttributes(lp);
        }
        dialog.setCancelable(this.mCancelable);
        dialog.setCanceledOnTouchOutside(this.mOutSideCancelable);
        int w = ResolutionUtils.getScreenWidth() - ResolutionUtils.dip2Px((float)50.0f);
        dialog.setContentView(this.createPage(dialog.getContext()), new ViewGroup.LayoutParams(w, -2));
        this.notifyAdapter();
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (AccountSelectDialog.this.mListener != null) {
                    AccountSelectDialog.this.mListener.onDismiss(dialog);
                }
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (AccountSelectDialog.this.mListener != null) {
                    AccountSelectDialog.this.mListener.onCancel();
                }
            }
        });
        this.mDialog = dialog;
    }

    public int getId() {
        return DialogId.AccountReloginSelectDialog;
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        if (this.mListener != null) {
            this.mListener.onDismiss(dialog);
        }
    }

    @Override
    public void onSelectClicked(AccountInfoEx accountInfo) {
        if (this.mListener != null) {
            this.mListener.onSelectClicked(accountInfo);
        }
        this.mDialog.dismiss();
    }

    @Override
    public void onClearClicked(final AccountInfoEx accountInfo) {
        String tips;
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                if (AccountSelectDialog.this.mListener != null) {
                    AccountSelectDialog.this.mListener.onClearClicked(accountInfo);
                }
                if (AccountSelectDialog.this.accountInfosToShow != null) {
                    AccountSelectDialog.this.accountInfosToShow.remove(accountInfo);
                    if (AccountSelectDialog.this.accountInfosToShow.size() > 0) {
                        AccountSelectDialog.this.updateList(AccountSelectDialog.this.accountInfosToShow);
                    } else {
                        AccountSelectDialog.this.mDialog.dismiss();
                    }
                }
            }
        };
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.LOGIN_TYPE_CONFIG);
        LoginTypeConfigData loginTypeConfigData = null;
        if (configData instanceof LoginTypeConfigData) {
            loginTypeConfigData = (LoginTypeConfigData)configData;
        }
        boolean hasDialog = false;
        if (this.mDialog != null && accountInfo != null && accountInfo.accountInfo != null && loginTypeConfigData != null && loginTypeConfigData.hasException(accountInfo.accountInfo.loginType) && !StringUtils.isEmpty((String)(tips = loginTypeConfigData.clearExceptionDes))) {
            hasDialog = true;
            String cancel = ResourceUtils.getString((int)R.string.btn_cancel);
            String confirm = ResourceUtils.getString((int)R.string.btn_confirm);
            OkCancelDialog dialog = new OkCancelDialog((CharSequence)tips, (CharSequence)confirm, (CharSequence)cancel, true, true, new OkCancelDialogListener(){

                public void onCancel() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AccountSelect", (String)"cancel!", (Object[])new Object[0]);
                    }
                }

                public void onOk() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AccountSelect", (String)"confirm!", (Object[])new Object[0]);
                    }
                    command.run();
                }
            });
            dialog.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AccountSelect", (String)"cancel!", (Object[])new Object[0]);
                    }
                }
            });
            DialogLinkManager dialogLinkManager = new DialogLinkManager(this.mDialog.getContext());
            dialogLinkManager.showDialog((BaseDialog)dialog);
        }
        if (!hasDialog) {
            command.run();
        }
    }

    boolean onLongClicked(View view, AccountInfoEx accountInfo) {
        if (view == null || accountInfo == null) {
            return false;
        }
        if (this.mCallFrom == 14) {
            if (this.mLastPopWindow != null) {
                this.mLastPopWindow.dismiss();
            }
            this.mLastPopWindow = new DeletePopWindow(view.getContext(), accountInfo, this);
            int popWidth = this.mLastPopWindow.getContentView().getMeasuredWidth();
            int x = view.getLeft() + view.getWidth() / 2 - popWidth / 2;
            int y = view.getTop() + view.getHeight() / 2;
            MLog.debug((Object)TAG, (String)"onLongClicked x: %d, y: %d", (Object[])new Object[]{x, y});
            this.mLastPopWindow.showAtLocation(view, 0, x, y);
            return true;
        }
        return false;
    }

    @Override
    public void onNoneAboveClicked() {
        if (this.mListener != null) {
            this.mListener.onNoneAboveClicked();
        }
        this.mDialog.dismiss();
    }

    @Override
    public void onCancel() {
        if (this.mListener != null) {
            this.mListener.onCancel();
        }
    }

    private static class SelectItemHolder
    extends RecyclerView.ViewHolder {
        private CircleImageView mIcon;
        private CircleImageView mTypeIcon;
        private YYTextView mTitleView;
        private YYTextView mTagView;
        private YYImageView mDeleteView;
        private YYView mLineView;
        private AccountInfoEx mInfo;
        private AccountSelectDialog mSelectDialog;

        SelectItemHolder(ViewGroup parent, AccountSelectDialog selectDialog) {
            super(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_login_account_select_layout, parent, false));
            this.mSelectDialog = selectDialog;
            this.mIcon = (CircleImageView)this.itemView.findViewById(R.id.selectIconIv);
            this.mTypeIcon = (CircleImageView)this.itemView.findViewById(R.id.selectTypeIv);
            this.mTitleView = (YYTextView)this.itemView.findViewById(R.id.selectNameTv);
            this.mTagView = (YYTextView)this.itemView.findViewById(R.id.selectTagTv);
            this.mDeleteView = (YYImageView)this.itemView.findViewById(R.id.selectDeleteIv);
            this.mLineView = (YYView)this.itemView.findViewById(R.id.selectLine);
            this.mTitleView.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.ROBOTO_MEDIUM));
            this.initClickListener();
        }

        public void initClickListener() {
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (mSelectDialog != null) {
                        mSelectDialog.onSelectClicked(mInfo);
                    }
                }
            });
            this.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    if (mSelectDialog != null) {
                        return mSelectDialog.onLongClicked(view, mInfo);
                    }
                    return false;
                }
            });
            this.mDeleteView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (mSelectDialog != null) {
                        mSelectDialog.onClearClicked(mInfo);
                    }
                }
            });
        }

        public void update(List<AccountInfoEx> accountList, int position, int callFrom) {
            AccountInfoEx info = null;
            if (position >= 0 && position < accountList.size()) {
                info = accountList.get(position);
            }
            if (info != null) {
                MLog.debug((Object)AccountSelectDialog.TAG, (String)("update accountInfo: " + info + ", callFrom: " + callFrom), (Object[])new Object[0]);
                this.mInfo = info;
                if (info.accountInfo.loginType == 10) {
                    this.mTypeIcon.setImageResource(-1);
                } else if (info.accountInfo.loginType == 3) {
                    this.mTypeIcon.setImageResource(R.drawable.google_select);
                } else if (info.accountInfo.loginType == 1) {
                    this.mTypeIcon.setImageResource(R.drawable.facebook_selector);
                } else if (info.accountInfo.loginType == 4) {
                    this.mTypeIcon.setImageResource(R.drawable.line_phone_selector);
                } else if (info.accountInfo.loginType == 5) {
                    this.mTypeIcon.setImageResource(R.drawable.login_vk_selector);
                } else if (info.accountInfo.loginType == 2) {
                    this.mTypeIcon.setImageResource(R.drawable.login_phone_selector);
                } else if (info.accountInfo.loginType == 7) {
                    this.mTypeIcon.setImageResource(R.drawable.login_zalo);
                }
                if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTLoginAccount", (String)"type:%d name:%s icon:%s", (Object[])new Object[]{info.accountInfo.loginType, info.userInfo.getNick(), info.userInfo.getAvatar()});
                }
                ImageLoader.loadImage((RecycleImageView)this.mIcon, (String)(info.userInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)(info.userInfo.getSex() == 1 ? R.drawable.icon_avatar_default_male : R.drawable.icon_avatar_default_female));
                if (info.accountInfo != null && AccountUtil.getUid() > 0L && AccountUtil.getUid() == info.accountInfo.uuid) {
                    this.mTagView.setVisibility(0);
                } else {
                    this.mTagView.setVisibility(8);
                }
                this.mTitleView.setText((CharSequence)info.userInfo.getNick());
            }
            if (callFrom == 14) {
                this.mDeleteView.setVisibility(4);
                if (position == accountList.size() - 1) {
                    this.mLineView.setVisibility(8);
                } else {
                    this.mLineView.setVisibility(0);
                }
            } else {
                this.mDeleteView.setVisibility(0);
                this.mLineView.setVisibility(8);
            }
        }
    }

    private static class DeletePopWindow
    extends PopupWindow {
        private AccountInfoEx mAccountInfo;
        private AccountSelectDialog mSelectDialog;

        DeletePopWindow(Context context, AccountInfoEx accountInfo, AccountSelectDialog selectDialog) {
            super(context);
            this.mAccountInfo = accountInfo;
            this.mSelectDialog = selectDialog;
            this.initView(context);
        }

        private void initView(Context context) {
            View container = View.inflate((Context)context, (int)R.layout.pop_login_account_delete_layout, null);
            View deleteView = container.findViewById(R.id.popDeleteLl);
            deleteView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    this.dismiss();
                    if (mSelectDialog != null) {
                        mSelectDialog.onClearClicked(mAccountInfo);
                    }
                }
            });
            this.setContentView(container);
            this.setWidth(-2);
            this.setHeight(-2);
            this.setOutsideTouchable(true);
            this.setBackgroundDrawable((Drawable)new ColorDrawable(ResourceUtils.getColor((int)R.color.transparent)));
        }
    }
}

