/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.relogin;

import android.content.DialogInterface;
import android.os.SystemClock;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountListManager;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.relogin.AccountInfoEx;
import com.yy.hiyo.login.relogin.AccountSelectDialog;
import com.yy.hiyo.login.relogin.IDialogCallBack;
import com.yy.hiyo.login.request.ILoginRequestCallBack;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Call;

public class AccountReLoginController
extends AbstractLoginer {
    private static final int MAX_ACCOUNT_TO_SHOW = 3;
    private static final String TAG = "FTLoginAccount";
    private boolean mNeedShowLoadingDialogInNextRunnable = false;
    private AccountSelectDialog mAccountSelectDialog;
    private int mCallFrom = 10;
    private int mLoginOutBy;
    private int mSelectIndex;
    private IAB mReLoginOptTest;

    public AccountReLoginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 6);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
    }

    public AccountReLoginController updateCallFrom(int callFrom) {
        this.mCallFrom = callFrom;
        return this;
    }

    public int getCallFrom() {
        return this.mCallFrom;
    }

    public AccountReLoginController updateLoginOutBy(int loginOutBy) {
        this.mLoginOutBy = loginOutBy;
        return this;
    }

    private String getReportSource() {
        return String.valueOf(this.mCallFrom);
    }

    private boolean isReLoginOptimized() {
        if (this.mReLoginOptTest == null && NewABDefine.RELOGIN_DIALOG_OPT.isTestValid()) {
            this.mReLoginOptTest = NewABDefine.RELOGIN_DIALOG_OPT.getTest();
        }
        MLog.debug((Object)"AccountReloginController", (String)("isReLoginOptimiezed test: " + this.mReLoginOptTest), (Object[])new Object[0]);
        return NAB.B.equals((Object)this.mReLoginOptTest);
    }

    @Override
    public void openLoginWindow() {
        if (this.mLoginOutBy == 4) {
            return;
        }
        if (!SettingFlags.getBoolean((String)"accountlogin", (boolean)true)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"open account switch dialog ignore, switch not open", (Object[])new Object[0]);
            }
            return;
        }
        this.showLoginedAccountListDialogIfNeed();
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (NotificationDef.N_LOGIN_SUCCESS == notification.id) {
            this.mNeedShowLoadingDialogInNextRunnable = false;
            this.mLoginOutBy = -1;
        }
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        if (callBack != null) {
            callBack.onError(String.valueOf(105), "");
        }
    }

    private void showAccountHistoryLoadingDialog() {
        this.mNeedShowLoadingDialogInNextRunnable = true;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!AccountReLoginController.this.mNeedShowLoadingDialogInNextRunnable) {
                    return;
                }
                ProgressDialog dialog = new ProgressDialog("", false, false, null);
                AccountReLoginController.this.getDialogLinkManager().showDialog((BaseDialog)dialog);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)AccountReLoginController.TAG, (String)"showloading dialog", (Object[])new Object[0]);
                }
            }
        }, (long)300L);
    }

    private void hideAccountHistoryLoadingDialog() {
        this.mNeedShowLoadingDialogInNextRunnable = false;
        this.getDialogLinkManager().dismissDialog();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"hide loading dialog", (Object[])new Object[0]);
        }
    }

    private List<AccountInfoEx> transformAccountList(List<AccountInfo> list) {
        if (list == null || list.size() <= 0) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)TAG, (String)"accounts Empty!", (Object[])new Object[0]);
            }
            return Collections.emptyList();
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"accounts size:%d!", (Object[])new Object[]{list.size()});
        }
        ArrayList<AccountInfoEx> accountInfosToShow = new ArrayList<AccountInfoEx>(3);
        for (AccountInfo info : list) {
            if (info == null || info.loginType == 10 || info.loginType <= 0 || info.uuid <= 0L) continue;
            accountInfosToShow.add(new AccountInfoEx(info, null));
            if (accountInfosToShow.size() < 3) continue;
            break;
        }
        return accountInfosToShow;
    }

    private void showLoginedAccountListDialogIfNeed() {
        if (this.mAccountSelectDialog != null) {
            return;
        }
        this.getDialogLinkManager().dismissDialog();
        this.showAccountHistoryLoadingDialog();
        AccountModel.getInstance().getAccountsHasLogined(new AccountListManager.IObtainCallBack(){

            public void onCallBackOnUiThread(List<AccountInfo> list) {
                final List accountInfosToShow = AccountReLoginController.this.transformAccountList(list);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)AccountReLoginController.TAG, (String)"to show accounts size: %d", (Object[])new Object[]{accountInfosToShow.size()});
                }
                if (accountInfosToShow.isEmpty()) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)AccountReLoginController.TAG, (String)"accounts Empty!", (Object[])new Object[0]);
                    }
                    AccountReLoginController.this.hideAccountHistoryLoadingDialog();
                    return;
                }
                if (AccountReLoginController.this.mCallFrom != 14 && !AccountReLoginController.this.isReLoginOptimized() && AccountReLoginController.this.mLoginOutBy == 1 && accountInfosToShow.size() <= 1) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)AccountReLoginController.TAG, (String)("sign click, hide, accountInfoList: " + accountInfosToShow.size()), (Object[])new Object[0]);
                    }
                    AccountReLoginController.this.hideAccountHistoryLoadingDialog();
                    return;
                }
                ArrayList<Long> uids = new ArrayList<Long>(accountInfosToShow.size());
                for (AccountInfo info : list) {
                    uids.add(info.uuid);
                }
                List userInfosFromCache = ((IUserInfoService)AccountReLoginController.this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uids, new OnProfileListCallback(){

                    public void onUISuccess(List<UserInfoBean> userInfos) {
                        if (userInfos == null || userInfos.size() <= 0 || AccountReLoginController.this.mAccountSelectDialog == null) {
                            return;
                        }
                        AccountReLoginController.this.showAccountSelectDialog(userInfos, accountInfosToShow);
                    }

                    public void onError(Call call, Exception e, int id2) {
                        if (AccountReLoginController.this.mAccountSelectDialog == null) {
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AccountReLoginController.this.hideAccountHistoryLoadingDialog();
                                }
                            });
                        }
                        FeatureLog.e((String)AccountReLoginController.TAG, (String)(e != null ? e.toString() : ""), (Object[])new Object[0]);
                    }

                    public void onResponseError(int id2, String message, String response) {
                        if (AccountReLoginController.this.mAccountSelectDialog == null) {
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AccountReLoginController.this.hideAccountHistoryLoadingDialog();
                                }
                            });
                        }
                        if (message == null) {
                            message = "";
                        }
                        if (response == null) {
                            response = "";
                        }
                        FeatureLog.e((String)AccountReLoginController.TAG, (String)(message + response), (Object[])new Object[0]);
                    }
                });
                AccountReLoginController.this.showAccountSelectDialog(userInfosFromCache, accountInfosToShow);
            }
        });
    }

    private void showAccountSelectDialog(List<UserInfoBean> userInfoList, List<AccountInfoEx> accountInfoList) {
        List<AccountInfoEx> accountInfosToShowWithUserInfo = null;
        if (accountInfoList != null) {
            accountInfosToShowWithUserInfo = new ArrayList(accountInfoList.size());
            UserInfoBean userInfoBean = null;
            int index = 1;
            for (AccountInfoEx info : accountInfoList) {
                userInfoBean = null;
                if (userInfoList != null) {
                    for (UserInfoBean item : userInfoList) {
                        if (item == null || item.getUid() != info.accountInfo.uuid) continue;
                        userInfoBean = item;
                        break;
                    }
                }
                if (userInfoBean != null) {
                    info.updateUserInfo(userInfoBean);
                } else if (StringUtils.isNotEmpty((String)info.accountInfo.userName) && StringUtils.isNotEmpty((String)info.accountInfo.iconUrl) && info.accountInfo.vid > 0L) {
                    userInfoBean = new UserInfoBean();
                    userInfoBean.setAvatar(info.accountInfo.iconUrl);
                    userInfoBean.setNick(info.accountInfo.userName);
                    userInfoBean.setSex(info.accountInfo.sex);
                    userInfoBean.setVid(info.accountInfo.vid);
                    info.updateUserInfo(userInfoBean);
                }
                if (userInfoBean == null) continue;
                info.statIndex = index++;
                accountInfosToShowWithUserInfo.add(info);
            }
        } else {
            accountInfosToShowWithUserInfo = Collections.emptyList();
        }
        if (!accountInfosToShowWithUserInfo.isEmpty()) {
            if (this.mAccountSelectDialog != null) {
                this.mAccountSelectDialog.updateList(accountInfosToShowWithUserInfo);
            } else {
                this.showAccountSelectDialog(accountInfosToShowWithUserInfo);
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"showAccountSelectDialog fail, account list is empty", (Object[])new Object[0]);
        }
    }

    private boolean isAccountSelectDialogCancelable() {
        boolean cancelable = true;
        if (this.mCallFrom != 14 && this.isReLoginOptimized()) {
            cancelable = false;
        }
        return cancelable;
    }

    private void showAccountSelectDialog(List<AccountInfoEx> accountInfosToShow) {
        AccountSelectDialog dialog;
        if (accountInfosToShow == null || accountInfosToShow.size() <= 0) {
            return;
        }
        this.hideAccountHistoryLoadingDialog();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"showAccountsSelectDialog", (Object[])new Object[0]);
        }
        boolean cancelable = this.isAccountSelectDialogCancelable();
        this.mAccountSelectDialog = dialog = new AccountSelectDialog(this.mCallFrom, accountInfosToShow, cancelable, cancelable, new IDialogCallBack(){

            @Override
            public void onDismiss(DialogInterface dialog) {
                AccountReLoginController.this.mAccountSelectDialog = null;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)AccountReLoginController.TAG, (String)"AccountsSelectDialog dismissed!", (Object[])new Object[0]);
                }
            }

            @Override
            public void onSelectClicked(AccountInfoEx accountInfo) {
                AccountReLoginController.this.handleAccountSelect(accountInfo);
            }

            @Override
            public void onClearClicked(AccountInfoEx accountInfo) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)AccountReLoginController.TAG, (String)"AccountsSelectDialog onClearClicked %d!", (Object[])new Object[]{accountInfo != null ? accountInfo.accountInfo.uuid : -1L});
                }
                if (accountInfo != null) {
                    AccountModel.getInstance().deleteHasLoginedAccount(accountInfo.accountInfo.uuid);
                    HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "history_delete").put("history_id", String.valueOf(accountInfo.statIndex)).put("click_source", AccountReLoginController.this.getReportSource()));
                }
            }

            @Override
            public void onNoneAboveClicked() {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)AccountReLoginController.TAG, (String)"AccountsSelectDialog onNoneAboveClicked!", (Object[])new Object[0]);
                }
            }

            @Override
            public void onCancel() {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)AccountReLoginController.TAG, (String)"AccountsSelectDialog onCancelClicked!", (Object[])new Object[0]);
                }
            }
        });
        this.getDialogLinkManager().showDialog((BaseDialog)dialog);
        HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "history_show").put("history_id", String.valueOf(accountInfosToShow.size())).put("click_source", this.getReportSource()));
    }

    @Override
    public String getCurLoginAccount() {
        return String.valueOf(this.mSelectIndex);
    }

    private void handleAccountSelect(final AccountInfoEx accountInfo) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"AccountsSelectDialog onSelectClicked %d!", (Object[])new Object[]{accountInfo != null ? accountInfo.accountInfo.uuid : -1L});
        }
        if (accountInfo != null) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "history_click").put("history_id", String.valueOf(accountInfo.statIndex)).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("click_source", this.getReportSource()));
            if (accountInfo.accountInfo.uuid == AccountUtil.getUid()) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"AccountsSelectDialog select Click ignore, click account is current logined", (Object[])new Object[0]);
                }
                return;
            }
            if (AccountModel.getInstance().isAccountValidIncludeToken(accountInfo.accountInfo) && StringUtils.isNotEmpty((String)accountInfo.accountInfo.sessionKey)) {
                this.mLoginCallBack.onLoginStart(this);
                this.mSelectIndex = accountInfo.statIndex;
                final long startTime = SystemClock.uptimeMillis();
                this.mLoginCallBack.getLoginRequester().refreshAccountToken(accountInfo.accountInfo.uuid, accountInfo.accountInfo.token, accountInfo.accountInfo.sessionKey, new ILoginRequestCallBack(){

                    @Override
                    public void onSuccess(LoginData data) {
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)AccountReLoginController.TAG, (String)"AccountsSelectDialog login success %s!", (Object[])new Object[]{data != null ? data : ""});
                        }
                        if (data != null) {
                            AccountInfo account = AccountInfo.obtain((LoginData)data);
                            account.loginType = accountInfo.accountInfo.loginType;
                            account.resultType = 1;
                            AccountReLoginController.this.updateLoginType(6);
                            AccountReLoginController.this.mLoginCallBack.onLoginSuccess(AccountReLoginController.this, account);
                            HiidoStatis.reportAppMonitorReturnCode((String)"hylogin/accouttoken", (long)(SystemClock.uptimeMillis() - startTime), (String)"0");
                        } else {
                            HiidoStatis.reportAppMonitorReturnCode((String)"hylogin/accouttoken", (long)(SystemClock.uptimeMillis() - startTime), (String)"10000");
                            AccountReLoginController.this.mLoginCallBack.onLoginError(AccountReLoginController.this, true, "loginData null", "");
                            AccountReLoginController.this.loginByOtherType(accountInfo);
                        }
                    }

                    @Override
                    public void onError(String errorCode, String errorDescription, String exceptionDue) {
                        HiidoStatis.reportAppMonitorReturnCode((String)"hylogin/accouttoken", (long)(SystemClock.uptimeMillis() - startTime), (String)errorCode);
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)AccountReLoginController.TAG, (String)"AccountsSelectDialog login error:errorCode %s errorDescription:%s exceptionDue\uff1a%s!", (Object[])new Object[]{errorCode, errorDescription, exceptionDue});
                        }
                        AccountReLoginController.this.mLoginCallBack.onLoginError(AccountReLoginController.this, true, errorCode, errorDescription + exceptionDue);
                        AccountReLoginController.this.loginByOtherType(accountInfo);
                    }
                });
            } else {
                this.loginByOtherType(accountInfo);
            }
        }
    }

    private void loginByOtherType(AccountInfoEx accountInfoEx) {
        if (accountInfoEx == null || accountInfoEx.accountInfo == null) {
            MLog.debug((Object)TAG, (String)"loginByOtherType fail, accountInfo is null", (Object[])new Object[0]);
            return;
        }
        this.updateLoginType(accountInfoEx.accountInfo.loginType);
        if (this.mLoginCallBack != null) {
            this.mLoginCallBack.loginByOtherType(this.mCallFrom, accountInfoEx.accountInfo.loginType, accountInfoEx.accountInfo.uuid);
        }
    }
}

