/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone.windows;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.lang.ref.WeakReference;

public class ShakeAnim {
    private static final long CODE_ANIM_INTERVAL = 2000L;
    private static final long START_DELAY = 3000L;
    private Runnable mCodeAnimTask;
    private Runnable mCodeAnimRepeatTask;
    private WeakReference<View> mTargetViewRef;
    private long mStartDelay;
    private Animator mAnimator;
    private float[] mScaleAttrs = new float[]{1.0f, 1.2f, 0.8f, 1.0f};
    private int mAnimCount = -1;
    private int mCurrentCount = 0;

    private ShakeAnim(View targetView, long startDelay) {
        this.mTargetViewRef = new WeakReference<View>(targetView);
        this.mStartDelay = startDelay;
    }

    public static ShakeAnim of(View targetView) {
        return new ShakeAnim(targetView, 3000L);
    }

    public static ShakeAnim of(View targetView, long startDelay) {
        return new ShakeAnim(targetView, startDelay);
    }

    public ShakeAnim ofScale(float ... values) {
        this.mScaleAttrs = values;
        return this;
    }

    public ShakeAnim ofCount(int count) {
        this.mAnimCount = count <= 0 ? -1 : count;
        return this;
    }

    public void start() {
        if (this.mCodeAnimTask == null) {
            this.mCodeAnimTask = new Runnable(){

                @Override
                public void run() {
                    ShakeAnim.this.repeatCodeAnim();
                }
            };
        }
        this.stop(true);
        YYTaskExecutor.postToMainThread((Runnable)this.mCodeAnimTask, (long)this.mStartDelay);
    }

    private void startScaleCodeAnim() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])this.mScaleAttrs);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float scale = ((Float)animation.getAnimatedValue()).floatValue();
                View target = (View)ShakeAnim.this.mTargetViewRef.get();
                if (target != null) {
                    target.setScaleX(scale);
                    target.setScaleY(scale);
                }
            }
        });
        animator.setDuration(800L);
        animator.start();
        this.mAnimator = animator;
    }

    private void repeatCodeAnim() {
        if (this.mCodeAnimRepeatTask == null) {
            this.mCodeAnimRepeatTask = new Runnable(){

                @Override
                public void run() {
                    if (ShakeAnim.this.mAnimCount > 0) {
                        ShakeAnim.this.mCurrentCount++;
                    }
                    if (ShakeAnim.this.mAnimCount == -1 || ShakeAnim.this.mCurrentCount <= ShakeAnim.this.mAnimCount) {
                        ShakeAnim.this.startScaleCodeAnim();
                        YYTaskExecutor.postToMainThread((Runnable)this, (long)2000L);
                    } else {
                        MLog.debug((Object)"ShakeAnim", (String)"\u52a8\u753b\u7ed3\u675f\uff0c\u6b21\u6570:%d \u5df2\u7ecf\u8d85\u8fc7\u89c4\u5b9a: %d", (Object[])new Object[]{ShakeAnim.this.mCurrentCount, ShakeAnim.this.mAnimCount});
                    }
                }
            };
        }
        YYTaskExecutor.removeTask((Runnable)this.mCodeAnimRepeatTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mCodeAnimRepeatTask);
    }

    public void stop(boolean resetScale) {
        YYTaskExecutor.removeTask((Runnable)this.mCodeAnimTask);
        YYTaskExecutor.removeTask((Runnable)this.mCodeAnimRepeatTask);
        View targetView = (View)this.mTargetViewRef.get();
        if (targetView != null) {
            targetView.clearAnimation();
        }
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        this.mCurrentCount = 0;
        if (resetScale) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    View targetView = (View)ShakeAnim.this.mTargetViewRef.get();
                    if (targetView != null) {
                        targetView.setScaleY(1.0f);
                        targetView.setScaleY(1.0f);
                    }
                }
            });
        }
    }
}

