/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone.windows;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.R;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.common.Callback;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.ui.widget.bar.CommonTitleBar;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.LoginTypeConfigData;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.LoginTrack;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.base.utils.NextBtn;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.bean.LoginSmallIconInfo;
import com.yy.hiyo.login.bean.PhoneActionParam;
import com.yy.hiyo.login.phone.ILoginItem;
import com.yy.hiyo.login.phone.ILoginItemListener;
import com.yy.hiyo.login.phone.IPhoneLoginUiCallback;
import com.yy.hiyo.login.phone.PhoneLoginController;
import com.yy.hiyo.login.phone.views.NextSplashLightBtn;
import com.yy.hiyo.login.phone.views.PhoneCodeItem;
import com.yy.hiyo.login.phone.views.PhoneNumberItem;
import com.yy.hiyo.login.phone.views.PhonePasswordItem;
import com.yy.hiyo.login.phone.windows.OtherLoginDialog;
import com.yy.hiyo.login.request.ILoginRequester;
import com.yy.hiyo.login.utils.LoginTypeContainerHelper;
import com.yy.hiyo.login.view.LoginSmallBtn;
import java.util.Collection;
import java.util.List;

public class PhoneLoginWindow
extends DefaultWindow
implements View.OnClickListener,
IConfigListener<LoginTypeConfigData> {
    private static final String TAG = "PhoneLoginWindow";
    private PhoneLoginController mLoginer;
    private IPhoneLoginUiCallback mPhoneUiCallBack;
    private OtherLoginDialog.IOtherLoginListener mListener;
    private CommonTitleBar mTitleBar;
    private PhoneNumberItem mPhoneNumItem;
    private PhoneCodeItem mPhoneCodeItem;
    private PhonePasswordItem mOldPwdItem;
    private PhonePasswordItem mNewPwdItem;
    private PhonePasswordItem mConfirmPwdItem;
    private ViewGroup mBottomLayout;
    private LinearLayout mOtherWayContainer;
    private NextSplashLightBtn mGoBtnLayout;
    private NextBtn mGoBtn;
    private YYTextView mExtraEntranceTv;
    private ViewGroup mExtraEntranceLl;
    private YYTextView mForgetEntranceTv;
    private YYTextView mSmsCodeEntranceTv;
    private YYTextView mTipView;
    private YYTextView mPwdDescView;
    private int mPhoneMode;
    private ILoginItemListener mItemListener = new ILoginItemListener(){

        @Override
        public void onItemComplete(boolean isComplete) {
            MLog.debug((Object)PhoneLoginWindow.TAG, (String)"onItemComplete mode: %d", (Object[])new Object[]{PhoneLoginWindow.this.getLoginMode()});
            switch (PhoneLoginWindow.this.getLoginMode()) {
                case 1: {
                    PhoneLoginWindow.this.mGoBtnLayout.setEnabled(PhoneLoginWindow.this.mPhoneNumItem.isComplete() && PhoneLoginWindow.this.mConfirmPwdItem.isComplete() && PhoneLoginWindow.this.mConfirmPwdItem.hasInput());
                    break;
                }
                case 0: {
                    PhoneLoginWindow.this.mPhoneCodeItem.setCodeBtnEnable(PhoneLoginWindow.this.mPhoneNumItem.isComplete() && !PhoneLoginWindow.this.mPhoneUiCallBack.isCodeRendering());
                    PhoneLoginWindow.this.mGoBtnLayout.setEnabled(PhoneLoginWindow.this.mPhoneCodeItem.isComplete() && PhoneLoginWindow.this.mPhoneNumItem.isComplete());
                    break;
                }
                case 3: {
                    PhoneLoginWindow.this.mPhoneCodeItem.setCodeBtnEnable(PhoneLoginWindow.this.mPhoneNumItem.isComplete() && !PhoneLoginWindow.this.mPhoneUiCallBack.isCodeRendering());
                    PhoneLoginWindow.this.mGoBtnLayout.setEnabled(PhoneLoginWindow.this.mPhoneCodeItem.isComplete() && PhoneLoginWindow.this.mPhoneNumItem.isComplete() && PhoneLoginWindow.this.mConfirmPwdItem.isComplete());
                    break;
                }
                case 4: {
                    PhoneLoginWindow.this.mPhoneCodeItem.setCodeBtnEnable(PhoneLoginWindow.this.mPhoneNumItem.isComplete() && !PhoneLoginWindow.this.mPhoneUiCallBack.isCodeRendering());
                    PhoneLoginWindow.this.mGoBtnLayout.setEnabled(PhoneLoginWindow.this.mPhoneCodeItem.isComplete() && PhoneLoginWindow.this.mPhoneNumItem.isComplete() && PhoneLoginWindow.this.mConfirmPwdItem.isComplete());
                    break;
                }
                case 5: {
                    PhoneLoginWindow.this.mPhoneCodeItem.setCodeBtnEnable(PhoneLoginWindow.this.mPhoneNumItem.isComplete() && !PhoneLoginWindow.this.mPhoneUiCallBack.isCodeRendering());
                    PhoneLoginWindow.this.mGoBtnLayout.setEnabled(PhoneLoginWindow.this.mPhoneCodeItem.isComplete() && PhoneLoginWindow.this.mConfirmPwdItem.isComplete());
                    break;
                }
                case 6: {
                    PhoneLoginWindow.this.mGoBtnLayout.setEnabled(PhoneLoginWindow.this.mOldPwdItem.isComplete() && PhoneLoginWindow.this.mNewPwdItem.isComplete() && PhoneLoginWindow.this.mConfirmPwdItem.isComplete());
                    break;
                }
            }
        }
    };

    public PhoneLoginWindow(Context context, PhoneLoginController loginer, IPhoneLoginUiCallback callBacks, OtherLoginDialog.IOtherLoginListener listener, int mode, String name) {
        super(context, (UICallBacks)callBacks, name);
        this.mLoginer = loginer;
        this.mPhoneUiCallBack = callBacks;
        this.mListener = listener;
        this.mPhoneMode = mode;
        this.initViews();
        LoginTrack.reportPhoneWindowShow(mode);
    }

    private int getLoginMode() {
        return this.mPhoneMode;
    }

    private void bindLoginType() {
        MLog.debug((Object)TAG, (String)"bindLoginType", (Object[])new Object[0]);
        if (this.mLoginer != null) {
            JLoginTypeInfo loginTypeInfo = this.mLoginer.getLoginTypeInfo();
            Kvo.removeKvoBinding((KvoSource)loginTypeInfo, (Object)((Object)this), (String)"receiveLoginSecondUpdate");
            Kvo.addKvoBinding((KvoSource)loginTypeInfo, (Object)((Object)this), (String)"receiveLoginSecondUpdate");
            Kvo.removeKvoBinding((KvoSource)loginTypeInfo, (Object)((Object)this), (String)"receiveLoginUpdateUpdate");
            Kvo.addKvoBinding((KvoSource)loginTypeInfo, (Object)((Object)this), (String)"receiveLoginUpdateUpdate");
        }
    }

    private void unbindLoginType() {
        MLog.debug((Object)TAG, (String)"unbindLoginType", (Object[])new Object[0]);
        if (this.mLoginer != null) {
            JLoginTypeInfo loginTypeInfo = this.mLoginer.getLoginTypeInfo();
            Kvo.removeKvoBinding((KvoSource)loginTypeInfo, (Object)((Object)this), (String)"receiveLoginSecondUpdate");
            Kvo.removeKvoBinding((KvoSource)loginTypeInfo, (Object)((Object)this), (String)"receiveLoginUpdateUpdate");
        }
    }

    @KvoMethodAnnotation(name="totalTypeList", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginSecondUpdate(KvoEventIntent event) {
        this.updateOtherLogin((List)event.newValue());
    }

    @KvoMethodAnnotation(name="updateTypeList", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginUpdateUpdate(KvoEventIntent event) {
        List updateList = (List)event.newValue();
        if (!FP.empty((Collection)updateList)) {
            for (LoginTypeData u : updateList) {
                LoginTypeContainerHelper.updateLoginType(this.mOtherWayContainer, u);
            }
        }
    }

    private void initViews() {
        this.setBackgroundColor(ResourceUtils.getColor((int)R.color.common_window_white_bg));
        View rootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_phone_login_page, null);
        this.mTitleBar = (CommonTitleBar)rootView.findViewById(R.id.titleBar);
        this.mPwdDescView = (YYTextView)rootView.findViewById(R.id.passwordTipTv);
        this.mPhoneNumItem = (PhoneNumberItem)rootView.findViewById(R.id.phoneNumItem);
        this.mPhoneCodeItem = (PhoneCodeItem)rootView.findViewById(R.id.phoneCodeItem);
        this.mOldPwdItem = (PhonePasswordItem)rootView.findViewById(R.id.oldPwdItem);
        this.mNewPwdItem = (PhonePasswordItem)rootView.findViewById(R.id.newPwdItem);
        this.mConfirmPwdItem = (PhonePasswordItem)rootView.findViewById(R.id.confirmPwdItem);
        this.mGoBtnLayout = (NextSplashLightBtn)rootView.findViewById(R.id.phoneActionBtn);
        this.mGoBtnLayout.setNextBtnAnimDuration(800L);
        this.mGoBtn = this.mGoBtnLayout.getNextBtn();
        View tipContainer = rootView.findViewById(R.id.phoneTipLl);
        this.mTipView = (YYTextView)tipContainer.findViewById(R.id.phoneTipTv);
        this.mTipView.setVisibility(4);
        this.mExtraEntranceTv = (YYTextView)rootView.findViewById(R.id.extraEntranceTv);
        this.mExtraEntranceLl = (ViewGroup)rootView.findViewById(R.id.extraEntranceLl);
        this.mForgetEntranceTv = (YYTextView)this.mExtraEntranceLl.findViewById(R.id.forgetPwdTv);
        this.mSmsCodeEntranceTv = (YYTextView)this.mExtraEntranceLl.findViewById(R.id.smsCodeTv);
        this.mForgetEntranceTv.getPaint().setFlags(8);
        this.mForgetEntranceTv.getPaint().setAntiAlias(true);
        this.mSmsCodeEntranceTv.getPaint().setFlags(8);
        this.mSmsCodeEntranceTv.getPaint().setAntiAlias(true);
        this.mBottomLayout = (ViewGroup)rootView.findViewById(R.id.phoneBottomLayout);
        this.mOtherWayContainer = (LinearLayout)this.mBottomLayout.findViewById(R.id.ll_login_other_way_container);
        this.getBaseLayer().addView(rootView, new ViewGroup.LayoutParams(-1, -1));
        this.mTitleBar.updateData(R.drawable.icon_nav_back, "", -1, "");
        this.initListener();
        this.initTypeAndMode();
    }

    private void initListener() {
        this.mTitleBar.setClickListeners(new View.OnClickListener(){

            public void onClick(View view) {
                if (PhoneLoginWindow.this.mPhoneUiCallBack != null) {
                    PhoneLoginWindow.this.mPhoneUiCallBack.onBackIconClicked((AbstractWindow)PhoneLoginWindow.this);
                }
            }
        }, null, new View.OnClickListener(){

            public void onClick(View v) {
                if (PhoneLoginWindow.this.mPhoneUiCallBack != null) {
                    PhoneLoginWindow.this.mPhoneUiCallBack.onGoPhoneWindow(3);
                }
                if (PhoneLoginWindow.this.mLoginer != null) {
                    LoginTrack.reportSignClick(PhoneLoginWindow.this.mLoginer.getLocalReportAB());
                }
            }
        });
        this.mGoBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhoneLoginWindow.this.handleGoAction();
            }
        });
        this.mForgetEntranceTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhoneLoginWindow.this.mPhoneUiCallBack != null) {
                    PhoneLoginWindow.this.mPhoneUiCallBack.onGoPhoneWindow(4);
                }
                if (PhoneLoginWindow.this.mLoginer != null) {
                    LoginTrack.reportForgetPwdClick(PhoneLoginWindow.this.mLoginer.getLocalReportAB());
                }
            }
        });
        this.mSmsCodeEntranceTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhoneLoginWindow.this.mPhoneUiCallBack != null) {
                    PhoneLoginWindow.this.mPhoneUiCallBack.onGoPhoneWindow(0);
                }
                if (PhoneLoginWindow.this.mLoginer != null) {
                    LoginTrack.reportSmsLoginClick(PhoneLoginWindow.this.mLoginer.getLocalReportAB());
                }
            }
        });
        this.mPhoneNumItem.observeListener(this.mItemListener);
        this.mPhoneNumItem.setCountryClick(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhoneLoginWindow.this.mPhoneUiCallBack != null) {
                    PhoneLoginWindow.this.mPhoneUiCallBack.onCountryClicked();
                }
            }
        });
        this.mPhoneCodeItem.observeListener(this.mItemListener);
        this.mPhoneCodeItem.setCodeBtnClick(new View.OnClickListener(){

            public void onClick(View v) {
                PhoneLoginWindow.this.mPhoneCodeItem.setCodeBtnEnable(false);
                if (PhoneLoginWindow.this.mPhoneUiCallBack != null) {
                    PhoneLoginWindow.this.mPhoneUiCallBack.onPhoneNumReady(PhoneLoginWindow.this.mPhoneNumItem.getPhoneNumFormat(), PhoneLoginWindow.this.mPhoneNumItem.getCountry(), PhoneLoginWindow.this.mPhoneNumItem.getCountryCode(), new Callback<Boolean>(){

                        public void onResponse(Boolean sent) {
                            MLog.debug((Object)PhoneLoginWindow.TAG, (String)("send code response: " + sent), (Object[])new Object[0]);
                            if (sent.booleanValue()) {
                                if (PhoneLoginWindow.this.getLoginMode() == 4 || PhoneLoginWindow.this.getLoginMode() == 3 || PhoneLoginWindow.this.getLoginMode() == 5) {
                                    PhoneLoginWindow.this.mTipView.setVisibility(0);
                                    PhoneLoginWindow.this.mTipView.setOnClickListener(null);
                                    PhoneLoginWindow.this.mTipView.setText((CharSequence)ResourceUtils.getString((int)R.string.login_phone_sms_sent_notice_tip));
                                }
                                PhoneLoginWindow.this.showSoftInputIfNeed();
                            }
                        }
                    });
                }
                LoginTrack.reportSmsCodeSendClick(PhoneLoginWindow.this.getLoginMode());
            }
        });
        this.mOldPwdItem.observeListener(this.mItemListener);
        this.mNewPwdItem.observeListener(this.mItemListener);
        this.mConfirmPwdItem.observeListener(this.mItemListener);
    }

    private void updateOtherLogin(List<LoginTypeData> secondTypeList) {
        if (secondTypeList != null) {
            LinearLayout container = this.mOtherWayContainer;
            container.removeAllViews();
            if (secondTypeList.size() > 0) {
                this.mBottomLayout.setVisibility(0);
                for (LoginTypeData loginType : secondTypeList) {
                    if (loginType == null || loginType.getType() == this.mLoginer.getSelectLoginType() || loginType == LoginTypeData.GUEST) continue;
                    LoginSmallBtn btn = LoginSmallBtn.create(loginType);
                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(LoginSmallBtn.generateDefaultParams());
                    btn.setLayoutParams((ViewGroup.LayoutParams)lp);
                    btn.setOnClickListener(this);
                    container.addView((View)btn);
                }
            } else {
                this.mBottomLayout.setVisibility(8);
            }
        }
    }

    public void onUpdateConfig(@Nullable LoginTypeConfigData data) {
        this.updatePwdRule(data);
    }

    private void handleGoAction() {
        ImeUtil.hideIME((Activity)((Activity)this.getContext()));
        if (this.mPhoneUiCallBack != null) {
            this.mPhoneUiCallBack.onGoAction(this.getActionParam());
        }
    }

    @Nullable
    private PhoneActionParam getActionParam() {
        PhoneActionParam param = new PhoneActionParam(this.getLoginMode());
        switch (param.getMode()) {
            case 1: {
                param.setConfirmPassword(this.mConfirmPwdItem.getPasswordText());
                break;
            }
            case 0: {
                param.setCodeFormat(this.mPhoneCodeItem.getCodeFormat());
                break;
            }
            case 3: {
                param.setCodeFormat(this.mPhoneCodeItem.getCodeFormat());
                param.setConfirmPassword(this.mConfirmPwdItem.getPasswordText());
                if (this.mConfirmPwdItem.isComplete()) break;
                SingleToastUtil.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.login_phone_pwd_not_match_rule_warning));
                return null;
            }
            case 4: {
                param.setCodeFormat(this.mPhoneCodeItem.getCodeFormat());
                param.setConfirmPassword(this.mConfirmPwdItem.getPasswordText());
                if (this.mConfirmPwdItem.isComplete()) break;
                SingleToastUtil.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.login_phone_pwd_not_match_rule_warning));
                return null;
            }
            case 5: {
                param.setCodeFormat(this.mPhoneCodeItem.getCodeFormat());
                param.setConfirmPassword(this.mConfirmPwdItem.getPasswordText());
                if (this.mConfirmPwdItem.isComplete()) break;
                SingleToastUtil.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.login_phone_pwd_not_match_rule_warning));
                LoginTrack.reportPhonePwdSetResult(false, "1");
                return null;
            }
            case 6: {
                param.setOldPassword(this.mOldPwdItem.getPasswordText());
                param.setNewPassword(this.mNewPwdItem.getPasswordText());
                param.setConfirmPassword(this.mConfirmPwdItem.getPasswordText());
                if (StringUtils.equal((String)param.getOldPassword(), (String)param.getNewPassword()) || StringUtils.equal((String)param.getOldPassword(), (String)param.getConfirmPassword())) {
                    SingleToastUtil.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.login_phone_old_new_same_warning));
                    LoginTrack.reportPhonePwdResetResult(false, "2");
                    return null;
                }
                if (!StringUtils.equal((String)param.getNewPassword(), (String)param.getConfirmPassword())) {
                    SingleToastUtil.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.login_phone_new_confrim_not_same_warning));
                    LoginTrack.reportPhonePwdResetResult(false, "3");
                    return null;
                }
                if (this.mConfirmPwdItem.isComplete()) break;
                SingleToastUtil.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.login_phone_pwd_not_match_rule_warning));
                LoginTrack.reportPhonePwdResetResult(false, "1");
                return null;
            }
        }
        param.setCountry(this.mPhoneNumItem.getCountry());
        param.setCountryCode(this.mPhoneNumItem.getCountryCode());
        param.setPhoneNumFormat(this.mPhoneNumItem.getPhoneNumFormat());
        return param;
    }

    public AbstractLoginer getCurrentLoginController() {
        return this.mLoginer;
    }

    public void fillPhoneCountry(String countryCode, String country, boolean forceFill, boolean autoSendCode) {
        int mode;
        MLog.debug((Object)TAG, (String)"fillPhoneNumber countryCode: %s, country: %s, autoSendCode: %b", (Object[])new Object[]{countryCode, country, autoSendCode});
        if (!forceFill) {
            this.mPhoneNumItem.setCountryInfoIfNeed(countryCode, country);
        } else {
            this.mPhoneNumItem.setCountryInfo(countryCode, country);
        }
        if (autoSendCode && ((mode = this.getLoginMode()) == 0 || mode == 3 || mode == 4)) {
            this.mItemListener.onItemComplete(this.mPhoneNumItem.isComplete());
            if (this.mPhoneCodeItem.isCodeBtnEnable()) {
                this.mPhoneCodeItem.performCodeBtnClick();
            }
        }
        this.showSoftInputIfNeed();
    }

    public void fillPhoneNumber(String phoneNum, boolean forceFill, boolean autoSendCode) {
        int mode;
        MLog.debug((Object)TAG, (String)"fillPhoneNumber phoneNum: %s, autoSendCode: %b", (Object[])new Object[]{phoneNum, autoSendCode});
        if (!forceFill) {
            this.mPhoneNumItem.setPhoneNumIfNeed(phoneNum);
        } else {
            this.mPhoneNumItem.setPhoneNumber(phoneNum);
        }
        if (autoSendCode && ((mode = this.getLoginMode()) == 0 || mode == 3 || mode == 4)) {
            this.mItemListener.onItemComplete(this.mPhoneNumItem.isComplete());
            if (this.mPhoneCodeItem.isCodeBtnEnable()) {
                this.mPhoneCodeItem.performCodeBtnClick();
            }
        }
        this.showSoftInputIfNeed();
    }

    public void fillSmsCode(String smsContent, boolean forceFill, boolean autoGo) {
        MLog.debug((Object)TAG, (String)("fillSmsCode: " + smsContent), (Object[])new Object[0]);
        if (!forceFill) {
            this.mPhoneCodeItem.setCodeIfNeed(smsContent);
        } else {
            this.mPhoneCodeItem.setCode(smsContent);
        }
        if (autoGo) {
            this.mItemListener.onItemComplete(this.mPhoneCodeItem.isComplete());
            if (this.mGoBtn.isEnabled()) {
                MLog.debug((Object)TAG, (String)"fillSmsCode \u89e6\u53d1\u81ea\u52a8\u70b9\u51fb", (Object[])new Object[0]);
                this.mGoBtn.performClick();
            } else {
                MLog.debug((Object)TAG, (String)"fillSmsCode \u65e0\u6cd5\u89e6\u53d1\u81ea\u52a8\u70b9\u51fb\uff0c\u6309\u94ae\u8fd8\u4e0d\u53ef\u7528", (Object[])new Object[0]);
            }
        }
        this.showSoftInputIfNeed();
    }

    private void initTypeAndMode() {
        int loginType = this.mLoginer.getSelectLoginType();
        if (loginType == LoginTypeData.WHATSAPP.getType()) {
            this.initForWhatsApp();
        } else {
            this.initForPhone();
        }
    }

    private void initPhoneDefaultOtherEntrance() {
        this.mExtraEntranceTv.setVisibility(0);
        this.mExtraEntranceTv.setTextColor(ResourceUtils.getColor((int)R.color.login_phone_des));
        this.mExtraEntranceTv.setMovementMethod(LinkMovementMethod.getInstance());
        String tryOtherWays = ResourceUtils.getString((int)R.string.login_try_another_way_span);
        String feedbackContent = ResourceUtils.getString((int)R.string.login_try_another_way_place_holder, (Object[])new Object[]{tryOtherWays});
        SpannableString spannableString = new SpannableString((CharSequence)feedbackContent);
        if (feedbackContent.contains(tryOtherWays)) {
            int start = feedbackContent.indexOf(tryOtherWays);
            int end = feedbackContent.indexOf(tryOtherWays) + tryOtherWays.length();
            spannableString.setSpan((Object)new ClickableSpan(){

                public void onClick(@NonNull View view) {
                    if (PhoneLoginWindow.this.mPhoneUiCallBack != null) {
                        PhoneLoginWindow.this.mPhoneUiCallBack.onJumpToOtherWays();
                    }
                }
            }, start, end, 17);
            spannableString.setSpan((Object)new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.color_ffc102)), start, end, 17);
        }
        this.mExtraEntranceTv.setText((CharSequence)spannableString);
    }

    private void initForWhatsApp() {
        ILoginActionCallBack loginCallBack = this.getCurrentLoginController().getLoginCallBack();
        ILoginRequester loginRequester = null;
        if (loginCallBack != null) {
            loginRequester = loginCallBack.getLoginRequester();
        }
        MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.WHATSAPP_LOGIN_SELECT, (Object)loginRequester);
        this.mTitleBar.updateData(R.drawable.icon_nav_back, ResourceUtils.getString((int)R.string.login_phone_window_title_whatsapp), -1, "", 0x800003);
        this.mPhoneNumItem.setHint(ResourceUtils.getString((int)R.string.login_whatsapp_num_tips));
        this.mPhoneNumItem.setVisibility(0);
        this.mPhoneCodeItem.setVisibility(0);
        this.mOldPwdItem.setVisibility(8);
        this.mNewPwdItem.setVisibility(8);
        this.mConfirmPwdItem.setVisibility(0);
        this.mExtraEntranceLl.setVisibility(8);
        this.initPhoneDefaultOtherEntrance();
        if (this.mLoginer != null) {
            this.updateOtherLogin(this.mLoginer.getLoginTypeInfo().totalTypeList);
        }
    }

    private void initForPhone() {
        this.initPwdRule();
        int loginMode = this.getLoginMode();
        switch (loginMode) {
            case 1: {
                this.mTitleBar.updateData(R.drawable.icon_nav_back, ResourceUtils.getString((int)R.string.login_phone_window_title_password), -1, ResourceUtils.getString((int)R.string.login_phone_window_title_signup), 0x800003);
                this.mTitleBar.setRightTextColor(ResourceUtils.getColor((int)R.color.color_FFC102));
                this.mTitleBar.setRightTextTypeface(Typeface.DEFAULT_BOLD);
                this.mTitleBar.setRightTextSize(16.0f);
                this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_login));
                this.mGoBtn.setContentDescription((CharSequence)"LOGIN");
                this.mPhoneNumItem.setVisibility(0);
                this.mConfirmPwdItem.setVisibility(0);
                this.mExtraEntranceLl.setVisibility(0);
                this.mConfirmPwdItem.setRuleEnable(false);
                break;
            }
            case 3: {
                this.mTitleBar.updateData(R.drawable.icon_nav_back, ResourceUtils.getString((int)R.string.login_phone_window_title_signup), -1, "", 0x800003);
                this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_login));
                this.mGoBtn.setContentDescription((CharSequence)"LOGIN");
                this.mPhoneNumItem.setVisibility(0);
                this.mPhoneCodeItem.setVisibility(0);
                this.mConfirmPwdItem.setVisibility(0);
                this.mPwdDescView.setVisibility(0);
                break;
            }
            case 4: {
                this.mTitleBar.updateData(R.drawable.icon_nav_back, ResourceUtils.getString((int)R.string.login_phone_window_title_setpwd), -1, "", 0x800003);
                this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_login));
                this.mGoBtn.setContentDescription((CharSequence)"LOGIN");
                this.mPhoneNumItem.setVisibility(0);
                this.mPhoneCodeItem.setVisibility(0);
                this.mConfirmPwdItem.setVisibility(0);
                this.mPwdDescView.setVisibility(0);
                break;
            }
            case 5: {
                this.mTitleBar.updateData(R.drawable.icon_nav_back, ResourceUtils.getString((int)R.string.login_phone_window_title_setpwd), -1, "", 0x800003);
                this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_phone_pwd_done_title));
                this.mGoBtn.setContentDescription((CharSequence)"DONE");
                this.mPhoneNumItem.setVisibility(8);
                this.mPhoneCodeItem.setVisibility(0);
                this.mConfirmPwdItem.setVisibility(0);
                this.mPwdDescView.setVisibility(0);
                break;
            }
            case 6: {
                this.mTitleBar.updateData(R.drawable.icon_nav_back, ResourceUtils.getString((int)R.string.login_phone_window_title_reset), -1, "", 0x800003);
                this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_phone_pwd_done_title));
                this.mGoBtn.setContentDescription((CharSequence)"DONE");
                this.mPhoneNumItem.setVisibility(8);
                this.mOldPwdItem.setVisibility(0);
                this.mOldPwdItem.setPasswordIcon(0);
                this.mOldPwdItem.setHint(ResourceUtils.getString((int)R.string.login_phone_old_pwd_input_hint));
                this.mOldPwdItem.setRuleEnable(false);
                this.mNewPwdItem.setVisibility(0);
                this.mNewPwdItem.setPasswordIcon(0);
                this.mNewPwdItem.setHint(ResourceUtils.getString((int)R.string.login_phone_new_pwd_input_hint));
                this.mConfirmPwdItem.setVisibility(0);
                this.mConfirmPwdItem.setPasswordIcon(0);
                this.mConfirmPwdItem.setHint(ResourceUtils.getString((int)R.string.login_phone_confirm_pwd_input_hint));
                this.mPwdDescView.setVisibility(0);
                break;
            }
            default: {
                this.mTitleBar.updateData(R.drawable.icon_nav_back, ResourceUtils.getString((int)R.string.login_phone_window_title_normal), -1, "", 0x800003);
                this.mGoBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_login));
                this.mGoBtn.setContentDescription((CharSequence)"LOGIN");
                this.mPhoneNumItem.setVisibility(0);
                this.mPhoneCodeItem.setVisibility(0);
                this.initPhoneDefaultOtherEntrance();
            }
        }
        if (loginMode != 5 && loginMode != 6) {
            if (this.mLoginer != null) {
                this.updateOtherLogin(this.mLoginer.getLoginTypeInfo().totalTypeList);
            }
            this.bindLoginType();
        }
    }

    private void initPwdRule() {
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.LOGIN_TYPE_CONFIG, (IConfigListener)this);
        LoginTypeConfigData loginTypeConfigData = null;
        if (configData instanceof LoginTypeConfigData) {
            loginTypeConfigData = (LoginTypeConfigData)configData;
        }
        this.updatePwdRule(loginTypeConfigData);
    }

    private void updatePwdRule(LoginTypeConfigData configData) {
        if (configData == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)("updatePwdRule rule:" + configData.passwordRule), (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)configData.passwrodRuleDesc)) {
            this.mPwdDescView.setText((CharSequence)configData.passwrodRuleDesc);
        } else {
            this.mPwdDescView.setText((CharSequence)ResourceUtils.getString((int)R.string.login_phone_password_rule_notice));
        }
        this.mOldPwdItem.setPasswordRule(configData.passwordRule);
        this.mNewPwdItem.setPasswordRule(configData.passwordRule);
        this.mConfirmPwdItem.setPasswordRule(configData.passwordRule);
    }

    public void showSoftInputIfNeed() {
        YYConstraintLayout focusItem = null;
        switch (this.getLoginMode()) {
            case 1: {
                if (!this.mPhoneNumItem.isComplete()) {
                    focusItem = this.mPhoneNumItem;
                    break;
                }
                if (this.mConfirmPwdItem.isComplete() && this.mConfirmPwdItem.hasInput()) break;
                focusItem = this.mConfirmPwdItem;
                break;
            }
            case 0: {
                if (!this.mPhoneNumItem.isComplete()) {
                    focusItem = this.mPhoneNumItem;
                    break;
                }
                if (this.mPhoneCodeItem.isComplete()) break;
                focusItem = this.mPhoneCodeItem;
                break;
            }
            case 3: 
            case 4: {
                if (!this.mPhoneNumItem.isComplete()) {
                    focusItem = this.mPhoneNumItem;
                    break;
                }
                if (!this.mPhoneCodeItem.isComplete()) {
                    focusItem = this.mPhoneCodeItem;
                    break;
                }
                if (this.mConfirmPwdItem.isComplete()) break;
                focusItem = this.mConfirmPwdItem;
                break;
            }
            case 5: {
                if (!this.mPhoneCodeItem.isComplete()) {
                    focusItem = this.mPhoneCodeItem;
                    break;
                }
                if (this.mConfirmPwdItem.isComplete()) break;
                focusItem = this.mConfirmPwdItem;
                break;
            }
            case 6: {
                if (!this.mOldPwdItem.isComplete() || StringUtils.isEmpty((String)this.mOldPwdItem.getPasswordText())) {
                    focusItem = this.mOldPwdItem;
                    break;
                }
                if (!this.mNewPwdItem.isComplete()) {
                    focusItem = this.mNewPwdItem;
                    break;
                }
                if (this.mConfirmPwdItem.isComplete()) break;
                focusItem = this.mConfirmPwdItem;
                break;
            }
        }
        this.showSoftInputIfNeed((ILoginItem)focusItem);
    }

    private void showSoftInputIfNeed(final ILoginItem item) {
        if (item == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                item.focus(PhoneLoginWindow.this.getContext());
            }
        });
    }

    public String getPhoneNumFull() {
        return this.mPhoneNumItem.getPhoneNumFull();
    }

    public String getPhoneViewText() {
        return this.mPhoneNumItem.getPhoneNum();
    }

    public String getCountryViewText() {
        return this.mPhoneNumItem.getCountryCode();
    }

    public String getCodeFormat() {
        return this.mPhoneCodeItem.getCodeFormat();
    }

    public String getPhoneNumFormat() {
        return this.mPhoneNumItem.getPhoneNumFormat();
    }

    public void updateCodeButton(CharSequence content) {
        this.mPhoneCodeItem.setButtonContent(content);
        this.mItemListener.onItemComplete(this.mPhoneCodeItem.isComplete());
    }

    public String getCodeViewText() {
        return this.mPhoneCodeItem.getCode();
    }

    public YYTextView getCodeTipView() {
        return this.mTipView;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void onClick(View v) {
        LoginSmallIconInfo smallIconInfo;
        if (v instanceof LoginSmallBtn && (smallIconInfo = ((LoginSmallBtn)v).getData()) != null && this.mListener != null) {
            this.mListener.onJump(smallIconInfo.loginType, this.getLoginFrom());
        }
    }

    protected int getLoginFrom() {
        return 3;
    }

    public void onDetached() {
        super.onDetached();
        int loginMode = this.getLoginMode();
        if (loginMode != 5 && loginMode != 6) {
            this.unbindLoginType();
        }
    }

    protected IPhoneLoginUiCallback getUICallbacks() {
        return (IPhoneLoginUiCallback)super.getUICallbacks();
    }

    public void onShown() {
        super.onShown();
        MLog.debug((Object)TAG, (String)"onShown", (Object[])new Object[0]);
        this.mItemListener.onItemComplete(false);
        this.setSoftInputMode(48);
        this.showSoftInputIfNeed();
    }

    public void draw(Canvas canvas) {
        try {
            super.draw(canvas);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public boolean isDarkMode() {
        return true;
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.mTitleBar;
    }
}

