/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone.hint;

import android.os.Message;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.Callback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.login.LoginTrack;
import com.yy.hiyo.mvp.base.AppLifeCycleOwner;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.PlatformMsgDef;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IPhoneNumCallback;

public class PhoneHintPresenter {
    private static final String TAG = "FTLoginPhone PhoneHintPresenter";
    private MutableLiveData<Boolean> mConnectResult;
    private Callback<String> mHintCallback;

    public PhoneHintPresenter(FragmentActivity context) {
        this.init(context);
    }

    private void init(final FragmentActivity activity) {
        this.mConnectResult = new MutableLiveData();
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
        Message message = Message.obtain();
        message.what = PlatformMsgDef.MSG_CREATE_PHONE_NUM_HANDLER;
        message.obj = new IPhoneNumCallback(){

            public void onResponse(String phoneNumber, int resultCode) {
                if (resultCode == 1) {
                    LoginTrack.googleApiCall();
                } else if (resultCode == 2) {
                    LoginTrack.googleApiCall();
                }
                PhoneHintPresenter.this.mHintCallback.onResponse((Object)phoneNumber);
                if (!FP.empty((CharSequence)phoneNumber)) {
                    LoginTrack.googleApiSuccess(phoneNumber);
                }
                PhoneHintPresenter.this.mConnectResult.removeObservers(AppLifeCycleOwner.get());
            }

            public void onNoSimCardOrNoGoogleService() {
                PhoneHintPresenter.this.mConnectResult.setValue((Object)false);
            }

            public void onApiClientConnectSuccess() {
                PhoneHintPresenter.this.mConnectResult.setValue((Object)true);
            }

            public void onApiClientConnectFail() {
                PhoneHintPresenter.this.mConnectResult.setValue((Object)false);
            }

            public void onApiClientConnectSuspended() {
                PhoneHintPresenter.this.mConnectResult.setValue((Object)false);
            }

            public FragmentActivity getActivity() {
                return activity;
            }
        };
        Object result = adapter.handleMessageSync(message);
        if (result == null && SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("Why is null!");
        }
    }

    public void requestPhoneNumberHint(FragmentActivity activity, Callback<String> callback) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestPhoneNumberHint activity %s, callback %s", (Object[])new Object[]{activity, callback});
        }
        this.mHintCallback = callback;
        this.mConnectResult.removeObservers(AppLifeCycleOwner.get());
        this.mConnectResult.observe(AppLifeCycleOwner.get(), isConnect -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"requestPhoneNumberHint connect result %s", (Object[])new Object[]{isConnect});
            }
            if (Boolean.TRUE.equals(isConnect)) {
                this.sendRequestIntent(activity);
            } else {
                this.mHintCallback.onResponse((Object)"");
            }
        });
    }

    private void sendRequestIntent(FragmentActivity activity) {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
        Message message = Message.obtain();
        message.what = PlatformMsgDef.MSG_PHONE_NUM_HANDLER_START;
        Object result = adapter.handleMessageSync(message);
        if (result == null && SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("Why is null!");
        }
    }
}

