/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone;

import android.app.Activity;
import android.content.Context;
import android.os.CountDownTimer;
import androidx.annotation.Nullable;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.common.Callback;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.localprecent.LocalPercent;
import com.yy.appbase.ui.country.CountryData;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.appbase.ui.country.CountrySelectWindow;
import com.yy.appbase.ui.country.ICountrySelectCallBack;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.util.ArStringUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.BDAConst;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.LoginTrack;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.account.PhoneLoginData;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.bean.PhoneActionParam;
import com.yy.hiyo.login.growth.CountDownParam;
import com.yy.hiyo.login.phone.IPhoneLoginUiCallback;
import com.yy.hiyo.login.phone.hint.HagoSmsRetriever;
import com.yy.hiyo.login.phone.hint.PhoneHintPresenter;
import com.yy.hiyo.login.phone.windows.OtherLoginDialog;
import com.yy.hiyo.login.phone.windows.PhoneLoginWindow;
import com.yy.hiyo.login.request.ILoginRequestCallBack;
import com.yy.hiyo.login.request.IRequestSmsCodeCallBack;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhoneLoginController
extends AbstractLoginer
implements IPhoneLoginUiCallback,
OtherLoginDialog.IOtherLoginListener {
    private static final String TAG = "PhoneLoginController";
    private static final long CODE_WAITING_TIME = 60000L;
    private PhoneLoginWindow mDefaultWindow;
    private CountrySelectWindow mCountrySelectWindow;
    private WeakReference<PhoneLoginWindow> mOtherWindowRef;
    private String mCountryCode;
    private String mPhoneNum;
    private String mCountry;
    private String mPasswordSha;
    private String mSmsCode;
    private int mLoginDialogId = -1;
    private boolean mHasRequestPhone = false;
    private PhoneHintPresenter mPhoneHintPresenter;
    private HagoSmsRetriever mSmsRetriever;
    private int mDefaultMode = 0;
    private CountDownTimer mCodeTimer;
    private boolean mIsFirstSend = true;
    private boolean mIsRending = false;
    private boolean mAutoFillSms;
    private boolean mAutoSendSms;
    private LocalPercent.ABTest mLocalPwdAB = LocalPercent.ABTest.D;

    public PhoneLoginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 2);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        this.initData();
    }

    public boolean isAutoFillSms() {
        return this.mAutoFillSms;
    }

    public boolean choosePwdLogin() {
        return this.getLocalPwdAB() == LocalPercent.ABTest.C;
    }

    private void closePhoneWindow(boolean ani, AbstractWindow window) {
        if (window != null) {
            this.mWindowMgr.popWindow(ani, window);
        }
    }

    private void openCountrySelectWindow() {
        if (this.mCountrySelectWindow == null) {
            this.mCountrySelectWindow = new CountrySelectWindow((Context)this.mContext, (ICountrySelectCallBack)this);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mCountrySelectWindow, true);
    }

    private void requestSmsCode(int retryTimes, boolean openCheckWindow, Callback<Boolean> callback) {
        if (this.mSelectLoginType == 8) {
            Object param = MsgDispatcher.getInstance().sendMessageSync(GrowthMsgDef.WHATSAPP_LOGIN_TOKEN);
            String whatsAppToken = null;
            if (param instanceof String) {
                whatsAppToken = (String)param;
            }
            this.requestSmsCode(whatsAppToken, retryTimes, openCheckWindow, callback);
        } else {
            this.requestSmsCode(null, retryTimes, openCheckWindow, callback);
        }
    }

    private void requestSmsCode(@Nullable String whatsAppToken, int retryTimes, final boolean openCheckWindow, final Callback<Boolean> callback) {
        final Object[] fRetryTimesObject = new Object[]{retryTimes};
        String s = "start phone login request sms code retryTimes = " + retryTimes;
        BDAConst.bDALoginPhone((String)s);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTLoginPhone", (String)s, (Object[])new Object[0]);
        }
        final long startTime = System.currentTimeMillis();
        this.mLoginCallBack.getLoginRequester().requestSmsCode(this.mPhoneNum, this.mCountryCode, whatsAppToken, new IRequestSmsCodeCallBack(){

            @Override
            public void onSuccess(boolean sendToWhatsapp) {
                String s = "start phone login request sms code success";
                BDAConst.bDALoginPhone((String)s, (int)1);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTLoginPhone", (String)s, (Object[])new Object[0]);
                }
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/sendSms");
                if (PhoneLoginController.this.mSelectLoginType == 8) {
                    MLog.debug((Object)PhoneLoginController.TAG, (String)("reportFromSentCode: " + sendToWhatsapp), (Object[])new Object[0]);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "ready_receive_code").put("code_source", sendToWhatsapp ? "1" : "2").put("phone_number", PhoneLoginController.this.getCurLoginAccount()));
                }
                if (PhoneLoginController.this.mLoginCallBack != null && PhoneLoginController.this.mLoginCallBack.getLoginStater() != null) {
                    PhoneLoginController.this.mLoginCallBack.getLoginStater().onSmsGetResult(true, "");
                }
                PhoneLoginController.this.getDialogLinkManager().dismissDialog();
                CountryHelper.CountryInfo countryInfo = PhoneLoginController.this.phoneToCountryInfo(PhoneLoginController.this.mCountryCode + PhoneLoginController.this.mPhoneNum);
                if (countryInfo != null) {
                    PhoneLoginController.this.savePhoneInfo(countryInfo.code, countryInfo.numberCode, PhoneLoginController.this.mPhoneNum);
                }
                PhoneLoginController.this.handleAfterCodeSent();
                if (callback != null) {
                    callback.onResponse((Object)true);
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription) {
                int theRetryTimes;
                boolean restry = false;
                String s = "start phone login request sms code error errorCode = " + errorCode + "  errorDescription = " + errorDescription;
                BDAConst.bDALoginPhone((String)s, (int)0);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTLoginPhone", (String)s, (Object[])new Object[0]);
                }
                if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) && fRetryTimesObject[0] instanceof Integer && (theRetryTimes = ((Integer)fRetryTimesObject[0]).intValue()) > 0) {
                    restry = true;
                    PhoneLoginController.this.requestSmsCode(--theRetryTimes, openCheckWindow, (Callback<Boolean>)callback);
                }
                if (!restry) {
                    long time = System.currentTimeMillis() - startTime;
                    LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/sendSms");
                    if (PhoneLoginController.this.mLoginCallBack != null && PhoneLoginController.this.mLoginCallBack.getLoginStater() != null) {
                        PhoneLoginController.this.mLoginCallBack.getLoginStater().onSmsGetResult(false, errorCode);
                    }
                    PhoneLoginController.this.getDialogLinkManager().dismissDialog();
                    PhoneLoginController.this.showSmsCodeRequestErrorTips(openCheckWindow, errorCode, errorDescription);
                    if (callback != null) {
                        callback.onResponse((Object)false);
                    }
                }
            }
        });
    }

    public boolean isPhoneRelatedWindowShowing() {
        AbstractWindow window = this.getCurrentWindow();
        if (window == null) {
            return false;
        }
        return window == this.mCountrySelectWindow || window == this.mDefaultWindow || window == (this.mOtherWindowRef == null ? null : (PhoneLoginWindow)((Object)this.mOtherWindowRef.get()));
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        if (callBack != null) {
            callBack.onError(String.valueOf(105), "");
        }
    }

    @Override
    public boolean isCodeRendering() {
        return this.mIsRending;
    }

    @Override
    public void onGoPhoneWindow(int mode) {
        MLog.debug((Object)TAG, (String)("onGoPhoneWindow mode: " + mode), (Object[])new Object[0]);
        String winName = "";
        switch (mode) {
            case 1: {
                winName = "PhonePwdLogin";
                break;
            }
            case 0: {
                this.initSmsRetriever();
                if (this.getSelectLoginType() == 8) {
                    winName = "WhatsAppLogin";
                    break;
                }
                winName = "PhoneLogin";
                break;
            }
            case 3: {
                this.initSmsRetriever();
                winName = "SmsPwdLogin";
                break;
            }
            case 4: {
                this.initSmsRetriever();
                winName = "PwdForgetLogin";
                break;
            }
            case 5: {
                this.initSmsRetriever();
                winName = "PhonePwdSet";
                break;
            }
            case 6: {
                winName = "PhonePwdReset";
                break;
            }
        }
        PhoneLoginWindow phoneLoginWindow = new PhoneLoginWindow((Context)this.mContext, this, this, this, mode, winName);
        if (mode == this.mDefaultMode) {
            this.mDefaultWindow = phoneLoginWindow;
            if (this.mWindowMgr.getCurrentWindow() != this.mDefaultWindow) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_show"));
            }
        } else {
            this.mOtherWindowRef = new WeakReference<PhoneLoginWindow>(phoneLoginWindow);
        }
        this.openWindow(phoneLoginWindow);
    }

    @Override
    public void openLoginWindow() {
        MLog.debug((Object)TAG, (String)("openLoginWindow loginType: " + this.getSelectLoginType()), (Object[])new Object[0]);
        if (this.getSelectLoginType() == 8) {
            this.mDefaultMode = 0;
            this.onGoPhoneWindow(this.mDefaultMode);
        } else if (this.mSelectLoginUid > 0L) {
            this.handleQuickLogin();
        } else {
            this.handleDefaultLogin();
        }
    }

    private LocalPercent.ABTest getLocalPwdAB() {
        if (this.mLocalPwdAB == null) {
            this.mLocalPwdAB = LocalPercent.getTest((String)"pwd_login_entrance_test|a_10|b_10|c_10|d_70");
        }
        return this.mLocalPwdAB;
    }

    public String getLocalReportAB() {
        if (this.mLocalPwdAB == null) {
            return "";
        }
        String abTest = this.mLocalPwdAB.getDesc();
        String reportAB = "";
        if (StringUtils.equal((String)abTest, (String)LocalPercent.ABTest.A.getDesc())) {
            reportAB = "0";
        } else if (StringUtils.equal((String)abTest, (String)LocalPercent.ABTest.B.getDesc())) {
            reportAB = "1";
        } else if (StringUtils.equal((String)abTest, (String)LocalPercent.ABTest.C.getDesc())) {
            reportAB = "2";
        }
        return reportAB;
    }

    private void handleDefaultLogin() {
        this.mDefaultMode = this.choosePwdLogin() ? 1 : 0;
        this.onGoPhoneWindow(this.mDefaultMode);
    }

    private void handleQuickLogin() {
        this.initData();
        if (StringUtils.isEmpty((String)this.mPasswordSha) || StringUtils.isEmpty((String)this.mPhoneNum) || StringUtils.isEmpty((String)this.mCountryCode)) {
            MLog.debug((Object)TAG, (String)"handleQuickLogin fail, password or phone or countryCode is null", (Object[])new Object[0]);
            this.handleDefaultLogin();
        } else {
            BDAConst.bDALoginPhone((String)"start phone quick login has pwd");
            final long startTime = System.currentTimeMillis();
            this.mLoginCallBack.onLoginStart(this);
            MLog.infoIfDebug((Object)TAG, (String)"handleQuickLogin phone: %s, countryCode: %s, passwordSha: %s", (Object[])new Object[]{this.mPhoneNum, this.mCountryCode, this.mPasswordSha});
            final PhoneActionParam param = new PhoneActionParam(2);
            param.setPhoneNumFormat(this.mPhoneNum);
            param.setCountryCode(this.mCountryCode);
            param.setConfirmPassword(this.mPasswordSha);
            this.mLoginCallBack.getLoginRequester().phoneLoginWithHashPwd(this.mPhoneNum, this.mCountryCode, this.mPasswordSha, new ILoginRequestCallBack(){

                @Override
                public void onSuccess(LoginData data) {
                    if (data instanceof PhoneLoginData) {
                        PhoneLoginData phoneLoginData = (PhoneLoginData)data;
                        phoneLoginData.phoneMode = 2;
                        PhoneLoginController.this.handleLoginSuccess(startTime, phoneLoginData);
                    } else {
                        PhoneLoginController.this.handleLoginFail(param, startTime, "114", "");
                    }
                }

                @Override
                public void onError(String errorCode, String errorDescription, String exceptionDue) {
                    MLog.error((Object)PhoneLoginController.TAG, (String)"handleQuickLogin error: %s, desc: %s", (Object[])new Object[]{errorCode, errorDescription});
                    PhoneLoginController.this.handleLoginFail(param, startTime, errorCode, errorDescription);
                }
            });
        }
    }

    private void initSmsRetriever() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.getTag(), (String)"initSmsRetriever", (Object[])new Object[0]);
        }
        try {
            if (this.mSmsRetriever == null) {
                this.mSmsRetriever = new HagoSmsRetriever();
                this.mSmsRetriever.setCodeListener(new Callback<String>(){

                    public void onResponse(String code) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PhoneLoginController.this.getTag(), (String)"initSmsRetriever onResponse code %s", (Object[])new Object[]{code});
                        }
                        PhoneLoginController.this.mSmsCode = code;
                        PhoneLoginController.this.mAutoFillSms = true;
                        PhoneLoginController.this.updateCodeItemToUi(true);
                    }
                });
                this.mSmsRetriever.start();
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    @Override
    public void popAllWindow() {
        this.popAllWindow(false);
    }

    private void popAllWindow(boolean anim2) {
        AbstractWindow entranceWin;
        if (this.mCountrySelectWindow != null) {
            this.closePhoneWindow(anim2 && this.getCurrentWindow() == this.mCountrySelectWindow, (AbstractWindow)this.mCountrySelectWindow);
        }
        AbstractWindow abstractWindow = entranceWin = this.mOtherWindowRef == null ? null : (AbstractWindow)this.mOtherWindowRef.get();
        if (entranceWin != null) {
            this.closePhoneWindow(anim2 && this.getCurrentWindow() == entranceWin, entranceWin);
            this.mOtherWindowRef = null;
        }
        if (this.mDefaultWindow != null) {
            this.closePhoneWindow(anim2 && this.getCurrentWindow() == this.mDefaultWindow, (AbstractWindow)this.mDefaultWindow);
        }
        this.getDialogLinkManager().dismissDialog();
    }

    public void onBackIconClicked(AbstractWindow window) {
        if (window == this.mCountrySelectWindow) {
            this.closePhoneWindow(true, window);
        } else if (window == this.mDefaultWindow) {
            if (AccountUtil.getUid() <= 0L) {
                this.showLoginReturnDialog(true);
            } else {
                this.popAllWindow(true);
            }
        } else {
            this.closePhoneWindow(true, window);
            this.mOtherWindowRef = null;
        }
    }

    private void showLoginReturnDialog(boolean showReturn) {
        if (this.mLoginDialogId != -1) {
            return;
        }
        OtherLoginDialog otherLoginDialog = null;
        otherLoginDialog = showReturn ? new OtherLoginDialog(this.getLoginTypeInfo(), true, ResourceUtils.getString((int)R.string.login_return_dialog_title), ResourceUtils.getString((int)R.string.login_return_dialog_content), this) : new OtherLoginDialog(this.getLoginTypeInfo(), false, ResourceUtils.getString((int)R.string.login_try_other_ways), ResourceUtils.getString((int)R.string.login_try_other_ways_tips), this);
        otherLoginDialog.setCurrentLoginType(this.mSelectLoginType);
        this.getDialogLinkManager().showDialog((BaseDialog)otherLoginDialog);
        this.mLoginDialogId = otherLoginDialog.getId();
        ImeUtil.hideIME((Activity)this.mContext);
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.getCurrentWindow() == this.mDefaultWindow && AccountUtil.getUid() <= 0L) {
            this.showLoginReturnDialog(true);
            return true;
        }
        return super.onWindowBackKeyEvent();
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mDefaultWindow == abstractWindow && this.isCurPhoneWindow(abstractWindow) && !this.mHasRequestPhone && this.isNeedPhoneNum()) {
            this.requestPhoneHint();
        }
    }

    private PhoneHintPresenter getPhoneHintPresenter() {
        if (this.mPhoneHintPresenter == null) {
            this.mPhoneHintPresenter = new PhoneHintPresenter(this.mContext);
        }
        return this.mPhoneHintPresenter;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (abstractWindow == this.mDefaultWindow) {
            this.mDefaultWindow = null;
            this.mCountrySelectWindow = null;
            this.mOtherWindowRef = null;
            if (this.mSmsRetriever != null) {
                this.mSmsRetriever.onDestroy();
                this.mSmsRetriever = null;
            }
            this.mAutoFillSms = false;
            this.mAutoSendSms = false;
            this.mHasRequestPhone = false;
        }
    }

    protected boolean isCurPhoneWindow(AbstractWindow window) {
        if (window instanceof PhoneLoginWindow) {
            PhoneLoginWindow phoneLoginWindow = (PhoneLoginWindow)window;
            return this.getSelectLoginType() == phoneLoginWindow.getCurrentLoginController().getSelectLoginType();
        }
        return false;
    }

    @Override
    public void onCountryClicked() {
        this.openCountrySelectWindow();
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "region_code"));
    }

    public void onCountrySelected(CountryHelper.CountryInfo info) {
        if (info == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)"onCountrySelected countryCode: %s", (Object[])new Object[]{info.numberCode});
        this.mCountry = info.code;
        this.mCountryCode = info.numberCode;
        this.closePhoneWindow(true, (AbstractWindow)this.mCountrySelectWindow);
        this.updatePhoneItemToUi(true);
    }

    @Override
    public void onPhoneNumReady(String phoneNumFormat, String country, String countryCode, @Nullable Callback<Boolean> callback) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        this.mCountry = country;
        this.mCountryCode = countryCode;
        if (!StringUtils.equal((String)this.mPhoneNum, (String)phoneNumFormat)) {
            this.mIsFirstSend = true;
        }
        this.mPhoneNum = phoneNumFormat;
        this.getDialogLinkManager().dismissDialog();
        this.getDialogLinkManager().showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.login_get_sms_code), false, false, null));
        this.requestSmsCode(0, false, callback);
        if (this.mLoginCallBack != null && this.mLoginCallBack.getLoginStater() != null) {
            this.mLoginCallBack.getLoginStater().onSmsGetClicked();
        }
        if (this.mSelectLoginType == 8) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "wa_send").put("phone_number", this.getCurLoginAccount()));
        } else {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_send").put("phone_number", this.getCurLoginAccount()));
        }
    }

    @Override
    public void onGoAction(PhoneActionParam param) {
        if (param == null) {
            String s = "start phone param null, go action fail";
            BDAConst.bDALoginPhone((String)s, (int)0);
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            String s = "start phone action: " + param.getMode() + " fail, network unavailable";
            BDAConst.bDALoginPhone((String)s, (int)0);
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTLoginPhone", (String)s, (Object[])new Object[0]);
            }
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        MLog.infoIfDebug((Object)this.getTag(), (String)("onGoAction param: " + param), (Object[])new Object[0]);
        this.getDialogLinkManager().dismissDialog();
        if (this.mLoginCallBack != null && this.mLoginCallBack.getLoginStater() != null) {
            this.mLoginCallBack.getLoginStater().onSmsCheckClicked(this.getCurLoginAccount());
        }
        switch (param.getMode()) {
            case 1: {
                this.handleLoginForPwd(param);
                break;
            }
            case 0: {
                this.handleLoginForSms(param);
                break;
            }
            case 3: 
            case 4: {
                this.handleLoginForSmsPwd(param);
                break;
            }
            case 5: {
                this.handleSetPwd(param);
                break;
            }
            case 6: {
                this.handleResetPwd(param);
                break;
            }
        }
    }

    private void updatePhoneItemToUi(boolean updateForce) {
        AbstractWindow abstractWindow = this.getCurrentWindow();
        if (this.isCurPhoneWindow(abstractWindow)) {
            PhoneLoginWindow phoneLoginWindow = (PhoneLoginWindow)abstractWindow;
            phoneLoginWindow.fillPhoneCountry(this.mCountryCode, this.mCountry, updateForce, false);
            phoneLoginWindow.fillPhoneNumber(this.mPhoneNum, updateForce && StringUtils.isEmpty((String)phoneLoginWindow.getPhoneViewText()), this.mAutoSendSms);
        }
    }

    private void updateCodeItemToUi(boolean updateForce) {
        AbstractWindow abstractWindow = this.getCurrentWindow();
        if (this.isCurPhoneWindow(abstractWindow)) {
            PhoneLoginWindow phoneLoginWindow = (PhoneLoginWindow)abstractWindow;
            phoneLoginWindow.fillSmsCode(this.mSmsCode, updateForce, this.mAutoFillSms);
        }
    }

    private void handleLoginForPwd(final @NotNull PhoneActionParam param) {
        BDAConst.bDALoginPhone((String)"start phone login has pwd");
        final long startTime = System.currentTimeMillis();
        this.mLoginCallBack.onLoginStart(this);
        String phoneNum = param.getPhoneNumFormat();
        String countryCode = param.getCountryCode();
        this.savePhoneInfo(param.getCountry(), countryCode, phoneNum);
        this.mLoginCallBack.getLoginRequester().phoneLoginWithPwd(phoneNum, countryCode, param.getConfirmPassword(), new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (data instanceof PhoneLoginData) {
                    PhoneLoginData phoneLoginData = (PhoneLoginData)data;
                    phoneLoginData.phoneMode = param.getMode();
                    PhoneLoginController.this.handleLoginSuccess(startTime, phoneLoginData);
                } else {
                    PhoneLoginController.this.handleLoginFail(param, startTime, "114", "");
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                PhoneLoginController.this.handleLoginFail(param, startTime, errorCode, errorDescription);
            }
        });
    }

    private void handleLoginForSmsPwd(final @NotNull PhoneActionParam param) {
        BDAConst.bDALoginPhone((String)"start phone login has code and pwd");
        final long startTime = System.currentTimeMillis();
        this.mLoginCallBack.onLoginStart(this);
        String phoneNum = param.getPhoneNumFormat();
        String countryCode = param.getCountryCode();
        this.savePhoneInfo(param.getCountry(), countryCode, phoneNum);
        this.mLoginCallBack.getLoginRequester().phoneLogin(phoneNum, countryCode, param.getCodeFormat(), param.getConfirmPassword(), new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (data instanceof PhoneLoginData) {
                    PhoneLoginData phoneLoginData = (PhoneLoginData)data;
                    phoneLoginData.phoneMode = param.getMode();
                    PhoneLoginController.this.handleLoginSuccess(startTime, phoneLoginData);
                } else {
                    PhoneLoginController.this.handleLoginFail(param, startTime, "114", "");
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                PhoneLoginController.this.handleLoginFail(param, startTime, errorCode, errorDescription);
            }
        });
    }

    private void handleLoginForSms(final @NotNull PhoneActionParam param) {
        BDAConst.bDALoginPhone((String)"start phone login has code");
        final long startTime = System.currentTimeMillis();
        this.mLoginCallBack.onLoginStart(this);
        String phoneNum = param.getPhoneNumFormat();
        String countryCode = param.getCountryCode();
        this.savePhoneInfo(param.getCountry(), countryCode, phoneNum);
        this.mLoginCallBack.getLoginRequester().phoneLogin(phoneNum, countryCode, param.getCodeFormat(), new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (data instanceof PhoneLoginData) {
                    PhoneLoginData phoneLoginData = (PhoneLoginData)data;
                    phoneLoginData.phoneMode = param.getMode();
                    PhoneLoginController.this.handleLoginSuccess(startTime, phoneLoginData);
                } else {
                    PhoneLoginController.this.handleLoginFail(param, startTime, "114", "");
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                PhoneLoginController.this.handleLoginFail(param, startTime, errorCode, errorDescription);
            }
        });
        if (this.mSelectLoginType == 8) {
            LoginTrack.reportWhatsAppLogin();
        } else {
            LoginTrack.reportPhoneLogin(this.getLocalReportAB());
        }
    }

    private void handleSetPwd(final @NotNull PhoneActionParam param) {
        BDAConst.bDALoginPhone((String)"start phone set pwd");
        this.mLoginCallBack.getLoginRequester().setLoginPassword(param.getCodeFormat(), param.getConfirmPassword(), new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (data instanceof PhoneLoginData) {
                    PhoneLoginData phoneLoginData = (PhoneLoginData)data;
                    phoneLoginData.phoneMode = param.getMode();
                    PhoneLoginController.this.handleSetPwdSuccess(phoneLoginData);
                } else {
                    PhoneLoginController.this.handleSetPwdFail(param, "114", "");
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                PhoneLoginController.this.handleSetPwdFail(param, errorCode, errorDescription);
            }
        });
    }

    private void handleResetPwd(final @NotNull PhoneActionParam param) {
        BDAConst.bDALoginPhone((String)"start phone reset pwd");
        this.mLoginCallBack.getLoginRequester().resetLoginPassword(param.getOldPassword(), param.getConfirmPassword(), new ILoginRequestCallBack(){

            @Override
            public void onSuccess(LoginData data) {
                if (data instanceof PhoneLoginData) {
                    PhoneLoginData phoneLoginData = (PhoneLoginData)data;
                    phoneLoginData.phoneMode = param.getMode();
                    PhoneLoginController.this.handleSetPwdSuccess(phoneLoginData);
                } else {
                    PhoneLoginController.this.handleSetPwdFail(param, "114", "");
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                PhoneLoginController.this.handleSetPwdFail(param, errorCode, errorDescription);
            }
        });
    }

    private void handleLoginSuccess(long startTime, PhoneLoginData phoneLoginData) {
        String s = "start phone login success";
        BDAConst.bDALoginPhone((String)"start phone login success", (int)1);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTLoginPhone", (String)"start phone login success", (Object[])new Object[0]);
        }
        MLog.infoIfDebug((Object)TAG, (String)("handleLoginSuccess loginData: " + phoneLoginData), (Object[])new Object[0]);
        this.stopCodeTimer();
        AccountInfo accountInfo = AccountInfo.obtain((LoginData)phoneLoginData);
        accountInfo.loginType = this.mSelectLoginType == 8 ? 8 : 2;
        if (this.mLoginCallBack != null) {
            this.mLoginCallBack.onLoginSuccess(this, accountInfo);
        }
        this.savePhoneInfo(phoneLoginData.registerCountry, phoneLoginData.countryCode, phoneLoginData.getPhoneNum(), phoneLoginData.passwordSha, phoneLoginData.uuid);
        long time = System.currentTimeMillis() - startTime;
        if (phoneLoginData.phoneMode == 0 || phoneLoginData.phoneMode == 3) {
            LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/smsAuth");
        } else if (phoneLoginData.phoneMode == 4) {
            LoginTrack.reportForgetPwdLoginResult(true);
            LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/smsAuth");
        } else if (phoneLoginData.phoneMode == 1 || phoneLoginData.phoneMode == 2) {
            LoginTrack.reportPhonePwdLoginResult(true, this.getLocalReportAB());
            LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/passwordAuth");
        }
        this.mLocalPwdAB = null;
    }

    private void handleLoginFail(PhoneActionParam param, long startTime, String errorCode, String errorDesc) {
        this.getDialogLinkManager().dismissDialog();
        String s = "start phone login fail, errorCode: " + errorCode;
        BDAConst.bDALoginPhone((String)s, (int)0);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTLoginPhone", (String)s, (Object[])new Object[0]);
        }
        if (this.mLoginCallBack != null) {
            this.mLoginCallBack.onLoginError(this, errorCode, "");
        }
        long time = System.currentTimeMillis() - startTime;
        LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"99999", (String)"login/smsAuth");
        if (StringUtils.equal((String)errorCode, (String)"30001")) {
            if (param.getMode() == 1 || param.getMode() == 2) {
                this.popAllWindow();
                this.mAutoSendSms = true;
                this.onGoPhoneWindow(0);
            }
        } else if (param.getMode() == 2) {
            this.handleDefaultLogin();
        }
        if (param.getMode() == 4) {
            LoginTrack.reportForgetPwdLoginResult(false);
        } else if (param.getMode() == 1 || param.getMode() == 2) {
            LoginTrack.reportPhonePwdLoginResult(false, this.getLocalReportAB());
        }
    }

    private void handleSetPwdSuccess(PhoneLoginData phoneLoginData) {
        if (phoneLoginData == null) {
            return;
        }
        MLog.infoIfDebug((Object)TAG, (String)("handleSetPwdSuccess data: " + phoneLoginData), (Object[])new Object[0]);
        String s = "start phone pwd set success";
        BDAConst.bDALoginPhone((String)"start phone pwd set success", (int)1);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTLoginPhone", (String)"start phone pwd set success", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)phoneLoginData.passwordSha) && phoneLoginData.uuid > 0L) {
            this.mPasswordSha = phoneLoginData.passwordSha;
            SettingFlags.setStringValue((String)("key_last_login_password" + phoneLoginData.uuid), (String)StringUtils.ensureNotNull((String)phoneLoginData.passwordSha));
        }
        this.popAllWindow(true);
        if (phoneLoginData.phoneMode == 5) {
            LoginTrack.reportPhonePwdSetResult(true, null);
        } else if (phoneLoginData.phoneMode == 6) {
            LoginTrack.reportPhonePwdResetResult(true, null);
        }
    }

    private void handleSetPwdFail(PhoneActionParam param, String errorCode, String errorDesc) {
        MLog.debug((Object)TAG, (String)"handleSetPasswordFail errorCode: %s, errorDesc: %s", (Object[])new Object[]{errorCode, errorDesc});
        String s = "start phone pwd set fail, errorCode: " + errorCode;
        BDAConst.bDALoginPhone((String)s, (int)0);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTLoginPhone", (String)s, (Object[])new Object[0]);
        }
        String reportReason = "6";
        String errorDes = ResourceUtils.getString((int)R.string.login_phone_password_set_fail_warning);
        if (StringUtils.equal((String)"20105", (String)errorCode)) {
            errorDes = ResourceUtils.getString((int)R.string.login_phone_pwd_error_excess_warning);
            TopToastUtils.showErrorToast((CharSequence)errorCode, (int)1);
            reportReason = "4";
        } else if (StringUtils.equal((String)"30001", (String)errorCode)) {
            errorDes = ResourceUtils.getString((int)R.string.login_phone_pwd_error_risk_warning);
            TopToastUtils.showErrorToast((CharSequence)errorCode, (int)1);
            reportReason = "5";
        } else if (StringUtils.equal((String)"20104", (String)errorCode)) {
            errorDes = ResourceUtils.getString((int)R.string.login_phone_old_invalid_warning);
            SingleToastUtil.showToast((Context)this.mContext, (String)errorDes);
            reportReason = "0";
        } else {
            SingleToastUtil.showToast((Context)this.mContext, (String)errorDes);
        }
        if (param.getMode() == 5) {
            LoginTrack.reportPhonePwdSetResult(false, reportReason);
        } else if (param.getMode() == 6) {
            LoginTrack.reportPhonePwdResetResult(false, reportReason);
        }
    }

    @Override
    public String getCurLoginAccount() {
        if (StringUtils.isNotEmpty((String)this.mCountryCode) && StringUtils.isNotEmpty((String)this.mCountry) && StringUtils.isNotEmpty((String)this.mPhoneNum)) {
            return this.mCountry + "  +" + this.mCountryCode + "_" + this.mPhoneNum + "_" + (this.mDefaultWindow != null ? this.mDefaultWindow.getCodeViewText() : "sms");
        }
        if (this.mDefaultWindow != null && StringUtils.isNotEmpty((String)this.mDefaultWindow.getCountryViewText())) {
            return this.mDefaultWindow.getCountryViewText() + "_" + (this.mDefaultWindow.getPhoneViewText() != null ? this.mDefaultWindow.getPhoneViewText() : "") + "_" + this.mDefaultWindow.getCodeViewText();
        }
        return "0";
    }

    @Override
    public void onJumpToFeedback() {
        if (this.mLoginCallBack != null) {
            this.mLoginCallBack.showFeedBack();
        }
    }

    @Override
    public void onJumpToOtherWays() {
        this.showLoginReturnDialog(false);
    }

    private void showSmsCodeRequestErrorTips(boolean openCheckWindow, String errorCode, String errorDescription) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        String tips = ResourceUtils.getString((int)R.string.login_get_sms_code_error);
        if (errorCode != null && errorCode.equals("200")) {
            tips = ResourceUtils.getString((int)R.string.login_phone_invalid_new_tips);
        } else if (errorCode != null && errorCode.equals("119")) {
            tips = ResourceUtils.getString((int)R.string.login_get_sms_code_frequently);
        }
        TopToastUtils.showToast((CharSequence)tips, (int)0, (int)ResourceUtils.getColor((int)R.color.error_toast_bg), (boolean)false);
    }

    @Override
    public void onJump(LoginTypeData loginType, int from) {
        if (this.mLoginCallBack != null) {
            this.mLoginCallBack.loginByOtherType(from, loginType.getType(), 0L);
        }
        this.popAllWindow();
    }

    @Override
    public void onOtherLoginBackClicked() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "click_back").put("phone_number", this.getCurLoginAccount()));
        this.popAllWindow(true);
        this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
    }

    @Override
    public void onDismiss() {
        this.mLoginDialogId = -1;
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification != null && notification.id == NotificationDef.N_LOGIN_SUCCESS && this.mLoginDialogId == DialogId.OtherLoginDialog) {
            this.getDialogLinkManager().dismissDialog();
        }
    }

    protected void openWindow(PhoneLoginWindow phoneWindow) {
        this.initData();
        MLog.infoIfDebug((Object)TAG, (String)"openWindow name: %s, countryCode: %s, phone: %s, sms: %s, autoSend: %b, autoFill: %b", (Object[])new Object[]{phoneWindow.getName(), this.mCountryCode, this.mPhoneNum, this.mSmsCode, this.mAutoSendSms, this.mAutoFillSms});
        phoneWindow.fillPhoneCountry(this.mCountryCode, this.mCountry, false, false);
        phoneWindow.fillPhoneNumber(this.mPhoneNum, false, this.mAutoSendSms);
        phoneWindow.fillSmsCode(this.mSmsCode, false, this.mAutoFillSms);
        this.mAutoSendSms = false;
        this.mAutoFillSms = false;
        this.mWindowMgr.pushWindow((AbstractWindow)phoneWindow, true);
    }

    private void initData() {
        AbstractWindow curWin;
        if (this.mSelectLoginUid > 0L) {
            this.mCountryCode = SettingFlags.getStringValue((String)("key_last_login_country_code" + this.mSelectLoginUid), (String)"");
            this.mPhoneNum = SettingFlags.getStringValue((String)("key_last_login_phonenum" + this.mSelectLoginUid), (String)"");
            this.mCountry = SettingFlags.getStringValue((String)("key_last_login_country" + this.mSelectLoginUid), (String)"");
            this.mPasswordSha = SettingFlags.getStringValue((String)("key_last_login_password" + this.mSelectLoginUid), (String)"");
        } else {
            if (StringUtils.isEmpty((String)this.mCountryCode)) {
                this.mCountryCode = SettingFlags.getStringValue((String)"key_last_login_country_code", (String)"");
            }
            if (StringUtils.isEmpty((String)this.mPhoneNum)) {
                this.mPhoneNum = SettingFlags.getStringValue((String)"key_last_login_phonenum", (String)"");
            }
            if (StringUtils.isEmpty((String)this.mCountry)) {
                this.mCountry = SettingFlags.getStringValue((String)"key_last_login_country", (String)"");
            }
            this.mPasswordSha = null;
        }
        if (StringUtils.isEmpty((String)this.mCountryCode)) {
            CountryData data = CountryData.getDefault();
            this.mCountry = data.countryName;
            this.mCountryCode = data.countryCode;
        }
        if (this.isCurPhoneWindow(curWin = this.getCurrentWindow())) {
            PhoneLoginWindow phoneLoginWindow = (PhoneLoginWindow)curWin;
            if (StringUtils.isEmpty((String)this.mPhoneNum)) {
                this.mPhoneNum = phoneLoginWindow.getPhoneNumFormat();
            }
            if (StringUtils.isEmpty((String)this.mSmsCode)) {
                this.mSmsCode = phoneLoginWindow.getCodeFormat();
            }
        }
    }

    public String getPhoneNum() {
        return this.mPhoneNum;
    }

    private void stopCodeTimer() {
        if (this.mCodeTimer != null) {
            this.mCodeTimer.cancel();
            this.mCodeTimer = null;
        }
        this.mIsRending = false;
    }

    private void startCodeTimer() {
        MLog.debug((Object)TAG, (String)"startCodeTimer", (Object[])new Object[0]);
        this.stopCodeTimer();
        this.mCodeTimer = new CountDownTimer(60000L, 1000L){

            public void onTick(final long millisUntilFinished) {
                PhoneLoginController.this.mIsRending = true;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractWindow win = PhoneLoginController.this.getCurrentWindow();
                        if (PhoneLoginController.this.isCurPhoneWindow(win)) {
                            PhoneLoginWindow phoneWin = (PhoneLoginWindow)win;
                            String content = ResourceUtils.getString((int)R.string.login_resend, (Object[])new Object[]{millisUntilFinished / 1000L});
                            phoneWin.updateCodeButton(content);
                            CountDownParam data = new CountDownParam(millisUntilFinished, phoneWin);
                            MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.WHATSAPP_LOGIN_COUNTDOWN, (Object)data);
                        }
                    }
                });
            }

            public void onFinish() {
                PhoneLoginController.this.mIsRending = false;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractWindow win = PhoneLoginController.this.getCurrentWindow();
                        if (PhoneLoginController.this.isCurPhoneWindow(win)) {
                            PhoneLoginWindow phoneWin = (PhoneLoginWindow)win;
                            if (StringUtils.isEmpty((String)phoneWin.getCodeViewText())) {
                                PhoneLoginController.this.onJumpToOtherWays();
                            }
                            phoneWin.updateCodeButton(ResourceUtils.getString((int)R.string.str_button_get_code));
                            CountDownParam data = new CountDownParam(0L, phoneWin);
                            MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.WHATSAPP_LOGIN_COUNTDOWN, (Object)data);
                        }
                    }
                });
            }
        }.start();
    }

    private boolean isNeedPhoneNum() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.getTag(), (String)"isNeedPhoneNum phoneNum %s", (Object[])new Object[]{this.getPhoneNum()});
        }
        return FP.empty((CharSequence)this.getPhoneNum());
    }

    private void requestPhoneHint() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.getTag(), (String)"requestPhoneHint", (Object[])new Object[0]);
        }
        this.mHasRequestPhone = true;
        this.getPhoneHintPresenter().requestPhoneNumberHint(this.mContext, new Callback<String>(){

            public void onResponse(String phoneNumber) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PhoneLoginController.this.getTag(), (String)"requestPhoneNumberHint response phoneNumber: %s", (Object[])new Object[]{phoneNumber});
                }
                if (FP.empty((CharSequence)phoneNumber)) {
                    PhoneLoginController.this.showSoftInputIfNeed();
                } else {
                    CountryHelper.CountryInfo info = PhoneLoginController.this.phoneToCountryInfo(phoneNumber);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PhoneLoginController.this.getTag(), (String)"requestPhoneNumberHint \u5bf9\u5e94\u7684\u533a\u53f7: %s", (Object[])new Object[]{info});
                    }
                    if (info != null) {
                        int start = phoneNumber.indexOf(info.numberCode);
                        String realNum = phoneNumber.substring(start + FP.size((CharSequence)info.numberCode));
                        PhoneLoginController.this.savePhoneInfo(info.code, info.numberCode, ArStringUtils.transformArToNormalNumInArLocal((String)realNum));
                        PhoneLoginController.this.updatePhoneItemToUi(false);
                    } else {
                        MLog.error((Object)PhoneLoginController.this.getTag(), (String)"requestPhoneHint \u83b7\u53d6\u533a\u53f7\u51fa\u9519", (Object[])new Object[0]);
                        PhoneLoginController.this.showSoftInputIfNeed();
                    }
                }
            }
        });
    }

    private void showSoftInputIfNeed() {
        AbstractWindow curWin = this.getCurrentWindow();
        if (this.isCurPhoneWindow(curWin)) {
            ((PhoneLoginWindow)curWin).showSoftInputIfNeed();
        }
    }

    protected void handleAfterCodeSent() {
        this.updatePhoneItemToUi(false);
        this.startCodeTimer();
        this.showCodeSentTip();
    }

    private void showCodeSentTip() {
        AbstractWindow win = this.getCurrentWindow();
        if (this.isCurPhoneWindow(win)) {
            PhoneLoginWindow phoneWin = (PhoneLoginWindow)win;
            if (this.mIsFirstSend) {
                if (this.getSelectLoginType() == LoginTypeData.WHATSAPP.getType()) {
                    TopToastUtils.showSucceedToast((CharSequence)ResourceUtils.getString((int)R.string.login_code_has_sent_tips_whatsapp, (Object[])new Object[]{phoneWin.getPhoneNumFull()}), (int)0, (boolean)false);
                } else {
                    TopToastUtils.showSucceedToast((CharSequence)ResourceUtils.getString((int)R.string.login_code_has_sent_tips, (Object[])new Object[]{phoneWin.getPhoneNumFull()}), (int)0, (boolean)false);
                }
            } else {
                TopToastUtils.showSucceedToast((CharSequence)ResourceUtils.getString((int)R.string.login_code_has_resent_tips, (Object[])new Object[]{phoneWin.getPhoneNumFull()}), (int)0, (boolean)false);
            }
            this.mIsFirstSend = false;
        }
    }

    void savePhoneInfo(String country, String countryCode, String phoneNumber) {
        this.savePhoneInfo(country, countryCode, phoneNumber, null, 0L);
    }

    void savePhoneInfo(String country, String countryCode, String phoneNumber, String passwordSha, long uid) {
        String phoneNumFormat = ArStringUtils.transformArToNormalNumInArLocal((String)phoneNumber);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.getTag(), (String)"savePhoneInfo country %s, phoneNumber %s", (Object[])new Object[]{country, phoneNumFormat});
        }
        this.mPhoneNum = phoneNumFormat;
        SettingFlags.setStringValue((String)"key_last_login_phonenum", (String)phoneNumFormat);
        this.mCountry = StringUtils.ensureNotNull((String)country);
        SettingFlags.setStringValue((String)"key_last_login_country", (String)this.mCountry);
        this.mCountryCode = StringUtils.ensureNotNull((String)countryCode);
        SettingFlags.setStringValue((String)"key_last_login_country_code", (String)this.mCountryCode);
        if (uid > 0L) {
            SettingFlags.setStringValue((String)("key_last_login_phonenum" + uid), (String)StringUtils.ensureNotNull((String)phoneNumFormat));
            SettingFlags.setStringValue((String)("key_last_login_country" + uid), (String)StringUtils.ensureNotNull((String)country));
            SettingFlags.setStringValue((String)("key_last_login_country_code" + uid), (String)StringUtils.ensureNotNull((String)countryCode));
            if (StringUtils.isNotEmpty((String)passwordSha)) {
                SettingFlags.setStringValue((String)("key_last_login_password" + uid), (String)StringUtils.ensureNotNull((String)passwordSha));
            }
            MLog.infoIfDebug((Object)this.getTag(), (String)"savePhoneInfo uid: %d, password: %s, phone: %s", (Object[])new Object[]{uid, passwordSha, phoneNumFormat});
        }
    }

    @Nullable
    CountryHelper.CountryInfo phoneToCountryInfo(String phoneNumberE164) {
        List countryInfoList = CountryHelper.getAllCountryList();
        for (CountryHelper.CountryInfo item : countryInfoList) {
            if (FP.empty((CharSequence)item.numberCode) || !phoneNumberE164.startsWith(item.numberCode)) continue;
            return item;
        }
        return null;
    }

    protected String getTag() {
        return TAG;
    }
}

