/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.guest;

import android.content.Context;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.BDAConst;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IGuestAutoLoginCallback;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.guest.GuestBackPressLoginUtil;
import com.yy.hiyo.login.guest.GuestLoginDialog;
import com.yy.hiyo.login.request.ILoginRequestCallBack;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class GuestLoginController
extends AbstractLoginer {
    private static String TAG = "FTLoginGuest";
    private boolean mShowErrorTips = false;
    private ILoginRequestCallBackEx mCurCallBackEx;
    IGuestAutoLoginCallback mAutoLoginCallBack;

    public GuestLoginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 10);
    }

    private void showLoginPage(int failType, final boolean fromBackPress) {
        boolean isGuestLogin;
        String s = "showLoginPage" + failType;
        BDAConst.bDAGuest((String)s);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)s, (Object[])new Object[0]);
        }
        if (isGuestLogin = GuestBackPressLoginUtil.isAlwaysGuestLogin()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"back press and guest logintrue", (Object[])new Object[0]);
            }
            this.handleGuestLogin(fromBackPress);
        } else if (!this.mDialogLinkManager.isDialogShowing()) {
            GuestLoginDialog dialog = new GuestLoginDialog((Context)this.mContext, this.getLoginTypeInfo(), failType, fromBackPress);
            this.mDialogLinkManager.showDialog((BaseDialog)dialog);
            dialog.setOnGuestLoginListener(new GuestLoginDialog.IGuestLoginListener(){

                @Override
                public void onCloseClick() {
                    BDAConst.bDAGuest((String)"onCloseClick");
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)TAG, (String)"onCloseClick", (Object[])new Object[0]);
                    }
                    GuestLoginController.this.mDialogLinkManager.dismissDialog();
                    GuestLoginController.this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
                }

                @Override
                public void onLoginClick(int type) {
                    BDAConst.bDAGuest((String)("onCloseClick type = " + type));
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)TAG, (String)"onLoginClick %s", (Object[])new Object[]{type});
                    }
                    if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        GuestLoginController.this.mDialogLinkManager.dismissDialog();
                        GuestLoginController.this.mLoginCallBack.loginByOtherType(fromBackPress ? 6 : 5, type);
                    } else {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.str_network_not_capable), (int)0);
                    }
                }
            });
        }
    }

    private void handleGuestLogin(boolean fromBackPress) {
        if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.mLoginCallBack.loginByOtherType(fromBackPress ? 6 : 5, 10);
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.str_network_not_capable), (int)0);
        }
    }

    @Override
    public void openLoginWindow() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"openLoginWindow", (Object[])new Object[0]);
        }
        this.mShowErrorTips = true;
        this.startLogin(false);
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        if (callBack != null) {
            callBack.onError(String.valueOf(105), "");
        }
    }

    public void startAutoLogin(IGuestAutoLoginCallback callBack) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startAutoLogin", (Object[])new Object[0]);
        }
        this.mShowErrorTips = false;
        this.startLogin(true);
        this.mAutoLoginCallBack = callBack;
    }

    public void openLoginDialog(int loginType, boolean isFromBackPress) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"openLoginDialog loginType %s, isFromBackPress %b", (Object[])new Object[]{loginType, isFromBackPress});
        }
        this.mShowErrorTips = false;
        this.showLoginPage(loginType, isFromBackPress);
        if (isFromBackPress) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "back_show"));
        } else {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "failed_show"));
        }
    }

    private void startLogin(boolean autoLogin) {
        this.enableAutoLogin(false);
        if (this.mShowErrorTips) {
            this.mLoginCallBack.onLoginStart(this);
        }
        BDAConst.bDAGuest((String)"guest login!");
        if (this.mCurCallBackEx != null) {
            this.mCurCallBackEx.canceled = true;
        }
        ILoginRequestCallBackEx callBackEx = new ILoginRequestCallBackEx(){

            @Override
            public void onSuccess(LoginData data) {
                if (this.canceled) {
                    if (GuestLoginController.this.mAutoLoginCallBack != null && ((GuestLoginController)GuestLoginController.this).mCurCallBackEx.autoLogin) {
                        GuestLoginController.this.mAutoLoginCallBack.onCancel();
                    }
                    return;
                }
                boolean fAutoLogin = this.autoLogin;
                String s = String.format("guest login succeed data: %s", data);
                BDAConst.bDAGuest((String)s, (int)1);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)TAG, (String)s, (Object[])new Object[0]);
                }
                if (data != null) {
                    AccountInfo account = AccountInfo.obtain((LoginData)data);
                    account.loginType = 10;
                    if (GuestLoginController.this.mLoginCallBack != null) {
                        GuestLoginController.this.mLoginCallBack.onLoginSuccess(GuestLoginController.this, account);
                    }
                    if (GuestLoginController.this.mAutoLoginCallBack != null && fAutoLogin) {
                        GuestLoginController.this.mAutoLoginCallBack.onSuccess();
                    }
                } else {
                    GuestLoginController.this.handleLoginError("123", "get google user info fail");
                }
            }

            @Override
            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                if (this.canceled) {
                    if (GuestLoginController.this.mAutoLoginCallBack != null && this.autoLogin) {
                        GuestLoginController.this.mAutoLoginCallBack.onCancel();
                    }
                    return;
                }
                String s = String.format("guest login code: %s, des: %s", errorCode, exceptionDue);
                BDAConst.bDAGuest((String)s, (int)0);
                FeatureLog.e((String)TAG, (String)s, (Object[])new Object[0]);
                GuestLoginController.this.handleLoginError(errorCode, errorDescription);
            }
        };
        callBackEx.autoLogin = autoLogin;
        this.mCurCallBackEx = callBackEx;
        this.mLoginCallBack.getLoginRequester().loginGuest(callBackEx);
    }

    private void handleLoginError(String errorCode, String des) {
        String s = String.format("login error:%s %s", errorCode, des);
        BDAConst.bDAGuest((String)s, (int)0);
        FeatureLog.e((String)TAG, (String)s, (Object[])new Object[0]);
        if (this.mLoginCallBack != null) {
            this.mLoginCallBack.onLoginError(this, this.mShowErrorTips, errorCode, des);
        }
        if (this.mAutoLoginCallBack != null) {
            this.mAutoLoginCallBack.onError(errorCode, des);
        }
    }

    public void enableAutoLogin(boolean enable) {
        if (this.mAutoLoginCallBack != null && !enable) {
            this.mAutoLoginCallBack.onCancel();
            if (this.mCurCallBackEx != null && this.mCurCallBackEx.autoLogin) {
                this.mCurCallBackEx.canceled = true;
            }
            this.mAutoLoginCallBack = null;
        }
    }

    @Override
    public void popAllWindow() {
        super.popAllWindow();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"popAllWindow", (Object[])new Object[0]);
        }
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    private static abstract class ILoginRequestCallBackEx
    implements ILoginRequestCallBack {
        public boolean autoLogin;
        public boolean canceled;

        private ILoginRequestCallBackEx() {
        }
    }
}

