/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.findfriend;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.kvo.moduledata.PlatformPermissionModuleData;
import com.yy.appbase.kvomodule.BaseModuleData;
import com.yy.appbase.kvomodule.BizModule;
import com.yy.appbase.kvomodule.callback.ILoadFindFriendsData;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.callback.ICheckNeedUpload;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ContactUtils;
import com.yy.hiyo.im.ImRepository;
import com.yy.hiyo.login.LoginApi;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.hiyo.login.base.IQueryThirdPartyCallBack;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.findfriend.ZaloBindErrorHandle;
import com.yy.hiyo.login.zalo.ZaloBindAccount;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IGetFirendListCallBack;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.socialplatformbase.data.UserBaseInfo;
import common.Header;
import ikxd.apigateway.ApiGateway;
import ikxd.apigateway.GetFriendListReq;
import ikxd.apigateway.Uri;
import ikxd.apigateway.UserInfo;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class PlatformPermissionModuleImpl
extends BizModule<PlatformPermissionModuleData>
implements PlatformPermissionModule {
    private static final String TAG = "PlatformPermissionModul";

    public PlatformPermissionModuleImpl(PlatformPermissionModuleData mData) {
        super((BaseModuleData)mData);
    }

    public int facebookPermission(final int permissionState) {
        AccountInfo info = AccountModel.getInstance().getAccountInfo();
        if (info != null && info.loginType == 1) {
            if (permissionState != CheckStatus.AUTH) {
                ((PlatformPermissionModuleData)this.mData).facebookState.setValue("permissionState", (Object)CheckStatus.AUTH);
            }
        } else {
            Object hasPermission = MsgDispatcher.getInstance().sendMessageSync(BaseMsgDef.MSG_GET_FACEBOOK_BIND_STATU, (Object)new IQueryThirdPartyCallBack(){

                public void onSuccess(boolean hasBinded, String thirdPartyUserId) {
                    if (permissionState != (hasBinded ? CheckStatus.AUTH : CheckStatus.UNAUTH)) {
                        ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)(hasBinded ? CheckStatus.AUTH : CheckStatus.UNAUTH));
                    }
                }

                public void onError(int errorCode, Throwable e) {
                }
            });
            if (hasPermission instanceof Boolean && permissionState != ((Boolean)hasPermission != false ? CheckStatus.AUTH : CheckStatus.UNAUTH)) {
                ((PlatformPermissionModuleData)this.mData).facebookState.setValue("permissionState", (Object)((Boolean)hasPermission != false ? CheckStatus.AUTH : CheckStatus.UNAUTH));
            }
        }
        return ((PlatformPermissionModuleData)this.mData).facebookState.permissionState;
    }

    public int zaloPermission(final int permissionState) {
        if (ZaloBindAccount.isZaloLoginType()) {
            ((PlatformPermissionModuleData)this.mData).zaloState.setValue("permissionState", (Object)CheckStatus.AUTH);
        } else {
            boolean hasPermission = ZaloBindAccount.getZaloBindStatu(new IQueryThirdPartyCallBack(){

                public void onSuccess(boolean hasBinded, String thirdPartyUserId) {
                    PlatformPermissionModuleImpl.this.notifyZaloValue(hasBinded, permissionState);
                }

                public void onError(int errorCode, Throwable e) {
                }
            });
            if (hasPermission) {
                this.notifyZaloValue(true, permissionState);
            }
        }
        return ((PlatformPermissionModuleData)this.mData).zaloState.permissionState;
    }

    private void notifyZaloValue(boolean hasPermission, int permissionState) {
        int checkStatu;
        int n = checkStatu = hasPermission ? CheckStatus.AUTH : CheckStatus.UNAUTH;
        if (permissionState != checkStatu) {
            ((PlatformPermissionModuleData)this.mData).zaloState.setValue("permissionState", (Object)checkStatu);
        }
    }

    public String getFacebookUserId() {
        Object fbUserId = MsgDispatcher.getInstance().sendMessageSync(BaseMsgDef.MSG_GET_FACEBOOK_USER_ID);
        if (fbUserId instanceof String) {
            return (String)fbUserId;
        }
        return "";
    }

    public void bindFacebook(final Object callback) {
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_FACEBOOK_BIND_ACCOUNT, -1, -1, (Object)new IBindThirdPartyAccountCallBack(){

            public void onSuccess() {
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.AUTH);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"bind facebook success", (Object[])new Object[0]);
                }
                if (callback instanceof IBindThirdPartyAccountCallBack) {
                    ((IBindThirdPartyAccountCallBack)callback).onSuccess();
                }
                LoginApi.getInstance().sendFbRegisterPushMsg();
            }

            public void onCancel() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"bind facebook cancel", (Object[])new Object[0]);
                }
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.UNAUTH);
                if (callback instanceof IBindThirdPartyAccountCallBack) {
                    ((IBindThirdPartyAccountCallBack)callback).onCancel();
                }
            }

            public void onError(int errorCode, Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"bind facebook error", (Object[])new Object[0]);
                }
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.UNAUTH);
                if (callback instanceof IBindThirdPartyAccountCallBack) {
                    ((IBindThirdPartyAccountCallBack)callback).onError(errorCode, e);
                }
            }
        });
    }

    public void authFacebook(final Object callback) {
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_FACEBOOK_AUTHORIZATION, -1, -1, (Object)new IThirdPartyAuthorizationCallBack(){

            public void onSuccess(LoginSuccessResult result) {
                String facebookUserId;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"auth facebook success", (Object[])new Object[0]);
                }
                if (TextUtils.isEmpty((CharSequence)(facebookUserId = PlatformPermissionModuleImpl.this.getFacebookUserId()))) {
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.AUTH);
                    if (callback instanceof IThirdPartyAuthorizationCallBack) {
                        ((IThirdPartyAuthorizationCallBack)callback).onSuccess(result);
                    }
                    return;
                }
                String loginUserId = result.authorizedData.userId;
                if (facebookUserId.equals(loginUserId)) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"insertIfNewUserNotExist facebook success", (Object[])new Object[0]);
                    }
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.facebook_update_account_success), (int)1);
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.AUTH);
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"insertIfNewUserNotExist facebook error for different accounts", (Object[])new Object[0]);
                    }
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.facebook_update_account_fail), (int)1);
                    MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_FACEBOOK_LOGOUT);
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.EXPIRE);
                }
            }

            public void onCancel() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"auth facebook cancel", (Object[])new Object[0]);
                }
                if (callback instanceof IThirdPartyAuthorizationCallBack) {
                    ((IThirdPartyAuthorizationCallBack)callback).onCancel();
                }
            }

            public void onError(int errorCode, Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"auth facebook error", (Object[])new Object[0]);
                }
                if (errorCode == 101) {
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.EXPIRE);
                }
                if (callback instanceof IThirdPartyAuthorizationCallBack) {
                    ((IThirdPartyAuthorizationCallBack)callback).onError(errorCode, e);
                }
            }
        });
    }

    public List<UserBaseInfo> getFacebookFriendList(final IGetFirendListCallBack callback) {
        AbsPlatformAdapter absPlatformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
        if (absPlatformAdapter != null) {
            absPlatformAdapter.getFriendList(new IGetFirendListCallBack(){

                public void onSuccess(ArrayList<UserBaseInfo> list) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("get facebook friend list success, size:" + list), (Object[])new Object[0]);
                    }
                    ((PlatformPermissionModuleData)PlatformPermissionModuleImpl.this.mData).setValue("facebookFriendList", list);
                    if (callback != null) {
                        callback.onSuccess(list);
                    }
                }

                public void onError(int errorCode, Exception e) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("get facebook friend list error,code: " + errorCode + "err:" + e), (Object[])new Object[0]);
                    }
                    if (errorCode == 101) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"token error", (Object[])new Object[0]);
                        }
                        ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("permissionState", (Object)CheckStatus.EXPIRE);
                    }
                    if (callback != null) {
                        callback.onError(errorCode, e);
                    }
                }
            });
        }
        return ((PlatformPermissionModuleData)this.mData).facebookFriendList;
    }

    public int locationPermission(Activity aty) {
        ((PlatformPermissionModuleData)this.mData).locationState.setValue("permissionState", (Object)(PermissionHelper.hasLocationPermission((Activity)aty) ? CheckStatus.AUTH : CheckStatus.UNAUTH));
        return ((PlatformPermissionModuleData)this.mData).locationState.permissionState;
    }

    public void contactPermission(Activity aty, final int permissionState) {
        ContactUtils.hasContactPermission((Activity)aty, (ContactUtils.IContactPermissionCheckCallBack)new ContactUtils.IContactPermissionCheckCallBack(){

            public void onHasContactPermissionCallBack(final boolean has) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int perState;
                        if (PlatformPermissionModuleImpl.this.mData == null || ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState == null) {
                            return;
                        }
                        int n = perState = has ? CheckStatus.AUTH : CheckStatus.UNAUTH;
                        if (permissionState != perState) {
                            ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.setValue("permissionState", (Object)perState);
                        }
                    }
                });
            }
        });
    }

    public List<FindFriend> loadFriendsData(final Object ctx, final int limit, final ILoadFindFriendsData mCallback) {
        LocationInfo info = LocationHelper.getLocationInfo((boolean)true);
        float longitude = 0.0f;
        float latitude = 0.0f;
        if (info != null) {
            longitude = (float)info.getLongitude();
            latitude = (float)info.getLatitude();
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"load friends request", (Object[])new Object[0]);
        }
        GetFriendListReq req = new GetFriendListReq.Builder().latitude(Float.valueOf(latitude)).longitude(Float.valueOf(longitude)).online_status(Long.valueOf(2L)).limit(Long.valueOf(limit)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_apigateway_d");
        ApiGateway ikxdApigateway = new ApiGateway.Builder().get_friend_list_req(req).uri(Uri.kUriGetFriendListReq).header(header).build();
        ProtoManager.getInstance().send((AndroidMessage)ikxdApigateway, (IProtoCallback)new IProtoCallback<ApiGateway>(){

            public void onResponse(@Nullable ApiGateway resp) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"loadFriendsData error:", (Object[])new Object[0]);
                }
                if (resp == null) {
                    if (mCallback != null) {
                        mCallback.onLoadError(ctx, limit, "proto parse error", 1);
                    }
                    return;
                }
                ArrayList<FindFriend> friends = new ArrayList<FindFriend>();
                if (resp.uri == Uri.kUriGetFriendListRes) {
                    List infos = resp.get_friend_list_res.users;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("get find friend data from server,size:" + (infos != null ? infos.size() : 0)), (Object[])new Object[0]);
                    }
                    StringBuilder uidStringBuilder = new StringBuilder();
                    if (infos != null && !infos.isEmpty()) {
                        for (UserInfo info : infos) {
                            FindFriend f = FindFriend.transform((UserInfo)info);
                            if (f.getType() == 1L && ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState != null && (((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.permissionState == CheckStatus.UNAUTH || ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.permissionState == CheckStatus.UNCHECK)) {
                                if (!MLog.isLogLevelBlowInfo()) continue;
                                MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"permission deny,remove uid:%d", (Object[])new Object[]{f.getUid()});
                                continue;
                            }
                            friends.add(f);
                            uidStringBuilder.append("[" + f.getUid() + "]");
                        }
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("load friends result : " + uidStringBuilder.toString()), (Object[])new Object[0]);
                    }
                }
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).friendsListStatus.success();
                ((PlatformPermissionModuleData)PlatformPermissionModuleImpl.this.mData).setValue("findFriendList", friends);
                if (mCallback != null) {
                    mCallback.onLoadSuccess(ctx, ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).findFriendList, limit);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("load find Friends Data retryWhenTimeout:" + canRetry), (Object[])new Object[0]);
                }
                if (mCallback != null && canRetry) {
                    boolean bizRetry = mCallback.onRetry(ctx, limit);
                    if (!bizRetry) {
                        mCallback.onLoadError(ctx, limit, "retryWhenTimeout", 2);
                    }
                    return bizRetry;
                }
                return canRetry;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("load find Friends Data retryWhenError:" + canRetry + " reason:" + reason + " code:" + code), (Object[])new Object[0]);
                }
                if (mCallback != null && canRetry) {
                    boolean bizRetry = mCallback.onRetry(ctx, limit);
                    if (!bizRetry) {
                        mCallback.onLoadError(ctx, limit, "retryWhenError:" + reason, 3);
                    }
                    return bizRetry;
                }
                return canRetry;
            }
        });
        return ((PlatformPermissionModuleData)this.mData).findFriendList;
    }

    public void checkUploadFb(final INetRespCallback<NetCheckUpload> checkUploadINetRespCallback) {
        LoginApi.getInstance().checkUploadFacebook(new INetRespCallback<NetCheckUpload>(){

            public void onError(Call call, Exception e, int id2) {
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.dataStatus.fail();
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.setValue("finishCheck", new Object());
                if (checkUploadINetRespCallback != null) {
                    checkUploadINetRespCallback.onError(call, e, id2);
                }
            }

            public void onResponse(String response, BaseResponseBean<NetCheckUpload> res, int id2) {
                if (res != null && res.isSuccess()) {
                    NetCheckUpload upload = (NetCheckUpload)res.data;
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.dataStatus.success();
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.setValue("version", (Object)upload.version);
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.setValue("need", (Object)upload.need);
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.setValue("finishCheck", new Object());
                } else {
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.dataStatus.fail();
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.checkNeedUpload.setValue("finishCheck", new Object());
                }
                if (checkUploadINetRespCallback != null) {
                    checkUploadINetRespCallback.onResponse(response, res, id2);
                }
            }
        });
    }

    public void checkUploadZalo(final INetRespCallback<NetCheckUpload> checkUploadINetRespCallback) {
        LoginApi.getInstance().checkUploadZalo(new INetRespCallback<NetCheckUpload>(){

            public void onError(Call call, Exception e, int id2) {
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.dataStatus.fail();
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.setValue("finishCheck", new Object());
                if (checkUploadINetRespCallback != null) {
                    checkUploadINetRespCallback.onError(call, e, id2);
                }
            }

            public void onResponse(String response, BaseResponseBean<NetCheckUpload> res, int id2) {
                if (res != null && res.isSuccess()) {
                    NetCheckUpload upload = (NetCheckUpload)res.data;
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.dataStatus.success();
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.setValue("version", (Object)upload.version);
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.setValue("need", (Object)upload.need);
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.setValue("finishCheck", new Object());
                } else {
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.dataStatus.fail();
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.checkNeedUpload.setValue("finishCheck", new Object());
                }
                if (checkUploadINetRespCallback != null) {
                    checkUploadINetRespCallback.onResponse(response, res, id2);
                }
            }
        });
    }

    public void checkUploadContacts(final ICheckNeedUpload callback) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"checkUploadContact err ", (Object[])new Object[0]);
        }
        ImRepository.checkUploadContacts((ICheckNeedUpload)new ICheckNeedUpload(){

            public void onSuccess(NetCheckUpload responseBean) {
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.checkNeedUpload.dataStatus.success();
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.checkNeedUpload.setValue("version", (Object)responseBean.version);
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.checkNeedUpload.setValue("need", (Object)responseBean.need);
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.checkNeedUpload.setValue("finishCheck", new Object());
                if (callback != null) {
                    callback.onSuccess(responseBean);
                }
            }

            public void onError(int code, String msg) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("checkUploadContact err " + code + " msg" + msg), (Object[])new Object[0]);
                }
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.checkNeedUpload.dataStatus.fail();
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.checkNeedUpload.setValue("finishCheck", new Object());
                if (callback != null) {
                    callback.onError(code, msg);
                }
            }
        });
    }

    public void uploadContacts() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ImRepository.uploadContacts((String)ContactUtils.getContacts((Context)RuntimeContext.sApplicationContext), value -> ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.setValue("hasUpload", value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).contactState.setValue("hasUpload", (Object)false);
                }
            }
        });
    }

    public void bindZalo(final Object callback) {
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_ZALO_BIND_ACCOUNT, -1, -1, (Object)new IBindThirdPartyAccountCallBack(){

            public void onSuccess() {
                YYTaskExecutor.postToMainThread(() -> ToastUtils.showToast((Activity)PlatformPermissionModuleImpl.this.getEnv().getContext(), (int)R.string.bind_fb_success, (int)1));
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"bind zalo success", (Object[])new Object[0]);
                }
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.setValue("permissionState", (Object)CheckStatus.AUTH);
                if (callback instanceof IBindThirdPartyAccountCallBack) {
                    ((IBindThirdPartyAccountCallBack)callback).onSuccess();
                }
            }

            public void onCancel() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"bind zalo cancel", (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread(() -> ToastUtils.showToast((Activity)PlatformPermissionModuleImpl.this.getEnv().getContext(), (int)R.string.fb_bind_cancel, (int)1));
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.setValue("permissionState", (Object)CheckStatus.UNAUTH);
                if (callback instanceof IBindThirdPartyAccountCallBack) {
                    ((IBindThirdPartyAccountCallBack)callback).onCancel();
                }
            }

            public void onError(int errorCode, Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"bind zalo error", (Object[])new Object[0]);
                }
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).zaloState.setValue("permissionState", (Object)CheckStatus.UNAUTH);
                if (callback instanceof IBindThirdPartyAccountCallBack) {
                    ((IBindThirdPartyAccountCallBack)callback).onError(errorCode, e);
                }
                ZaloBindErrorHandle.handleError(errorCode, e, (Context)PlatformPermissionModuleImpl.this.getEnv().getContext());
            }
        });
    }

    public void notifyZaloLogin() {
        ((PlatformPermissionModuleData)this.mData).zaloState.setValue("permissionState", (Object)CheckStatus.AUTH);
    }

    public void uploadFacebookFriendList() {
        this.getFacebookFriendList(new IGetFirendListCallBack(){

            public void onSuccess(ArrayList<UserBaseInfo> list) {
                boolean canUpload = false;
                if (AccountUtil.getsLoginType() == 1) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"login type fb,can upload", (Object[])new Object[0]);
                    }
                    canUpload = true;
                } else {
                    Object saveBindedFbId = MsgDispatcher.getInstance().sendMessageSync(BaseMsgDef.MSG_GET_FACEBOOK_USER_ID);
                    String platformUserId = ThirdPartyPlatformHelper.getInstance().getPlatform(5).getPlatformUserId();
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"FacebookUpload", (String)"facebook upload,saveId:%s, currentId:%s", (Object[])new Object[]{saveBindedFbId, platformUserId});
                    }
                    if (saveBindedFbId instanceof String && StringUtils.isNotEmpty((String)platformUserId) && saveBindedFbId.equals(platformUserId)) {
                        canUpload = true;
                    }
                }
                if (!canUpload) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"can not upload fb!!", (Object[])new Object[0]);
                    }
                    return;
                }
                LoginApi.getInstance().uploadFacebookFriends(list, new INetRespCallback(){

                    public void onError(Call call, Exception e, int id2) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)("getFacebookFriendList err:" + e.getMessage()), (Object[])new Object[0]);
                        }
                        ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("hasUpload", (Object)false);
                    }

                    public void onResponse(String response, BaseResponseBean res, int id2) {
                        if (res != null && res.isSuccess()) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"upload facebook friends success", (Object[])new Object[0]);
                            }
                            ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("hasUpload", (Object)true);
                        } else {
                            ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("hasUpload", (Object)false);
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"upload facebook friends fail", (Object[])new Object[0]);
                            }
                        }
                    }
                });
            }

            public void onError(int errorCode, Exception e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PlatformPermissionModuleImpl.TAG, (String)"upload facebook friends fail", (Object[])new Object[0]);
                }
                ((PlatformPermissionModuleData)((PlatformPermissionModuleImpl)PlatformPermissionModuleImpl.this).mData).facebookState.setValue("hasUpload", (Object)false);
            }
        });
    }
}

