/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.basicprofile;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.widget.DatePicker;
import com.yy.appbase.R;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.BirthdayDefines;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnCameraCallbak;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.service.callback.OnProfileSingleCallback;
import com.yy.appbase.service.callback.OnUpdateCallback;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.appbase.ui.dialog.DateTimePickerDialog;
import com.yy.appbase.ui.dialog.OkDatePickerDialog;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.HomeTownConfig;
import com.yy.appbase.util.AgeUtils;
import com.yy.appbase.util.EquipmentUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.login.AbstractHandleUserInfoLoginer;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.basicprofile.BasicProfileWindow;
import com.yy.hiyo.login.basicprofile.ChooseHometownDialog;
import com.yy.hiyo.login.basicprofile.IBasicProfileCallBack;
import com.yy.hiyo.login.utils.RegisterUtils;
import com.yy.hiyo.user.interest.IInterestLabelService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class BasicProfileController
extends DefaultWindowController
implements BasicProfileWindow.IWindowCallBack {
    private static final String TAG = "BasicProfileController";
    private static final String PROFILE = "profile_";
    private static final String AVATAR_DIR = "avatar";
    private static final int USER_DATA_UPDATE_BY_DEFAULT_FILL = 1;
    private static final String ICON_EXT = ".jpg";
    private IBasicProfileCallBack mProfileCallBack;
    private BasicProfileWindow mBasicProfileWindow;
    private DialogLinkManager mMyDialogManager;
    private UserInfoBean mDefaultTempInfo;
    private String mPath;
    private String mIconUrl;
    private long mUid;

    public BasicProfileController(Environment env, IBasicProfileCallBack callBack) {
        super(env);
        this.mProfileCallBack = callBack;
    }

    private static void adjustIcon(final IServiceManager serviceManager, final String iconUrl, long uid) {
        String avatarFileName = BasicProfileController.getTempAvatarName(uid);
        File dir = FileStorageUtils.getInstance().getDirAndCreate(true, AVATAR_DIR);
        final File iconFile = new File(dir, avatarFileName);
        try {
            ImageLoader.savePhotoSync((String)iconUrl, (File)iconFile);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        final String iconPath = iconFile.getAbsolutePath();
        if (StringUtils.isEmpty((String)iconPath) || !YYFileUtils.isFileExisted((String)iconPath)) {
            return;
        }
        final Runnable deleteTempIcon = new Runnable(){

            @Override
            public void run() {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        YYFileUtils.delete((File)iconFile);
                    }
                }, (long)5000L);
            }
        };
        if (AccountUtil.getUid() == uid) {
            ((IUserInfoService)serviceManager.getService(IUserInfoService.class)).getUserInfo(uid, new OnProfileListCallback(){

                public void onUISuccess(List<UserInfoBean> userInfo) {
                    String iconUrl2;
                    UserInfoBean userInfoBean = userInfo != null && userInfo.size() > 0 ? userInfo.get(0) : null;
                    String string2 = iconUrl2 = userInfoBean != null ? userInfoBean.getAvatar() : "";
                    if (StringUtils.equal((String)iconUrl, (String)iconUrl2)) {
                        ((IUserInfoService)serviceManager.getService(IUserInfoService.class)).updateAvatar(iconPath, new OnUpdateCallback(){

                            public void onUISuccess(String imageUrl, int id2) {
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)BasicProfileController.TAG, (String)"adjustIcon new icon:%s old icon:%s", (Object[])new Object[]{imageUrl, iconUrl2});
                                }
                                deleteTempIcon.run();
                            }

                            public void onError(Call call, Exception e, int id2) {
                                deleteTempIcon.run();
                            }

                            public void onResponseError(int id2, String message, String response) {
                                deleteTempIcon.run();
                            }
                        });
                    } else {
                        deleteTempIcon.run();
                    }
                }

                public void onError(Call call, Exception e, int id2) {
                    deleteTempIcon.run();
                }

                public void onResponseError(int id2, String message, String response) {
                    deleteTempIcon.run();
                }
            });
        }
    }

    private void handleQureyProfileUpdatedError(Object[] fRetryTimesObject, String errorCode, String message, long uuid, IQueryHasProfileSettingUped callback) {
        int theRetryTimes;
        boolean restry = false;
        if (fRetryTimesObject != null && fRetryTimesObject.length > 0 && fRetryTimesObject[0] instanceof Integer && (theRetryTimes = ((Integer)fRetryTimesObject[0]).intValue()) > 0) {
            restry = true;
            this.queryProfileHasUpdated(--theRetryTimes, uuid, callback);
        }
        MLog.error((Object)TAG, (String)" query error:%s %s", (Object[])new Object[]{errorCode, message});
        if (!restry && callback != null) {
            callback.onError(uuid, errorCode, message);
        }
    }

    public boolean queryProfileHasUpdated(long uuid, IQueryHasProfileSettingUped callBack) {
        boolean result = SettingFlags.getBoolean((String)(PROFILE + uuid), (boolean)false);
        if (result) {
            if (callBack != null) {
                callBack.onSuccess(uuid, true);
            }
            return true;
        }
        if (callBack == null) {
            return true;
        }
        this.queryProfileHasUpdated(1, uuid, callBack);
        return true;
    }

    public static boolean getProfileHasUpdatedFlagFromCache(long uuid) {
        return SettingFlags.getBoolean((String)(PROFILE + uuid), (boolean)false);
    }

    public boolean isCurPhoneBasicProfileWindow() {
        AbstractWindow window = this.getCurrentWindow();
        return window != null && window == this.mBasicProfileWindow;
    }

    public void setProfileHasUpdated(long uuid) {
        SettingFlags.setBoolean((String)(PROFILE + uuid), (boolean)true);
    }

    private static String getTempAvatarName(long uuid) {
        return uuid + "_" + System.currentTimeMillis() + "_icon" + ICON_EXT;
    }

    public void deleteTempAvatar() {
        AccountInfo info = AccountModel.getInstance().getAccountInfo();
        if (info != null) {
            final String iconFileName = BasicProfileController.getTempAvatarName(info.uuid);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    File dir = FileStorageUtils.getInstance().getDirAndCreate(true, BasicProfileController.AVATAR_DIR);
                    File iconFile = new File(dir, iconFileName);
                    FileUtils.deleteFile((File)iconFile);
                }
            });
        }
    }

    public static void adjustIconUrl(final IServiceManager serviceManager) {
        final long uid = AccountUtil.getUid();
        if (serviceManager != null && serviceManager.getService(IUserInfoService.class) != null && uid > 0L) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    OnProfileListCallback getUserInfoCallBack = new OnProfileListCallback(){

                        public void onUISuccess(List<UserInfoBean> userInfo) {
                            String iconUrl;
                            UserInfoBean userInfoBean = userInfo != null && userInfo.size() > 0 ? userInfo.get(0) : null;
                            String string2 = iconUrl = userInfoBean != null ? userInfoBean.getAvatar() : "";
                            if (URLUtils.isOurHostByUrl((String)iconUrl)) {
                                return;
                            }
                            Runnable adjustIcon = new Runnable(){

                                @Override
                                public void run() {
                                    BasicProfileController.adjustIcon(serviceManager, iconUrl, uid);
                                }
                            };
                            YYTaskExecutor.execute((Runnable)adjustIcon);
                        }

                        public void onError(Call call, Exception e, int id2) {
                        }

                        public void onResponseError(int id2, String message, String response) {
                        }
                    };
                    ((IUserInfoService)serviceManager.getService(IUserInfoService.class)).getUserInfo(uid, getUserInfoCallBack);
                }
            };
            YYTaskExecutor.execute((Runnable)command, (long)7000L);
        }
    }

    private void queryProfileHasUpdated(int retryTimes, final long uuid, final IQueryHasProfileSettingUped callBack) {
        boolean result = SettingFlags.getBoolean((String)(PROFILE + uuid), (boolean)false);
        if (result) {
            if (callBack != null) {
                callBack.onSuccess(uuid, true);
            }
            return;
        }
        final Object[] fRetryTimesObject = new Object[]{retryTimes};
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uuid, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> list) {
                boolean result = SettingFlags.getBoolean((String)(BasicProfileController.PROFILE + uuid), (boolean)false);
                boolean infoIsEmpty = false;
                if (list == null || list.size() < 1) {
                    infoIsEmpty = true;
                } else {
                    UserInfoBean userInfo = list.get(0);
                    if (userInfo == null || StringUtils.isEmpty((String)userInfo.getNick()) || userInfo.getSex() < 0) {
                        infoIsEmpty = true;
                    } else if (userInfo.getUpdateType() == 1) {
                        infoIsEmpty = true;
                    }
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)BasicProfileController.TAG, (String)" query success empty:%s", (Object[])new Object[]{infoIsEmpty});
                }
                if (callBack != null) {
                    if (!infoIsEmpty && AccountUtil.getUid() > 0L) {
                        BasicProfileController.this.setProfileHasUpdated(AccountUtil.getUid());
                    }
                    callBack.onSuccess(uuid, !infoIsEmpty || result);
                }
            }

            public void onError(Call call, final Exception e, int id2) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BasicProfileController.this.handleQureyProfileUpdatedError(fRetryTimesObject, "111", e != null ? e.toString() : "", uuid, callBack);
                    }
                });
            }

            public void onResponseError(int id2, String message, final String response) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BasicProfileController.this.handleQureyProfileUpdatedError(fRetryTimesObject, "112", response, uuid, callBack);
                    }
                });
            }
        });
    }

    protected void statGetIconFromResult(String url, boolean success, Exception e) {
        AbstractHandleUserInfoLoginer.statGetIconFromResult(url, success, e);
    }

    public void convertAvatar(final String url) {
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        if (!TextUtils.isEmpty((CharSequence)url) && accountInfo != null) {
            final String avatarFileName = BasicProfileController.getTempAvatarName(accountInfo.uuid);
            this.mIconUrl = url;
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    File dir = FileStorageUtils.getInstance().getDirAndCreate(true, BasicProfileController.AVATAR_DIR);
                    final File iconFile = new File(dir, avatarFileName);
                    ImageLoader.savePhotoSync((String)url, (File)iconFile, (ImageLoader.ISavePicListener)new ImageLoader.ISavePicListener(){

                        public void onFailed(Exception e) {
                            MLog.error((Object)BasicProfileController.TAG, (String)"convertAvatar error", (Throwable)e, (Object[])new Object[0]);
                            BasicProfileController.this.statGetIconFromResult(url, false, e);
                        }

                        public void onSuccess() {
                            BasicProfileController.this.statGetIconFromResult(url, true, null);
                            String iconPath = iconFile.getAbsolutePath();
                            if (StringUtils.isEmpty((String)BasicProfileController.this.mPath) && YYFileUtils.isFileExisted((String)iconPath)) {
                                BasicProfileController.this.mPath = iconPath;
                                if (BasicProfileController.this.mBasicProfileWindow != null) {
                                    BasicProfileController.this.mBasicProfileWindow.updateIcon(BasicProfileController.this.mPath, R.drawable.register_icon_avatar_nor);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    public void openProfileEditWindow(UserInfoBean info) {
        this.mDefaultTempInfo = info;
        if (this.mBasicProfileWindow == null) {
            this.mBasicProfileWindow = new BasicProfileWindow(info, (Context)this.mContext, this);
        }
        if (this.mProfileCallBack.getLoginStatistics() != null) {
            this.mProfileCallBack.getLoginStatistics().onBasicProfileOpen();
        }
        this.mUid = AccountModel.getInstance().getAccountInfo().uuid;
        this.mPath = "";
        String iconURL = info != null ? info.getAvatar() : "";
        this.mDefaultTempInfo.setAvatar(null);
        if (!TextUtils.isEmpty((CharSequence)iconURL)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"covert url:%s", (Object[])new Object[]{iconURL});
            }
            this.convertAvatar(iconURL);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mBasicProfileWindow, true);
        int pageId = 1;
        if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 3) {
            pageId = 2;
        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 4) {
            pageId = 3;
        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 1) {
            pageId = 4;
        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 7) {
            pageId = 5;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_info_show").put("page_id", String.valueOf(pageId)));
    }

    public void openProfileEditWindow() {
        if (this.mBasicProfileWindow == null) {
            this.mBasicProfileWindow = new BasicProfileWindow((Context)this.mContext, this);
        }
        if (this.mProfileCallBack.getLoginStatistics() != null) {
            this.mProfileCallBack.getLoginStatistics().onBasicProfileOpen();
        }
        this.mUid = AccountModel.getInstance().getAccountInfo().uuid;
        this.mWindowMgr.pushWindow((AbstractWindow)this.mBasicProfileWindow, true);
        int pageId = 1;
        if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 3) {
            pageId = 2;
        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 4) {
            pageId = 3;
        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 1) {
            pageId = 4;
        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 7) {
            pageId = 5;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "phone_info_show").put("page_id", String.valueOf(pageId)));
    }

    private DialogLinkManager getMyDialogManager() {
        this.mMyDialogManager = new DialogLinkManager((Context)this.mContext);
        return this.mMyDialogManager;
    }

    private void handleUpdateUserInfoError(String errorCode, String message) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleUpdateUserInfoError errorCode=%s, message=%s", (Object[])new Object[]{errorCode, message});
        }
        this.dismissDialog();
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        if (StringUtils.isEmpty((String)message)) {
            message = ResourceUtils.getString((int)R.string.login_save_profile_error);
        }
        SingleToastUtil.showToast((Context)this.mContext, (String)message);
        if (RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, (String)(ResourceUtils.getString((int)R.string.login_save_profile_error) + message), (Object[])new Object[0]);
        }
    }

    public static void updateUserInfo(final IServiceManager serviceManager, String imagePath, final UserInfoBean userInfo, final OnProfileSingleCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"updateUserInfo2 imagePath %s", (Object[])new Object[]{imagePath});
            }
            String name = FileUtils.getFileName((String)imagePath);
            String objectKey = "uurl/" + name;
            ((IOOSService)serviceManager.getService(IOOSService.class)).uploadFile(objectKey, imagePath, new IUploadObjectCallBack(){

                public void onSuccess(UploadObjectRequest request) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)BasicProfileController.TAG, (String)"updateUserInfo2 onSuccess!", (Object[])new Object[0]);
                    }
                    String imageUrl = request.mUrl;
                    userInfo.setAvatar(imageUrl);
                    ((IUserInfoService)serviceManager.getService(IUserInfoService.class)).uploadUserInfo(userInfo, BasicProfileController.createCallBackWithLog(callback));
                }

                public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)BasicProfileController.TAG, (String)"updateUserInfo2 onFailure!", (Object[])new Object[0]);
                    }
                    if (callback != null) {
                        callback.onResponseError(errorCode, "", "");
                    }
                }
            });
        } else {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"updateUserInfo2!", (Object[])new Object[0]);
            }
            ((IUserInfoService)serviceManager.getService(IUserInfoService.class)).uploadUserInfo(userInfo, BasicProfileController.createCallBackWithLog(callback));
        }
    }

    private static OnProfileSingleCallback createCallBackWithLog(final OnProfileSingleCallback callback) {
        return new OnProfileSingleCallback(){

            public void onUISuccess(UserInfoBean userInfo) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)BasicProfileController.TAG, (String)"updateUserInfo2  updateUser onSuccess!", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onUISuccess(userInfo);
                }
            }

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)BasicProfileController.TAG, (String)"updateUserInfo2  updateUser onError!", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onError(call, e, id2);
                }
            }

            public void onResponseError(int id2, String message, String response) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)BasicProfileController.TAG, (String)"updateUserInfo2  updateUser onResponseError!", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onResponseError(id2, message, response);
                }
            }
        };
    }

    public void closeWindow(boolean isAnimating) {
        this.mWindowMgr.popWindow(isAnimating, (AbstractWindow)this.mBasicProfileWindow);
    }

    private void updateUserInfo(IServiceManager serviceManager, UserInfoBean userInfo) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateUserInfo!", (Object[])new Object[0]);
        }
        ((IUserInfoService)serviceManager.getService(IUserInfoService.class)).uploadUserInfo(userInfo, new OnProfileSingleCallback(){

            public void onUISuccess(UserInfoBean userInfo) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)BasicProfileController.TAG, (String)"updateUserInfo onUISuccess!", (Object[])new Object[0]);
                }
                BasicProfileController.this.dismissDialog();
                if (userInfo != null) {
                    if (BasicProfileController.this.mProfileCallBack != null) {
                        BasicProfileController.this.mProfileCallBack.onProfileInfoSaved(BasicProfileController.this.mUid);
                    }
                    BasicProfileController.this.sendRegisterPushMsg();
                    BasicProfileController.this.setProfileHasUpdated(BasicProfileController.this.mUid);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_USER_INFO_UPDATED, (Object)userInfo.getUid()));
                }
            }

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)BasicProfileController.TAG, (String)"updateUserInfo onError!", (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BasicProfileController.this.handleUpdateUserInfoError("111", ResourceUtils.getString((int)R.string.login_save_profile_error));
                    }
                });
            }

            public void onResponseError(final int id2, final String message, String response) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (id2 == 361) {
                            BasicProfileController.this.handleUpdateUserInfoError("30000", message);
                        } else {
                            BasicProfileController.this.handleUpdateUserInfoError("112", ResourceUtils.getString((int)R.string.login_save_profile_error));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void onSelectIconClicked() {
        ((ICameraService)this.getServiceManager().getService(ICameraService.class)).pickPhotoWithClip("FTEditAvatarProfile", new OnCameraCallbak(){

            public void onFinish(String path) {
                if (BasicProfileController.this.mBasicProfileWindow != null) {
                    BasicProfileController.this.mBasicProfileWindow.updateIcon(path, R.drawable.register_icon_avatar_nor);
                    BasicProfileController.this.mPath = path;
                }
            }
        }, 1);
    }

    @Override
    public void onSaveBtnClicked() {
        if (this.mBasicProfileWindow == null) {
            MLog.error((Object)TAG, (String)"onSaveBtnClicked why mBasicProfileWindow is null???", (Object[])new Object[0]);
            return;
        }
        if (this.mProfileCallBack != null && this.mProfileCallBack.getLoginStatistics() != null) {
            this.mProfileCallBack.getLoginStatistics().onProfileSaveClicked();
        }
        this.dismissDialog();
        String name = StringUtils.clearWhite((Activity)this.mContext, (String)this.mBasicProfileWindow.getNickName());
        this.mBasicProfileWindow.updateName(name);
        if (!TextUtils.isEmpty((CharSequence)name)) {
            this.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.login_save_profile), false, false, null));
            BasicProfileController.updateUserInfo(this.getServiceManager(), this.mPath, this.prepareUserInfo(this.mIconUrl != null ? this.mIconUrl : ""), new OnProfileSingleCallback(){

                public void onResponseError(final int id2, final String message, String response) {
                    if (BasicProfileController.this.mProfileCallBack != null && BasicProfileController.this.mProfileCallBack.getLoginStatistics() != null) {
                        BasicProfileController.this.mProfileCallBack.getLoginStatistics().onProfileSaveResult(false);
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (id2 == 361) {
                                BasicProfileController.this.handleUpdateUserInfoError("30000", message);
                            } else {
                                BasicProfileController.this.handleUpdateUserInfoError("112", ResourceUtils.getString((int)R.string.login_save_profile_error));
                            }
                        }
                    });
                }

                public void onUISuccess(UserInfoBean userInfo) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)BasicProfileController.TAG, (String)"onSaveBtnClicked onUISuccess", (Object[])new Object[0]);
                    }
                    if (BasicProfileController.this.mProfileCallBack != null && BasicProfileController.this.mProfileCallBack.getLoginStatistics() != null) {
                        BasicProfileController.this.mProfileCallBack.getLoginStatistics().onProfileSaveResult(true);
                    }
                    BasicProfileController.this.dismissDialog();
                    if (userInfo != null) {
                        if (BasicProfileController.this.mProfileCallBack != null) {
                            BasicProfileController.this.mProfileCallBack.onProfileInfoSaved(BasicProfileController.this.mUid);
                        }
                        BasicProfileController.this.deleteTempAvatar();
                        BasicProfileController.this.sendRegisterPushMsg();
                        BasicProfileController.this.setProfileHasUpdated(BasicProfileController.this.mUid);
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_USER_INFO_UPDATED, (Object)userInfo.getUid()));
                        String sex = userInfo.getSex() == 0 ? "F" : "M";
                        if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 1) {
                            BasicProfileController.this.reportLoginSex(userInfo.getSex(), 4);
                        } else if (AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().loginType == 3) {
                            BasicProfileController.this.reportLoginSex(userInfo.getSex(), 2);
                        }
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025801").put("data_source_id", "1").put("nick_name", userInfo.getNick()).put("birthday", userInfo.getBirthday()).put("gender", sex));
                    }
                }

                public void onError(Call call, Exception e, int id2) {
                    if (BasicProfileController.this.mProfileCallBack != null && BasicProfileController.this.mProfileCallBack.getLoginStatistics() != null) {
                        BasicProfileController.this.mProfileCallBack.getLoginStatistics().onProfileSaveResult(false);
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BasicProfileController.this.handleUpdateUserInfoError("111", ResourceUtils.getString((int)R.string.login_save_profile_error));
                        }
                    });
                }
            });
        }
    }

    private void sendRegisterPushMsg() {
        HttpUtil.httpReq((String)this.getFirstRegisterPushUrl(), null, (int)2, (INetRespCallback)new INetOriginRespCallback(){

            public void onError(Call call, Exception e, int id2) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)BasicProfileController.TAG, (String)("sendRegisterPushMsg error =" + e), (Object[])new Object[0]);
                }
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)BasicProfileController.TAG, (String)("sendRegisterPushMsg =" + response), (Object[])new Object[0]);
                }
            }
        });
    }

    private String getFirstRegisterPushUrl() {
        return UriProvider.getIkxdSvrHost() + UriProvider.POST_CONTACT_REGISTER_PUSH;
    }

    private void showDialog(BaseDialog dialog) {
        if (RuntimeContext.sIsDebuggable) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"show dialog %s", (Object[])new Object[]{dialog != null ? dialog.toString() : ""});
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"show dialog!", (Object[])new Object[0]);
        }
        this.getMyDialogManager().showDialog(dialog);
    }

    private void dismissDialog() {
        if (this.mMyDialogManager != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"dismissDialog!", (Object[])new Object[0]);
            }
            this.mMyDialogManager.dismissDialog();
        }
    }

    @Override
    public String clearWhite(String text) {
        return StringUtils.clearWhite((Activity)this.mContext, (String)text);
    }

    @Override
    public void onSkipBtnClicked() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onSkipBtnClicked()", (Object[])new Object[0]);
        }
        if (this.mProfileCallBack != null && this.mProfileCallBack.getLoginStatistics() != null) {
            this.mProfileCallBack.getLoginStatistics().onProfileSkipClicked();
        }
        this.dismissDialog();
        UserInfoBean userInfo = null;
        int pageId = 1;
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        if (accountInfo != null) {
            switch (accountInfo.loginType) {
                case 3: {
                    pageId = 2;
                    break;
                }
                case 1: {
                    pageId = 4;
                    break;
                }
                case 4: {
                    pageId = 3;
                    break;
                }
                case 7: {
                    pageId = 5;
                    break;
                }
                case 9: {
                    pageId = 7;
                    break;
                }
            }
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "info_skip").put("page_id", String.valueOf(pageId)));
        this.showDialog((BaseDialog)new ProgressDialog());
        if (pageId != 1) {
            if (this.mDefaultTempInfo != null && !StringUtils.isEmpty((String)this.mDefaultTempInfo.getNick())) {
                if (pageId == 4) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"Facebook\u8d44\u6599\u9875\u7f16\u8f91\u8df3\u8fc7", (Object[])new Object[0]);
                    }
                    userInfo = RegisterUtils.getDefaultUserInfo((Context)this.mContext, this.mDefaultTempInfo, 1);
                    this.reportLoginSex(userInfo.getSex(), pageId);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"Facebook\u8d44\u6599\u9875\u7f16\u8f91\u8df3\u8fc7\u8fdb\u5165\u5e94\u7528\u7684\u7528\u6237\u8d44\u6599\uff0c\u6635\u79f0:%s\uff0c\u751f\u65e5:%s\uff0c\u6027\u522b:%s", (Object[])new Object[]{userInfo.getNick(), userInfo.getBirthday(), String.valueOf(userInfo.getSex())});
                    }
                } else if (pageId == 2) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"Google\u8d44\u6599\u9875\u7f16\u8f91\u8df3\u8fc7", (Object[])new Object[0]);
                    }
                    userInfo = RegisterUtils.getDefaultUserInfo((Context)this.mContext, this.mDefaultTempInfo);
                    this.reportLoginSex(userInfo.getSex(), pageId);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"Google\u8d44\u6599\u9875\u7f16\u8f91\u8df3\u8fc7\u8fdb\u5165\u5e94\u7528\u7684\u7528\u6237\u8d44\u6599\uff0c\u6635\u79f0:%s\uff0c\u751f\u65e5:%s\uff0c\u6027\u522b:%s", (Object[])new Object[]{userInfo.getNick(), userInfo.getBirthday(), String.valueOf(userInfo.getSex())});
                    }
                } else {
                    userInfo = RegisterUtils.getDefaultUserInfo((Context)this.mContext, this.mDefaultTempInfo);
                }
                BasicProfileController.updateUserInfo(this.getServiceManager(), this.mPath, userInfo, new OnProfileSingleCallback(){

                    public void onResponseError(final int id2, final String message, String response) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (id2 == 361) {
                                    BasicProfileController.this.handleUpdateUserInfoError("30000", message);
                                } else {
                                    BasicProfileController.this.handleUpdateUserInfoError("112", ResourceUtils.getString((int)R.string.login_save_profile_error));
                                }
                            }
                        });
                    }

                    public void onUISuccess(UserInfoBean userInfo) {
                        BasicProfileController.this.dismissDialog();
                        if (userInfo != null) {
                            if (BasicProfileController.this.mProfileCallBack != null) {
                                BasicProfileController.this.mProfileCallBack.onProfileInfoSaved(BasicProfileController.this.mUid);
                            }
                            BasicProfileController.this.sendRegisterPushMsg();
                            BasicProfileController.this.setProfileHasUpdated(BasicProfileController.this.mUid);
                            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_USER_INFO_UPDATED, (Object)userInfo.getUid()));
                            if (BasicProfileController.this.mProfileCallBack != null && !((IInterestLabelService)BasicProfileController.this.getServiceManager().getService(IInterestLabelService.class)).canShowChooseInterestAfterRegistration()) {
                                MsgDispatcher.getInstance().sendMessage(BaseMsgDef.SHOW_AGE_INVALID);
                            }
                        }
                    }

                    public void onError(Call call, Exception e, int id2) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                BasicProfileController.this.handleUpdateUserInfoError("111", ResourceUtils.getString((int)R.string.login_save_profile_error));
                            }
                        });
                    }
                });
            } else {
                this.updateUserInfoBySkiped(userInfo, this.mUid);
                MsgDispatcher.getInstance().sendMessage(BaseMsgDef.SHOW_AGE_INVALID);
            }
        } else {
            this.updateUserInfoBySkiped(userInfo, this.mUid);
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.SHOW_AGE_INVALID);
        }
    }

    @Override
    public void onSelectHomeTownViewClicked() {
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.HOME_TOWN_CONFIG);
        ArrayList<CountryHelper.CountryInfo> countryList = new ArrayList<CountryHelper.CountryInfo>();
        if (configData instanceof HomeTownConfig) {
            List countryCodes = ((HomeTownConfig)configData).getCountryCodes();
            this.fillCountryList(countryCodes, countryList);
        } else {
            this.fillCountryList(HomeTownConfig.Companion.getDEFAULT_COUNTRY_CODES(), countryList);
        }
        this.showDialog(new ChooseHometownDialog(countryList, country -> this.mBasicProfileWindow.updateHomeTown(country)));
    }

    private void fillCountryList(List<String> countryCodes, List<CountryHelper.CountryInfo> countryList) {
        for (String countryCode : countryCodes) {
            if (countryList.size() >= 11) break;
            CountryHelper.CountryInfo countryInfo = CountryHelper.getCountryInfoByCode((String)countryCode);
            if (countryInfo != null) {
                countryList.add(CountryHelper.getCountryInfoByCode((String)countryCode));
                continue;
            }
            MLog.error((Object)TAG, (String)"fillCountryList countryCode = %s countryInfo is null", (Object[])new Object[]{countryCode});
        }
        CountryHelper.CountryInfo countryInfo = new CountryHelper.CountryInfo();
        countryInfo.englishName = ResourceUtils.getString((int)R.string.other_hometown);
        countryInfo.code = "others";
        countryList.add(countryInfo);
    }

    private void updateUserInfoBySkiped(UserInfoBean userInfo, long uid) {
        UserInfoBean userInfoBean = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uid, null);
        if (!(userInfoBean == null || StringUtils.isEmpty((String)userInfoBean.getNick()) || StringUtils.isEmpty((String)userInfoBean.getAvatar()) || StringUtils.isEmpty((String)userInfoBean.getBirthday()))) {
            String loginChannel = SettingFlags.getStringValue((String)"key_login_channel", (String)"other");
            if ("googlead".equals(loginChannel)) {
                userInfoBean.setBirthday(BirthdayDefines.defaultBirthday());
            }
            this.updateUserInfo(this.getServiceManager(), userInfoBean);
        } else {
            userInfo = RegisterUtils.getDefaultUserInfo((Context)this.mContext);
            this.updateUserInfo(this.getServiceManager(), userInfo);
        }
    }

    private void reportLoginSex(int sex, int pageId) {
        int reportSex = 0;
        if (sex == 0) {
            reportSex = 2;
        } else if (sex == 1) {
            reportSex = 1;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("page_id", String.valueOf(pageId)).put("out_gender", String.valueOf(reportSex)));
    }

    @Override
    public void onSelectBirthDayViewClicked() {
        if (EquipmentUtils.getInstance().getUseNewDatePick()) {
            final DateTimePickerDialog.Builder builder = new DateTimePickerDialog.Builder((Context)this.mContext);
            builder.setPositiveButton(new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (DateUtils.before((String)builder.getStr())) {
                        ToastUtils.showToast((Context)BasicProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_after_now), (int)0);
                    } else if (NAB.B.equals((Object)NewABDefine.HAGO_AGE_BLOCK.getTest())) {
                        BasicProfileController.this.mBasicProfileWindow.showConfirmDialog(builder.getStr());
                    } else {
                        BasicProfileController.this.mBasicProfileWindow.updateBirthDay(builder.getStr());
                    }
                    dialog.dismiss();
                }
            });
            builder.setNegativeButton(new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            if (this.mBasicProfileWindow != null) {
                builder.setLastDate(TextUtils.isEmpty((CharSequence)this.mBasicProfileWindow.getBirthday()) ? BirthdayDefines.defaultBirthday() : this.mBasicProfileWindow.getBirthday());
            }
            DateTimePickerDialog dialog = builder.create();
            dialog.show();
        } else {
            OkDatePickerDialog okDatePickerDialog = new OkDatePickerDialog((Context)this.mContext, 3, new OkDatePickerDialog.ISelectCallBack(){

                public void onCancel() {
                }

                public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
                    if (BasicProfileController.this.mBasicProfileWindow != null) {
                        String birth = AgeUtils.getBirthdayString((int)year, (int)month, (int)dayOfMonth);
                        if (NAB.B.equals((Object)NewABDefine.HAGO_AGE_BLOCK.getTest())) {
                            BasicProfileController.this.mBasicProfileWindow.showConfirmDialog(birth);
                        } else {
                            BasicProfileController.this.mBasicProfileWindow.updateBirthDay(birth);
                        }
                    }
                }
            });
            if (this.mBasicProfileWindow != null) {
                okDatePickerDialog.setLastDate(TextUtils.isEmpty((CharSequence)this.mBasicProfileWindow.getBirthday()) ? BirthdayDefines.defaultBirthday() : this.mBasicProfileWindow.getBirthday());
            }
            okDatePickerDialog.show();
        }
    }

    private UserInfoBean prepareUserInfo(String avatar) {
        UserInfoBean userInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
        if (userInfo == null) {
            userInfo = new UserInfoBean();
        }
        userInfo.setAvatar(avatar);
        userInfo.setUid(AccountUtil.getUid());
        userInfo.setSex(this.mBasicProfileWindow.getGender());
        userInfo.setNick(this.mBasicProfileWindow.getNickName());
        userInfo.setBirthday(this.mBasicProfileWindow.getBirthday());
        if (StringUtils.isNotEmpty((String)this.mBasicProfileWindow.getHometown())) {
            userInfo.setHometown(this.mBasicProfileWindow.getHometown());
        }
        return userInfo;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        this.mBasicProfileWindow = null;
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        boolean retVal = false;
        if (keyCode == 4 && event.getAction() == 1) {
            retVal = AbstractWindow.isHaveKeyDownEvent() ? this.onWindowBackKeyEvent() : true;
        }
        return retVal;
    }

    public static interface IQueryHasProfileSettingUped {
        public void onSuccess(long var1, boolean var3);

        public void onError(long var1, String var3, String var4);
    }
}

