/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.auto;

import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.hiyo.login.LoginController;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.guest.GuestLoginController;
import com.yy.hiyo.login.request.ILoginRequestCallBack;

public class AutoLoginUtil {
    private static final String TAG = "AutoLoginUtil";
    private static final String LOGIN_PHONE = "911059290";
    private static final String LOGIN_COUNTRY = "86";
    private static final String LOGIN_CODE = "5231";

    private static void checkLoginGuest(final LoginController loginController) {
        AccountInfo info = AccountModel.getInstance().getAccountInfo();
        if (info == null || info.uuid <= 0L) {
            loginController.getLoginRequester().loginGuest(new ILoginRequestCallBack(){

                @Override
                public void onSuccess(LoginData data) {
                    if (data != null) {
                        AccountInfo account = AccountInfo.obtain((LoginData)data);
                        account.loginType = 10;
                        GuestLoginController guestLoginController = new GuestLoginController(loginController.getEnvironment(), loginController, loginController.getLoginTypeInfo());
                        loginController.onLoginSuccess(guestLoginController, account);
                    }
                }

                @Override
                public void onError(String errorCode, String errorDescription, String exceptionDue) {
                }
            });
        }
    }

    public static void checkAutoLogin(LoginController loginController, boolean isCmdMonitor) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"checkAutoLogin isCmdMonitor: %s  TargetBuildConstant.autoLogin: %s", (Object[])new Object[]{isCmdMonitor, TargetBuildConstant.autoLogin});
        }
        if (!isCmdMonitor && !TargetBuildConstant.autoLogin) {
            return;
        }
        AutoLoginUtil.checkLoginGuest(loginController);
    }
}

