/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.LinearLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.abtest.StartABTestUtil;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.common.Callback;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.base.crash.CrashMonitor;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageButton;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.CountryCodeUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.login.ILoginPageCallBack;
import com.yy.hiyo.login.LoginTrack;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.base.language.LanguageLocaleHelper;
import com.yy.hiyo.login.bean.BaseLoginTypeViewInfo;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.bean.LoginBigButtonInfo;
import com.yy.hiyo.login.growth.LoginBackgroundData;
import com.yy.hiyo.login.utils.LoginTypeContainerHelper;
import com.yy.hiyo.login.utils.RegisterUtils;
import com.yy.hiyo.login.view.ILoginTypeView;
import com.yy.hiyo.login.view.LoginBigButton;
import com.yy.hiyo.login.view.LoginButtonInfoHelper;
import com.yy.hiyo.login.view.LoginSmallBtn;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class LoginTypeSelectWindow
extends DefaultWindow
implements View.OnClickListener {
    private static final String TAG = "FTLogin LoginTypeSelectWindow";
    private static final int MIN_DELAY_TIME = 500;
    private ILoginPageCallBack mMyCallBack;
    private LoginBigButton mLoginMainBtn;
    private LinearLayout mLoginIconsContainer;
    private YYTextView mTopNoticeView;
    protected YYTextView mTipView;
    private YYTextView mPrivacyView;
    protected YYImageView mClose;
    private YYImageButton mCheckPrivacyBtn;
    protected YYConstraintLayout mBgLayout;
    private long mLastClickTime;
    private YYTextView mTipExtraView;
    protected ConstraintLayout mRootView = null;
    protected JLoginTypeInfo mLoginTypeInfo;

    public LoginTypeSelectWindow(Context context, JLoginTypeInfo loginTypeInfo, ILoginPageCallBack callBacks) {
        super(context, (UICallBacks)callBacks, "LoginTypeSelect");
        this.mLoginTypeInfo = loginTypeInfo;
        this.mMyCallBack = callBacks;
        this.setWindowType(111);
        this.initViews();
        this.setCanPopByBackKey(false);
        this.setBackgroundColor(ResourceUtils.getColor((int)R.color.common_window_white_bg));
        this.setEnableSwipeGesture(false);
        this.initCustomView();
        if (StartABTestUtil.INSTANCE.isStartTest()) {
            YYTaskExecutor.postToMainThread(this::initLoginTypeView);
        } else {
            this.initLoginTypeView();
        }
    }

    private void bindLoginType() {
        if (this.mLoginTypeInfo != null) {
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginMainUpdate");
            Kvo.addKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginMainUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginSecondUpdate");
            Kvo.addKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginSecondUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginUpdateUpdate");
            Kvo.addKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginUpdateUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginExceptionUpdate");
            Kvo.addKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginExceptionUpdate");
        }
    }

    private void unbindLoginType() {
        if (this.mLoginTypeInfo != null) {
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginMainUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginSecondUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginUpdateUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)((Object)this), (String)"receiveLoginExceptionUpdate");
        }
    }

    public void onDetached() {
        super.onDetached();
        this.unbindLoginType();
    }

    @KvoMethodAnnotation(name="exceptionDes", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginExceptionUpdate(KvoEventIntent event) {
        if (AccountModel.hasLoginedBefore() != -1) {
            this.showTopNotice((String)event.newValue());
        } else {
            this.hideTopNotice();
        }
    }

    @KvoMethodAnnotation(name="mainType", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginMainUpdate(KvoEventIntent event) {
        this.showMainLogin((LoginTypeData)event.newValue());
        this.showSecondLogin(this.mLoginTypeInfo.totalTypeList);
    }

    @KvoMethodAnnotation(name="totalTypeList", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginSecondUpdate(KvoEventIntent event) {
        this.showSecondLogin((List)event.newValue());
    }

    @KvoMethodAnnotation(name="updateTypeList", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginUpdateUpdate(KvoEventIntent event) {
        List updateList = (List)event.newValue();
        MLog.debug((Object)TAG, (String)("receiveLoginUpdateUpdate: " + updateList), (Object[])new Object[0]);
        if (!FP.empty((Collection)updateList)) {
            for (LoginTypeData u : updateList) {
                LoginTypeContainerHelper.updateLoginType(this.mLoginIconsContainer, u);
            }
        }
    }

    protected void initCustomView() {
    }

    public void onShown() {
        super.onShown();
        MLog.debug((Object)TAG, (String)"onShown", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.LOGIN_BG_ANIM_RESUME);
    }

    public void onHidden() {
        super.onHidden();
        MLog.debug((Object)TAG, (String)"onHidden", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.LOGIN_BG_ANIM_STOP);
    }

    public void enterOtherLoginType() {
        MLog.debug((Object)TAG, (String)"enterOtherLoginType", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.LOGIN_BG_ANIM_STOP, (Object)true);
    }

    public void returnFromOtherLoginType() {
        MLog.debug((Object)TAG, (String)"returnFromOtherLoginType", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.LOGIN_BG_ANIM_RESUME, (Object)false);
    }

    public void setCanPopByBackKey(boolean pop) {
        this.mWindowInfo.setCanPopByBackKey(pop);
        if (pop) {
            this.mClose.setVisibility(0);
        } else {
            this.mClose.setVisibility(8);
        }
    }

    private void initViews() {
        ConstraintLayout rootView;
        this.mRootView = rootView = (ConstraintLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_login_select_page, null);
        if (SystemUtils.isShowEnvSetting()) {
            this.addDebugView((ViewGroup)rootView);
        }
        this.mBgLayout = (YYConstraintLayout)rootView.findViewById(R.id.clBgContainer);
        this.mTopNoticeView = (YYTextView)rootView.findViewById(R.id.tvTopNotice);
        this.mTipView = (YYTextView)rootView.findViewById(R.id.login_type_tips);
        this.mTipExtraView = (YYTextView)rootView.findViewById(R.id.login_type_extra);
        this.mLoginMainBtn = (LoginBigButton)rootView.findViewById(R.id.login_big_btn);
        this.mLoginMainBtn.setBackgroundResource(R.drawable.login_facebook_click_selector);
        this.mLoginMainBtn.setOnClickListener(this);
        this.mLoginIconsContainer = (LinearLayout)rootView.findViewById(R.id.login_types_container);
        this.initBackground();
        this.handleInitBottomPolicyView((ViewGroup)rootView);
        this.mClose = (YYImageView)rootView.findViewById(R.id.close);
        this.mClose.setOnClickListener(v -> {
            if (this.mMyCallBack != null) {
                this.mMyCallBack.onCloseClicked();
            }
        });
        this.getBaseLayer().addView((View)rootView, new ViewGroup.LayoutParams(-1, -1));
        if (LanguageLocaleHelper.canShowEntry()) {
            YYTextView textView = (YYTextView)this.findViewById(R.id.current_language);
            if (LanguageUtils.isHindi()) {
                textView.setText((CharSequence)"En");
            } else {
                textView.setText(R.string.short_tips_language_type_hindi);
            }
            textView.setVisibility(0);
            textView.setOnClickListener(v -> {
                MsgDispatcher.getInstance().sendMessage(BaseMsgDef.SHOW_CHANGED_LANGUAGE_DIALOG);
                LoginTrack.changeLanguageClick("1");
            });
            LoginTrack.changeLanguageShow();
        }
    }

    private void initLoginTypeView() {
        this.bindLoginType();
        if (this.mLoginTypeInfo != null) {
            this.showMainLogin(this.mLoginTypeInfo.mainType);
            this.showSecondLogin(this.mLoginTypeInfo.totalTypeList);
            if (AccountModel.hasLoginedBefore() != -1) {
                this.showTopNotice(this.mLoginTypeInfo.exceptionDes);
            } else {
                this.hideTopNotice();
            }
        }
    }

    private void handleInitBottomPolicyView(ViewGroup rootView) {
        boolean isShowCheckingPolicyView;
        this.initBottomPolicyView(rootView, isShowCheckingPolicyView, ResourceUtils.getString((int)((isShowCheckingPolicyView = RegisterUtils.isShowCheckingPolicyView()) ? R.string.login_user_check_pivacy_hint : R.string.login_privacy)));
    }

    private void initBottomPolicyView(ViewGroup rootView, boolean toCheck, String hintStr) {
        this.mPrivacyView = (YYTextView)rootView.findViewById(R.id.privacy);
        this.mPrivacyView.setMovementMethod(LinkMovementMethod.getInstance());
        String termsOfService = ResourceUtils.getString((int)R.string.short_tips_terms_of_service);
        String privacyPolicy = ResourceUtils.getString((int)R.string.short_tips_privacy_policy);
        ChainSpan chainSpan = ChainSpan.of();
        chainSpan.append((CharSequence)hintStr).space().beginBlock().append((CharSequence)termsOfService, new Object[]{TextSpan.of().size(11).color(ResourceUtils.getColor((int)R.color.login_text_policy)).build()}).onBlockClick(() -> {
            if (this.mMyCallBack != null) {
                this.mMyCallBack.onTermsOfServiceClicked();
            }
        }, true, ResourceUtils.getColor((int)R.color.login_text_policy)).endBlock().space().append((CharSequence)"&").space().beginBlock().append((CharSequence)privacyPolicy, new Object[]{TextSpan.of().size(11).color(ResourceUtils.getColor((int)R.color.login_text_policy)).build()}).onBlockClick(() -> {
            if (this.mMyCallBack != null) {
                this.mMyCallBack.onPrivacyClicked();
            }
        }, true, ResourceUtils.getColor((int)R.color.login_text_policy)).endBlock().onFinish(data -> {
            if (this.mPrivacyView != null) {
                this.mPrivacyView.setText((CharSequence)data);
            }
        }).build();
        this.mPrivacyView.postDelayed(() -> {
            if (this.mPrivacyView.getLineCount() <= 1) {
                return;
            }
            int padding = ResolutionUtils.dip2Px((float)16.0f);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mPrivacyView.getLayoutParams();
            params.setMarginEnd(padding);
            if (!toCheck) {
                params.setMarginStart(padding);
            }
            this.mPrivacyView.setLayoutParams((ViewGroup.LayoutParams)params);
        }, 10L);
        this.initBottomPolicyBtnView(rootView, toCheck);
    }

    private void initBottomPolicyBtnView(ViewGroup rootView, boolean toCheck) {
        this.mCheckPrivacyBtn = (YYImageButton)rootView.findViewById(R.id.check_privacy_btn);
        this.mCheckPrivacyBtn.setSelected(RegisterUtils.isPolicyViewCheckedState());
        this.mCheckPrivacyBtn.setOnClickListener(view -> {
            boolean isChecked = this.mCheckPrivacyBtn.isSelected();
            this.mCheckPrivacyBtn.setSelected(!isChecked);
            RegisterUtils.updatePolicyViewCheckedState(!isChecked);
        });
        this.mCheckPrivacyBtn.postDelayed(() -> {
            if (this.mPrivacyView == null || this.mPrivacyView.getLineCount() <= 1) {
                return;
            }
            int padding = ResolutionUtils.dip2Px((float)16.0f);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mCheckPrivacyBtn.getLayoutParams();
            params.setMarginStart(padding);
            this.mCheckPrivacyBtn.setLayoutParams((ViewGroup.LayoutParams)params);
        }, 10L);
        this.mCheckPrivacyBtn.setVisibility(toCheck ? 0 : 8);
    }

    private void addDebugView(ViewGroup rootView) {
        ViewStub stub = (ViewStub)rootView.findViewById(R.id.vsDebugBtn);
        YYButton envBtn = (YYButton)stub.inflate();
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product) {
            envBtn.setText((CharSequence)"\u70b9\u51fb\u5207\u6362\u73af\u5883\uff08\u5f53\u524d\u4e3a\u6b63\u5f0f\u73af\u5883");
        } else if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Test) {
            envBtn.setText((CharSequence)"\u70b9\u51fb\u5207\u6362\u73af\u5883\uff08\u5f53\u524d\u4e3a\u6d4b\u8bd5\u73af\u5883");
        } else if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Dev) {
            envBtn.setText((CharSequence)"\u70b9\u51fb\u5207\u6362\u73af\u5883\uff08\u5f53\u524d\u4e3aDev\u73af\u5883");
        }
        envBtn.setOnClickListener(view -> {
            if (this.mMyCallBack != null) {
                this.mMyCallBack.onEvnSettingClicked();
            }
        });
    }

    private void updateLoginMainAndTip(boolean update) {
        if (update) {
            this.mTipExtraView.setVisibility(0);
            String placeholder = "[image]";
            String replaceText = placeholder + " 4000";
            String tipExtra = this.getResources().getString(R.string.login_tip_extra, new Object[]{replaceText});
            int index = tipExtra.indexOf(replaceText);
            ChainSpan.of().append((CharSequence)tipExtra).span((Object)new ForegroundColorSpan(ColorUtils.parseColor((String)"#FFA944")), index, index + replaceText.length(), 17).replaceImage(placeholder, null, 0, 0, R.drawable.icon_coin_award, null).onFinish((Callback)new Callback<Spannable>(){

                public void onResponse(Spannable data) {
                    LoginTypeSelectWindow.this.mTipExtraView.setText((CharSequence)data);
                }
            }).build();
        } else {
            this.mTipExtraView.setVisibility(8);
        }
    }

    private void showMainLogin(LoginTypeData mainType) {
        MLog.debug((Object)TAG, (String)("showMainLogin: " + mainType), (Object[])new Object[0]);
        if (mainType != null) {
            this.createLoginBigBtnView(mainType);
            if (CountryCodeUtils.isCountryBrazil() || CountryCodeUtils.isCountryIndonesia() || CountryCodeUtils.isCountryVietnam()) {
                this.updateLoginMainAndTip(true);
            } else {
                this.updateLoginMainAndTip(false);
            }
        }
    }

    private void showSecondLogin(List<LoginTypeData> secondTypeList) {
        MLog.debug((Object)TAG, (String)("showSecondLogin: " + secondTypeList), (Object[])new Object[0]);
        if (secondTypeList != null) {
            this.mLoginIconsContainer.removeAllViews();
            for (LoginTypeData item : secondTypeList) {
                if (item == null || this.mLoginTypeInfo == null || item.equals((Object)this.mLoginTypeInfo.mainType)) continue;
                LoginSmallBtn smallBtn = this.createLoginBtnView(item);
                if (item == LoginTypeData.PHONE) {
                    smallBtn.setBackgroundResource(R.drawable.login_phone_weak_selector);
                }
                this.mLoginIconsContainer.addView((View)smallBtn);
                this.reportLoginTypeShow(item);
            }
        }
    }

    private void createLoginBigBtnView(LoginTypeData loginType) {
        LoginBigButtonInfo btnInfo = LoginButtonInfoHelper.createBigBtnInfo(loginType);
        this.mLoginMainBtn.setData(btnInfo);
        this.reportLoginTypeShow(loginType);
    }

    private LoginSmallBtn createLoginBtnView(LoginTypeData loginType) {
        LoginSmallBtn guestLoginView = LoginSmallBtn.create(loginType);
        guestLoginView.setOnClickListener(this);
        guestLoginView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(LoginSmallBtn.generateDefaultParams()));
        return guestLoginView;
    }

    private void reportLoginTypeShow(LoginTypeData type) {
        String functionId = "";
        switch (type) {
            case PHONE: {
                functionId = "phone_entrance_show";
                break;
            }
            case FACEBOOK: {
                functionId = "facebook_show";
                break;
            }
            case GOOGLE: {
                functionId = "google_show";
                break;
            }
            case ZALO: {
                functionId = "zalo_show";
                break;
            }
            case VK: {
                functionId = "vk_show";
                break;
            }
            case LINE: {
                functionId = "line_show";
                break;
            }
            case SNAPCHAT: {
                functionId = "snapchat_show";
                break;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)functionId)) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", functionId));
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        CrashMonitor.tryCatch((Object)((Object)this), (String)"com.yy.hiyo.login.LoginTypeSelectWindow#dispatchDraw", () -> LoginTypeSelectWindow.super.dispatchDraw(canvas));
    }

    public void onClick(View v) {
        LoginTypeData loginType;
        ILoginTypeView loginTypeView;
        Object viewInfo;
        if (this.isFastClick()) {
            return;
        }
        if (this.mMyCallBack != null && v instanceof ILoginTypeView && (viewInfo = (loginTypeView = (ILoginTypeView)v).getData()) != null && (loginType = ((BaseLoginTypeViewInfo)viewInfo).loginType) != null) {
            if (this.mMyCallBack.interceptLoginTypeSelected()) {
                return;
            }
            MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.LOGIN_BG_ANIM_STOP);
            this.mMyCallBack.onLoginTypeSelected(loginType.getType());
        }
    }

    public boolean isFastClick() {
        boolean flag = true;
        long currentClickTime = System.currentTimeMillis();
        if (currentClickTime - this.mLastClickTime >= 500L) {
            flag = false;
        }
        this.mLastClickTime = currentClickTime;
        return flag;
    }

    private void initBackground() {
        LoginBackgroundData backgroundData = new LoginBackgroundData();
        backgroundData.setRoot((ViewGroup)this.mBgLayout);
        backgroundData.setTipView(this.mTipView);
        backgroundData.setMainButton(this.mLoginMainBtn);
        MsgDispatcher.getInstance().sendMessageSync(GrowthMsgDef.LOGIN_BG_INIT, (Object)backgroundData);
    }

    public void showTopNotice(String notice) {
        if (!StringUtils.isEmpty((String)notice)) {
            this.mTopNoticeView.setVisibility(0);
            this.mTopNoticeView.setText((CharSequence)notice);
        } else {
            this.hideTopNotice();
        }
    }

    public void hideTopNotice() {
        this.mTopNoticeView.setVisibility(8);
    }
}

