/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.login.base.ILoginApi;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IGetFirendListCallBack;
import com.yy.socialplatformbase.data.UserBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class LoginApi
implements ILoginApi {
    private static final String TAG = "LoginApi";
    private static LoginApi instance = new LoginApi();

    public static LoginApi getInstance() {
        return instance;
    }

    public void uploadFacebookFriends(ArrayList<UserBaseInfo> facebookFriends, INetRespCallback<?> callback) {
        this.uploadFriends(facebookFriends, callback, "/addrlist/fb_upload", "fid");
    }

    public void getFacebookFriendList(IGetFirendListCallBack callback) {
        AbsPlatformAdapter absPlatformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
        if (absPlatformAdapter != null) {
            absPlatformAdapter.getFriendList(callback);
        }
    }

    public void uploadZaloFriendList(ArrayList<UserBaseInfo> zaloFriends, INetRespCallback callback) {
        this.uploadFriends(zaloFriends, callback, "/addrlist/zalo_upload", "zid");
    }

    private void uploadFriends(ArrayList<UserBaseInfo> zaloFriends, final INetRespCallback callback, String uri, String id2) {
        if (zaloFriends != null && !zaloFriends.isEmpty()) {
            if (zaloFriends.size() > 5000) {
                zaloFriends = (ArrayList)zaloFriends.subList(0, 5000);
            }
            JsonObject jsonObject = new JsonObject();
            JsonArray list = new JsonArray();
            jsonObject.add("list", (JsonElement)list);
            for (UserBaseInfo info : zaloFriends) {
                JsonObject item = new JsonObject();
                item.addProperty(id2, info.getUserId());
                item.addProperty("nick", info.getName());
                list.add((JsonElement)item);
            }
            HashMap data = new HashMap();
            YYTaskExecutor.execute(() -> {
                data.put("data", jsonObject.toString());
                HttpUtil.httpReq((String)(UriProvider.getIkxdSvrHost() + uri), (Map)data, (int)2, (INetRespCallback)new INetRespCallback<NetCheckUpload>(){

                    public boolean needToken() {
                        return false;
                    }

                    public void onError(Call call, Exception e, int id1) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)LoginApi.TAG, (String)("uploadFacebookFriends err:" + e.getMessage()), (Object[])new Object[0]);
                        }
                        if (callback != null) {
                            callback.onError(call, e, id1);
                        }
                    }

                    public void onResponse(String response, BaseResponseBean<NetCheckUpload> res, int id1) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)LoginApi.TAG, (String)("uploadFacebookFriends resp:" + response), (Object[])new Object[0]);
                        }
                        if (callback != null) {
                            callback.onResponse(response, res, id1);
                        }
                    }
                });
            });
        }
    }

    public void checkUploadFacebook(INetRespCallback<NetCheckUpload> callback) {
        this.check(callback, "/addrlist/fb_check");
    }

    public void checkUploadZalo(INetRespCallback<NetCheckUpload> callback) {
        this.check(callback, "/addrlist/zalo_check");
    }

    private void check(final INetRespCallback callback, String uri) {
        HttpUtil.httpReq((String)(UriProvider.getIkxdSvrHost() + uri), null, (int)1, (INetRespCallback)new INetRespCallback<NetCheckUpload>(){

            public boolean needToken() {
                return false;
            }

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LoginApi.TAG, (String)("checkUpload err:" + e.getMessage()), (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onError(call, e, id2);
                }
            }

            public void onResponse(String response, BaseResponseBean<NetCheckUpload> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LoginApi.TAG, (String)("checkUpload resp:" + response), (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onResponse(response, res, id2);
                }
            }
        });
    }

    public void sendFbRegisterPushMsg() {
        String url = UriProvider.getIkxdSvrHost() + "/addrlist/fb_push";
        this.sendRegisterPushMsg(url);
    }

    public void sendZaloRegisterPushMsg() {
        String url = UriProvider.getIkxdSvrHost() + "/addrlist/zalo_push";
        this.sendRegisterPushMsg(url);
    }

    private void sendRegisterPushMsg(String url) {
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("sendRegisterPushMsg url=" + url), (Object[])new Object[0]);
        }
        HttpUtil.httpReq((String)url, null, (int)2, (INetRespCallback)new INetOriginRespCallback(){

            public boolean needToken() {
                return false;
            }

            public void onError(Call call, Exception e, int id2) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)LoginApi.TAG, (String)("sendRegisterPushMsg error =" + e), (Object[])new Object[0]);
                }
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)LoginApi.TAG, (String)("sendRegisterPushMsg =" + response), (Object[])new Object[0]);
                }
            }
        });
    }
}

