/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.zalo;

import android.util.SparseArray;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.login.LoginApi;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.base.IQueryThirdPartyCallBack;
import com.yy.hiyo.login.request.IQueryThirdPartyAccountCallBack;
import com.yy.hiyo.login.request.LoginRequestFactory;
import com.yy.hiyo.login.zalo.IBindZaloAccount;
import com.yy.hiyo.login.zalo.ZaloLoginController;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IGetFirendListCallBack;
import com.yy.socialplatformbase.data.UserBaseInfo;
import java.util.ArrayList;
import okhttp3.Call;

public class ZaloBindAccount {
    private static final String TAG = "ZaloBind";
    private static final String KEY_ZALO_BIND_USERID = "key_zalo_accout_bind_id";
    private static final String KEY_ZALO_HAS_CHECK_BIND = "key_zalo_has_check_bind";

    public static boolean isZaloLoginType() {
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        return accountInfo != null && accountInfo.loginType == 7;
    }

    public static boolean isZaloBindStatu() {
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        return accountInfo != null && SettingFlags.getBoolean((String)("key_zalo_accout_bind_" + accountInfo.uuid), (boolean)false);
    }

    public static void bindZaloAccount(ZaloLoginController zaloLoginController, IBindZaloAccount callBack) {
        if (ZaloBindAccount.isZaloLoginType() && callBack != null) {
            callBack.onSuccess(AccountModel.getInstance().getAccountInfo());
            return;
        }
        zaloLoginController.bindAccount(callBack);
    }

    public static void checkUploadFriendList() {
        LoginApi.getInstance().checkUploadZalo(new INetRespCallback<NetCheckUpload>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<NetCheckUpload> res, int id2) {
                MLog.info((Object)ZaloBindAccount.TAG, (String)("checkUploadFriendList response = " + response), (Object[])new Object[0]);
                if (res != null && res.data != null && ((NetCheckUpload)res.data).need) {
                    ZaloBindAccount.uploadZaloFriendList(((NetCheckUpload)res.data).version <= 0L);
                }
            }
        });
    }

    private static void uploadZaloFriendList(final boolean enablePush) {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(9);
        if (adapter != null) {
            adapter.getFriendList(new IGetFirendListCallBack(){

                public void onSuccess(ArrayList<UserBaseInfo> list) {
                    MLog.info((Object)ZaloBindAccount.TAG, (String)("uploadZaloFriendList list = " + list), (Object[])new Object[0]);
                    LoginApi.getInstance().uploadZaloFriendList(list, new INetRespCallback(){

                        public void onError(Call call, Exception e, int id2) {
                        }

                        public void onResponse(String response, BaseResponseBean res, int id2) {
                            MLog.info((Object)ZaloBindAccount.TAG, (String)("uploadZaloFriendList response = " + response), (Object[])new Object[0]);
                            if (enablePush) {
                                LoginApi.getInstance().sendZaloRegisterPushMsg();
                            }
                        }
                    });
                }

                public void onError(int errorCode, Exception e) {
                }
            });
        }
    }

    public static boolean getZaloBindStatu(IQueryThirdPartyCallBack callBack) {
        MLog.info((Object)TAG, (String)"getZaloBindStatu start", (Object[])new Object[0]);
        if (ZaloBindAccount.isZaloLoginType()) {
            MLog.info((Object)TAG, (String)"binded zalo Login!", (Object[])new Object[0]);
            return true;
        }
        boolean result = false;
        final AccountInfo info = AccountModel.getInstance().getAccountInfo();
        if (info != null && info.uuid > -1L) {
            result = SettingFlags.getBoolean((String)("key_zalo_accout_bind_" + info.uuid), (boolean)false);
        }
        MLog.info((Object)TAG, (String)("getZaloBindStatu result = " + result), (Object[])new Object[0]);
        if (!result && info != null) {
            final IQueryThirdPartyCallBack fCallBack = callBack;
            final long uuid = info.uuid;
            LoginRequestFactory.getLoginRequester().queryThirdParty(info, new IQueryThirdPartyAccountCallBack(){

                @Override
                public void onSuccess(SparseArray<String> thirdPartyUserId) {
                    MLog.info((Object)ZaloBindAccount.TAG, (String)("getZaloBindStatu queryThirdParty onSuccess thirdPartyUserId = " + thirdPartyUserId), (Object[])new Object[0]);
                    SettingFlags.setBoolean((String)(ZaloBindAccount.KEY_ZALO_HAS_CHECK_BIND + info.uuid), (boolean)true);
                    if (thirdPartyUserId != null) {
                        String faceBookUserId = (String)thirdPartyUserId.get(9);
                        if (StringUtils.isNotEmpty((String)faceBookUserId)) {
                            ZaloBindAccount.updateZaloBindStatu(uuid, faceBookUserId);
                            if (fCallBack != null) {
                                fCallBack.onSuccess(true, faceBookUserId);
                            }
                            MLog.info((Object)ZaloBindAccount.TAG, (String)"has binded! ", (Object[])new Object[0]);
                        } else {
                            if (fCallBack != null) {
                                fCallBack.onSuccess(false, "");
                            }
                            MLog.info((Object)ZaloBindAccount.TAG, (String)"has not binded! ", (Object[])new Object[0]);
                        }
                    } else if (fCallBack != null) {
                        fCallBack.onError(-1, (Throwable)new RuntimeException(""));
                        MLog.error((Object)ZaloBindAccount.TAG, (String)"get bind statu errored empty!", (Object[])new Object[0]);
                    }
                }

                @Override
                public void onError(String errorCode, Throwable e) {
                    MLog.error((Object)ZaloBindAccount.TAG, (String)"get bind statu errored:%s %s", (Object[])new Object[]{errorCode, e != null ? e.toString() : ""});
                }
            });
        } else {
            MLog.info((Object)TAG, (String)"has binded!", (Object[])new Object[0]);
        }
        return result;
    }

    public static void updateZaloBindStatu(long uuid, String userId) {
        SettingFlags.setBoolean((String)("key_zalo_accout_bind_" + uuid), (boolean)true);
        SettingFlags.setStringValue((String)(KEY_ZALO_BIND_USERID + uuid), (String)userId);
    }
}

