/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.relogin;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.LoginTypeConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.relogin.AccountInfoEx;
import com.yy.hiyo.login.relogin.IDialogCallBack;
import java.util.List;

public class AccountSelectDialog
implements BaseDialog,
IDialogCallBack {
    private List<AccountInfoEx> accountInfosToShow;
    private final IDialogCallBack mListener;
    private final boolean mCancelable;
    private final boolean mOutSideCancelable;
    private ListView mListView;
    private Dialog mDialog;

    public AccountSelectDialog(List<AccountInfoEx> accountInfosToShow, boolean cancelable, boolean outSideCancelable, IDialogCallBack callBack) {
        this.mCancelable = cancelable;
        this.mOutSideCancelable = outSideCancelable;
        this.mListener = callBack;
        this.accountInfosToShow = accountInfosToShow;
    }

    public List<AccountInfoEx> getAccountInfosToShow() {
        return this.accountInfosToShow;
    }

    private LinearLayout createPage(Context context) {
        int topPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_toppadding);
        int leftPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_leftpadding);
        int bottomPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_bottompadding);
        int titleTextsize = ResourceUtils.getDimen((int)R.dimen.account_select_page_title_textsize);
        int noneTextsize = ResourceUtils.getDimen((int)R.dimen.account_select_page_none_textsize);
        int listpageTopPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_listpage_toppadding);
        int listpageBottomPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_listpage_bottompadding);
        int cloaseIconPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_listpage_bottompadding);
        int itemTopMargin = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_topmargin);
        int noneTextPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_none_padding);
        YYLinearLayout container = new YYLinearLayout(context);
        YYTextView title = new YYTextView(context);
        this.mListView = new ListView(context);
        YYTextView noneOfAbvoe = new YYTextView(context);
        container.setOrientation(1);
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        LayoutUtil.setPadding((View)container, (int)leftPadding, (int)topPadding, (int)(leftPadding - cloaseIconPadding), (int)(bottomPadding - noneTextPadding));
        title.setTextSize(0, (float)titleTextsize);
        this.mListView.setPadding(0, listpageTopPadding, 0, listpageBottomPadding - itemTopMargin - noneTextPadding);
        this.mListView.setDividerHeight(0);
        noneOfAbvoe.setTextSize(0, (float)noneTextsize);
        noneOfAbvoe.setPadding(0, noneTextPadding, 0, noneTextPadding);
        title.setTextColor(ResourceUtils.getColor((int)R.color.account_select_page_title));
        title.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        noneOfAbvoe.setTextColor(ResourceUtils.getColor((int)R.color.account_select_page_none));
        noneOfAbvoe.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        if (Build.VERSION.SDK_INT >= 17) {
            title.setTextAlignment(5);
            noneOfAbvoe.setTextAlignment(5);
        }
        container.addView((View)title);
        container.addView((View)this.mListView, new ViewGroup.LayoutParams(-1, -2));
        container.addView((View)noneOfAbvoe);
        title.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_account_select_page_title));
        noneOfAbvoe.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_account_select_page_none));
        container.setBackgroundColor(-1);
        noneOfAbvoe.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountSelectDialog.this.onNoneAboveClicked();
            }
        });
        return container;
    }

    public void updateList(final List<AccountInfoEx> accountInfosToShow) {
        if (this.mListView == null) {
            return;
        }
        this.mListView.setAdapter((ListAdapter)new BaseAdapter(){

            public int getCount() {
                return accountInfosToShow.size();
            }

            public Object getItem(int position) {
                return accountInfosToShow.get(position);
            }

            public long getItemId(int position) {
                return -1L;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                ItemView itemView;
                AccountInfoEx info = (AccountInfoEx)accountInfosToShow.get(position);
                if (convertView == null) {
                    int itemTopMargin = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_topmargin);
                    int iconHeight = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_icon_height);
                    itemView = new ItemView(parent.getContext(), AccountSelectDialog.this);
                    AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(-1, iconHeight + itemTopMargin);
                    itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    itemView.setBackgroundDrawable((Drawable)new ColorDrawable(-1));
                } else {
                    itemView = (ItemView)convertView;
                }
                itemView.update(info);
                return itemView;
            }
        });
    }

    public void init(Dialog dialog) {
        this.mDialog = dialog;
        dialog.setCancelable(this.mCancelable);
        dialog.setCanceledOnTouchOutside(this.mOutSideCancelable);
        dialog.setContentView((View)this.createPage(dialog.getContext()), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.updateList(this.accountInfosToShow);
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (AccountSelectDialog.this.mListener != null) {
                    AccountSelectDialog.this.mListener.onDismiss(dialog);
                }
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (AccountSelectDialog.this.mListener != null) {
                    AccountSelectDialog.this.mListener.onCancel();
                }
            }
        });
        this.mDialog = dialog;
    }

    public int getId() {
        return DialogId.AccountReloginSelectDialog;
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        if (this.mListener != null) {
            this.mListener.onDismiss(dialog);
        }
    }

    @Override
    public void onSelectClicked(AccountInfoEx accountInfo) {
        if (this.mListener != null) {
            this.mListener.onSelectClicked(accountInfo);
        }
        this.mDialog.dismiss();
    }

    @Override
    public void onClearClicked(final AccountInfoEx accountInfo) {
        String tips;
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                if (AccountSelectDialog.this.mListener != null) {
                    AccountSelectDialog.this.mListener.onClearClicked(accountInfo);
                }
                if (AccountSelectDialog.this.accountInfosToShow != null) {
                    AccountSelectDialog.this.accountInfosToShow.remove(accountInfo);
                    if (AccountSelectDialog.this.accountInfosToShow.size() > 0) {
                        AccountSelectDialog.this.updateList(AccountSelectDialog.this.accountInfosToShow);
                    } else {
                        AccountSelectDialog.this.mDialog.dismiss();
                    }
                }
            }
        };
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.LOGIN_TYPE_CONFIG);
        LoginTypeConfigData loginTypeConfigData = null;
        if (configData instanceof LoginTypeConfigData) {
            loginTypeConfigData = (LoginTypeConfigData)configData;
        }
        boolean hasDialog = false;
        if (this.mDialog != null && accountInfo != null && accountInfo.accountInfo != null && loginTypeConfigData != null && loginTypeConfigData.hasException(accountInfo.accountInfo.loginType) && !StringUtils.isEmpty((String)(tips = loginTypeConfigData.clearExceptionDes))) {
            hasDialog = true;
            String cancel = ResourceUtils.getString((int)R.string.btn_cancel);
            String confirm = ResourceUtils.getString((int)R.string.btn_confirm);
            OkCancelDialog dialog = new OkCancelDialog((CharSequence)tips, (CharSequence)confirm, (CharSequence)cancel, true, true, new OkCancelDialogListener(){

                public void onCancel() {
                    MLog.info((Object)"AccountSelect", (String)"cancel!", (Object[])new Object[0]);
                }

                public void onOk() {
                    MLog.info((Object)"AccountSelect", (String)"confirm!", (Object[])new Object[0]);
                    command.run();
                }
            });
            dialog.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    MLog.info((Object)"AccountSelect", (String)"cancel!", (Object[])new Object[0]);
                }
            });
            DialogLinkManager dialogLinkManager = new DialogLinkManager(this.mDialog.getContext());
            dialogLinkManager.showDialog((BaseDialog)dialog);
        }
        if (!hasDialog) {
            command.run();
        }
    }

    private boolean isFacebookUrgentHandle() {
        return !RuntimeContext.closeFacebookFix && RuntimeContext.sIsHagoApp;
    }

    @Override
    public void onNoneAboveClicked() {
        if (this.mListener != null) {
            this.mListener.onNoneAboveClicked();
        }
        this.mDialog.dismiss();
    }

    @Override
    public void onCancel() {
        if (this.mListener != null) {
            this.mListener.onCancel();
        }
    }

    private static class ItemView
    extends YYFrameLayout {
        private CircleImageView mIcon;
        private CircleImageView mLoginTypeIcon;
        private YYTextView mTitle;
        private YYImageView mCloseIcon;
        private AccountInfoEx mInfo;
        private IDialogCallBack mCallBack;

        ItemView(Context context, IDialogCallBack callBack) {
            super(context);
            this.mCallBack = callBack;
            int itemTextsize = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_title_textsize);
            int closeIconHeight = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_clost_icon_height);
            int iconHeight = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_icon_height);
            int loginTypeIconHeight = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_loginttype_icon_height);
            int loginTypeIconEdgeHeight = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_loginttype_icon_edge);
            int loginTypeIconOut = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_loginttype_icon_out);
            int itemTitleLeftMargin = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_title_leftmargin);
            int itemTopMargin = ResourceUtils.getDimen((int)R.dimen.account_select_page_item_topmargin);
            int cloaseIconPadding = ResourceUtils.getDimen((int)R.dimen.account_select_page_listpage_bottompadding);
            this.setPadding(0, 0, 0, itemTopMargin);
            YYLinearLayout container = new YYLinearLayout(context);
            YYFrameLayout iconContainer = new YYFrameLayout(context);
            this.mIcon = new CircleImageView(context);
            this.mLoginTypeIcon = new CircleImageView(context);
            this.mTitle = new YYTextView(context);
            YYView emptyView = new YYView(context);
            this.mCloseIcon = new YYImageView(context);
            container.setOrientation(0);
            FrameLayout.LayoutParams fLayoutParams = new FrameLayout.LayoutParams(-1, iconHeight);
            container.setLayoutParams((ViewGroup.LayoutParams)fLayoutParams);
            LinearLayout.LayoutParams lLayoutParams = new LinearLayout.LayoutParams(iconHeight + loginTypeIconOut, iconHeight);
            iconContainer.setLayoutParams((ViewGroup.LayoutParams)lLayoutParams);
            lLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            lLayoutParams.gravity = 8388627;
            lLayoutParams.weight = 1.0f;
            lLayoutParams.leftMargin = itemTitleLeftMargin;
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)lLayoutParams);
            this.mTitle.setLayoutParams((ViewGroup.LayoutParams)lLayoutParams);
            lLayoutParams = new LinearLayout.LayoutParams(0, -2);
            emptyView.setLayoutParams((ViewGroup.LayoutParams)lLayoutParams);
            lLayoutParams = new LinearLayout.LayoutParams(closeIconHeight + 2 * cloaseIconPadding, closeIconHeight + 2 * cloaseIconPadding);
            lLayoutParams.gravity = 21;
            lLayoutParams.leftMargin = itemTitleLeftMargin;
            this.mCloseIcon.setLayoutParams((ViewGroup.LayoutParams)lLayoutParams);
            fLayoutParams = new FrameLayout.LayoutParams(iconHeight, iconHeight);
            this.mIcon.setLayoutParams((ViewGroup.LayoutParams)fLayoutParams);
            fLayoutParams = new FrameLayout.LayoutParams(loginTypeIconHeight, loginTypeIconHeight);
            fLayoutParams.gravity = 0x800055;
            this.mLoginTypeIcon.setLayoutParams((ViewGroup.LayoutParams)fLayoutParams);
            this.mCloseIcon.setPadding(cloaseIconPadding, cloaseIconPadding, cloaseIconPadding, cloaseIconPadding);
            this.mCloseIcon.setImageResource(R.drawable.account_select_close);
            this.mTitle.setTextSize(0, (float)itemTextsize);
            this.mTitle.setTextColor(ResourceUtils.getColor((int)R.color.account_select_page_itemtitle));
            this.mTitle.setMaxLines(1);
            this.mTitle.setMaxWidth(10 * itemTextsize);
            this.mTitle.setEllipsize(TextUtils.TruncateAt.END);
            this.mTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
            this.mLoginTypeIcon.setBorderWidth(loginTypeIconEdgeHeight);
            this.mLoginTypeIcon.setBorderColor(ResourceUtils.getColor((int)R.color.account_select_page_item_edge));
            container.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_item_selector));
            container.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (mCallBack != null) {
                        mCallBack.onSelectClicked(mInfo);
                    }
                }
            });
            iconContainer.addView((View)this.mIcon);
            iconContainer.addView((View)this.mLoginTypeIcon);
            container.addView((View)iconContainer);
            container.addView((View)this.mTitle);
            container.addView((View)emptyView);
            container.addView((View)this.mCloseIcon);
            this.addView((View)container);
            this.initClickListener();
        }

        public void initClickListener() {
            this.mCloseIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (mCallBack != null) {
                        mCallBack.onClearClicked(mInfo);
                    }
                }
            });
        }

        public void update(AccountInfoEx info) {
            if (info != null) {
                if (info.accountInfo.loginType == 10) {
                    this.mLoginTypeIcon.setImageResource(-1);
                } else if (info.accountInfo.loginType == 3) {
                    this.mLoginTypeIcon.setImageResource(R.drawable.google_select);
                } else if (info.accountInfo.loginType == 1) {
                    this.mLoginTypeIcon.setImageResource(R.drawable.facebook_selector);
                } else if (info.accountInfo.loginType == 4) {
                    this.mLoginTypeIcon.setImageResource(R.drawable.line_phone_selector);
                } else if (info.accountInfo.loginType == 5) {
                    this.mLoginTypeIcon.setImageResource(R.drawable.login_vk_selector);
                } else if (info.accountInfo.loginType == 2) {
                    this.mLoginTypeIcon.setImageResource(R.drawable.login_phone_selector);
                } else if (info.accountInfo.loginType == 7) {
                    this.mLoginTypeIcon.setImageResource(R.drawable.login_zalo);
                }
                if (RuntimeContext.sIsDebuggable) {
                    FeatureLog.i((String)"FTLoginAccount", (String)"type:%d name:%s icon:%s", (Object[])new Object[]{info.accountInfo.loginType, info.userInfo.getNick(), info.userInfo.getAvatar()});
                }
                ImageLoader.loadImage((RecycleImageView)this.mIcon, (String)(info.userInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)(info.userInfo.getSex() == 1 ? R.drawable.icon_avatar_default_male : R.drawable.icon_avatar_default_female));
                String title = info.userInfo.getNick();
                if (info.accountInfo != null && AccountUtil.getUid() > 0L && AccountUtil.getUid() == info.accountInfo.uuid) {
                    title = title + ResourceUtils.getString((int)R.string.login_reloggin_current_account_tip);
                }
                this.mTitle.setText((CharSequence)title);
            }
            this.mInfo = info;
        }
    }
}

